/*
 * Decompiled with CFR 0.152.
 */
package de.guntram.mcmod.durabilityviewer.itemindicator;

import de.guntram.mcmod.durabilityviewer.Config;
import de.guntram.mcmod.durabilityviewer.itemindicator.ItemIndicator;
import net.minecraft.world.item.ItemStack;

public class ItemDamageIndicator
implements ItemIndicator {
    final ItemStack stack;
    boolean alwaysAssumeDamageable;

    public ItemDamageIndicator(ItemStack stack) {
        this(stack, false);
    }

    public ItemDamageIndicator(ItemStack stack, boolean alwaysDamageable) {
        this.stack = stack;
        this.alwaysAssumeDamageable = alwaysDamageable;
    }

    @Override
    public String getDisplayValue() {
        if (!this.stack.isDamageableItem()) {
            return "";
        }
        return ItemDamageIndicator.calculateDisplayValue(this.stack.getMaxDamage(), this.stack.getDamageValue());
    }

    public static String calculateDisplayValue(int max, int dam) {
        int cur = max - dam;
        int shown = cur > max * Config.percentToShowDamageRatherThanDurability / 100 ? -dam : cur;
        if (Config.showPercentRatherThanDurability) {
            return String.format("%.1f%%", (double)shown * 100.0 / (double)max);
        }
        return String.valueOf(shown);
    }

    @Override
    public int getDisplayColor() {
        int max = this.stack.getMaxDamage();
        int cur = this.stack.getDamageValue();
        return ItemDamageIndicator.calculateDisplayColor(max, cur);
    }

    public static int calculateDisplayColor(int max, int cur) {
        if (cur < max / 5) {
            return color_green;
        }
        if (cur > max * 9 / 10 && cur > max - 100) {
            return color_red;
        }
        if (cur > max * 4 / 5 && cur > max - 200) {
            return color_yellow;
        }
        return color_white;
    }

    @Override
    public boolean isEmpty() {
        return this.stack.isEmpty() || this.stack.getMaxDamage() - this.stack.getDamageValue() > this.stack.getMaxDamage() * Config.hideDamageOverPercent / 100;
    }

    @Override
    public boolean isItemStackDamageable() {
        return this.alwaysAssumeDamageable || this.stack.isDamageableItem();
    }

    @Override
    public ItemStack getItemStack() {
        return this.stack;
    }
}

