/*
 * Decompiled with CFR 0.152.
 */
package de.guntram.mcmod.durabilityviewer.sound;

import de.guntram.mcmod.durabilityviewer.Config;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.ItemStack;

public class ItemBreakingWarner {
    private int lastDurability = 1000;
    private ItemStack lastStack = null;
    private static SoundEvent sound;

    public ItemBreakingWarner() {
        if (sound == null) {
            ResourceLocation location = ResourceLocation.fromNamespaceAndPath((String)"durabilityviewer", (String)"tool_breaking");
            sound = SoundEvent.createVariableRangeEvent((ResourceLocation)location);
        }
    }

    public boolean checkBreaks(ItemStack stack) {
        this.lastStack = stack;
        if (stack == null || !stack.isDamageableItem()) {
            return false;
        }
        int newDurability = stack.getMaxDamage() - stack.getDamageValue();
        if (newDurability < this.lastDurability && newDurability < Config.soundBelowDurability && newDurability * 100 / Config.soundBelowPercent < stack.getMaxDamage()) {
            this.lastDurability = newDurability;
            return true;
        }
        this.lastDurability = newDurability;
        return false;
    }

    public static void playWarningSound() {
        Minecraft.getInstance().player.playSound(sound, 100.0f, 100.0f);
    }
}

