/*
 * Decompiled with CFR 0.152.
 */
package com.Gomania.gChat;

import java.awt.Color;
import java.io.File;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class GChat
extends JavaPlugin
implements Listener,
TabCompleter {
    private FileConfiguration config;
    private FileConfiguration messagesConfig;
    private File messagesFile;
    private final Map<UUID, String> playerChatModes = new ConcurrentHashMap<UUID, String>();
    private final Map<UUID, Long> reloadCooldowns = new ConcurrentHashMap<UUID, Long>();
    private final Map<UUID, Long> messageCooldowns = new ConcurrentHashMap<UUID, Long>();
    private final Pattern gradientPattern = Pattern.compile("\\{#([0-9A-Fa-f]{6})>\\}(.*?)\\{#([0-9A-Fa-f]{6})<\\}");
    private final Pattern colorPattern = Pattern.compile("&[0-9a-fk-or]", 2);
    private boolean hasPlaceholderAPI = false;
    private boolean hasLuckPerms = false;
    private Object luckPermsAPI = null;
    private List<String> blockedCommands = new ArrayList<String>();
    private String joinMessage;
    private String quitMessage;

    public void onEnable() {
        this.saveDefaultConfig();
        this.config = this.getConfig();
        this.setupMessages();
        this.reloadConfigValues();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.hasPlaceholderAPI = Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null;
        boolean bl = this.hasLuckPerms = Bukkit.getPluginManager().getPlugin("LuckPerms") != null;
        if (this.hasPlaceholderAPI) {
            this.getLogger().info("PlaceholderAPI found! Placeholders enabled.");
        }
        if (this.hasLuckPerms) {
            this.getLogger().info("LuckPerms found! Group support enabled.");
            try {
                Class<?> luckPermsClass = Class.forName("net.luckperms.api.LuckPerms");
                this.luckPermsAPI = Bukkit.getServicesManager().getRegistration(luckPermsClass).getProvider();
            }
            catch (Exception e) {
                this.getLogger().warning("Failed to initialize LuckPerms API: " + e.getMessage());
                this.hasLuckPerms = false;
            }
        }
        this.getLogger().info("gChat plugin enabled!");
    }

    public void onDisable() {
        this.playerChatModes.clear();
        this.reloadCooldowns.clear();
        this.messageCooldowns.clear();
        this.getLogger().info("gChat plugin disabled!");
    }

    private void setupMessages() {
        String language = this.config.getString("language", "ru").toLowerCase();
        this.messagesFile = new File(this.getDataFolder(), "messages_" + language + ".yml");
        if (!this.messagesFile.exists()) {
            try (InputStream in = this.getResource("messages_" + language + ".yml");){
                if (in != null) {
                    Files.copy(in, this.messagesFile.toPath(), new CopyOption[0]);
                }
            }
            catch (Exception e) {
                this.getLogger().warning("Failed to create messages file: " + e.getMessage());
            }
        }
        this.reloadMessages();
    }

    public void reloadMessages() {
        this.messagesConfig = YamlConfiguration.loadConfiguration((File)this.messagesFile);
    }

    public String getMessage(String path) {
        String message = this.messagesConfig.getString(path);
        if (message == null) {
            return "\u00a7cMessage not found: " + path;
        }
        String prefix = this.messagesConfig.getString("prefix", "&8[&6gChat&8]");
        message = message.replace("{prefix}", prefix);
        return message.replace("&", "\u00a7");
    }

    private void reloadConfigValues() {
        if (!new File(this.getDataFolder(), "config.yml").exists()) {
            this.saveDefaultConfig();
        }
        this.reloadConfig();
        this.config = this.getConfig();
        this.reloadMessages();
        this.blockedCommands = this.config.getStringList("blocked-commands");
        this.joinMessage = this.config.getString("join-message", "");
        this.quitMessage = this.config.getString("quit-message", "");
        this.hasPlaceholderAPI = Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null;
        boolean bl = this.hasLuckPerms = Bukkit.getPluginManager().getPlugin("LuckPerms") != null;
        if (this.hasLuckPerms) {
            try {
                Class<?> luckPermsClass = Class.forName("net.luckperms.api.LuckPerms");
                this.luckPermsAPI = Bukkit.getServicesManager().getRegistration(luckPermsClass).getProvider();
            }
            catch (Exception e) {
                this.getLogger().warning("Failed to initialize LuckPerms API: " + e.getMessage());
                this.hasLuckPerms = false;
            }
        }
    }

    private String formatMessage(Player player, String message, String chatMode) {
        Object finalFormat;
        String baseFormat = chatMode.equals("local") ? this.config.getString("local-chat.format", "&8[\u041b\u043e\u043a\u0430\u043b\u044c\u043d\u043e]") : this.config.getString("global-chat.format", "&8[\u0413\u043b\u043e\u0431\u0430\u043b\u044c\u043d\u043e]");
        String playerGroup = this.getPlayerGroup(player);
        String groupFormat = null;
        if (playerGroup != null && this.config.isConfigurationSection("group-formats") && this.config.getConfigurationSection("group-formats").contains(playerGroup)) {
            groupFormat = this.config.getString("group-formats." + playerGroup);
        }
        Object object = finalFormat = groupFormat != null ? groupFormat : this.config.getString("default-format", "%player_name% &7\u00bb %message%");
        if (finalFormat == null || ((String)finalFormat).isEmpty()) {
            finalFormat = "%player_name% \u00bb %message%";
        }
        finalFormat = ((String)finalFormat).replace("%gchat_format%", baseFormat != null ? baseFormat : "");
        finalFormat = this.replacePlaceholders(player, (String)finalFormat);
        finalFormat = ((String)finalFormat).replace("%message%", message);
        finalFormat = ((String)finalFormat).replace("&", "\u00a7");
        finalFormat = this.applyGradients((String)finalFormat);
        finalFormat = (String)finalFormat + "\u00a7r";
        return finalFormat;
    }

    private String getPlayerGroup(Player player) {
        if (!this.hasLuckPerms || this.luckPermsAPI == null) {
            return null;
        }
        try {
            String primaryGroup;
            Class<?> apiClass = this.luckPermsAPI.getClass();
            Object userManager = apiClass.getMethod("getUserManager", new Class[0]).invoke(this.luckPermsAPI, new Object[0]);
            Object user = userManager.getClass().getMethod("getUser", UUID.class).invoke(userManager, player.getUniqueId());
            if (user == null) {
                return null;
            }
            HashSet configGroups = new HashSet();
            if (this.config.isConfigurationSection("group-formats")) {
                configGroups.addAll(this.config.getConfigurationSection("group-formats").getKeys(false).stream().map(String::toLowerCase).collect(Collectors.toSet()));
            }
            if ((primaryGroup = (String)user.getClass().getMethod("getPrimaryGroup", new Class[0]).invoke(user, new Object[0])) != null && configGroups.contains(primaryGroup.toLowerCase())) {
                return primaryGroup.toLowerCase();
            }
            Object nodes = user.getClass().getMethod("getNodes", new Class[0]).invoke(user, new Object[0]);
            if (nodes instanceof Iterable) {
                for (Object node : (Iterable)nodes) {
                    String groupName;
                    if (!node.getClass().getSimpleName().equals("InheritanceNode") || (groupName = (String)node.getClass().getMethod("getGroupName", new Class[0]).invoke(node, new Object[0])) == null || !configGroups.contains(groupName.toLowerCase())) continue;
                    return groupName.toLowerCase();
                }
            }
        }
        catch (Exception e) {
            this.getLogger().warning("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0433\u0440\u0443\u043f\u043f\u0443 \u0438\u0433\u0440\u043e\u043a\u0430 \u0447\u0435\u0440\u0435\u0437 LuckPerms: " + e.getMessage());
        }
        return null;
    }

    private String replacePlaceholders(Player player, String text) {
        if (text == null || text.isEmpty()) {
            return "";
        }
        text = text.replace("%player_name%", player.getName()).replace("%player_world%", player.getWorld().getName());
        if (this.hasLuckPerms && text.contains("%luckperms_suffix%")) {
            try {
                Class<?> apiClass = this.luckPermsAPI.getClass();
                Object userManager = apiClass.getMethod("getUserManager", new Class[0]).invoke(this.luckPermsAPI, new Object[0]);
                Object user = userManager.getClass().getMethod("getUser", UUID.class).invoke(userManager, player.getUniqueId());
                if (user != null) {
                    Object cachedData = user.getClass().getMethod("getCachedData", new Class[0]).invoke(user, new Object[0]);
                    Object metaData = cachedData.getClass().getMethod("getMetaData", new Class[0]).invoke(cachedData, new Object[0]);
                    String suffix = (String)metaData.getClass().getMethod("getSuffix", new Class[0]).invoke(metaData, new Object[0]);
                    if (suffix != null && !suffix.isEmpty()) {
                        suffix = this.applyHexColors(suffix);
                        text = text.replace("%luckperms_suffix%", suffix);
                    } else {
                        text = text.replace("%luckperms_suffix%", "");
                    }
                } else {
                    text = text.replace("%luckperms_suffix%", "");
                }
            }
            catch (Exception e) {
                this.getLogger().warning("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0441\u0443\u0444\u0444\u0438\u043a\u0441 LuckPerms: " + e.getMessage());
                text = text.replace("%luckperms_suffix%", "");
            }
        }
        if (this.hasPlaceholderAPI) {
            try {
                Class<?> papiClass = Class.forName("me.clip.placeholderapi.PlaceholderAPI");
                Object result = papiClass.getMethod("setPlaceholders", Player.class, String.class).invoke(null, player, text);
                if (result instanceof String) {
                    text = (String)result;
                }
            }
            catch (Exception e) {
                this.getLogger().warning("Failed to set PlaceholderAPI placeholders: " + e.getMessage());
            }
        }
        return text;
    }

    private String applyHexColors(String text) {
        if (text == null) {
            return "";
        }
        Pattern pattern = Pattern.compile("&#([A-Fa-f0-9]{6})");
        Matcher matcher = pattern.matcher(text);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            String hex = matcher.group(1);
            StringBuilder replacement = new StringBuilder("\u00a7x");
            for (char c : hex.toCharArray()) {
                replacement.append("\u00a7").append(c);
            }
            matcher.appendReplacement(buffer, replacement.toString());
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }

    private String applyGradients(String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        Matcher matcher = this.gradientPattern.matcher(text);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            String startColor = matcher.group(1);
            String content = matcher.group(2);
            String endColor = matcher.group(3);
            String gradientText = this.createGradient(content, startColor, endColor);
            matcher.appendReplacement(result, Matcher.quoteReplacement(gradientText));
        }
        matcher.appendTail(result);
        return result.toString();
    }

    private String createGradient(String text, String startHex, String endHex) {
        if (text == null || text.isEmpty()) {
            return "";
        }
        try {
            Color startColor = Color.decode("#" + startHex);
            Color endColor = Color.decode("#" + endHex);
            StringBuilder gradient = new StringBuilder();
            int length = text.length();
            for (int i = 0; i < length; ++i) {
                float ratio = (float)i / (float)Math.max(1, length - 1);
                Color currentColor = this.interpolateColor(startColor, endColor, ratio);
                gradient.append(this.colorToMinecraftHex(currentColor));
                gradient.append(text.charAt(i));
            }
            return gradient.toString();
        }
        catch (Exception e) {
            this.getLogger().warning("Failed to create gradient: " + e.getMessage());
            return text;
        }
    }

    private String colorToMinecraftHex(Color color) {
        String hex = String.format("#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue());
        StringBuilder minecraftHex = new StringBuilder("\u00a7x");
        for (char c : hex.substring(1).toCharArray()) {
            minecraftHex.append("\u00a7").append(c);
        }
        return minecraftHex.toString();
    }

    private Color interpolateColor(Color start, Color end, float ratio) {
        int red = Math.max(0, Math.min(255, (int)((float)start.getRed() + ratio * (float)(end.getRed() - start.getRed()))));
        int green = Math.max(0, Math.min(255, (int)((float)start.getGreen() + ratio * (float)(end.getGreen() - start.getGreen()))));
        int blue = Math.max(0, Math.min(255, (int)((float)start.getBlue() + ratio * (float)(end.getBlue() - start.getBlue()))));
        return new Color(red, green, blue);
    }

    private void sendLocalMessage(Player sender, String formattedMessage) {
        if (!this.config.getBoolean("local-chat.enabled", true)) {
            sender.sendMessage(this.getMessage("local-chat-disabled"));
            return;
        }
        int radius = this.config.getInt("local-chat.radius", 50);
        double radiusSquared = radius * radius;
        int recipients = 0;
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!player.getWorld().equals((Object)sender.getWorld()) || !(player.getLocation().distanceSquared(sender.getLocation()) <= radiusSquared)) continue;
            player.sendMessage(formattedMessage);
            if (player.getUniqueId().equals(sender.getUniqueId())) continue;
            ++recipients;
        }
        if (recipients == 0 && this.config.getBoolean("local-chat.show-silent-message", true)) {
            sender.sendMessage(this.getMessage("local-chat-silent"));
        }
    }

    private void sendGlobalMessage(String formattedMessage) {
        if (!this.config.getBoolean("global-chat.enabled", true)) {
            return;
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            player.sendMessage(formattedMessage);
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (command.getName().equalsIgnoreCase("gchat")) {
            return this.handleGChatCommand(sender, args);
        }
        if (command.getName().equalsIgnoreCase("g")) {
            return this.handleGlobalCommand(sender, args);
        }
        if (command.getName().equalsIgnoreCase("l")) {
            return this.handleLocalCommand(sender, args);
        }
        return false;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (command.getName().equalsIgnoreCase("gchat") && args.length == 1) {
            ArrayList<String> completions = new ArrayList<String>();
            if (sender.hasPermission("gchat.reload")) {
                completions.add("reload");
            }
            if (sender.hasPermission("gchat.debug")) {
                completions.add("debug");
            }
            completions.add("help");
            return completions.stream().filter(c -> c.startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private boolean handleGChatCommand(CommandSender sender, String[] args) {
        if (args.length == 0) {
            this.sendHelp(sender);
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "reload": {
                if (!sender.hasPermission("gchat.reload")) {
                    sender.sendMessage(this.getMessage("no-permission"));
                    return true;
                }
                if (sender instanceof Player) {
                    int cooldown;
                    long lastReload;
                    Player player = (Player)sender;
                    long currentTime = System.currentTimeMillis();
                    if (currentTime - (lastReload = this.reloadCooldowns.getOrDefault(player.getUniqueId(), 0L).longValue()) < (long)(cooldown = this.config.getInt("reload-cooldown", 5) * 1000)) {
                        long remaining = ((long)cooldown - (currentTime - lastReload)) / 1000L;
                        sender.sendMessage(this.getMessage("reload-cooldown").replace("{time}", String.valueOf(remaining)));
                        return true;
                    }
                    this.reloadCooldowns.put(player.getUniqueId(), currentTime);
                }
                this.reloadConfigValues();
                sender.sendMessage(this.getMessage("config-reloaded"));
                break;
            }
            case "help": {
                this.sendHelp(sender);
                break;
            }
            case "debug": {
                if (!sender.hasPermission("gchat.debug")) {
                    sender.sendMessage(this.getMessage("no-permission"));
                    return true;
                }
                return this.handleDebugCommand(sender, args);
            }
            default: {
                sender.sendMessage(this.getMessage("unknown-command"));
            }
        }
        return true;
    }

    private boolean handleDebugCommand(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.getMessage("players-only"));
            return true;
        }
        Player player = (Player)sender;
        player.sendMessage("\u00a76=== Group Debug ===");
        player.sendMessage("\u00a77OP status: \u00a7e" + player.isOp());
        player.sendMessage("\u00a77Username: \u00a7e" + player.getName());
        if (!this.hasLuckPerms || this.luckPermsAPI == null) {
            player.sendMessage("\u00a7cLuckPerms \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0438\u043b\u0438 \u043d\u0435 \u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0438\u0440\u043e\u0432\u0430\u043d");
            return true;
        }
        try {
            Object cachedData;
            Object metaData;
            String suffix;
            Object nodes;
            Class<?> apiClass = this.luckPermsAPI.getClass();
            Object userManager = apiClass.getMethod("getUserManager", new Class[0]).invoke(this.luckPermsAPI, new Object[0]);
            Object user = userManager.getClass().getMethod("getUser", UUID.class).invoke(userManager, player.getUniqueId());
            if (user == null) {
                player.sendMessage("\u00a7c\u0418\u0433\u0440\u043e\u043a \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0432 LuckPerms");
                return true;
            }
            String primaryGroup = (String)user.getClass().getMethod("getPrimaryGroup", new Class[0]).invoke(user, new Object[0]);
            if (primaryGroup != null && !primaryGroup.equalsIgnoreCase("default")) {
                player.sendMessage("\u00a77Primary Group: \u00a7e" + primaryGroup);
            } else {
                player.sendMessage("\u00a77Primary Group: \u00a7cdefault");
            }
            HashSet configGroups = new HashSet();
            if (this.config.isConfigurationSection("group-formats")) {
                configGroups.addAll(this.config.getConfigurationSection("group-formats").getKeys(false));
            }
            if ((nodes = user.getClass().getMethod("getNodes", new Class[0]).invoke(user, new Object[0])) instanceof Iterable) {
                player.sendMessage("\u00a77=== Groups in config ===");
                for (Object node : (Iterable)nodes) {
                    String groupName;
                    if (!node.getClass().getSimpleName().equals("InheritanceNode") || (groupName = (String)node.getClass().getMethod("getGroupName", new Class[0]).invoke(node, new Object[0])) == null || !configGroups.contains(groupName.toLowerCase())) continue;
                    player.sendMessage("\u00a7e- " + groupName);
                }
            }
            player.sendMessage("\u00a77Suffix: \u00a7f" + ((suffix = (String)(metaData = (cachedData = user.getClass().getMethod("getCachedData", new Class[0]).invoke(user, new Object[0])).getClass().getMethod("getMetaData", new Class[0]).invoke(cachedData, new Object[0])).getClass().getMethod("getSuffix", new Class[0]).invoke(metaData, new Object[0])) != null ? suffix : "none"));
        }
        catch (Exception e) {
            player.sendMessage("\u00a7c\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0438 \u0434\u0430\u043d\u043d\u044b\u0445 LuckPerms: " + e.getMessage());
        }
        return true;
    }

    private boolean handleGlobalCommand(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            return true;
        }
        Player player = (Player)sender;
        if (args.length > 0) {
            this.processChatMessage(player, String.join((CharSequence)" ", args), "global");
        } else {
            this.playerChatModes.put(player.getUniqueId(), "global");
            player.sendMessage(this.getMessage("chat-mode-global"));
        }
        return true;
    }

    private boolean handleLocalCommand(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            return true;
        }
        Player player = (Player)sender;
        if (args.length > 0) {
            this.processChatMessage(player, String.join((CharSequence)" ", args), "local");
        } else {
            this.playerChatModes.put(player.getUniqueId(), "local");
            player.sendMessage(this.getMessage("chat-mode-local"));
        }
        return true;
    }

    private boolean canUseColors(Player player) {
        return player.hasPermission("gchat.color");
    }

    private boolean canUseGradients(Player player) {
        return player.hasPermission("gchat.gradient");
    }

    private String processMessageColors(Player player, String message) {
        if (this.canUseColors(player)) {
            return message.replace("&", "\u00a7");
        }
        return this.colorPattern.matcher(message).replaceAll("");
    }

    private String processMessageGradients(Player player, String message) {
        if (this.canUseGradients(player)) {
            return this.applyGradients(message);
        }
        return this.removeGradients(message);
    }

    private String removeGradients(String text) {
        return text.replaceAll("\\{#[0-9A-Fa-f]{6}>\\}", "").replaceAll("\\{#[0-9A-Fa-f]{6}<\\}", "");
    }

    private boolean checkCooldown(Player player) {
        int cooldown;
        long lastMessage;
        if (!this.config.getBoolean("message-cooldown.enabled", false)) {
            return true;
        }
        if (player.hasPermission("gchat.bypass.cooldown")) {
            return true;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - (lastMessage = this.messageCooldowns.getOrDefault(player.getUniqueId(), 0L).longValue()) < (long)(cooldown = this.config.getInt("message-cooldown.seconds", 3) * 1000)) {
            long remaining = ((long)cooldown - (currentTime - lastMessage)) / 1000L;
            player.sendMessage(this.getMessage("message-cooldown").replace("{time}", String.valueOf(remaining)));
            return false;
        }
        this.messageCooldowns.put(player.getUniqueId(), currentTime);
        return true;
    }

    private boolean checkMessageLength(Player player, String message) {
        int maxLength = this.config.getInt("max-message-length", 256);
        if (message.length() > maxLength && !player.hasPermission("gchat.bypass.length")) {
            player.sendMessage(this.getMessage("message-too-long").replace("{max}", String.valueOf(maxLength)));
            return false;
        }
        return true;
    }

    private String filterBadWords(Player player, String message) {
        if (!this.config.getBoolean("filter.enabled", false) || player.hasPermission("gchat.bypass.filter")) {
            return message;
        }
        List badWords = this.config.getStringList("filter.words");
        String resultMessage = message;
        for (String word : badWords) {
            if (!resultMessage.toLowerCase().contains(word.toLowerCase())) continue;
            if (this.config.getBoolean("filter.block-message", true)) {
                player.sendMessage(this.getMessage("message-blocked"));
                return null;
            }
            String replacement = String.join((CharSequence)"", Collections.nCopies(word.length(), "*"));
            resultMessage = resultMessage.replaceAll("(?i)" + Pattern.quote(word), replacement);
        }
        return resultMessage;
    }

    private boolean hasChatPermission(Player player, String chatType) {
        if (player.hasPermission("gchat.bypass")) {
            return true;
        }
        return chatType.equalsIgnoreCase("global") || chatType.equalsIgnoreCase("local");
    }

    private void processChatMessage(Player player, String originalMessage, String chatMode) {
        if (!this.hasChatPermission(player, chatMode)) {
            return;
        }
        if (!this.checkCooldown(player)) {
            return;
        }
        if (!this.checkMessageLength(player, originalMessage)) {
            return;
        }
        String filteredMessage = this.filterBadWords(player, originalMessage);
        if (filteredMessage == null) {
            return;
        }
        String processedMessage = this.processMessageColors(player, filteredMessage);
        processedMessage = this.processMessageGradients(player, processedMessage);
        String formattedMessage = this.formatMessage(player, processedMessage, chatMode);
        if (chatMode.equals("local")) {
            this.sendLocalMessage(player, formattedMessage);
        } else {
            this.sendGlobalMessage(formattedMessage);
        }
        if (this.config.getBoolean("log-to-console", false)) {
            String cleanMessage = originalMessage.replace("&", "").replace("\u00a7", "");
            String mode = chatMode.toUpperCase();
            Bukkit.getLogger().info("[" + mode + "] " + player.getName() + ": " + cleanMessage);
        }
    }

    @EventHandler
    public void onAsyncPlayerChatEvent(AsyncPlayerChatEvent event) {
        if (!this.config.getBoolean("enabled", true)) {
            return;
        }
        Player player = event.getPlayer();
        String originalMessage = event.getMessage();
        String chatMode = this.playerChatModes.getOrDefault(player.getUniqueId(), this.config.getString("default-chat-mode", "local"));
        if (originalMessage.startsWith("!")) {
            originalMessage = originalMessage.substring(1).trim();
            chatMode = "global";
        } else {
            chatMode = chatMode.toLowerCase();
        }
        Player finalPlayer = player;
        String finalMessage = originalMessage;
        String finalChatMode = chatMode;
        event.setCancelled(true);
        Bukkit.getScheduler().runTask((Plugin)this, () -> this.processChatMessage(finalPlayer, finalMessage, finalChatMode));
    }

    @EventHandler
    public void onPlayerCommand(PlayerCommandPreprocessEvent event) {
        String message = event.getMessage().toLowerCase();
        Player player = event.getPlayer();
        for (String cmd : this.blockedCommands) {
            if (!message.startsWith(cmd.toLowerCase())) continue;
            player.sendMessage(this.getMessage("no-permission"));
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (this.joinMessage != null && !this.joinMessage.isEmpty()) {
            event.setJoinMessage(this.joinMessage.replace("%player_name%", player.getName()).replace("&", "\u00a7"));
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        if (this.quitMessage != null && !this.quitMessage.isEmpty()) {
            event.setQuitMessage(this.quitMessage.replace("%player_name%", player.getName()).replace("&", "\u00a7"));
        }
    }

    private void sendHelp(CommandSender sender) {
        if (this.messagesConfig.contains("help")) {
            for (String line : this.messagesConfig.getStringList("help")) {
                sender.sendMessage(line.replace("&", "\u00a7"));
            }
        } else {
            sender.sendMessage("\u00a76\u00a7l=== gChat Help ===");
            sender.sendMessage("\u00a7e/gchat reload \u00a77- \u041f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044e");
            sender.sendMessage("\u00a7e/gchat help \u00a77- \u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u044d\u0442\u0443 \u043f\u043e\u043c\u043e\u0449\u044c");
            sender.sendMessage("\u00a7e/gchat debug \u00a77- Debug \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f");
            sender.sendMessage("\u00a7e/g \u00a77- \u041f\u0435\u0440\u0435\u043a\u043b\u044e\u0447\u0438\u0442\u044c\u0441\u044f \u043d\u0430 \u0433\u043b\u043e\u0431\u0430\u043b\u044c\u043d\u044b\u0439 \u0447\u0430\u0442");
            sender.sendMessage("\u00a7e/g <\u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435> \u00a77- \u041e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u0433\u043b\u043e\u0431\u0430\u043b\u044c\u043d\u043e\u0435 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435");
            sender.sendMessage("\u00a7e/l \u00a77- \u041f\u0435\u0440\u0435\u043a\u043b\u044e\u0447\u0438\u0442\u044c\u0441\u044f \u043d\u0430 \u043b\u043e\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0447\u0430\u0442");
            sender.sendMessage("\u00a7e/l <\u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435> \u00a77- \u041e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u043b\u043e\u043a\u0430\u043b\u044c\u043d\u043e\u0435 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435");
            sender.sendMessage("\u00a7e!<\u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435> \u00a77- \u041e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u0440\u0430\u0437\u043e\u0432\u043e\u0435 \u0433\u043b\u043e\u0431\u0430\u043b\u044c\u043d\u043e\u0435 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435");
            sender.sendMessage("\u00a76\u0413\u0440\u0430\u0434\u0438\u0435\u043d\u0442\u044b: \u00a77{#RRGGBB>}Text{#RRGGBB<}");
            if (sender.hasPermission("gchat.use")) {
                sender.sendMessage("\u00a7a\u2713 \u0412\u044b \u0438\u043c\u0435\u0435\u0442\u0435 \u0434\u043e\u0441\u0442\u0443\u043f \u043a \u0447\u0430\u0442\u0443");
            } else {
                sender.sendMessage("\u00a7c\u2717 \u0423 \u0432\u0430\u0441 \u043d\u0435\u0442 \u0434\u043e\u0441\u0442\u0443\u043f\u0430 \u043a \u0447\u0430\u0442\u0443");
            }
        }
    }
}

