/*
 * Decompiled with CFR 0.152.
 */
package com.Gomania.gChat;

import com.Gomania.gChat.commands.BroadcastCommand;
import com.Gomania.gChat.commands.GChatCommand;
import com.Gomania.gChat.commands.GlobalChatCommand;
import com.Gomania.gChat.commands.LocalChatCommand;
import com.Gomania.gChat.commands.MsgCommand;
import com.Gomania.gChat.hooks.DiscordSRVHook;
import com.Gomania.gChat.hooks.LuckPermsHook;
import com.Gomania.gChat.hooks.PlaceholderAPIHook;
import com.Gomania.gChat.listeners.PlayerChatListener;
import com.Gomania.gChat.listeners.PlayerCommandListener;
import com.Gomania.gChat.listeners.PlayerConnectionListener;
import com.Gomania.gChat.listeners.PlayerDeathListener;
import com.Gomania.gChat.managers.BroadcastManager;
import com.Gomania.gChat.managers.ChatManager;
import com.Gomania.gChat.managers.ConfigManager;
import com.Gomania.gChat.managers.DependencyManager;
import com.Gomania.gChat.managers.MessageManager;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class GChat
extends JavaPlugin {
    private ConfigManager configManager;
    private MessageManager messageManager;
    private ChatManager chatManager;
    private BroadcastManager broadcastManager;
    private DependencyManager dependencyManager;
    private LuckPermsHook luckPermsHook;
    private PlaceholderAPIHook placeholderAPIHook;
    private DiscordSRVHook discordSRVHook;
    private final Map<UUID, String> playerChatModes = new HashMap<UUID, String>();

    public void onEnable() {
        this.configManager = new ConfigManager(this);
        this.messageManager = new MessageManager(this);
        this.dependencyManager = new DependencyManager(this);
        this.dependencyManager.checkDependencies();
        if (this.dependencyManager.hasLuckPerms()) {
            this.luckPermsHook = new LuckPermsHook(this, this.dependencyManager.getLuckPermsAPI());
        }
        if (this.dependencyManager.hasPlaceholderAPI()) {
            this.placeholderAPIHook = new PlaceholderAPIHook(this);
        }
        if (this.dependencyManager.hasDiscordSRV() && this.configManager.isDiscordEnabled()) {
            this.discordSRVHook = new DiscordSRVHook(this);
            this.discordSRVHook.subscribe();
        }
        this.chatManager = new ChatManager(this);
        this.broadcastManager = new BroadcastManager(this);
        this.broadcastManager.scheduleBroadcasts();
        this.registerListeners();
        this.registerCommands();
        this.getLogger().info("gChat plugin enabled! (Refactored Structure)");
    }

    public void onDisable() {
        if (this.broadcastManager != null) {
            this.broadcastManager.cancelBroadcasts();
        }
        if (this.discordSRVHook != null) {
            this.discordSRVHook.unsubscribe();
        }
        if (this.luckPermsHook != null) {
            this.luckPermsHook.clearCache();
        }
        this.playerChatModes.clear();
        this.getLogger().info("gChat plugin disabled!");
    }

    private void registerListeners() {
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerChatListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerConnectionListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerDeathListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerCommandListener(this), (Plugin)this);
    }

    private void registerCommands() {
        PluginCommand gchat = this.getCommand("gchat");
        if (gchat != null) {
            GChatCommand gChatCommand = new GChatCommand(this);
            gchat.setExecutor((CommandExecutor)gChatCommand);
            gchat.setTabCompleter((TabCompleter)gChatCommand);
        } else {
            this.getLogger().warning("\u041a\u043e\u043c\u0430\u043d\u0434\u0430 'gchat' \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0432 plugin.yml!");
        }
        PluginCommand gCommand = this.getCommand("g");
        if (gCommand != null) {
            gCommand.setExecutor((CommandExecutor)new GlobalChatCommand(this));
        } else {
            this.getLogger().warning("\u041a\u043e\u043c\u0430\u043d\u0434\u0430 'g' \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0432 plugin.yml! \u041a\u043e\u043c\u0430\u043d\u0434\u044b /g \u0438 /gc \u043d\u0435 \u0431\u0443\u0434\u0443\u0442 \u0440\u0430\u0431\u043e\u0442\u0430\u0442\u044c.");
        }
        PluginCommand lCommand = this.getCommand("l");
        if (lCommand != null) {
            lCommand.setExecutor((CommandExecutor)new LocalChatCommand(this));
        } else {
            this.getLogger().warning("\u041a\u043e\u043c\u0430\u043d\u0434\u0430 'l' \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0432 plugin.yml! \u041a\u043e\u043c\u0430\u043d\u0434\u044b /l \u0438 /lc \u043d\u0435 \u0431\u0443\u0434\u0443\u0442 \u0440\u0430\u0431\u043e\u0442\u0430\u0442\u044c.");
        }
        PluginCommand broadcastCommand = this.getCommand("broadcast");
        if (broadcastCommand != null) {
            broadcastCommand.setExecutor((CommandExecutor)new BroadcastCommand(this));
        } else {
            this.getLogger().warning("\u041a\u043e\u043c\u0430\u043d\u0434\u0430 'broadcast' \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0432 plugin.yml!");
        }
        PluginCommand msgCommand = this.getCommand("msg");
        if (msgCommand != null) {
            msgCommand.setExecutor((CommandExecutor)new MsgCommand(this));
        } else {
            this.getLogger().warning("\u041a\u043e\u043c\u0430\u043d\u0434\u0430 'msg' \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0432 plugin.yml!");
        }
    }

    public void reloadPlugin() {
        boolean discordShouldBeEnabled;
        this.configManager.reloadConfigs();
        this.messageManager.reloadMessages();
        this.dependencyManager.checkDependencies();
        if (this.dependencyManager.hasLuckPerms()) {
            if (this.luckPermsHook == null) {
                this.luckPermsHook = new LuckPermsHook(this, this.dependencyManager.getLuckPermsAPI());
            } else {
                this.luckPermsHook.clearCache();
            }
        }
        if (this.dependencyManager.hasPlaceholderAPI() && this.placeholderAPIHook == null) {
            this.placeholderAPIHook = new PlaceholderAPIHook(this);
        }
        boolean bl = discordShouldBeEnabled = this.dependencyManager.hasDiscordSRV() && this.configManager.isDiscordEnabled();
        if (discordShouldBeEnabled && this.discordSRVHook == null) {
            this.discordSRVHook = new DiscordSRVHook(this);
            this.discordSRVHook.subscribe();
        } else if (!discordShouldBeEnabled && this.discordSRVHook != null) {
            this.discordSRVHook.unsubscribe();
            this.discordSRVHook = null;
        }
        this.chatManager.reload();
        this.broadcastManager.reload();
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public MessageManager getMessageManager() {
        return this.messageManager;
    }

    public ChatManager getChatManager() {
        return this.chatManager;
    }

    public BroadcastManager getBroadcastManager() {
        return this.broadcastManager;
    }

    public DependencyManager getDependencyManager() {
        return this.dependencyManager;
    }

    public LuckPermsHook getLuckPermsHook() {
        return this.luckPermsHook;
    }

    public PlaceholderAPIHook getPlaceholderAPIHook() {
        return this.placeholderAPIHook;
    }

    public DiscordSRVHook getDiscordSRVHook() {
        return this.discordSRVHook;
    }

    public String getPlayerChatMode(UUID uuid) {
        return this.playerChatModes.getOrDefault(uuid, this.configManager.getDefaultChatMode());
    }

    public void setPlayerChatMode(UUID uuid, String mode) {
        this.playerChatModes.put(uuid, mode);
    }

    public void removePlayerChatMode(UUID uuid) {
        this.playerChatModes.remove(uuid);
    }
}

