/*
 * Decompiled with CFR 0.152.
 */
package com.Gomania.gChat.commands;

import com.Gomania.gChat.GChat;
import com.Gomania.gChat.managers.BroadcastManager;
import com.Gomania.gChat.managers.MessageManager;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;

public class BroadcastCommand
implements CommandExecutor {
    private final GChat plugin;
    private final BroadcastManager broadcastManager;
    private final MessageManager messages;

    public BroadcastCommand(GChat plugin) {
        this.plugin = plugin;
        this.broadcastManager = plugin.getBroadcastManager();
        this.messages = plugin.getMessageManager();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("gchat.broadcast")) {
            sender.sendMessage(this.messages.getMessage("no-permission"));
            return true;
        }
        if (args.length == 0) {
            sender.sendMessage("\u00a76\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435: /broadcast <\u043d\u043e\u043c\u0435\u0440|next|reload>");
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "reload": {
                this.broadcastManager.reload();
                sender.sendMessage("\u00a7aBroadcast \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u0430 \u0438 \u0437\u0430\u0434\u0430\u0447\u0430 \u043f\u0435\u0440\u0435\u0437\u0430\u043f\u0443\u0449\u0435\u043d\u0430!");
                break;
            }
            case "next": {
                this.broadcastManager.sendNextBroadcastMessage();
                sender.sendMessage("\u00a7a\u0421\u043b\u0435\u0434\u0443\u044e\u0449\u0435\u0435 broadcast \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e!");
                break;
            }
            default: {
                try {
                    int index = Integer.parseInt(args[0]) - 1;
                    List<String> broadcastMessages = this.plugin.getConfigManager().getBroadcastMessages();
                    if (index < 0 || index >= broadcastMessages.size()) {
                        sender.sendMessage("\u00a7c\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440. \u0414\u043e\u0441\u0442\u0443\u043f\u043d\u043e " + broadcastMessages.size() + " \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0439 (\u043e\u0442 1 \u0434\u043e " + broadcastMessages.size() + ").");
                        return true;
                    }
                    this.broadcastManager.sendFormattedBroadcast(broadcastMessages.get(index));
                    sender.sendMessage("\u00a7aBroadcast \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 #" + (index + 1) + " \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e!");
                    break;
                }
                catch (NumberFormatException e) {
                    sender.sendMessage("\u00a7c\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442. \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 \u043d\u043e\u043c\u0435\u0440, next \u0438\u043b\u0438 reload.");
                }
            }
        }
        return true;
    }
}

