/*
 * Decompiled with CFR 0.152.
 */
package com.Gomania.gChat.commands;

import com.Gomania.gChat.GChat;
import com.Gomania.gChat.hooks.LuckPermsHook;
import com.Gomania.gChat.managers.ConfigManager;
import com.Gomania.gChat.managers.CooldownManager;
import com.Gomania.gChat.managers.MessageManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class GChatCommand
implements CommandExecutor,
TabCompleter {
    private final GChat plugin;
    private final MessageManager messages;
    private final ConfigManager config;
    private final CooldownManager reloadCooldown = new CooldownManager();

    public GChatCommand(GChat plugin) {
        this.plugin = plugin;
        this.messages = plugin.getMessageManager();
        this.config = plugin.getConfigManager();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            this.sendHelp(sender);
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "reload": {
                return this.handleReload(sender);
            }
            case "help": {
                this.sendHelp(sender);
                return true;
            }
            case "debug": {
                return this.handleDebug(sender);
            }
        }
        sender.sendMessage(this.messages.getMessage("unknown-command"));
        return true;
    }

    private boolean handleReload(CommandSender sender) {
        if (!sender.hasPermission("gchat.reload")) {
            sender.sendMessage(this.messages.getMessage("no-permission"));
            return true;
        }
        if (sender instanceof Player) {
            Player player = (Player)sender;
            int cd = this.config.getReloadCooldown();
            if (!this.reloadCooldown.check(player.getUniqueId(), cd)) {
                long remaining = this.reloadCooldown.getRemaining(player.getUniqueId(), cd);
                player.sendMessage(this.messages.getMessage("reload-cooldown").replace("{time}", String.valueOf(remaining)));
                return true;
            }
        }
        this.plugin.reloadPlugin();
        sender.sendMessage(this.messages.getMessage("config-reloaded"));
        return true;
    }

    private boolean handleDebug(CommandSender sender) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.messages.getMessage("players-only"));
            return true;
        }
        if (!sender.hasPermission("gchat.debug")) {
            sender.sendMessage(this.messages.getMessage("no-permission"));
            return true;
        }
        Player player = (Player)sender;
        LuckPermsHook lpHook = this.plugin.getLuckPermsHook();
        player.sendMessage("\u00a76=== gChat Debug ===");
        player.sendMessage("\u00a77Username: \u00a7e" + player.getName());
        if (lpHook == null) {
            player.sendMessage("\u00a7cLuckPerms \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0438\u043b\u0438 \u043d\u0435 \u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0438\u0440\u043e\u0432\u0430\u043d.");
        } else {
            try {
                Set<String> validGroups = this.config.getGroupFormatKeys();
                String group = lpHook.getPlayerGroup(player.getUniqueId(), validGroups);
                String suffix = lpHook.getPlayerSuffix(player.getUniqueId());
                player.sendMessage("\u00a77Primary Group (from cache): \u00a7e" + (group != null ? group : "default"));
                player.sendMessage("\u00a77Suffix (from cache): \u00a7f" + (suffix != null && !suffix.isEmpty() ? suffix : "none"));
            }
            catch (Exception e) {
                player.sendMessage("\u00a7c\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0438 \u0434\u0430\u043d\u043d\u044b\u0445 LuckPerms: " + e.getMessage());
            }
        }
        player.sendMessage("\u00a77PAPI: \u00a7e" + this.plugin.getDependencyManager().hasPlaceholderAPI());
        player.sendMessage("\u00a77DiscordSRV: \u00a7e" + this.plugin.getDependencyManager().hasDiscordSRV());
        return true;
    }

    private void sendHelp(CommandSender sender) {
        List<String> helpLines = this.messages.getHelpMessage();
        for (String line : helpLines) {
            sender.sendMessage(line);
        }
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            ArrayList<String> completions = new ArrayList<String>();
            if (sender.hasPermission("gchat.reload")) {
                completions.add("reload");
            }
            if (sender.hasPermission("gchat.debug")) {
                completions.add("debug");
            }
            completions.add("help");
            return completions.stream().filter(c -> c.startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

