/*
 * Decompiled with CFR 0.152.
 */
package com.Gomania.gChat.hooks;

import com.Gomania.gChat.GChat;
import com.Gomania.gChat.managers.ConfigManager;
import com.Gomania.gChat.utils.ChatColorUtils;
import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.api.Subscribe;
import github.scarsz.discordsrv.api.events.DiscordGuildMessagePostProcessEvent;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Role;
import github.scarsz.discordsrv.util.MessageUtil;
import java.awt.Color;
import java.util.List;
import org.bukkit.entity.Player;

public class DiscordSRVHook {
    private final GChat plugin;
    private final ConfigManager config;

    public DiscordSRVHook(GChat plugin) {
        this.plugin = plugin;
        this.config = plugin.getConfigManager();
    }

    public void subscribe() {
        try {
            DiscordSRV.api.subscribe((Object)this);
            this.plugin.getLogger().info("Successfully subscribed to DiscordSRV API.");
        }
        catch (Exception | NoClassDefFoundError e_api) {
            this.plugin.getLogger().warning("Failed to subscribe to DiscordSRV API: " + e_api.getMessage());
            this.plugin.getDependencyManager().setDiscordSRVStatus(false);
        }
    }

    public void unsubscribe() {
        if (!this.plugin.getDependencyManager().hasDiscordSRV()) {
            return;
        }
        try {
            DiscordSRV.api.unsubscribe((Object)this);
            this.plugin.getLogger().info("Unsubscribed from DiscordSRV API.");
        }
        catch (Exception | NoClassDefFoundError throwable) {
            // empty catch block
        }
    }

    @Subscribe
    public void onDiscordChat(DiscordGuildMessagePostProcessEvent event) {
        if (!this.config.isDiscordToMcEnabled()) {
            return;
        }
        event.setCancelled(true);
        String author = event.getMember().getEffectiveName();
        String message = MessageUtil.strip((String)event.getProcessedMessage());
        if (message.isEmpty()) {
            return;
        }
        String roleColorHex = "";
        String roleName = "";
        try {
            List roles;
            Color roleColor = event.getMember().getColor();
            if (roleColor != null) {
                roleColorHex = ChatColorUtils.colorToMinecraftHex(roleColor);
            }
            if (!(roles = event.getMember().getRoles()).isEmpty()) {
                roleName = ((Role)roles.get(0)).getName();
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to get Discord role info: " + e.getMessage());
        }
        String format = this.config.getDiscordFormat().replace("%role_color%", roleColorHex).replace("%role_name%", roleName).replace("%user%", author).replace("%message%", message);
        format = ChatColorUtils.translateColors(format, true, true);
        this.plugin.getChatManager().sendGlobalMessage(format, false);
    }

    public void sendToDiscord(Player player, String message) {
        if (!this.config.isMcToDiscordEnabled() || !this.plugin.getDependencyManager().hasDiscordSRV()) {
            return;
        }
        try {
            DiscordSRV.getPlugin().processChatMessage(player, message, null, false);
        }
        catch (Exception | NoClassDefFoundError e) {
            this.plugin.getLogger().warning("Failed to send message to DiscordSRV: " + e.getMessage());
            this.plugin.getDependencyManager().setDiscordSRVStatus(false);
        }
    }
}

