/*
 * Decompiled with CFR 0.152.
 */
package com.Gomania.gChat.hooks;

import com.Gomania.gChat.GChat;
import com.Gomania.gChat.utils.ChatColorUtils;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class LuckPermsHook {
    private final GChat plugin;
    private final Map<UUID, CachedPlayerData> cache = new ConcurrentHashMap<UUID, CachedPlayerData>();
    private final Object luckPermsAPI;

    public LuckPermsHook(GChat plugin, Object luckPermsAPI) {
        this.plugin = plugin;
        this.luckPermsAPI = luckPermsAPI;
    }

    public String getPlayerGroup(UUID uuid, Set<String> validGroups) {
        long now = System.currentTimeMillis();
        CachedPlayerData cached = this.cache.get(uuid);
        if (cached != null && now - cached.timestamp < 60000L) {
            return cached.primaryGroup;
        }
        try {
            Class<?> apiClass = this.luckPermsAPI.getClass();
            Object userManager = apiClass.getMethod("getUserManager", new Class[0]).invoke(this.luckPermsAPI, new Object[0]);
            Object user = userManager.getClass().getMethod("getUser", UUID.class).invoke(userManager, uuid);
            if (user == null) {
                return null;
            }
            String primaryGroup = (String)user.getClass().getMethod("getPrimaryGroup", new Class[0]).invoke(user, new Object[0]);
            CachedPlayerData newData = new CachedPlayerData();
            newData.timestamp = now;
            newData.primaryGroup = primaryGroup != null && validGroups.contains(primaryGroup.toLowerCase()) ? primaryGroup.toLowerCase() : null;
            Object cachedData = user.getClass().getMethod("getCachedData", new Class[0]).invoke(user, new Object[0]);
            Object metaData = cachedData.getClass().getMethod("getMetaData", new Class[0]).invoke(cachedData, new Object[0]);
            String suffix = (String)metaData.getClass().getMethod("getSuffix", new Class[0]).invoke(metaData, new Object[0]);
            newData.suffix = suffix != null ? ChatColorUtils.translateColors(suffix, true, true) : "";
            this.cache.put(uuid, newData);
            return newData.primaryGroup;
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to get LuckPerms data for " + String.valueOf(uuid) + ": " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    public String getPlayerSuffix(UUID uuid) {
        CachedPlayerData cached = this.cache.get(uuid);
        if (cached == null) {
            this.getPlayerGroup(uuid, this.plugin.getConfigManager().getGroupFormatKeys());
            cached = this.cache.get(uuid);
        }
        return cached != null ? cached.suffix : "";
    }

    public void removeCache(UUID uuid) {
        this.cache.remove(uuid);
    }

    public void clearCache() {
        this.cache.clear();
    }

    private static class CachedPlayerData {
        String primaryGroup;
        String suffix;
        long timestamp;

        private CachedPlayerData() {
        }
    }
}

