/*
 * Decompiled with CFR 0.152.
 */
package com.Gomania.gChat.listeners;

import com.Gomania.gChat.GChat;
import com.Gomania.gChat.managers.ChatManager;
import com.Gomania.gChat.managers.ConfigManager;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.Plugin;

public class PlayerChatListener
implements Listener {
    private final GChat plugin;
    private final ChatManager chatManager;
    private final ConfigManager configManager;

    public PlayerChatListener(GChat plugin) {
        this.plugin = plugin;
        this.chatManager = plugin.getChatManager();
        this.configManager = plugin.getConfigManager();
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onAsyncPlayerChatEvent(AsyncPlayerChatEvent event) {
        if (!this.configManager.isPluginEnabled()) {
            return;
        }
        Player player = event.getPlayer();
        String originalMessage = event.getMessage();
        String chatMode = this.plugin.getPlayerChatMode(player.getUniqueId());
        if (originalMessage.startsWith("!")) {
            if ((originalMessage = originalMessage.substring(1).trim()).isEmpty()) {
                event.setCancelled(true);
                return;
            }
            chatMode = "global";
        } else {
            chatMode = chatMode.toLowerCase();
        }
        String finalMessage = originalMessage;
        String finalChatMode = chatMode;
        event.setCancelled(true);
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.chatManager.processChatMessage(player, finalMessage, finalChatMode));
    }
}

