/*
 * Decompiled with CFR 0.152.
 */
package com.Gomania.gChat.listeners;

import com.Gomania.gChat.GChat;
import com.Gomania.gChat.managers.ConfigManager;
import com.Gomania.gChat.managers.MessageManager;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;

public class PlayerCommandListener
implements Listener {
    private final ConfigManager config;
    private final MessageManager messages;

    public PlayerCommandListener(GChat plugin) {
        this.config = plugin.getConfigManager();
        this.messages = plugin.getMessageManager();
    }

    @EventHandler
    public void onPlayerCommand(PlayerCommandPreprocessEvent event) {
        if (!this.config.isBlockCommandsEnabled()) {
            return;
        }
        Player player = event.getPlayer();
        String message = event.getMessage().toLowerCase();
        if (player.isOp() || player.hasPermission("gchat.bcomm.bypass")) {
            return;
        }
        List<String> blockedCommands = this.config.getBlockedCommands();
        String cleanMessage = message.startsWith("/") ? message.substring(1) : message;
        for (String cmd : blockedCommands) {
            String cleanCmd;
            String string = cleanCmd = cmd.startsWith("/") ? cmd.substring(1) : cmd;
            if (!cleanMessage.startsWith(cleanCmd.toLowerCase() + " ") && !cleanMessage.equals(cleanCmd.toLowerCase())) continue;
            player.sendMessage(this.messages.getMessage("no-permission"));
            event.setCancelled(true);
            return;
        }
    }
}

