/*
 * Decompiled with CFR 0.152.
 */
package com.Gomania.gChat.listeners;

import com.Gomania.gChat.GChat;
import com.Gomania.gChat.hooks.LuckPermsHook;
import com.Gomania.gChat.managers.ConfigManager;
import com.Gomania.gChat.utils.ChatColorUtils;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class PlayerConnectionListener
implements Listener {
    private final GChat plugin;
    private final ConfigManager config;

    public PlayerConnectionListener(GChat plugin) {
        this.plugin = plugin;
        this.config = plugin.getConfigManager();
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        if (!this.config.isJoinQuitHandlingEnabled()) {
            return;
        }
        Player player = event.getPlayer();
        String joinMessage = this.config.getJoinMessage();
        if (joinMessage != null && !joinMessage.isEmpty()) {
            event.setJoinMessage(ChatColorUtils.translateColors(joinMessage.replace("%player_name%", player.getName()), true, true));
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        LuckPermsHook lpHook;
        String quitMessage;
        Player player = event.getPlayer();
        if (this.config.isJoinQuitHandlingEnabled() && (quitMessage = this.config.getQuitMessage()) != null && !quitMessage.isEmpty()) {
            event.setQuitMessage(ChatColorUtils.translateColors(quitMessage.replace("%player_name%", player.getName()), true, true));
        }
        if ((lpHook = this.plugin.getLuckPermsHook()) != null) {
            lpHook.removeCache(player.getUniqueId());
        }
        this.plugin.removePlayerChatMode(player.getUniqueId());
    }
}

