/*
 * Decompiled with CFR 0.152.
 */
package com.Gomania.gChat.listeners;

import com.Gomania.gChat.GChat;
import com.Gomania.gChat.managers.ConfigManager;
import com.Gomania.gChat.utils.ChatColorUtils;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.PlayerDeathEvent;

public class PlayerDeathListener
implements Listener {
    private final GChat plugin;
    private final ConfigManager config;

    public PlayerDeathListener(GChat plugin) {
        this.plugin = plugin;
        this.config = plugin.getConfigManager();
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        if (!this.config.isDeathMessagesEnabled()) {
            return;
        }
        Player player = event.getEntity();
        Player killer = player.getKiller();
        String customDeathMessage = null;
        if (killer != null) {
            customDeathMessage = this.config.getDeathMsgPlayerKill().replace("%player%", player.getName()).replace("%killer%", killer.getName());
        } else {
            EntityDamageByEntityEvent damageByEntity;
            Entity damager;
            EntityDamageEvent lastDamage = player.getLastDamageCause();
            if (lastDamage instanceof EntityDamageByEntityEvent && (damager = (damageByEntity = (EntityDamageByEntityEvent)lastDamage).getDamager()) instanceof LivingEntity && !(damager instanceof Player)) {
                String mobName = damager.getCustomName() != null ? damager.getCustomName() : damager.getName();
                customDeathMessage = this.config.getDeathMsgMobKill().replace("%player%", player.getName()).replace("%killer_mob%", mobName);
            }
        }
        if (customDeathMessage == null) {
            customDeathMessage = this.config.getDeathMsgOther().replace("%player%", player.getName());
        }
        customDeathMessage = ChatColorUtils.translateColors(customDeathMessage, true, true);
        Bukkit.broadcastMessage((String)customDeathMessage);
        if (this.config.isHideDefaultDeathMessage()) {
            event.setDeathMessage(null);
        }
    }
}

