/*
 * Decompiled with CFR 0.152.
 */
package com.Gomania.gChat.managers;

import com.Gomania.gChat.GChat;
import com.Gomania.gChat.hooks.PlaceholderAPIHook;
import com.Gomania.gChat.managers.ConfigManager;
import com.Gomania.gChat.utils.ChatColorUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Text;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class BroadcastManager {
    private final GChat plugin;
    private final ConfigManager config;
    private int broadcastTaskId = -1;
    private int currentBroadcastIndex = 0;
    private final Pattern urlPattern = Pattern.compile("(?:(https?)://)?([-\\w_.]+\\.[a-z]{2,})(/\\S*)?", 2);

    public BroadcastManager(GChat plugin) {
        this.plugin = plugin;
        this.config = plugin.getConfigManager();
    }

    public void scheduleBroadcasts() {
        if (this.broadcastTaskId != -1) {
            this.cancelBroadcasts();
        }
        if (this.config.isBroadcastEnabled()) {
            List<String> messages = this.config.getBroadcastMessages();
            if (messages.isEmpty()) {
                this.plugin.getLogger().warning("Broadcast is enabled, but no messages are configured in broadcast.yml");
                return;
            }
            int interval = this.config.getBroadcastInterval();
            if (interval <= 0) {
                this.plugin.getLogger().warning("Broadcast interval must be greater than 0.");
                return;
            }
            this.broadcastTaskId = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, () -> {
                if (messages.isEmpty() || Bukkit.getOnlinePlayers().isEmpty()) {
                    return;
                }
                String message = (String)messages.get(this.currentBroadcastIndex);
                this.sendFormattedBroadcast(message);
                this.currentBroadcastIndex = (this.currentBroadcastIndex + 1) % messages.size();
            }, (long)interval * 20L, (long)interval * 20L);
            this.plugin.getLogger().info("Broadcast system started with interval: " + interval + " seconds");
        }
    }

    public void cancelBroadcasts() {
        if (this.broadcastTaskId != -1) {
            Bukkit.getScheduler().cancelTask(this.broadcastTaskId);
            this.broadcastTaskId = -1;
        }
    }

    public void reload() {
        this.cancelBroadcasts();
        this.scheduleBroadcasts();
    }

    public void sendNextBroadcastMessage() {
        List<String> messages = this.config.getBroadcastMessages();
        if (messages.isEmpty()) {
            return;
        }
        String message = messages.get(this.currentBroadcastIndex);
        this.sendFormattedBroadcast(message);
        this.currentBroadcastIndex = (this.currentBroadcastIndex + 1) % messages.size();
    }

    public void sendFormattedBroadcast(String message) {
        if (message == null || message.isEmpty()) {
            return;
        }
        message = message.replace("/n", "\n");
        String header = this.config.getBroadcastHeader();
        if (header != null && !header.isEmpty()) {
            this.sendClickableMessage(ChatColorUtils.translateColors(header, true, true));
        }
        this.sendClickableMessage(ChatColorUtils.translateColors(message, true, true));
        String footer = this.config.getBroadcastFooter();
        if (footer != null && !footer.isEmpty()) {
            this.sendClickableMessage(ChatColorUtils.translateColors(footer, true, true));
        }
    }

    private void sendClickableMessage(String message) {
        if (message == null || message.isEmpty()) {
            return;
        }
        if (Bukkit.getOnlinePlayers().isEmpty()) {
            this.plugin.getLogger().info("[BROADCAST] " + ChatColorUtils.stripColors(message));
            return;
        }
        PlaceholderAPIHook papiHook = this.plugin.getPlaceholderAPIHook();
        Matcher matcher = this.urlPattern.matcher(message);
        ArrayList<TextComponent> components = new ArrayList<TextComponent>();
        int lastEnd = 0;
        while (matcher.find()) {
            if (matcher.start() > lastEnd) {
                String before = message.substring(lastEnd, matcher.start());
                components.add(new TextComponent(TextComponent.fromLegacyText((String)before)));
            }
            Object url = matcher.group();
            String displayUrl = url;
            if (matcher.group(1) == null) {
                url = "https://" + (String)url;
            }
            TextComponent urlComponent = new TextComponent(TextComponent.fromLegacyText((String)displayUrl));
            urlComponent.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, (String)url));
            urlComponent.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text("\u00a7a\u041d\u0430\u0436\u043c\u0438\u0442\u0435, \u0447\u0442\u043e\u0431\u044b \u043e\u0442\u043a\u0440\u044b\u0442\u044c \u0441\u0441\u044b\u043b\u043a\u0443")}));
            components.add(urlComponent);
            lastEnd = matcher.end();
        }
        if (lastEnd < message.length()) {
            String remaining = message.substring(lastEnd);
            components.add(new TextComponent(TextComponent.fromLegacyText((String)remaining)));
        }
        TextComponent finalMessage = new TextComponent("");
        for (TextComponent component : components) {
            finalMessage.addExtra((BaseComponent)component);
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (papiHook != null) {
                String playerSpecificMessage = papiHook.setPlaceholders(player, message);
                if (!playerSpecificMessage.equals(message)) {
                    player.sendMessage(playerSpecificMessage);
                    continue;
                }
                player.spigot().sendMessage((BaseComponent)finalMessage);
                continue;
            }
            player.spigot().sendMessage((BaseComponent)finalMessage);
        }
    }
}

