/*
 * Decompiled with CFR 0.152.
 */
package com.Gomania.gChat.managers;

import com.Gomania.gChat.GChat;
import com.Gomania.gChat.hooks.DiscordSRVHook;
import com.Gomania.gChat.hooks.LuckPermsHook;
import com.Gomania.gChat.hooks.PlaceholderAPIHook;
import com.Gomania.gChat.managers.ConfigManager;
import com.Gomania.gChat.managers.CooldownManager;
import com.Gomania.gChat.managers.MessageManager;
import com.Gomania.gChat.utils.ChatColorUtils;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.entity.Player;

public class ChatManager {
    private final GChat plugin;
    private final ConfigManager config;
    private final MessageManager messages;
    private final CooldownManager messageCooldown = new CooldownManager();
    private final CooldownManager mentionCooldown = new CooldownManager();
    private Pattern mentionPattern;
    private Pattern urlPattern;

    public ChatManager(GChat plugin) {
        this.plugin = plugin;
        this.config = plugin.getConfigManager();
        this.messages = plugin.getMessageManager();
        this.reload();
    }

    public void reload() {
        this.mentionPattern = Pattern.compile(Pattern.quote(this.config.getMentionPrefix()) + "([A-Za-z0-9_]{3,16})");
        this.urlPattern = Pattern.compile("(?:(https?)://)?([-\\w_.]+\\.[a-z]{2,})(/\\S*)?", 2);
        this.messageCooldown.clear();
        this.mentionCooldown.clear();
    }

    public void processChatMessage(Player player, String originalMessage, String chatMode) {
        if (!this.hasChatPermission(player, chatMode)) {
            return;
        }
        if (!this.checkCooldown(player)) {
            return;
        }
        String filteredMessage = this.filterBadWords(player, originalMessage);
        if (filteredMessage == null) {
            return;
        }
        if ((filteredMessage = this.filterLinks(player, filteredMessage)) == null) {
            return;
        }
        if (!this.checkMessageLength(player, filteredMessage)) {
            return;
        }
        String messageWithMentions = filteredMessage;
        HashSet<Player> mentionedPlayers = new HashSet<Player>();
        if (this.config.isMentionsEnabled() && player.hasPermission("gchat.mention")) {
            messageWithMentions = this.processMentions(player, filteredMessage, mentionedPlayers);
        }
        String processedMessage = ChatColorUtils.translateColors(messageWithMentions, this.canUseColors(player), this.canUseGradients(player));
        String formattedMessage = this.formatMessage(player, processedMessage, chatMode);
        if (chatMode.equals("local")) {
            this.sendLocalMessage(player, formattedMessage);
        } else {
            this.sendGlobalMessage(formattedMessage, true);
            if (this.config.isMentionsEnabled() && !mentionedPlayers.isEmpty()) {
                this.notifyMentionedPlayers(mentionedPlayers);
            }
        }
        if (this.config.isLogToConsoleEnabled()) {
            String cleanMessage = ChatColorUtils.stripColors(filteredMessage);
            Bukkit.getLogger().info("[" + chatMode.toUpperCase() + "] " + player.getName() + ": " + cleanMessage);
        }
    }

    private String processMentions(Player sender, String message, Set<Player> mentionedPlayers) {
        Matcher matcher = this.mentionPattern.matcher(message);
        StringBuffer sb = new StringBuffer();
        int mentionCd = this.config.getMentionCooldown();
        boolean canMention = this.mentionCooldown.check(sender.getUniqueId(), mentionCd);
        boolean triedToMention = false;
        while (matcher.find()) {
            String mentionedName = matcher.group(1);
            Player mentionedPlayer = Bukkit.getPlayerExact((String)mentionedName);
            if (mentionedPlayer != null && mentionedPlayer.isOnline() && !mentionedPlayer.equals((Object)sender)) {
                triedToMention = true;
                if (canMention) {
                    String highlight = ChatColorUtils.translateColors(this.config.getMentionHighlight().replace("%player%", mentionedName), true, true);
                    matcher.appendReplacement(sb, Matcher.quoteReplacement(highlight));
                    mentionedPlayers.add(mentionedPlayer);
                    continue;
                }
                matcher.appendReplacement(sb, matcher.group(0));
                continue;
            }
            matcher.appendReplacement(sb, matcher.group(0));
        }
        if (!canMention && triedToMention) {
            long remaining = this.mentionCooldown.getRemaining(sender.getUniqueId(), mentionCd);
            sender.sendMessage(this.messages.getMessage("mention-cooldown").replace("{time}", String.valueOf(remaining)));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private void notifyMentionedPlayers(Set<Player> mentionedPlayers) {
        try {
            Sound sound = Sound.valueOf((String)this.config.getMentionSound().toUpperCase());
            float volume = this.config.getMentionVolume();
            float pitch = this.config.getMentionPitch();
            for (Player p : mentionedPlayers) {
                p.playSound(p.getLocation(), sound, volume, pitch);
            }
        }
        catch (IllegalArgumentException e) {
            this.plugin.getLogger().warning("Invalid mention sound in config: " + this.config.getMentionSound());
        }
    }

    private String formatMessage(Player player, String message, String chatMode) {
        String groupFormat;
        String baseFormat = chatMode.equals("local") ? this.config.getLocalChatFormat() : this.config.getGlobalChatFormat();
        LuckPermsHook lpHook = this.plugin.getLuckPermsHook();
        PlaceholderAPIHook papiHook = this.plugin.getPlaceholderAPIHook();
        String playerGroup = null;
        if (lpHook != null) {
            playerGroup = lpHook.getPlayerGroup(player.getUniqueId(), this.config.getGroupFormatKeys());
        }
        Object finalFormat = (groupFormat = this.config.getGroupFormat(playerGroup)) != null ? groupFormat : this.config.getDefaultFormat();
        finalFormat = ((String)finalFormat).replace("%gchat_format%", baseFormat != null ? baseFormat : "");
        finalFormat = ((String)finalFormat).replace("%player_name%", player.getName());
        finalFormat = ((String)finalFormat).replace("%player_world%", player.getWorld().getName());
        if (lpHook != null && ((String)finalFormat).contains("%luckperms_suffix%")) {
            finalFormat = ((String)finalFormat).replace("%luckperms_suffix%", lpHook.getPlayerSuffix(player.getUniqueId()));
        }
        if (papiHook != null) {
            finalFormat = papiHook.setPlaceholders(player, (String)finalFormat);
        }
        finalFormat = ((String)finalFormat).replace("%message%", message);
        finalFormat = ChatColorUtils.translateColors((String)finalFormat, true, true);
        finalFormat = (String)finalFormat + "\u00a7r";
        return finalFormat;
    }

    public void sendLocalMessage(Player sender, String formattedMessage) {
        if (!this.config.isLocalChatEnabled()) {
            if (this.config.showDisabledLocalChatMessage()) {
                sender.sendMessage(this.messages.getMessage("local-chat-disabled"));
            }
            return;
        }
        int radius = this.config.getLocalChatRadius();
        double radiusSquared = radius * radius;
        int recipients = 0;
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!player.getWorld().equals((Object)sender.getWorld()) || !(player.getLocation().distanceSquared(sender.getLocation()) <= radiusSquared)) continue;
            player.sendMessage(formattedMessage);
            if (player.getUniqueId().equals(sender.getUniqueId())) continue;
            ++recipients;
        }
        if (recipients == 0 && this.config.showLocalChatSilentMessage()) {
            sender.sendMessage(this.messages.getMessage("local-chat-silent"));
        }
    }

    public void sendGlobalMessage(String formattedMessage) {
        this.sendGlobalMessage(formattedMessage, true);
    }

    public void sendGlobalMessage(String formattedMessage, boolean sendToDiscord) {
        DiscordSRVHook discordHook;
        if (!this.config.isGlobalChatEnabled()) {
            return;
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            player.sendMessage(formattedMessage);
        }
        if (!sendToDiscord || (discordHook = this.plugin.getDiscordSRVHook()) == null || this.config.isMcToDiscordEnabled()) {
            // empty if block
        }
    }

    private boolean checkCooldown(Player player) {
        if (!this.config.isMessageCooldownEnabled() || player.hasPermission("gchat.bypass.cooldown")) {
            return true;
        }
        int cooldownSeconds = this.config.getMessageCooldownSeconds();
        if (!this.messageCooldown.check(player.getUniqueId(), cooldownSeconds)) {
            long remaining = this.messageCooldown.getRemaining(player.getUniqueId(), cooldownSeconds);
            player.sendMessage(this.messages.getMessage("message-cooldown").replace("{time}", String.valueOf(remaining)));
            return false;
        }
        return true;
    }

    private boolean checkMessageLength(Player player, String message) {
        int maxLength = this.config.getMaxMessageLength();
        if (message.length() > maxLength && !player.hasPermission("gchat.bypass.length")) {
            player.sendMessage(this.messages.getMessage("message-too-long").replace("{max}", String.valueOf(maxLength)));
            return false;
        }
        return true;
    }

    private String filterBadWords(Player player, String message) {
        if (!this.config.isFilterEnabled() || player.hasPermission("gchat.bypass.filter")) {
            return message;
        }
        List<String> badWords = this.config.getFilterWords();
        String resultMessage = message;
        for (String word : badWords) {
            if (!resultMessage.toLowerCase().contains(word.toLowerCase())) continue;
            if (this.config.isFilterBlockMessage()) {
                player.sendMessage(this.messages.getMessage("message-blocked"));
                return null;
            }
            String replacement = String.join((CharSequence)"", Collections.nCopies(word.length(), "*"));
            resultMessage = resultMessage.replaceAll("(?i)" + Pattern.quote(word), replacement);
        }
        return resultMessage;
    }

    private String filterLinks(Player player, String message) {
        if (!this.config.isLinkFilterEnabled() || player.hasPermission("gchat.link.bypass")) {
            return message;
        }
        Matcher matcher = this.urlPattern.matcher(message);
        if (matcher.find()) {
            player.sendMessage(this.messages.getMessage("illegal-link"));
            return null;
        }
        return message;
    }

    private boolean hasChatPermission(Player player, String chatType) {
        if (player.hasPermission("gchat.bypass")) {
            return true;
        }
        return chatType.equalsIgnoreCase("global") || chatType.equalsIgnoreCase("local");
    }

    private boolean canUseColors(Player player) {
        return player.hasPermission("gchat.color");
    }

    private boolean canUseGradients(Player player) {
        return player.hasPermission("gchat.gradient");
    }
}

