/*
 * Decompiled with CFR 0.152.
 */
package com.Gomania.gChat.managers;

import com.Gomania.gChat.GChat;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigManager {
    private final GChat plugin;
    private FileConfiguration config;
    private FileConfiguration broadcastConfig;
    private File broadcastFile;
    private List<String> blockedCommands;
    private boolean logToConsole;
    private boolean blockCommandsEnabled;

    public ConfigManager(GChat plugin) {
        this.plugin = plugin;
        this.loadConfigs();
    }

    public void loadConfigs() {
        this.plugin.saveDefaultConfig();
        this.config = this.plugin.getConfig();
        this.broadcastFile = new File(this.plugin.getDataFolder(), "broadcast.yml");
        if (!this.broadcastFile.exists()) {
            this.plugin.saveResource("broadcast.yml", false);
        }
        this.broadcastConfig = YamlConfiguration.loadConfiguration((File)this.broadcastFile);
        this.cacheValues();
    }

    public void reloadConfigs() {
        this.plugin.reloadConfig();
        this.config = this.plugin.getConfig();
        this.broadcastConfig = YamlConfiguration.loadConfiguration((File)this.broadcastFile);
        this.cacheValues();
    }

    private void cacheValues() {
        this.blockedCommands = this.config.getStringList("blocked-commands");
        this.logToConsole = this.config.getBoolean("log-to-console", false);
        this.blockCommandsEnabled = this.config.getBoolean("block-commands-enabled", true);
    }

    public String getLanguage() {
        return this.config.getString("language", "ru").toLowerCase();
    }

    public boolean isPluginEnabled() {
        return this.config.getBoolean("enabled", true);
    }

    public String getDefaultChatMode() {
        return this.config.getString("default-chat-mode", "local");
    }

    public int getReloadCooldown() {
        return this.config.getInt("reload-cooldown", 5);
    }

    public boolean isLogToConsoleEnabled() {
        return this.logToConsole;
    }

    public int getMaxMessageLength() {
        return this.config.getInt("max-message-length", 256);
    }

    public String getLocalChatFormat() {
        return this.config.getString("local-chat.format", "&8[\u041b\u043e\u043a\u0430\u043b\u044c\u043d\u043e]");
    }

    public String getGlobalChatFormat() {
        return this.config.getString("global-chat.format", "&8[\u0413\u043b\u043e\u0431\u0430\u043b\u044c\u043d\u043e]");
    }

    public int getLocalChatRadius() {
        return this.config.getInt("local-chat.radius", 50);
    }

    public boolean isLocalChatEnabled() {
        return this.config.getBoolean("local-chat.enabled", true);
    }

    public boolean showDisabledLocalChatMessage() {
        return this.config.getBoolean("local-chat.show-disabled-local-chat", true);
    }

    public boolean showLocalChatSilentMessage() {
        return this.config.getBoolean("local-chat.show-silent-message", true);
    }

    public boolean isGlobalChatEnabled() {
        return this.config.getBoolean("global-chat.enabled", true);
    }

    public boolean isMessageCooldownEnabled() {
        return this.config.getBoolean("message-cooldown.enabled", false);
    }

    public int getMessageCooldownSeconds() {
        return this.config.getInt("message-cooldown.seconds", 3);
    }

    public boolean isFilterEnabled() {
        return this.config.getBoolean("filter.enabled", false);
    }

    public boolean isFilterBlockMessage() {
        return this.config.getBoolean("filter.block-message", true);
    }

    public List<String> getFilterWords() {
        return this.config.getStringList("filter.words");
    }

    public boolean isLinkFilterEnabled() {
        return this.config.getBoolean("filter-links.enabled", true);
    }

    public boolean isJoinQuitHandlingEnabled() {
        return this.config.getBoolean("handle-join-quit-messages", true);
    }

    public String getJoinMessage() {
        return this.config.getString("join-message", "");
    }

    public String getQuitMessage() {
        return this.config.getString("quit-message", "");
    }

    public boolean isBlockCommandsEnabled() {
        return this.blockCommandsEnabled;
    }

    public List<String> getBlockedCommands() {
        return this.blockedCommands;
    }

    public boolean isDeathMessagesEnabled() {
        return this.config.getBoolean("death-messages.enabled", true);
    }

    public boolean isHideDefaultDeathMessage() {
        return this.config.getBoolean("death-messages.hide-default-message", true);
    }

    public String getDeathMsgPlayerKill() {
        return this.config.getString("death-messages.player-kill", "&c\u2620 %player% \u0431\u044b\u043b \u0443\u0431\u0438\u0442 \u0438\u0433\u0440\u043e\u043a\u043e\u043c %killer%.");
    }

    public String getDeathMsgMobKill() {
        return this.config.getString("death-messages.mob-kill", "&c\u2620 %player% \u043f\u0430\u043b \u0432 \u0431\u043e\u044e \u0441 %killer_mob%.");
    }

    public String getDeathMsgOther() {
        return this.config.getString("death-messages.other", "&c\u2620 %player% \u0442\u0440\u0430\u0433\u0438\u0447\u0435\u0441\u043a\u0438 \u043f\u043e\u0433\u0438\u0431.");
    }

    public boolean isDiscordEnabled() {
        return this.config.getBoolean("discord-chat.enabled", true);
    }

    public String getDiscordFormat() {
        return this.config.getString("discord-chat.format", "&8[&9Discord&8] &7%user% &8\u00bb &f%message%");
    }

    public boolean isMcToDiscordEnabled() {
        return this.config.getBoolean("discord-chat.mc-to-discord", true);
    }

    public boolean isDiscordToMcEnabled() {
        return this.config.getBoolean("discord-chat.discord-to-mc", true);
    }

    public boolean isMentionsEnabled() {
        return this.config.getBoolean("player-mentions.enabled", true);
    }

    public String getMentionPrefix() {
        return this.config.getString("player-mentions.prefix", "@");
    }

    public String getMentionHighlight() {
        return this.config.getString("player-mentions.highlight-format", "&e&l@%player%&r");
    }

    public String getMentionSound() {
        return this.config.getString("player-mentions.sound", "ENTITY_EXPERIENCE_ORB_PICKUP");
    }

    public float getMentionVolume() {
        return (float)this.config.getDouble("player-mentions.sound-volume", 1.0);
    }

    public float getMentionPitch() {
        return (float)this.config.getDouble("player-mentions.sound-pitch", 1.5);
    }

    public int getMentionCooldown() {
        return this.config.getInt("player-mentions.cooldown", 10);
    }

    public String getDefaultFormat() {
        return this.config.getString("default-format", "%player_name% &7\u00bb %message%");
    }

    public String getGroupFormat(String group) {
        if (group == null) {
            return null;
        }
        return this.config.getString("group-formats." + group);
    }

    public Set<String> getGroupFormatKeys() {
        if (!this.config.isConfigurationSection("group-formats")) {
            return Collections.emptySet();
        }
        return this.config.getConfigurationSection("group-formats").getKeys(false);
    }

    public FileConfiguration getBroadcastConfig() {
        return this.broadcastConfig;
    }

    public boolean isBroadcastEnabled() {
        return this.broadcastConfig.getBoolean("enabled", false);
    }

    public int getBroadcastInterval() {
        return this.broadcastConfig.getInt("interval", 300);
    }

    public List<String> getBroadcastMessages() {
        return this.broadcastConfig.getStringList("messages");
    }

    public String getBroadcastHeader() {
        return this.broadcastConfig.getString("header", "");
    }

    public String getBroadcastFooter() {
        return this.broadcastConfig.getString("footer", "");
    }
}

