/*
 * Decompiled with CFR 0.152.
 */
package com.Gomania.gChat.managers;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class CooldownManager {
    private final Map<UUID, Long> cooldowns = new ConcurrentHashMap<UUID, Long>();

    public boolean check(UUID uuid, int seconds) {
        long now = System.currentTimeMillis();
        Long lastTime = this.cooldowns.get(uuid);
        if (lastTime == null || now - lastTime >= (long)seconds * 1000L) {
            this.cooldowns.put(uuid, now);
            return true;
        }
        return false;
    }

    public long getRemaining(UUID uuid, int seconds) {
        Long lastTime = this.cooldowns.get(uuid);
        if (lastTime == null) {
            return 0L;
        }
        long elapsed = System.currentTimeMillis() - lastTime;
        long remaining = (long)seconds * 1000L - elapsed;
        return remaining > 0L ? remaining / 1000L + 1L : 0L;
    }

    public void clear() {
        this.cooldowns.clear();
    }

    public void remove(UUID uuid) {
        this.cooldowns.remove(uuid);
    }
}

