/*
 * Decompiled with CFR 0.152.
 */
package com.Gomania.gChat.managers;

import com.Gomania.gChat.GChat;
import org.bukkit.Bukkit;

public class DependencyManager {
    private final GChat plugin;
    private boolean hasPlaceholderAPI = false;
    private boolean hasLuckPerms = false;
    private boolean hasDiscordSRV = false;
    private Object luckPermsAPI = null;

    public DependencyManager(GChat plugin) {
        this.plugin = plugin;
    }

    public void checkDependencies() {
        boolean bl = this.hasPlaceholderAPI = Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null;
        if (this.hasPlaceholderAPI) {
            this.plugin.getLogger().info("PlaceholderAPI found! Placeholders enabled.");
        }
        if (Bukkit.getPluginManager().getPlugin("LuckPerms") != null) {
            try {
                Class<?> luckPermsClass = Class.forName("net.luckperms.api.LuckPerms");
                this.luckPermsAPI = Bukkit.getServicesManager().getRegistration(luckPermsClass).getProvider();
                boolean bl2 = this.hasLuckPerms = this.luckPermsAPI != null;
                if (this.hasLuckPerms) {
                    this.plugin.getLogger().info("LuckPerms found! Group support enabled.");
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Failed to initialize LuckPerms API: " + e.getMessage());
                this.hasLuckPerms = false;
                this.luckPermsAPI = null;
            }
        } else {
            this.hasLuckPerms = false;
            this.luckPermsAPI = null;
        }
        if (Bukkit.getPluginManager().getPlugin("DiscordSRV") != null) {
            try {
                Class.forName("github.scarsz.discordsrv.DiscordSRV");
                this.hasDiscordSRV = true;
                this.plugin.getLogger().info("DiscordSRV found! Integration will be enabled if set in config.");
            }
            catch (ClassNotFoundException | NoClassDefFoundError e) {
                this.plugin.getLogger().warning("DiscordSRV plugin found, but required classes are missing. Integration disabled.");
                this.hasDiscordSRV = false;
            }
        } else {
            this.hasDiscordSRV = false;
            this.plugin.getLogger().info("DiscordSRV plugin not found. Integration disabled.");
        }
    }

    public boolean hasPlaceholderAPI() {
        return this.hasPlaceholderAPI;
    }

    public boolean hasLuckPerms() {
        return this.hasLuckPerms;
    }

    public boolean hasDiscordSRV() {
        return this.hasDiscordSRV;
    }

    public Object getLuckPermsAPI() {
        return this.luckPermsAPI;
    }

    public void setDiscordSRVStatus(boolean status) {
        this.hasDiscordSRV = status;
    }
}

