/*
 * Decompiled with CFR 0.152.
 */
package com.Gomania.gChat.managers;

import com.Gomania.gChat.GChat;
import com.Gomania.gChat.utils.ChatColorUtils;
import java.io.File;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class MessageManager {
    private final GChat plugin;
    private FileConfiguration messagesConfig;
    private File messagesFile;
    private String prefix;

    public MessageManager(GChat plugin) {
        this.plugin = plugin;
        this.loadMessages();
    }

    public void loadMessages() {
        String language = this.plugin.getConfigManager().getLanguage();
        this.messagesFile = new File(this.plugin.getDataFolder(), "messages_" + language + ".yml");
        if (!this.messagesFile.exists()) {
            try (InputStream in = this.plugin.getResource("messages_" + language + ".yml");){
                if (in != null) {
                    Files.copy(in, this.messagesFile.toPath(), new CopyOption[0]);
                } else {
                    this.plugin.getLogger().warning("Could not find messages_" + language + ".yml resource. Creating empty file.");
                    this.messagesFile.createNewFile();
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Failed to create messages file: " + e.getMessage());
            }
        }
        this.reloadMessages();
    }

    public void reloadMessages() {
        this.messagesConfig = YamlConfiguration.loadConfiguration((File)this.messagesFile);
        this.prefix = this.messagesConfig.getString("prefix", "&8[&6gChat&8]");
    }

    public String getMessage(String path) {
        String message = this.messagesConfig.getString(path);
        if (message == null) {
            return "\u00a7cMessage not found: " + path;
        }
        message = message.replace("{prefix}", this.prefix);
        return ChatColorUtils.translateColors(message, true, true);
    }

    public List<String> getHelpMessage() {
        ArrayList<String> helpLines = this.messagesConfig.getStringList("help");
        if (helpLines == null || helpLines.isEmpty()) {
            helpLines = new ArrayList<String>();
            helpLines.add("&6&l=== gChat Help ===");
            helpLines.add("&e/gchat reload &7- \u041f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044e");
            helpLines.add("&e/gchat help &7- \u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u044d\u0442\u0443 \u043f\u043e\u043c\u043e\u0449\u044c");
            helpLines.add("&e/gchat debug &7- Debug \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f");
            helpLines.add("&e/g &7- \u041f\u0435\u0440\u0435\u043a\u043b\u044e\u0447\u0438\u0442\u044c\u0441\u044f \u043d\u0430 \u0433\u043b\u043e\u0431\u0430\u043b\u044c\u043d\u044b\u0439 \u0447\u0430\u0442");
            helpLines.add("&e/l &7- \u041f\u0435\u0440\u0435\u043a\u043b\u044e\u0447\u0438\u0442\u044c\u0441\u044f \u043d\u0430 \u043b\u043e\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0447\u0430\u0442");
            helpLines.add("&e!<\u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435> &7- \u041e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u0440\u0430\u0437\u043e\u0432\u043e\u0435 \u0433\u043b\u043e\u0431\u0430\u043b\u044c\u043d\u043e\u0435 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435");
        }
        return helpLines.stream().map(line -> ChatColorUtils.translateColors(line, true, true)).collect(Collectors.toList());
    }
}

