/*
 * Decompiled with CFR 0.152.
 */
package com.Gomania.gChat.utils;

import java.awt.Color;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.ChatColor;

public class ChatColorUtils {
    private static final Pattern GRADIENT_PATTERN = Pattern.compile("\\{#([0-9A-Fa-f]{6})>\\}(.*?)\\{#([0-9A-Fa-f]{6})<\\}");
    private static final Pattern HEX_PATTERN = Pattern.compile("&#([A-Fa-f0-9]{6})");

    public static String translateColors(String text, boolean allowColors, boolean allowGradients) {
        if (text == null || text.isEmpty()) {
            return "";
        }
        if (allowGradients) {
            text = ChatColorUtils.applyGradients(text);
        }
        text = ChatColorUtils.applyHexColors(text);
        if (allowColors) {
            text = ChatColorUtils.replaceStandardColors(text);
        }
        return text;
    }

    private static String replaceStandardColors(String text) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)text);
    }

    private static String applyHexColors(String text) {
        if (text == null) {
            return "";
        }
        Matcher matcher = HEX_PATTERN.matcher(text);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            String hex = matcher.group(1);
            StringBuilder replacement = new StringBuilder("\u00a7x");
            for (char c : hex.toCharArray()) {
                replacement.append("\u00a7").append(c);
            }
            matcher.appendReplacement(buffer, replacement.toString());
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }

    public static String applyGradients(String text) {
        if (text == null) {
            return text;
        }
        Matcher matcher = GRADIENT_PATTERN.matcher(text);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            String startColor = matcher.group(1);
            String content = matcher.group(2);
            String endColor = matcher.group(3);
            String gradientText = ChatColorUtils.createGradient(content, startColor, endColor);
            matcher.appendReplacement(result, Matcher.quoteReplacement(gradientText));
        }
        matcher.appendTail(result);
        return result.toString();
    }

    private static String createGradient(String text, String startHex, String endHex) {
        try {
            Color startColor = Color.decode("#" + startHex);
            Color endColor = Color.decode("#" + endHex);
            StringBuilder gradient = new StringBuilder();
            int length = text.length();
            for (int i = 0; i < length; ++i) {
                if (text.charAt(i) == '\u00a7' && i + 1 < length) {
                    gradient.append(text.charAt(i)).append(text.charAt(i + 1));
                    ++i;
                    continue;
                }
                float ratio = length == 1 ? 0.5f : (float)i / (float)(length - 1);
                Color current = ChatColorUtils.interpolateColor(startColor, endColor, ratio);
                gradient.append(ChatColorUtils.colorToMinecraftHex(current)).append(text.charAt(i));
            }
            return gradient.toString();
        }
        catch (Exception e) {
            return text;
        }
    }

    private static Color interpolateColor(Color start, Color end, float ratio) {
        int r = Math.max(0, Math.min(255, (int)((float)start.getRed() + ratio * (float)(end.getRed() - start.getRed()))));
        int g = Math.max(0, Math.min(255, (int)((float)start.getGreen() + ratio * (float)(end.getGreen() - start.getGreen()))));
        int b = Math.max(0, Math.min(255, (int)((float)start.getBlue() + ratio * (float)(end.getBlue() - start.getBlue()))));
        return new Color(r, g, b);
    }

    public static String colorToMinecraftHex(Color color) {
        String hex = String.format("%02X%02X%02X", color.getRed(), color.getGreen(), color.getBlue());
        StringBuilder sb = new StringBuilder("\u00a7x");
        for (char c : hex.toCharArray()) {
            sb.append("\u00a7").append(c);
        }
        return sb.toString();
    }

    public static String stripColors(String input) {
        if (input == null) {
            return null;
        }
        String noHex = input.replaceAll("\u00a7x(\u00a7[0-9A-Fa-f]){6}", "");
        return ChatColor.stripColor((String)noHex);
    }
}

