/*
 * Decompiled with CFR 0.152.
 */
package com.Gomania.gChat;

import com.Gomania.gChat.MsgCommand;
import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.api.Subscribe;
import github.scarsz.discordsrv.api.events.DiscordGuildMessagePostProcessEvent;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Role;
import java.awt.Color;
import java.io.File;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Text;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class GChat
extends JavaPlugin
implements Listener,
TabCompleter {
    private FileConfiguration config;
    private FileConfiguration messagesConfig;
    private FileConfiguration broadcastConfig;
    private File messagesFile;
    private File broadcastFile;
    private final Map<UUID, String> playerChatModes = new HashMap<UUID, String>();
    private final CooldownManager messageCooldown = new CooldownManager();
    private final CooldownManager reloadCooldown = new CooldownManager();
    private final CooldownManager mentionCooldown = new CooldownManager();
    private LuckPermsCache lpCache;
    private final Pattern gradientPattern = Pattern.compile("\\{#([0-9A-Fa-f]{6})>\\}(.*?)\\{#([0-9A-Fa-f]{6})<\\}");
    private final Pattern colorPattern = Pattern.compile("&[0-9a-fk-or]", 2);
    private final Pattern urlPattern = Pattern.compile("(?:(https?)://)?([-\\w_.]+\\.[a-z]{2,})(/\\S*)?", 2);
    private Pattern mentionPattern;
    private boolean hasPlaceholderAPI = false;
    private boolean hasLuckPerms = false;
    private Object luckPermsAPI = null;
    private List<String> blockedCommands = new ArrayList<String>();
    private String joinMessage;
    private String quitMessage;
    private boolean handleJoinQuitMessages = true;
    private boolean blockCommandsEnabled = true;
    private boolean deathMessagesEnabled = true;
    private boolean hideDefaultDeathMessage = true;
    private String deathMsgPlayerKill;
    private String deathMsgMobKill;
    private String deathMsgOther;
    private boolean hasDiscordSRV = false;
    private DiscordSRVListener discordSrvListener = null;
    private String discordFormat = "&8[&9Discord&8] &7%user% &8\u00bb &f%message%";
    private boolean discordEnabled = true;
    private boolean discordMcToDiscord = true;
    private boolean discordDiscordToMc = true;
    private boolean mentionsEnabled = true;
    private String mentionPrefix = "@";
    private String mentionHighlight = "&e&l@%player%&r";
    private String mentionSound = "ENTITY_EXPERIENCE_ORB_PICKUP";
    private float mentionVolume = 1.0f;
    private float mentionPitch = 1.5f;
    private int broadcastTaskId = -1;
    private int currentBroadcastIndex = 0;

    public void onEnable() {
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdirs();
        }
        this.saveDefaultConfig();
        this.config = this.getConfig();
        this.setupMessages();
        this.setupBroadcastConfig();
        this.reloadAllConfigsAndServices();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        try {
            this.getCommand("msg").setExecutor((CommandExecutor)new MsgCommand(this));
        }
        catch (Exception e) {
            this.getLogger().warning("Failed to set executor for 'msg' command. Is MsgCommand class available?");
        }
        this.getLogger().info("gChat plugin enabled!");
    }

    public void onDisable() {
        this.playerChatModes.clear();
        this.reloadCooldown.clear();
        this.messageCooldown.clear();
        this.mentionCooldown.clear();
        if (this.lpCache != null) {
            this.lpCache.clear();
        }
        if (this.discordSrvListener != null && this.hasDiscordSRV) {
            try {
                DiscordSRV.api.unsubscribe((Object)this.discordSrvListener);
                this.getLogger().info("Unsubscribed from DiscordSRV API.");
            }
            catch (Exception | NoClassDefFoundError throwable) {
                // empty catch block
            }
        }
        if (this.broadcastTaskId != -1) {
            Bukkit.getScheduler().cancelTask(this.broadcastTaskId);
        }
        this.getLogger().info("gChat plugin disabled!");
    }

    private void setupMessages() {
        String language = this.config.getString("language", "ru").toLowerCase();
        this.messagesFile = new File(this.getDataFolder(), "messages_" + language + ".yml");
        if (!this.messagesFile.exists()) {
            try (InputStream in = this.getResource("messages_" + language + ".yml");){
                if (in != null) {
                    Files.copy(in, this.messagesFile.toPath(), new CopyOption[0]);
                }
            }
            catch (Exception e) {
                this.getLogger().warning("Failed to create messages file: " + e.getMessage());
            }
        }
    }

    private void setupBroadcastConfig() {
        this.broadcastFile = new File(this.getDataFolder(), "broadcast.yml");
        if (!this.broadcastFile.exists()) {
            try (InputStream in = this.getResource("broadcast.yml");){
                if (in != null) {
                    Files.copy(in, this.broadcastFile.toPath(), new CopyOption[0]);
                } else {
                    this.broadcastConfig = YamlConfiguration.loadConfiguration((File)this.broadcastFile);
                    this.broadcastConfig.set("enabled", (Object)true);
                    this.broadcastConfig.set("interval", (Object)300);
                    this.broadcastConfig.set("header", (Object)"&6&l=== \u0421\u0415\u0420\u0412\u0415\u0420\u041d\u041e\u0415 \u041e\u0411\u042a\u042f\u0412\u041b\u0415\u041d\u0418\u0415 ===");
                    this.broadcastConfig.set("footer", (Object)"&7\u0421\u043f\u0430\u0441\u0438\u0431\u043e \u0437\u0430 \u0438\u0433\u0440\u0443 \u043d\u0430 \u043d\u0430\u0448\u0435\u043c \u0441\u0435\u0440\u0432\u0435\u0440\u0435!");
                    ArrayList<String> messages = new ArrayList<String>();
                    messages.add("&a\u041d\u0435 \u0437\u0430\u0431\u0443\u0434\u044c\u0442\u0435 \u043f\u0440\u043e\u0447\u0438\u0442\u0430\u0442\u044c \u043f\u0440\u0430\u0432\u0438\u043b\u0430 \u0441\u0435\u0440\u0432\u0435\u0440\u0430!");
                    messages.add("&b\u041f\u0440\u0438\u0441\u043e\u0435\u0434\u0438\u043d\u044f\u0439\u0442\u0435\u0441\u044c \u043a \u043d\u0430\u0448\u0435\u043c\u0443 Discord: https://discord.gg/example");
                    messages.add("&c\u0412\u043d\u0438\u043c\u0430\u043d\u0438\u0435! \u0417\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u0447\u0438\u0442\u043e\u0432!");
                    this.broadcastConfig.set("messages", messages);
                    this.broadcastConfig.save(this.broadcastFile);
                }
            }
            catch (Exception e) {
                this.getLogger().warning("Failed to create broadcast config: " + e.getMessage());
            }
        }
    }

    public void reloadMessages() {
        this.messagesConfig = YamlConfiguration.loadConfiguration((File)this.messagesFile);
    }

    public void reloadBroadcastConfig() {
        this.broadcastConfig = YamlConfiguration.loadConfiguration((File)this.broadcastFile);
    }

    public String getMessage(String path) {
        String message = this.messagesConfig.getString(path);
        if (message == null) {
            return "\u00a7cMessage not found: " + path;
        }
        String prefix = this.messagesConfig.getString("prefix", "&8[&6gChat&8]");
        message = message.replace("{prefix}", prefix);
        return ChatColorUtils.translateColors(message, true, true);
    }

    public void reloadAllConfigsAndServices() {
        File configFile = new File(this.getDataFolder(), "config.yml");
        if (!configFile.exists()) {
            this.saveDefaultConfig();
        }
        this.reloadConfig();
        this.config = this.getConfig();
        this.reloadMessages();
        this.reloadBroadcastConfig();
        this.blockedCommands = this.config.getStringList("blocked-commands");
        this.joinMessage = this.config.getString("join-message", "");
        this.quitMessage = this.config.getString("quit-message", "");
        this.handleJoinQuitMessages = this.config.getBoolean("handle-join-quit-messages", true);
        this.blockCommandsEnabled = this.config.getBoolean("block-commands-enabled", true);
        this.deathMessagesEnabled = this.config.getBoolean("death-messages.enabled", true);
        this.hideDefaultDeathMessage = this.config.getBoolean("death-messages.hide-default-message", true);
        this.deathMsgPlayerKill = this.config.getString("death-messages.player-kill", "&c\u2620 %player% \u0431\u044b\u043b \u0443\u0431\u0438\u0442 \u0438\u0433\u0440\u043e\u043a\u043e\u043c %killer%.");
        this.deathMsgMobKill = this.config.getString("death-messages.mob-kill", "&c\u2620 %player% \u043f\u0430\u043b \u0432 \u0431\u043e\u044e \u0441 %killer_mob%.");
        this.deathMsgOther = this.config.getString("death-messages.other", "&c\u2620 %player% \u0442\u0440\u0430\u0433\u0438\u0447\u0435\u0441\u043a\u0438 \u043f\u043e\u0433\u0438\u0431.");
        this.discordEnabled = this.config.getBoolean("discord-chat.enabled", true);
        this.discordFormat = this.config.getString("discord-chat.format", "&8[&9Discord&8] &7%user% &8\u00bb &f%message%");
        this.discordMcToDiscord = this.config.getBoolean("discord-chat.mc-to-discord", true);
        this.discordDiscordToMc = this.config.getBoolean("discord-chat.discord-to-mc", true);
        this.mentionsEnabled = this.config.getBoolean("player-mentions.enabled", true);
        this.mentionPrefix = this.config.getString("player-mentions.prefix", "@");
        this.mentionHighlight = this.config.getString("player-mentions.highlight-format", "&e&l@%player%&r");
        this.mentionSound = this.config.getString("player-mentions.sound", "ENTITY_EXPERIENCE_ORB_PICKUP");
        this.mentionVolume = (float)this.config.getDouble("player-mentions.sound-volume", 1.0);
        this.mentionPitch = (float)this.config.getDouble("player-mentions.sound-pitch", 1.5);
        this.mentionPattern = Pattern.compile(Pattern.quote(this.mentionPrefix) + "([A-Za-z0-9_]{3,16})");
        this.setupBroadcast();
        if (this.lpCache != null) {
            this.lpCache.clear();
        }
        this.checkDependencies();
    }

    private void checkDependencies() {
        block12: {
            this.hasPlaceholderAPI = Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null;
            boolean bl = this.hasLuckPerms = Bukkit.getPluginManager().getPlugin("LuckPerms") != null;
            if (this.hasPlaceholderAPI) {
                this.getLogger().info("PlaceholderAPI found! Placeholders enabled.");
            }
            if (this.hasLuckPerms) {
                this.getLogger().info("LuckPerms found! Group support enabled.");
                try {
                    Class<?> luckPermsClass = Class.forName("net.luckperms.api.LuckPerms");
                    this.luckPermsAPI = Bukkit.getServicesManager().getRegistration(luckPermsClass).getProvider();
                    this.lpCache = new LuckPermsCache(this.luckPermsAPI);
                }
                catch (Exception e) {
                    this.getLogger().warning("Failed to initialize LuckPerms API: " + e.getMessage());
                    this.hasLuckPerms = false;
                }
            }
            if (this.discordEnabled) {
                if (Bukkit.getPluginManager().getPlugin("DiscordSRV") != null) {
                    try {
                        Class.forName("github.scarsz.discordsrv.DiscordSRV");
                        this.getLogger().info("DiscordSRV found! Enabling integration.");
                        this.hasDiscordSRV = true;
                        if (this.discordSrvListener != null) break block12;
                        this.discordSrvListener = new DiscordSRVListener(this);
                        try {
                            DiscordSRV.api.subscribe((Object)this.discordSrvListener);
                            this.getLogger().info("Successfully subscribed to DiscordSRV API.");
                        }
                        catch (Exception | NoClassDefFoundError e_api) {
                            this.getLogger().warning("Failed to subscribe to DiscordSRV API: " + e_api.getMessage());
                            this.hasDiscordSRV = false;
                            this.discordSrvListener = null;
                        }
                    }
                    catch (ClassNotFoundException | NoClassDefFoundError e) {
                        this.getLogger().warning("DiscordSRV plugin found, but required classes are missing. Integration disabled.");
                        this.hasDiscordSRV = false;
                        this.discordSrvListener = null;
                    }
                } else {
                    this.hasDiscordSRV = false;
                    this.discordSrvListener = null;
                    this.getLogger().info("DiscordSRV plugin not found. Integration disabled.");
                }
            } else {
                this.hasDiscordSRV = false;
                this.discordSrvListener = null;
                this.getLogger().info("DiscordSRV integration is disabled in config.yml.");
            }
        }
    }

    private void setupBroadcast() {
        if (this.broadcastTaskId != -1) {
            Bukkit.getScheduler().cancelTask(this.broadcastTaskId);
            this.broadcastTaskId = -1;
        }
        if (this.broadcastConfig.getBoolean("enabled", false)) {
            List messages = this.broadcastConfig.getStringList("messages");
            if (messages.isEmpty()) {
                return;
            }
            int interval = this.broadcastConfig.getInt("interval", 300);
            this.broadcastTaskId = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this, () -> {
                if (messages.isEmpty()) {
                    return;
                }
                String message = (String)messages.get(this.currentBroadcastIndex);
                this.sendFormattedBroadcast(message);
                this.currentBroadcastIndex = (this.currentBroadcastIndex + 1) % messages.size();
            }, (long)interval * 20L, (long)interval * 20L);
            this.getLogger().info("Broadcast system started with interval: " + interval + " seconds");
        }
    }

    private void sendFormattedBroadcast(String message) {
        if (message == null || message.isEmpty()) {
            return;
        }
        message = message.replace("/n", "\n");
        String header = this.broadcastConfig.getString("header", "");
        if (header != null && !header.isEmpty()) {
            this.sendClickableMessage(ChatColorUtils.translateColors(header, true, true));
        }
        this.sendClickableMessage(ChatColorUtils.translateColors(message, true, true));
        String footer = this.broadcastConfig.getString("footer", "");
        if (footer != null && !footer.isEmpty()) {
            this.sendClickableMessage(ChatColorUtils.translateColors(footer, true, true));
        }
    }

    private void sendClickableMessage(String message) {
        if (message == null || message.isEmpty()) {
            return;
        }
        if (Bukkit.getOnlinePlayers().isEmpty()) {
            this.getLogger().info("[BROADCAST] " + message.replace("\u00a7", "&"));
            return;
        }
        Matcher matcher = this.urlPattern.matcher(message);
        ArrayList<TextComponent> components = new ArrayList<TextComponent>();
        int lastEnd = 0;
        while (matcher.find()) {
            if (matcher.start() > lastEnd) {
                String before = message.substring(lastEnd, matcher.start());
                components.add(new TextComponent(TextComponent.fromLegacyText((String)before)));
            }
            Object url = matcher.group();
            String displayUrl = url;
            if (matcher.group(1) == null) {
                url = "https://" + (String)url;
            }
            TextComponent urlComponent = new TextComponent(TextComponent.fromLegacyText((String)displayUrl));
            urlComponent.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, (String)url));
            urlComponent.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text("\u00a7a\u041d\u0430\u0436\u043c\u0438\u0442\u0435 \u0447\u0442\u043e\u0431\u044b \u043e\u0442\u043a\u0440\u044b\u0442\u044c \u0441\u0441\u044b\u043b\u043a\u0443")}));
            components.add(urlComponent);
            lastEnd = matcher.end();
        }
        if (lastEnd < message.length()) {
            String remaining = message.substring(lastEnd);
            components.add(new TextComponent(TextComponent.fromLegacyText((String)remaining)));
        }
        TextComponent finalMessage = new TextComponent("");
        for (TextComponent component : components) {
            finalMessage.addExtra((BaseComponent)component);
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            String playerSpecificMessage = this.applyPlaceholderAPI(player, finalMessage.toLegacyText());
            if (!playerSpecificMessage.equals(finalMessage.toLegacyText())) {
                player.sendMessage(playerSpecificMessage);
                continue;
            }
            player.spigot().sendMessage((BaseComponent)finalMessage);
        }
    }

    private String applyPlaceholderAPI(Player player, String message) {
        if (!this.hasPlaceholderAPI || message == null || message.isEmpty()) {
            return message;
        }
        try {
            Class<?> papiClass = Class.forName("me.clip.placeholderapi.PlaceholderAPI");
            Object result = papiClass.getMethod("setPlaceholders", Player.class, String.class).invoke(null, player, message);
            if (result instanceof String) {
                return (String)result;
            }
        }
        catch (Exception e) {
            this.getLogger().warning("Failed to set PlaceholderAPI placeholders for player " + player.getName() + ": " + e.getMessage());
        }
        return message;
    }

    private String formatMessage(Player player, String message, String chatMode) {
        Object finalFormat;
        String baseFormat = chatMode.equals("local") ? this.config.getString("local-chat.format", "&8[\u041b\u043e\u043a\u0430\u043b\u044c\u043d\u043e]") : this.config.getString("global-chat.format", "&8[\u0413\u043b\u043e\u0431\u0430\u043b\u044c\u043d\u043e]");
        String playerGroup = this.getPlayerGroup(player);
        String groupFormat = null;
        if (playerGroup != null && this.config.isConfigurationSection("group-formats") && this.config.getConfigurationSection("group-formats").contains(playerGroup)) {
            groupFormat = this.config.getString("group-formats." + playerGroup);
        }
        Object object = finalFormat = groupFormat != null ? groupFormat : this.config.getString("default-format", "%player_name% &7\u00bb %message%");
        if (finalFormat == null || ((String)finalFormat).isEmpty()) {
            finalFormat = "%player_name% \u00bb %message%";
        }
        finalFormat = ((String)finalFormat).replace("%gchat_format%", baseFormat != null ? baseFormat : "");
        finalFormat = this.replacePlaceholders(player, (String)finalFormat);
        finalFormat = ((String)finalFormat).replace("%message%", message);
        finalFormat = ChatColorUtils.translateColors((String)finalFormat, true, true);
        finalFormat = (String)finalFormat + "\u00a7r";
        return finalFormat;
    }

    private String getPlayerGroup(Player player) {
        if (!this.hasLuckPerms || this.luckPermsAPI == null) {
            return null;
        }
        HashSet<String> validGroups = new HashSet<String>();
        if (this.config.isConfigurationSection("group-formats")) {
            validGroups.addAll(this.config.getConfigurationSection("group-formats").getKeys(false).stream().map(String::toLowerCase).collect(Collectors.toSet()));
        }
        return this.lpCache.getPlayerGroup(player.getUniqueId(), validGroups);
    }

    private String replacePlaceholders(Player player, String text) {
        if (text == null || text.isEmpty()) {
            return "";
        }
        text = text.replace("%player_name%", player.getName()).replace("%player_world%", player.getWorld().getName());
        if (this.hasLuckPerms && text.contains("%luckperms_suffix%")) {
            String suffix = this.lpCache.getPlayerSuffix(player.getUniqueId());
            text = text.replace("%luckperms_suffix%", suffix);
        }
        if (this.hasPlaceholderAPI) {
            try {
                Class<?> papiClass = Class.forName("me.clip.placeholderapi.PlaceholderAPI");
                Object result = papiClass.getMethod("setPlaceholders", Player.class, String.class).invoke(null, player, text);
                if (result instanceof String) {
                    text = (String)result;
                }
            }
            catch (Exception e) {
                this.getLogger().warning("Failed to set PlaceholderAPI placeholders: " + e.getMessage());
            }
        }
        return text;
    }

    private void sendLocalMessage(Player sender, String formattedMessage) {
        boolean localChatEnabled = this.config.getBoolean("local-chat.enabled", true);
        boolean showDisabledMessage = this.config.getBoolean("local-chat.show-disabled-local-chat", true);
        if (!localChatEnabled) {
            if (showDisabledMessage) {
                sender.sendMessage(this.getMessage("local-chat-disabled"));
            }
            return;
        }
        int radius = this.config.getInt("local-chat.radius", 50);
        double radiusSquared = radius * radius;
        int recipients = 0;
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!player.getWorld().equals((Object)sender.getWorld()) || !(player.getLocation().distanceSquared(sender.getLocation()) <= radiusSquared)) continue;
            player.sendMessage(formattedMessage);
            if (player.getUniqueId().equals(sender.getUniqueId())) continue;
            ++recipients;
        }
        if (recipients == 0 && this.config.getBoolean("local-chat.show-silent-message", true)) {
            sender.sendMessage(this.getMessage("local-chat-silent"));
        }
    }

    private void sendGlobalMessage(String formattedMessage) {
        if (!this.config.getBoolean("global-chat.enabled", true)) {
            return;
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            player.sendMessage(formattedMessage);
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (command.getName().equalsIgnoreCase("gchat")) {
            return this.handleGChatCommand(sender, args);
        }
        if (command.getName().equalsIgnoreCase("g")) {
            return this.handleGlobalCommand(sender, args);
        }
        if (command.getName().equalsIgnoreCase("l")) {
            return this.handleLocalCommand(sender, args);
        }
        if (command.getName().equalsIgnoreCase("broadcast")) {
            return this.handleBroadcastCommand(sender, args);
        }
        return false;
    }

    private String filterLinks(Player player, String message) {
        if (!this.config.getBoolean("filter-links.enabled", true)) {
            return message;
        }
        if (player.hasPermission("gchat.link.bypass")) {
            return message;
        }
        Matcher matcher = this.urlPattern.matcher(message);
        if (matcher.find()) {
            player.sendMessage(this.getMessage("illegal-link"));
            return null;
        }
        return message;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (command.getName().equalsIgnoreCase("gchat") && args.length == 1) {
            ArrayList<String> completions = new ArrayList<String>();
            if (sender.hasPermission("gchat.reload")) {
                completions.add("reload");
            }
            if (sender.hasPermission("gchat.debug")) {
                completions.add("debug");
            }
            completions.add("help");
            return completions.stream().filter(c -> c.startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private boolean handleGChatCommand(CommandSender sender, String[] args) {
        if (args.length == 0) {
            this.sendHelp(sender);
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "reload": {
                if (!sender.hasPermission("gchat.reload")) {
                    sender.sendMessage(this.getMessage("no-permission"));
                    return true;
                }
                if (sender instanceof Player) {
                    Player player = (Player)sender;
                    int cd = this.config.getInt("reload-cooldown", 5);
                    if (!this.reloadCooldown.check(player.getUniqueId(), cd)) {
                        long remaining = this.reloadCooldown.getRemaining(player.getUniqueId(), cd);
                        player.sendMessage(this.getMessage("reload-cooldown").replace("{time}", String.valueOf(remaining)));
                        return true;
                    }
                }
                this.reloadAllConfigsAndServices();
                sender.sendMessage(this.getMessage("config-reloaded"));
                break;
            }
            case "help": {
                this.sendHelp(sender);
                break;
            }
            case "debug": {
                if (!sender.hasPermission("gchat.debug")) {
                    sender.sendMessage(this.getMessage("no-permission"));
                    return true;
                }
                return this.handleDebugCommand(sender, args);
            }
            default: {
                sender.sendMessage(this.getMessage("unknown-command"));
            }
        }
        return true;
    }

    private boolean handleDebugCommand(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.getMessage("players-only"));
            return true;
        }
        Player player = (Player)sender;
        player.sendMessage("\u00a76=== Group Debug ===");
        player.sendMessage("\u00a77OP status: \u00a7e" + player.isOp());
        player.sendMessage("\u00a77Username: \u00a7e" + player.getName());
        if (!this.hasLuckPerms || this.luckPermsAPI == null) {
            player.sendMessage("\u00a7cLuckPerms \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0438\u043b\u0438 \u043d\u0435 \u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0438\u0440\u043e\u0432\u0430\u043d");
            return true;
        }
        try {
            HashSet<String> validGroups = new HashSet<String>();
            if (this.config.isConfigurationSection("group-formats")) {
                validGroups.addAll(this.config.getConfigurationSection("group-formats").getKeys(false));
            }
            String group = this.lpCache.getPlayerGroup(player.getUniqueId(), validGroups);
            String suffix = this.lpCache.getPlayerSuffix(player.getUniqueId());
            player.sendMessage("\u00a77Primary Group: \u00a7e" + (group != null ? group : "default"));
            player.sendMessage("\u00a77Suffix: \u00a7f" + (suffix != null && !suffix.isEmpty() ? suffix : "none"));
        }
        catch (Exception e) {
            player.sendMessage("\u00a7c\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0438 \u0434\u0430\u043d\u043d\u044b\u0445 LuckPerms: " + e.getMessage());
        }
        return true;
    }

    private boolean handleGlobalCommand(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            return true;
        }
        Player player = (Player)sender;
        if (args.length > 0) {
            this.processChatMessage(player, String.join((CharSequence)" ", args), "global");
        } else {
            this.playerChatModes.put(player.getUniqueId(), "global");
            player.sendMessage(this.getMessage("chat-mode-global"));
        }
        return true;
    }

    private boolean handleLocalCommand(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            return true;
        }
        Player player = (Player)sender;
        if (args.length > 0) {
            this.processChatMessage(player, String.join((CharSequence)" ", args), "local");
        } else {
            this.playerChatModes.put(player.getUniqueId(), "local");
            player.sendMessage(this.getMessage("chat-mode-local"));
        }
        return true;
    }

    private boolean checkCooldown(Player player) {
        if (!this.config.getBoolean("message-cooldown.enabled", false)) {
            return true;
        }
        if (player.hasPermission("gchat.bypass.cooldown")) {
            return true;
        }
        int cooldownSeconds = this.config.getInt("message-cooldown.seconds", 3);
        if (!this.messageCooldown.check(player.getUniqueId(), cooldownSeconds)) {
            long remaining = this.messageCooldown.getRemaining(player.getUniqueId(), cooldownSeconds);
            player.sendMessage(this.getMessage("message-cooldown").replace("{time}", String.valueOf(remaining)));
            return false;
        }
        return true;
    }

    private boolean checkMessageLength(Player player, String message) {
        int maxLength = this.config.getInt("max-message-length", 256);
        if (message.length() > maxLength && !player.hasPermission("gchat.bypass.length")) {
            player.sendMessage(this.getMessage("message-too-long").replace("{max}", String.valueOf(maxLength)));
            return false;
        }
        return true;
    }

    private String filterBadWords(Player player, String message) {
        if (!this.config.getBoolean("filter.enabled", false) || player.hasPermission("gchat.bypass.filter")) {
            return message;
        }
        List badWords = this.config.getStringList("filter.words");
        String resultMessage = message;
        for (String word : badWords) {
            if (!resultMessage.toLowerCase().contains(word.toLowerCase())) continue;
            if (this.config.getBoolean("filter.block-message", true)) {
                player.sendMessage(this.getMessage("message-blocked"));
                return null;
            }
            String replacement = String.join((CharSequence)"", Collections.nCopies(word.length(), "*"));
            resultMessage = resultMessage.replaceAll("(?i)" + Pattern.quote(word), replacement);
        }
        return resultMessage;
    }

    private boolean hasChatPermission(Player player, String chatType) {
        if (player.hasPermission("gchat.bypass")) {
            return true;
        }
        return chatType.equalsIgnoreCase("global") || chatType.equalsIgnoreCase("local");
    }

    private void processChatMessage(Player player, String originalMessage, String chatMode) {
        if (!this.hasChatPermission(player, chatMode)) {
            return;
        }
        if (!this.checkCooldown(player)) {
            return;
        }
        String filteredMessage = this.filterBadWords(player, originalMessage);
        if (filteredMessage == null) {
            return;
        }
        if ((filteredMessage = this.filterLinks(player, filteredMessage)) == null) {
            return;
        }
        if (!this.checkMessageLength(player, filteredMessage)) {
            return;
        }
        String messageWithMentions = filteredMessage;
        HashSet<Player> mentionedPlayers = new HashSet<Player>();
        if (this.mentionsEnabled && player.hasPermission("gchat.mention")) {
            Matcher matcher = this.mentionPattern.matcher(messageWithMentions);
            StringBuffer sb = new StringBuffer();
            int mentionCd = this.config.getInt("player-mentions.cooldown", 10);
            boolean canMention = this.mentionCooldown.check(player.getUniqueId(), mentionCd);
            boolean triedToMention = false;
            while (matcher.find()) {
                String mentionedName = matcher.group(1);
                Player mentionedPlayer = Bukkit.getPlayerExact((String)mentionedName);
                if (mentionedPlayer != null && mentionedPlayer.isOnline() && !mentionedPlayer.equals((Object)player)) {
                    triedToMention = true;
                    if (canMention) {
                        String highlight = ChatColorUtils.translateColors(this.mentionHighlight.replace("%player%", mentionedName), true, true);
                        matcher.appendReplacement(sb, Matcher.quoteReplacement(highlight));
                        mentionedPlayers.add(mentionedPlayer);
                        continue;
                    }
                    matcher.appendReplacement(sb, matcher.group(0));
                    continue;
                }
                matcher.appendReplacement(sb, matcher.group(0));
            }
            if (!canMention && triedToMention) {
                long remaining = this.mentionCooldown.getRemaining(player.getUniqueId(), mentionCd);
                player.sendMessage(this.getMessage("mention-cooldown").replace("{time}", String.valueOf(remaining)));
            }
            matcher.appendTail(sb);
            messageWithMentions = sb.toString();
        }
        String processedMessage = ChatColorUtils.translateColors(messageWithMentions, GChat.canUseColors(player), GChat.canUseGradients(player));
        String formattedMessage = this.formatMessage(player, processedMessage, chatMode);
        if (chatMode.equals("local")) {
            this.sendLocalMessage(player, formattedMessage);
        } else {
            this.sendGlobalMessage(formattedMessage);
            if (this.mentionsEnabled && !mentionedPlayers.isEmpty()) {
                try {
                    Sound sound = Sound.valueOf((String)this.mentionSound.toUpperCase());
                    for (Player p : mentionedPlayers) {
                        p.playSound(p.getLocation(), sound, this.mentionVolume, this.mentionPitch);
                    }
                }
                catch (IllegalArgumentException e) {
                    this.getLogger().warning("Invalid sound in config: " + this.mentionSound);
                }
            }
            if (this.hasDiscordSRV && this.discordSrvListener != null && this.discordMcToDiscord) {
                this.discordSrvListener.sendToDiscord(player, filteredMessage);
            }
        }
        if (this.config.getBoolean("log-to-console", false)) {
            String cleanMessage = filteredMessage.replace("&", "").replace("\u00a7", "");
            Bukkit.getLogger().info("[" + chatMode.toUpperCase() + "] " + player.getName() + ": " + cleanMessage);
        }
    }

    private static boolean canUseColors(Player player) {
        return player.hasPermission("gchat.color");
    }

    private static boolean canUseGradients(Player player) {
        return player.hasPermission("gchat.gradient");
    }

    @EventHandler
    public void onAsyncPlayerChatEvent(AsyncPlayerChatEvent event) {
        if (!this.config.getBoolean("enabled", true)) {
            return;
        }
        Player player = event.getPlayer();
        String originalMessage = event.getMessage();
        String chatMode = this.playerChatModes.getOrDefault(player.getUniqueId(), this.config.getString("default-chat-mode", "local"));
        if (originalMessage.startsWith("!")) {
            originalMessage = originalMessage.substring(1).trim();
            chatMode = "global";
        } else {
            chatMode = chatMode.toLowerCase();
        }
        Player finalPlayer = player;
        String finalMessage = originalMessage;
        String finalChatMode = chatMode;
        event.setCancelled(true);
        Bukkit.getScheduler().runTask((Plugin)this, () -> this.processChatMessage(finalPlayer, finalMessage, finalChatMode));
    }

    @EventHandler
    public void onPlayerCommand(PlayerCommandPreprocessEvent event) {
        if (!this.blockCommandsEnabled) {
            return;
        }
        Player player = event.getPlayer();
        String message = event.getMessage().toLowerCase();
        if (player.isOp() || player.hasPermission("gchat.bcomm.bypass")) {
            return;
        }
        for (String cmd : this.blockedCommands) {
            String cleanMessage;
            String cleanCmd = cmd.startsWith("/") ? cmd.substring(1) : cmd;
            String string = cleanMessage = message.startsWith("/") ? message.substring(1) : message;
            if (!cleanMessage.startsWith(cleanCmd.toLowerCase() + " ") && !cleanMessage.equals(cleanCmd.toLowerCase())) continue;
            player.sendMessage(this.getMessage("no-permission"));
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        if (!this.handleJoinQuitMessages) {
            return;
        }
        Player player = event.getPlayer();
        if (this.joinMessage != null && !this.joinMessage.isEmpty()) {
            event.setJoinMessage(ChatColorUtils.translateColors(this.joinMessage.replace("%player_name%", player.getName()), true, true));
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        if (!this.handleJoinQuitMessages) {
            return;
        }
        Player player = event.getPlayer();
        if (this.quitMessage != null && !this.quitMessage.isEmpty()) {
            event.setQuitMessage(ChatColorUtils.translateColors(this.quitMessage.replace("%player_name%", player.getName()), true, true));
        }
        if (this.lpCache != null) {
            this.lpCache.remove(player.getUniqueId());
        }
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        if (!this.deathMessagesEnabled) {
            return;
        }
        Player player = event.getEntity();
        Player killer = player.getKiller();
        String customDeathMessage = null;
        if (killer != null) {
            customDeathMessage = this.deathMsgPlayerKill.replace("%player%", player.getName()).replace("%killer%", killer.getName());
        } else {
            EntityDamageByEntityEvent damageByEntity;
            Entity damager;
            EntityDamageEvent lastDamage = player.getLastDamageCause();
            if (lastDamage instanceof EntityDamageByEntityEvent && (damager = (damageByEntity = (EntityDamageByEntityEvent)lastDamage).getDamager()) instanceof LivingEntity && !(damager instanceof Player)) {
                String mobName = damager.getCustomName() != null ? damager.getCustomName() : damager.getName();
                customDeathMessage = this.deathMsgMobKill.replace("%player%", player.getName()).replace("%killer_mob%", mobName);
            }
        }
        if (customDeathMessage == null) {
            customDeathMessage = this.deathMsgOther.replace("%player%", player.getName());
        }
        customDeathMessage = ChatColorUtils.translateColors(customDeathMessage, true, true);
        Bukkit.broadcastMessage((String)customDeathMessage);
        if (this.hideDefaultDeathMessage) {
            event.setDeathMessage(null);
        }
    }

    private boolean handleBroadcastCommand(CommandSender sender, String[] args) {
        if (!sender.hasPermission("gchat.broadcast")) {
            sender.sendMessage(this.getMessage("no-permission"));
            return true;
        }
        if (args.length == 0) {
            sender.sendMessage("\u00a76\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435: /broadcast <\u043d\u043e\u043c\u0435\u0440|next|reload>");
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "reload": {
                this.reloadBroadcastConfig();
                this.setupBroadcast();
                sender.sendMessage("\u00a7aBroadcast \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u0430!");
                break;
            }
            case "next": {
                this.sendNextBroadcastMessage();
                sender.sendMessage("\u00a7a\u0421\u043b\u0435\u0434\u0443\u044e\u0449\u0435\u0435 broadcast \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e!");
                break;
            }
            default: {
                try {
                    int index = Integer.parseInt(args[0]) - 1;
                    List messages = this.broadcastConfig.getStringList("messages");
                    if (index < 0 || index >= messages.size()) {
                        sender.sendMessage("\u00a7c\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f. \u0414\u043e\u0441\u0442\u0443\u043f\u043d\u043e " + messages.size() + " \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0439.");
                        return true;
                    }
                    this.sendFormattedBroadcast((String)messages.get(index));
                    sender.sendMessage("\u00a7aBroadcast \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 #" + (index + 1) + " \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e!");
                    break;
                }
                catch (NumberFormatException e) {
                    sender.sendMessage("\u00a7c\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442. \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 \u043d\u043e\u043c\u0435\u0440, next \u0438\u043b\u0438 reload.");
                }
            }
        }
        return true;
    }

    private void sendNextBroadcastMessage() {
        List messages = this.broadcastConfig.getStringList("messages");
        if (messages.isEmpty()) {
            return;
        }
        String message = (String)messages.get(this.currentBroadcastIndex);
        this.sendFormattedBroadcast(message);
        this.currentBroadcastIndex = (this.currentBroadcastIndex + 1) % messages.size();
    }

    private void sendHelp(CommandSender sender) {
        if (this.messagesConfig.contains("help")) {
            for (String line : this.messagesConfig.getStringList("help")) {
                sender.sendMessage(ChatColorUtils.translateColors(line, true, true));
            }
        } else {
            sender.sendMessage("\u00a76\u00a7l=== gChat Help ===");
            sender.sendMessage("\u00a7e/gchat reload \u00a77- \u041f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044e");
            sender.sendMessage("\u00a7e/gchat help \u00a77- \u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u044d\u0442\u0443 \u043f\u043e\u043c\u043e\u0449\u044c");
            sender.sendMessage("\u00a7e/gchat debug \u00a77- Debug \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f");
            sender.sendMessage("\u00a7e/g \u00a77- \u041f\u0435\u0440\u0435\u043a\u043b\u044e\u0447\u0438\u0442\u044c\u0441\u044f \u043d\u0430 \u0433\u043b\u043e\u0431\u0430\u043b\u044c\u043d\u044b\u0439 \u0447\u0430\u0442");
            sender.sendMessage("\u00a7e/g <\u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435> \u00a77- \u041e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u0433\u043b\u043e\u0431\u0430\u043b\u044c\u043d\u043e\u0435 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435");
            sender.sendMessage("\u00a7e/l \u00a77- \u041f\u0435\u0440\u0435\u043a\u043b\u044e\u0447\u0438\u0442\u044c\u0441\u044f \u043d\u0430 \u043b\u043e\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0447\u0430\u0442");
            sender.sendMessage("\u00a7e/l <\u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435> \u00a77- \u041e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u043b\u043e\u043a\u0430\u043b\u044c\u043d\u043e\u0435 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435");
            sender.sendMessage("\u00a7e!<\u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435> \u00a77- \u041e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u0440\u0430\u0437\u043e\u0432\u043e\u0435 \u0433\u043b\u043e\u0431\u0430\u043b\u044c\u043d\u043e\u0435 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435");
            sender.sendMessage("\u00a76\u0413\u0440\u0430\u0434\u0438\u0435\u043d\u0442\u044b: \u00a77{#RRGGBB>}Text{#RRGGBB<}");
            sender.sendMessage("\u00a76HEX: \u00a77&#RRGGBB");
            if (sender.hasPermission("gchat.use")) {
                sender.sendMessage("\u00a7a\u2713 \u0412\u044b \u0438\u043c\u0435\u0435\u0442\u0435 \u0434\u043e\u0441\u0442\u0443\u043f \u043a \u0447\u0430\u0442\u0443");
            } else {
                sender.sendMessage("\u00a7c\u2717 \u0423 \u0432\u0430\u0441 \u043d\u0435\u0442 \u0434\u043e\u0441\u0442\u0443\u043f\u0430 \u043a \u0447\u0430\u0442\u0443");
            }
        }
    }

    public class CooldownManager {
        private final Map<UUID, Long> cooldowns = new ConcurrentHashMap<UUID, Long>();

        public boolean check(UUID uuid, int seconds) {
            long now = System.currentTimeMillis();
            Long lastTime = this.cooldowns.get(uuid);
            if (lastTime == null || now - lastTime >= (long)seconds * 1000L) {
                this.cooldowns.put(uuid, now);
                return true;
            }
            return false;
        }

        public long getRemaining(UUID uuid, int seconds) {
            Long lastTime = this.cooldowns.get(uuid);
            if (lastTime == null) {
                return 0L;
            }
            long elapsed = System.currentTimeMillis() - lastTime;
            long remaining = (long)seconds * 1000L - elapsed;
            return remaining > 0L ? remaining / 1000L : 0L;
        }

        public void clear() {
            this.cooldowns.clear();
        }
    }

    public class DiscordSRVListener {
        private final GChat plugin;

        public DiscordSRVListener(GChat plugin) {
            this.plugin = plugin;
        }

        @Subscribe
        public void onDiscordChat(DiscordGuildMessagePostProcessEvent event) {
            if (!this.plugin.discordDiscordToMc) {
                return;
            }
            event.setCancelled(true);
            String author = event.getMember().getEffectiveName();
            String message = event.getMessage().getContentStripped();
            if (message.isEmpty()) {
                return;
            }
            String roleColorHex = "";
            try {
                Color roleColor = event.getMember().getColor();
                if (roleColor != null) {
                    roleColorHex = ChatColorUtils.colorToMinecraftHex(roleColor);
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Failed to get Discord role color: " + e.getMessage());
            }
            String roleName = "";
            try {
                List roles = event.getMember().getRoles();
                if (!roles.isEmpty()) {
                    roleName = ((Role)roles.get(0)).getName();
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Failed to get Discord role name: " + e.getMessage());
            }
            String format = this.plugin.discordFormat.replace("%role_color%", roleColorHex).replace("%role_name%", roleName).replace("%user%", author).replace("%message%", message);
            format = ChatColorUtils.translateColors(format, true, true);
            this.plugin.sendGlobalMessage(format);
        }

        public void sendToDiscord(Player player, String message) {
            if (!this.plugin.discordMcToDiscord || !this.plugin.hasDiscordSRV) {
                return;
            }
            try {
                DiscordSRV.getPlugin().processChatMessage(player, message, null, false);
            }
            catch (Exception | NoClassDefFoundError e) {
                this.plugin.getLogger().warning("Failed to send message to DiscordSRV (processChatMessage failed): " + e.getMessage());
                this.plugin.hasDiscordSRV = false;
                this.plugin.discordSrvListener = null;
            }
        }
    }

    public static class LuckPermsCache {
        private final Map<UUID, CachedPlayerData> cache = new ConcurrentHashMap<UUID, CachedPlayerData>();
        private final Object luckPermsAPI;

        public LuckPermsCache(Object luckPermsAPI) {
            this.luckPermsAPI = luckPermsAPI;
        }

        public String getPlayerGroup(UUID uuid, Set<String> validGroups) {
            long now = System.currentTimeMillis();
            CachedPlayerData cached = this.cache.get(uuid);
            if (cached != null && now - cached.timestamp < 60000L) {
                return cached.primaryGroup;
            }
            try {
                Class<?> apiClass = this.luckPermsAPI.getClass();
                Object userManager = apiClass.getMethod("getUserManager", new Class[0]).invoke(this.luckPermsAPI, new Object[0]);
                Object user = userManager.getClass().getMethod("getUser", UUID.class).invoke(userManager, uuid);
                if (user == null) {
                    return null;
                }
                String primaryGroup = (String)user.getClass().getMethod("getPrimaryGroup", new Class[0]).invoke(user, new Object[0]);
                if (primaryGroup != null && validGroups.contains(primaryGroup.toLowerCase())) {
                    CachedPlayerData newData = new CachedPlayerData();
                    newData.primaryGroup = primaryGroup.toLowerCase();
                    Object cachedData = user.getClass().getMethod("getCachedData", new Class[0]).invoke(user, new Object[0]);
                    Object metaData = cachedData.getClass().getMethod("getMetaData", new Class[0]).invoke(cachedData, new Object[0]);
                    String suffix = (String)metaData.getClass().getMethod("getSuffix", new Class[0]).invoke(metaData, new Object[0]);
                    newData.suffix = suffix != null ? ChatColorUtils.translateColors(suffix, true, true) : "";
                    newData.timestamp = now;
                    this.cache.put(uuid, newData);
                    return newData.primaryGroup;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        public String getPlayerSuffix(UUID uuid) {
            CachedPlayerData cached = this.cache.get(uuid);
            return cached != null ? cached.suffix : "";
        }

        public void remove(UUID uuid) {
            this.cache.remove(uuid);
        }

        public void clear() {
            this.cache.clear();
        }

        public static class CachedPlayerData {
            String primaryGroup;
            String suffix;
            long timestamp;
        }
    }

    public static class ChatColorUtils {
        private static final Pattern GRADIENT_PATTERN = Pattern.compile("\\{#([0-9A-Fa-f]{6})>\\}(.*?)\\{#([0-9A-Fa-f]{6})<\\}");
        private static final Pattern HEX_PATTERN = Pattern.compile("&#([A-Fa-f0-9]{6})");

        public static String translateColors(String text, boolean allowColors, boolean allowGradients) {
            if (text == null) {
                return "";
            }
            if (allowGradients) {
                text = ChatColorUtils.applyGradients(text);
            }
            text = ChatColorUtils.applyHexColors(text);
            if (allowColors) {
                text = ChatColorUtils.replaceStandardColors(text);
            }
            return text;
        }

        private static String replaceStandardColors(String text) {
            return text.replace("&", "\u00a7");
        }

        private static String applyHexColors(String text) {
            if (text == null) {
                return "";
            }
            Matcher matcher = HEX_PATTERN.matcher(text);
            StringBuffer buffer = new StringBuffer();
            while (matcher.find()) {
                String hex = matcher.group(1);
                StringBuilder replacement = new StringBuilder("\u00a7x");
                for (char c : hex.toCharArray()) {
                    replacement.append("\u00a7").append(c);
                }
                matcher.appendReplacement(buffer, replacement.toString());
            }
            matcher.appendTail(buffer);
            return buffer.toString();
        }

        public static String applyGradients(String text) {
            if (text == null) {
                return text;
            }
            Matcher matcher = GRADIENT_PATTERN.matcher(text);
            StringBuffer result = new StringBuffer();
            while (matcher.find()) {
                String startColor = matcher.group(1);
                String content = matcher.group(2);
                String endColor = matcher.group(3);
                String gradientText = ChatColorUtils.createGradient(content, startColor, endColor);
                matcher.appendReplacement(result, Matcher.quoteReplacement(gradientText));
            }
            matcher.appendTail(result);
            return result.toString();
        }

        private static String createGradient(String text, String startHex, String endHex) {
            try {
                Color startColor = Color.decode("#" + startHex);
                Color endColor = Color.decode("#" + endHex);
                StringBuilder gradient = new StringBuilder();
                int length = text.length();
                for (int i = 0; i < length; ++i) {
                    float ratio = (float)i / (float)Math.max(1, length - 1);
                    Color current = ChatColorUtils.interpolateColor(startColor, endColor, ratio);
                    gradient.append(ChatColorUtils.colorToMinecraftHex(current)).append(text.charAt(i));
                }
                return gradient.toString();
            }
            catch (Exception e) {
                return text;
            }
        }

        private static Color interpolateColor(Color start, Color end, float ratio) {
            int r = Math.max(0, Math.min(255, (int)((float)start.getRed() + ratio * (float)(end.getRed() - start.getRed()))));
            int g = Math.max(0, Math.min(255, (int)((float)start.getGreen() + ratio * (float)(end.getGreen() - start.getGreen()))));
            int b = Math.max(0, Math.min(255, (int)((float)start.getBlue() + ratio * (float)(end.getBlue() - start.getBlue()))));
            return new Color(r, g, b);
        }

        private static String colorToMinecraftHex(Color color) {
            String hex = String.format("%02X%02X%02X", color.getRed(), color.getGreen(), color.getBlue());
            StringBuilder sb = new StringBuilder("\u00a7x");
            for (char c : hex.toCharArray()) {
                sb.append("\u00a7").append(c);
            }
            return sb.toString();
        }

        public static String removeGradients(String text) {
            if (text == null) {
                return "";
            }
            return text.replaceAll("\\{#[0-9A-Fa-f]{6}>\\}", "").replaceAll("\\{#[0-9A-Fa-f]{6}<\\}", "");
        }
    }
}

