/*
 * Decompiled with CFR 0.152.
 */
package dev.kalbarczyk.easyroads.config;

import dev.kalbarczyk.easyroads.config.ConfigState;
import dev.kalbarczyk.easyroads.models.Road;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;

public record ConfigHandler(FileConfiguration config, Logger logger) {
    public ConfigState load() {
        double speedIncreaseRate = this.loadSpeedIncreaseRate();
        double speedDecayRate = this.loadSpeedDecayRate();
        ConfigState.Messages messages = this.loadMessages();
        Set<Class<? extends LivingEntity>> affectedEntities = this.loadAffectedEntities();
        Set<Road> roads = this.loadRoads();
        this.logLoadedRoads(roads);
        return new ConfigState(roads, speedIncreaseRate, speedDecayRate, affectedEntities, messages);
    }

    private double loadSpeedIncreaseRate() {
        return this.config.getDouble("speedIncreaseRate", 0.01);
    }

    private double loadSpeedDecayRate() {
        return this.config.getDouble("speedDecayRate", 1.0);
    }

    private ConfigState.Messages loadMessages() {
        return new ConfigState.Messages(this.translateColors(this.config.getString("messages.onRoad", "&cYou are on a road!")), this.translateColors(this.config.getString("messages.noPermission", "&4You do not have permission to use this command.")), this.translateColors(this.config.getString("messages.reloadSuccess", "&aConfiguration reloaded successfully.")), this.translateColors(this.config.getString("messages.listHeader", "&6Roads:")), this.translateColors(this.config.getString("messages.help.header", "&bEasyRoads commands:")), this.translateColors(this.config.getString("messages.help.reload", "&7/easyroads reload - Reload the EasyRoads configuration.")), this.translateColors(this.config.getString("messages.help.list", "&7/easyroads list - List all roads.")), this.translateColors(this.config.getString("messages.help.help", "&7/easyroads help - Display this help message.")), this.translateColors(this.config.getString("messages.invalidCommand", "&cInvalid subcommand. Use /easyroads help for available commands.")));
    }

    private Set<Class<? extends LivingEntity>> loadAffectedEntities() {
        HashSet<Class<? extends LivingEntity>> entities = new HashSet<Class<? extends LivingEntity>>();
        for (String entityName : this.config.getStringList("affectedEntities")) {
            try {
                Class clazz;
                EntityType type = EntityType.valueOf((String)entityName);
                if (type == EntityType.PLAYER || (clazz = type.getEntityClass()) == null || !LivingEntity.class.isAssignableFrom(clazz)) continue;
                entities.add(clazz.asSubclass(LivingEntity.class));
            }
            catch (IllegalArgumentException e) {
                this.logger.warning("Invalid entity type in config: " + entityName);
            }
        }
        return entities;
    }

    private Set<Road> loadRoads() {
        ConfigurationSection roadSection = this.config.getConfigurationSection("roads");
        if (roadSection == null) {
            this.logger.warning("No roads section found in config!");
            return new HashSet<Road>();
        }
        return roadSection.getKeys(false).stream().map(key -> new Road(Objects.requireNonNull(roadSection.getConfigurationSection(key)), this.logger)).collect(Collectors.toSet());
    }

    private void logLoadedRoads(Set<Road> roads) {
        this.logger.info("--------------------");
        this.logger.info("Loaded roads:");
        this.logger.info("--------------------");
        int i = 1;
        for (Road road : roads) {
            this.logger.info(i + ") " + String.valueOf(road));
            ++i;
        }
        this.logger.info("--------------------");
    }

    private String translateColors(String message) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }
}

