/*
 * Decompiled with CFR 0.152.
 */
package dev.kalbarczyk.easyroads.models;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.configuration.ConfigurationSection;

public class Road {
    private final double speed;
    private final Logger log;
    private final List<RoadBlock> blocks = new ArrayList<RoadBlock>();

    public Road(ConfigurationSection config, Logger logger) {
        this.speed = config.getDouble("speed", 0.2);
        this.log = logger;
        config.getStringList("blocks").forEach(a -> {
            if (a.equalsIgnoreCase("AIR")) {
                this.log.severe("Road blocks cannot be set to AIR. Skipping this block.");
                return;
            }
            if (a.equalsIgnoreCase("EMPTY") || a.equalsIgnoreCase("NULL") || a.equalsIgnoreCase("ANY")) {
                this.blocks.add(RoadBlock.any());
                return;
            }
            int index = a.indexOf(91);
            if (index == -1) {
                index = a.length();
            }
            String material = a.substring(0, index).trim();
            String data = a.substring(index);
            Material matchedMaterial = Material.matchMaterial((String)material);
            if (matchedMaterial == null && (matchedMaterial = Material.matchMaterial((String)material, (boolean)true)) != null) {
                this.log.warning("Found legacy material in road. You should update it to the new name to avoid any potential issues.");
                this.log.warning(String.format("Input string: %s -> %s", material, matchedMaterial.name()));
            }
            if (matchedMaterial == null) {
                this.log.severe("Invalid road block defined, skipping. Make sure to specify a valid material!");
                this.log.severe(String.format("Input string: %s", a));
                return;
            }
            this.blocks.add(RoadBlock.specific(Bukkit.createBlockData((Material)matchedMaterial, (String)data)));
        });
    }

    public boolean isRoadBlock(Block block) {
        if (this.blocks.isEmpty()) {
            return false;
        }
        for (int i = 0; i < this.blocks.size(); ++i) {
            Block checkBlock = block.getRelative(0, -i, 0);
            if (this.blocks.get(i).matches(checkBlock)) continue;
            return false;
        }
        return true;
    }

    public double getSpeedModifier() {
        return this.speed;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\u00a76Road\u00a7r\n");
        sb.append("  \u00a77Speed: \u00a7f").append(this.speed).append("\n");
        sb.append("  \u00a77Blocks: \u00a7f");
        boolean first = true;
        for (RoadBlock roadBlocks : this.blocks) {
            if (!first) {
                sb.append("\u00a77, \u00a7f");
            }
            sb.append(roadBlocks.getDisplayName());
            first = false;
        }
        return sb.toString();
    }

    private record RoadBlock(BlockData blockData, boolean isAny) {
        public static RoadBlock any() {
            return new RoadBlock(null, true);
        }

        public static RoadBlock specific(BlockData blockData) {
            return new RoadBlock(blockData, false);
        }

        public boolean matches(Block block) {
            if (this.isAny) {
                return !block.getType().isAir();
            }
            return block.getBlockData().matches(this.blockData);
        }

        public String getDisplayName() {
            if (this.isAny) {
                return "\u00a7fany";
            }
            return this.blockData.getMaterial().name().toLowerCase().replace("_", " ");
        }
    }
}

