/*
 * Decompiled with CFR 0.152.
 */
package dev.kalbarczyk.easyroads.tasks;

import dev.kalbarczyk.easyroads.EasyRoads;
import dev.kalbarczyk.easyroads.models.Road;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;

public class EasyRoadsTask
extends BukkitRunnable {
    private static final int UPDATE_ON_ROAD_DIVIDER = 20;
    private static final int UPDATE_ENTITY_CACHE = 100;
    private static final UUID MODIFIER_UUID = UUID.fromString("0d2d4303-c228-4075-9f94-00fa3036f40c");
    private static final String MODIFIER_NAME = "EasyRoads";
    private static final AttributeModifier EMPTY_MODIFIER = new AttributeModifier(MODIFIER_UUID, "EasyRoads", 0.0, AttributeModifier.Operation.ADD_SCALAR);
    private final EasyRoads plugin;
    private final Map<UUID, Double> currentSpeedMap = new HashMap<UUID, Double>();
    private final Map<UUID, Double> targetSpeedMap = new HashMap<UUID, Double>();
    private final Map<World, Collection<Entity>> affectedEntitiesMap = new HashMap<World, Collection<Entity>>();
    private long tickCounter = 0L;

    public EasyRoadsTask(EasyRoads plugin) {
        this.plugin = plugin;
    }

    public void run() {
        Bukkit.getOnlinePlayers().forEach(this::applyAttributeToLivingEntity);
        this.affectedEntitiesMap.forEach((w, a) -> a.forEach(this::applyAttributeToEntity));
        if (this.tickCounter++ % 100L == 0L && !this.plugin.getConfigState().affectedEntities().isEmpty()) {
            Bukkit.getWorlds().forEach(a -> this.affectedEntitiesMap.put((World)a, a.getEntitiesByClasses(this.plugin.getConfigState().affectedEntities().toArray(new Class[0]))));
        }
    }

    private void applyAttributeToEntity(Entity entity) {
        if (entity.isValid() && entity instanceof LivingEntity) {
            this.applyAttributeToLivingEntity((LivingEntity)entity);
        }
    }

    private void applyAttributeToLivingEntity(LivingEntity livingEntity) {
        double targetSpeedMod;
        double currentSpeedMod = this.currentSpeedMap.getOrDefault(livingEntity.getUniqueId(), 0.0);
        if (currentSpeedMod == (targetSpeedMod = this.getTargetSpeed(livingEntity))) {
            return;
        }
        AttributeInstance attrib = livingEntity.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED);
        assert (attrib != null);
        attrib.removeModifier(EMPTY_MODIFIER);
        currentSpeedMod = targetSpeedMod >= currentSpeedMod ? Math.min(currentSpeedMod + this.plugin.getConfigState().speedIncreaseRate(), targetSpeedMod) : Math.max(currentSpeedMod - this.plugin.getConfigState().speedDecayRate(), 0.0);
        attrib.addModifier(new AttributeModifier(MODIFIER_UUID, MODIFIER_NAME, currentSpeedMod, AttributeModifier.Operation.ADD_SCALAR));
        this.currentSpeedMap.put(livingEntity.getUniqueId(), currentSpeedMod);
    }

    private double getTargetSpeed(LivingEntity livingEntity) {
        if (this.tickCounter % 20L == (long)(livingEntity.getEntityId() % 20)) {
            double targetSpeedMod = Double.NEGATIVE_INFINITY;
            Block blockBelowFeet = livingEntity.getLocation().clone().subtract(0.0, 0.1, 0.0).getBlock();
            for (Road road : this.plugin.getConfigState().roads()) {
                if (!(road.getSpeedModifier() > targetSpeedMod) || !road.isRoadBlock(blockBelowFeet)) continue;
                targetSpeedMod = road.getSpeedModifier();
                if (!(livingEntity instanceof Player)) continue;
                Player p = (Player)livingEntity;
                p.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(this.plugin.getConfigState().messages().onRoad()));
            }
            if (targetSpeedMod == Double.NEGATIVE_INFINITY) {
                targetSpeedMod = 0.0;
            }
            this.targetSpeedMap.put(livingEntity.getUniqueId(), targetSpeedMod);
        }
        return this.targetSpeedMap.getOrDefault(livingEntity.getUniqueId(), 0.0);
    }
}

