const fs = require('fs').promises;
const path = require('path');

async function createJsonFiles(folderPath) {
    try {
        // Read all files in the folder
        const files = await fs.readdir(folderPath);
        
        // Filter for PNG files
        const pngFiles = files.filter(file => path.extname(file).toLowerCase() === '.png');
        
        // Process each PNG file
        for (const file of pngFiles) {
            const fileNameWithoutExt = path.basename(file, '.png');
            const jsonContent = {
                parent: "minecraft:item/generated",
                textures: {
                    layer0: `mc_donalds:item/${fileNameWithoutExt}`
                }
            };
            
            // Create JSON file path
            const jsonFilePath = path.join(folderPath, `${fileNameWithoutExt}.json`);
            
            // Write JSON file
            await fs.writeFile(jsonFilePath, JSON.stringify(jsonContent, null, 2));
            console.log(`Created ${jsonFilePath}`);
        }
        
        console.log('Processing complete!');
    } catch (error) {
        console.error('Error:', error.message);
    }
}

// Usage: node generateJsonFiles.js <folder-path>
const folderPath = process.argv[2] || './'; // Use command line argument or current directory
createJsonFiles(folderPath);