/*
 * Decompiled with CFR 0.152.
 */
package tech.muddykat.engineered_schematics;

import blusunrize.immersiveengineering.api.ManualHelper;
import blusunrize.immersiveengineering.api.client.ieobj.IEOBJCallback;
import blusunrize.immersiveengineering.api.client.ieobj.IEOBJCallbacks;
import blusunrize.lib.manual.ManualEntry;
import blusunrize.lib.manual.ManualInstance;
import blusunrize.lib.manual.Tree;
import com.mojang.logging.LogUtils;
import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;
import tech.muddykat.engineered_schematics.client.renderer.CorkboardRenderer;
import tech.muddykat.engineered_schematics.client.renderer.ESDynamicModel;
import tech.muddykat.engineered_schematics.client.screen.SchematicsScreen;
import tech.muddykat.engineered_schematics.event.SchematicPickBlockHandler;
import tech.muddykat.engineered_schematics.helper.SchematicTableCallbacks;
import tech.muddykat.engineered_schematics.registry.ESMenuTypes;
import tech.muddykat.engineered_schematics.registry.ESRegistry;

@Mod(value="engineered_schematics")
public class EngineeredSchematics {
    public static final String MODID = "engineered_schematics";
    public static final String SCHEMATIC_GUIID = "schematic_table";
    public static final Logger LOGGER = LogUtils.getLogger();
    private static final HashMap<ResourceLocation, ItemStack> ES_FORMATION_TEMPLATE = new HashMap();

    public EngineeredSchematics() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        LogUtils.getLogger().info("Starting Engineered Schematics");
        ESRegistry.register(modEventBus);
        ESMenuTypes.register(modEventBus);
        ESRegistry.initialize();
        modEventBus.addListener(this::addCreative);
    }

    public static void setTemplateFormationItem(ResourceLocation id, ItemStack item) {
        ES_FORMATION_TEMPLATE.put(id, item);
    }

    public static boolean hasFormationItem(ResourceLocation uniqueName) {
        return ES_FORMATION_TEMPLATE.containsKey(uniqueName);
    }

    public static ItemStack getFormationItem(ResourceLocation uniqueName) {
        return ES_FORMATION_TEMPLATE.get(uniqueName);
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.f_256788_) {
            event.accept(ESRegistry.BLOCK_ITEM_SCHEMATIC_TABLE);
        }
    }

    public static ResourceLocation makeTextureLocation(String name) {
        return new ResourceLocation(MODID, "textures/gui/" + name + ".png");
    }

    @Mod.EventBusSubscriber(modid="engineered_schematics", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            IEOBJCallbacks.register((ResourceLocation)new ResourceLocation(EngineeredSchematics.MODID, "schematic_table_block"), (IEOBJCallback)SchematicTableCallbacks.INSTANCE);
            MenuScreens.m_96206_(ESMenuTypes.SCHEMATICS.getType(), SchematicsScreen::new);
            MinecraftForge.EVENT_BUS.register((Object)new SchematicPickBlockHandler());
            ClientModEvents.setupManualEntries();
        }

        @SubscribeEvent
        public static void registerModelLoaders(ModelEvent.RegisterGeometryLoaders event) {
            CorkboardRenderer.FRAME_EDGE = new ESDynamicModel("frame_edge");
            CorkboardRenderer.CORNER = new ESDynamicModel("corner");
            CorkboardRenderer.SCHEMATIC = new ESDynamicModel("schematic");
        }

        private static <T extends BlockEntity> void registerBERenderNoContext(EntityRenderersEvent.RegisterRenderers event, BlockEntityType<? extends T> type, Supplier<BlockEntityRenderer<T>> render) {
            event.registerBlockEntityRenderer(type, $ -> (BlockEntityRenderer)render.get());
        }

        @SubscribeEvent
        public static void registerBERenderer(EntityRenderersEvent.RegisterRenderers event) {
            ClientModEvents.registerBERenderNoContext(event, (BlockEntityType)ESRegistry.SCHEMATIC_BOARD_TYPE.get(), CorkboardRenderer::new);
        }

        private static void setupManualEntries() {
            ManualInstance instance = ManualHelper.getManual();
            Tree.InnerNode parent_category = instance.getRoot().getOrCreateSubnode((Comparable)new ResourceLocation(EngineeredSchematics.MODID, "main"), 99);
            ManualEntry.ManualEntryBuilder builder = new ManualEntry.ManualEntryBuilder(ManualHelper.getManual());
            builder.readFromFile(new ResourceLocation(EngineeredSchematics.MODID, "es"));
            instance.addEntry(parent_category, builder.create());
            builder.readFromFile(new ResourceLocation(EngineeredSchematics.MODID, EngineeredSchematics.SCHEMATIC_GUIID));
            instance.addEntry(parent_category, builder.create());
            builder.readFromFile(new ResourceLocation(EngineeredSchematics.MODID, "schematic_item"));
            instance.addEntry(parent_category, builder.create());
        }
    }
}

