/*
 * Decompiled with CFR 0.152.
 */
package tech.muddykat.engineered_schematics.block;

import blusunrize.immersiveengineering.api.IEProperties;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import tech.muddykat.engineered_schematics.block.entity.SchematicBoardBlockEntity;
import tech.muddykat.engineered_schematics.registry.ESRegistry;

public class SchematicCorkBoard
extends Block
implements EntityBlock {
    public static final Property<Direction> FACING;
    protected static final VoxelShape EAST_AABB;
    protected static final VoxelShape WEST_AABB;
    protected static final VoxelShape SOUTH_AABB;
    protected static final VoxelShape NORTH_AABB;

    public SchematicCorkBoard() {
        super(BlockBehaviour.Properties.m_284310_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING});
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        SchematicBoardBlockEntity interaction;
        InteractionResult res;
        InteractionResult superResult = super.m_6227_(state, world, pos, player, hand, hit);
        if (superResult.m_19077_()) {
            return superResult;
        }
        Direction side = hit.m_82434_();
        float hitX = (float)hit.m_82450_().f_82479_ - (float)pos.m_123341_();
        float hitY = (float)hit.m_82450_().f_82480_ - (float)pos.m_123342_();
        float hitZ = (float)hit.m_82450_().f_82481_ - (float)pos.m_123343_();
        ItemStack heldItem = player.m_21120_(hand);
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof SchematicBoardBlockEntity && ((res = (interaction = (SchematicBoardBlockEntity)tile).interact(side, player, hand, heldItem, hitX, hitY, hitZ)).m_19077_() || res == InteractionResult.FAIL)) {
            return res;
        }
        return superResult;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        switch ((Direction)pState.m_61143_(FACING)) {
            case NORTH: {
                return SOUTH_AABB;
            }
            case SOUTH: {
                return NORTH_AABB;
            }
            case WEST: {
                return EAST_AABB;
            }
        }
        return WEST_AABB;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        BlockState blockstate;
        if (!pContext.m_7058_() && (blockstate = pContext.m_43725_().m_8055_(pContext.m_8083_().m_121945_(pContext.m_43719_().m_122424_()))).m_60713_((Block)this) && blockstate.m_61143_(FACING) == pContext.m_43719_()) {
            return null;
        }
        blockstate = this.m_49966_();
        for (Direction direction : pContext.m_6232_()) {
            if (!Direction.Plane.HORIZONTAL.test(direction)) continue;
            blockstate = (BlockState)blockstate.m_61124_(FACING, (Comparable)direction.m_122424_());
        }
        return blockstate;
    }

    public void onNeighborChange(BlockState state, LevelReader level, BlockPos pos, BlockPos neighbor) {
        super.onNeighborChange(state, level, pos, neighbor);
        BlockEntity tile = level.m_7702_(pos);
        if (tile instanceof SchematicBoardBlockEntity) {
            SchematicBoardBlockEntity board = (SchematicBoardBlockEntity)tile;
            board.updateEdges(pos);
            board.updateEdges(neighbor);
        }
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean pMovedByPiston) {
        super.m_6807_(state, level, pos, oldState, pMovedByPiston);
        BlockEntity tile = level.m_7702_(pos);
        if (tile instanceof SchematicBoardBlockEntity) {
            SchematicBoardBlockEntity board = (SchematicBoardBlockEntity)tile;
            board.onInitialPlace();
        }
    }

    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return ((BlockEntityType)ESRegistry.SCHEMATIC_BOARD_TYPE.get()).m_155264_(pos, state);
    }

    static {
        EAST_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0);
        WEST_AABB = Block.m_49796_((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        SOUTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0);
        NORTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);
        FACING = IEProperties.FACING_HORIZONTAL;
    }
}

