/*
 * Decompiled with CFR 0.152.
 */
package tech.muddykat.engineered_schematics.block.entity;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlockEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.PlacementLimitation;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;
import tech.muddykat.engineered_schematics.client.renderer.BorderState;
import tech.muddykat.engineered_schematics.item.SchematicItem;
import tech.muddykat.engineered_schematics.registry.ESRegistry;

public class SchematicBoardBlockEntity
extends IEBaseBlockEntity
implements IIEInventory,
IEBlockInterfaces.IBlockEntityDrop,
IEBlockInterfaces.IStateBasedDirectional,
IEBlockInterfaces.IBlockOverlayText {
    public static final int NUM_SLOTS = 4;
    BorderState borderState = new BorderState();
    private final NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
    private final Map<Direction, Boolean> adjacentBlocks = new EnumMap<Direction, Boolean>(Direction.class);
    private final Map<BlockPos, Boolean> diagonalBlocks = new HashMap<BlockPos, Boolean>();
    private static Random rand;
    List<Float> randomStates = new ArrayList<Float>(8);

    public SchematicBoardBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ESRegistry.SCHEMATIC_BOARD_TYPE.get(), pos, state);
        rand = new Random(this.m_58899_().m_121878_());
        while (this.randomStates.size() < 8) {
            this.randomStates.add(Float.valueOf(rand.nextFloat()));
        }
    }

    public Property<Direction> getFacingProperty() {
        return IEProperties.FACING_HORIZONTAL;
    }

    public PlacementLimitation getFacingLimitation() {
        return PlacementLimitation.HORIZONTAL_AXIS;
    }

    public boolean mirrorFacingOnPlacement(LivingEntity placer) {
        return placer.m_6144_();
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        this.borderState.writeToNBT(nbt);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.borderState.updateFromNBT(nbt);
    }

    public void readCustomNBT(CompoundTag nbt, boolean descPacket) {
        ContainerHelper.m_18980_((CompoundTag)nbt, this.inventory);
        this.borderState.updateFromNBT(nbt);
    }

    public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
        ContainerHelper.m_18973_((CompoundTag)nbt, this.inventory);
        this.borderState.writeToNBT(nbt);
    }

    public void getBlockEntityDrop(LootContext context, Consumer<ItemStack> drop) {
        ItemStack stack = new ItemStack((ItemLike)this.m_58900_().m_60734_(), 1);
        CompoundTag nbt = new CompoundTag();
        ContainerHelper.m_18973_((CompoundTag)nbt, this.inventory);
        if (!nbt.m_128456_()) {
            stack.m_41751_(nbt);
        }
        drop.accept(stack);
    }

    public void onBEPlaced(BlockPlaceContext ctx) {
        ItemStack stack = ctx.m_43722_();
        if (stack.m_41782_()) {
            this.readCustomNBT(stack.m_41784_(), false);
        }
    }

    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    public boolean isStackValid(int slot, ItemStack stack) {
        return stack.m_41720_() instanceof SchematicItem;
    }

    public int getSlotLimit(int slot) {
        return 1;
    }

    public void doGraphicalUpdates() {
        this.m_6596_();
        this.markContainingBlockForUpdate(null);
    }

    public static int getTargetedSlot(Direction side, float hitX, float hitY, float hitZ) {
        float targetV;
        float targetU = side == Direction.NORTH ? 1.0f - hitX : (side == Direction.SOUTH ? hitX : (side == Direction.EAST ? 1.0f - hitZ : hitZ));
        float f = targetV = side == Direction.UP ? 1.0f - hitZ : 1.0f - hitY;
        return (double)targetU < 0.5 ? ((double)targetV < 0.5 ? 0 : 2) : ((double)targetV < 0.5 ? 1 : 3);
    }

    public InteractionResult interact(Direction side, Player player, InteractionHand hand, ItemStack heldItem, float hitX, float hitY, float hitZ) {
        int targetedSlot = SchematicBoardBlockEntity.getTargetedSlot(side, hitX, hitY, hitZ);
        ItemStack stackInSlot = (ItemStack)this.inventory.get(targetedSlot);
        if (!stackInSlot.m_41619_()) {
            if (heldItem.m_41619_()) {
                player.m_21008_(hand, stackInSlot);
            } else if (!this.getLevelNonnull().m_5776_()) {
                player.m_5552_(stackInSlot, 0.0f);
            }
            this.inventory.set(targetedSlot, (Object)ItemStack.f_41583_);
            return InteractionResult.m_19078_((boolean)this.getLevelNonnull().f_46443_);
        }
        if (this.isStackValid(targetedSlot, heldItem)) {
            this.inventory.set(targetedSlot, (Object)heldItem.m_255036_(1));
            heldItem.m_41774_(1);
            return InteractionResult.m_19078_((boolean)this.getLevelNonnull().f_46443_);
        }
        this.markChunkDirty();
        this.markBlockForUpdate(this.m_58899_(), this.m_58900_());
        return InteractionResult.FAIL;
    }

    @Nullable
    public Component[] getOverlayText(Player player, HitResult mop, boolean hammer) {
        if (mop instanceof BlockHitResult) {
            BlockHitResult bhr = (BlockHitResult)mop;
            float hitX = (float)bhr.m_82450_().f_82479_ - (float)bhr.m_82425_().m_123341_();
            float hitY = (float)bhr.m_82450_().f_82480_ - (float)bhr.m_82425_().m_123342_();
            float hitZ = (float)bhr.m_82450_().f_82481_ - (float)bhr.m_82425_().m_123343_();
            int targetedSlot = SchematicBoardBlockEntity.getTargetedSlot(bhr.m_82434_(), hitX, hitY, hitZ);
            ItemStack stackInSlot = (ItemStack)this.inventory.get(targetedSlot);
            if (stackInSlot.m_41619_()) {
                return new Component[]{Component.m_237119_()};
            }
            return new Component[]{stackInSlot.m_41786_()};
        }
        return null;
    }

    public boolean useNixieFont(Player player, HitResult hitResult) {
        return false;
    }

    private boolean isSameBlockType(BlockPos pos) {
        assert (this.f_58857_ != null);
        BlockEntity blockEntity = this.f_58857_.m_7702_(pos);
        return blockEntity instanceof SchematicBoardBlockEntity;
    }

    public void refreshAdjacentBlocks() {
        Direction facing = this.getFacing();
        for (Direction dir : Direction.values()) {
            BlockPos adjacentPos = this.f_58858_.m_121945_(dir);
            boolean hasSameBlock = this.isSameBlockType(adjacentPos);
            this.adjacentBlocks.put(dir, hasSameBlock);
            this.borderState.updateEdge(dir, !hasSameBlock, facing);
        }
        this.updateDiagonalBlocks();
        this.borderState.updateCorners(this.adjacentBlocks, this.diagonalBlocks, facing, this.f_58858_);
        this.markBlockForUpdate(this.f_58858_, this.m_58900_());
    }

    private void updateDiagonalBlocks() {
        Direction facing = this.getFacing();
        this.diagonalBlocks.clear();
        this.checkAndCacheDiagonal(Direction.UP, facing.m_122427_());
        this.checkAndCacheDiagonal(Direction.UP, facing.m_122428_());
        this.checkAndCacheDiagonal(Direction.DOWN, facing.m_122427_());
        this.checkAndCacheDiagonal(Direction.DOWN, facing.m_122428_());
    }

    private void checkAndCacheDiagonal(Direction dir1, Direction dir2) {
        BlockPos diagonalPos = this.f_58858_.m_121945_(dir1).m_121945_(dir2);
        boolean hasSameBlock = this.isSameBlockType(diagonalPos);
        this.diagonalBlocks.put(diagonalPos, hasSameBlock);
    }

    public void updateEdges(BlockPos neighborPos) {
        BlockPos delta = neighborPos.m_121996_((Vec3i)this.f_58858_);
        int manhattan = Math.abs(delta.m_123341_()) + Math.abs(delta.m_123342_()) + Math.abs(delta.m_123343_());
        if (manhattan == 1) {
            Direction side = Direction.m_122372_((float)delta.m_123341_(), (float)delta.m_123342_(), (float)delta.m_123343_());
            boolean hasSameBlock = this.isSameBlockType(neighborPos);
            this.adjacentBlocks.put(side, hasSameBlock);
            this.borderState.updateEdge(side, !hasSameBlock, this.getFacing());
            this.updateDiagonalBlocks();
            this.borderState.updateCorners(this.adjacentBlocks, this.diagonalBlocks, this.getFacing(), this.f_58858_);
            this.markBlockForUpdate(this.f_58858_, this.m_58900_());
            this.notifyNeighborsToUpdate();
        } else if (manhattan == 2 && delta.m_123343_() == 0) {
            this.updateDiagonalBlocks();
            this.borderState.updateCorners(this.adjacentBlocks, this.diagonalBlocks, this.getFacing(), this.f_58858_);
            this.markBlockForUpdate(this.f_58858_, this.m_58900_());
        }
    }

    private void notifyNeighborsToUpdate() {
        for (Direction dir : Direction.values()) {
            BlockPos adjacentPos = this.f_58858_.m_121945_(dir);
            BlockEntity blockEntity = this.f_58857_.m_7702_(adjacentPos);
            if (!(blockEntity instanceof SchematicBoardBlockEntity)) continue;
            SchematicBoardBlockEntity board = (SchematicBoardBlockEntity)blockEntity;
            board.refreshAdjacentBlocks();
        }
    }

    public void onInitialPlace() {
        if (this.randomStates.isEmpty()) {
            rand = new Random(this.m_58899_().m_121878_());
            while (this.randomStates.size() < 8) {
                this.randomStates.add(Float.valueOf(rand.nextFloat()));
            }
        }
        this.refreshAdjacentBlocks();
        this.notifyNeighborsToUpdate();
        Direction facing = this.getFacing();
        this.notifyDiagonalNeighbor(Direction.UP, facing.m_122427_());
        this.notifyDiagonalNeighbor(Direction.UP, facing.m_122428_());
        this.notifyDiagonalNeighbor(Direction.DOWN, facing.m_122427_());
        this.notifyDiagonalNeighbor(Direction.DOWN, facing.m_122428_());
    }

    private void notifyDiagonalNeighbor(Direction dir1, Direction dir2) {
        BlockPos diagonalPos = this.f_58858_.m_121945_(dir1).m_121945_(dir2);
        BlockEntity blockEntity = this.f_58857_.m_7702_(diagonalPos);
        if (blockEntity instanceof SchematicBoardBlockEntity) {
            SchematicBoardBlockEntity board = (SchematicBoardBlockEntity)blockEntity;
            board.refreshAdjacentBlocks();
        }
    }

    public BorderState getBorderState() {
        return this.borderState;
    }

    public List<Float> getRandomState() {
        return this.randomStates;
    }
}

