/*
 * Decompiled with CFR 0.152.
 */
package tech.muddykat.engineered_schematics.block.entity;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.client.IModelOffsetProvider;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlockEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.PlacementLimitation;
import blusunrize.immersiveengineering.common.blocks.wooden.DeskBlock;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import tech.muddykat.engineered_schematics.helper.IInteractionObjectES;
import tech.muddykat.engineered_schematics.registry.ESMenuTypes;
import tech.muddykat.engineered_schematics.registry.ESRegistry;

public class SchematicTableBlockEntity
extends IEBaseBlockEntity
implements IIEInventory,
IEBlockInterfaces.IStateBasedDirectional,
IEBlockInterfaces.IHasDummyBlocks,
IModelOffsetProvider,
IInteractionObjectES<SchematicTableBlockEntity> {
    public static final BlockPos MASTER_POS = BlockPos.f_121853_;
    public static final BlockPos DUMMY_POS = new BlockPos(1, 0, 0);
    private final NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)3, (Object)ItemStack.f_41583_);
    private AABB renderAABB;

    public SchematicTableBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ESRegistry.SCHEMATIC_TABLE_TYPE.get(), pos, state);
    }

    public void readCustomNBT(CompoundTag nbt, boolean descPacket) {
        ContainerHelper.m_18980_((CompoundTag)nbt, this.inventory);
    }

    public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
        ContainerHelper.m_18973_((CompoundTag)nbt, this.inventory);
    }

    public AABB getRenderAABB() {
        if (this.renderAABB == null) {
            this.renderAABB = new AABB((double)(this.m_58899_().m_123341_() - 1), (double)this.m_58899_().m_123342_(), (double)(this.m_58899_().m_123343_() - 1), (double)(this.m_58899_().m_123341_() + 2), (double)(this.m_58899_().m_123342_() + 2), (double)(this.m_58899_().m_123343_() + 2));
        }
        return this.renderAABB;
    }

    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    public boolean isStackValid(int slot, ItemStack stack) {
        return true;
    }

    public int getSlotLimit(int slot) {
        return slot == 0 ? 1 : 64;
    }

    public void doGraphicalUpdates() {
    }

    @NotNull
    public PlacementLimitation getFacingLimitation() {
        return PlacementLimitation.HORIZONTAL;
    }

    public boolean canHammerRotate(Direction side, Vec3 hit, LivingEntity entity) {
        return false;
    }

    public boolean isDummy() {
        return (Boolean)this.getState().m_61143_((Property)IEProperties.MULTIBLOCKSLAVE);
    }

    @Nullable
    public SchematicTableBlockEntity master() {
        if (!this.isDummy()) {
            return this;
        }
        if (this.tempMasterBE != null) {
            return (SchematicTableBlockEntity)this.tempMasterBE;
        }
        Direction dummyDir = this.isDummy() ? this.getFacing().m_122428_() : this.getFacing().m_122427_();
        BlockPos masterPos = this.m_58899_().m_121945_(dummyDir);
        BlockEntity te = Utils.getExistingTileEntity((Level)this.f_58857_, (BlockPos)masterPos);
        return te instanceof SchematicTableBlockEntity ? (SchematicTableBlockEntity)te : null;
    }

    public void placeDummies(BlockPlaceContext ctx, BlockState blockState) {
        DeskBlock.placeDummies((BlockState)this.m_58900_(), (Level)this.f_58857_, (BlockPos)this.f_58858_, (BlockPlaceContext)ctx);
    }

    public void breakDummies(BlockPos pos, BlockState state) {
        this.tempMasterBE = this.master();
        Direction dummyDir = this.isDummy() ? this.getFacing().m_122428_() : this.getFacing().m_122427_();
        this.f_58857_.m_7471_(pos.m_121945_(dummyDir), false);
        if (this.inventory != null && !this.inventory.isEmpty()) {
            for (ItemStack item : this.inventory) {
                Utils.dropStackAtPos((Level)this.f_58857_, (BlockPos)pos, (ItemStack)item);
            }
        }
    }

    @Override
    public SchematicTableBlockEntity getGuiMaster() {
        if (!this.isDummy()) {
            return this;
        }
        Direction dummyDir = this.getFacing().m_122428_();
        BlockEntity tileEntityModWorkbench = this.f_58857_.m_7702_(this.f_58858_.m_121945_(dummyDir));
        if (tileEntityModWorkbench instanceof SchematicTableBlockEntity) {
            return (SchematicTableBlockEntity)tileEntityModWorkbench;
        }
        return null;
    }

    @Override
    public ESMenuTypes.ArgContainer<? super SchematicTableBlockEntity, ?> getContainerType() {
        return ESMenuTypes.SCHEMATICS;
    }

    @Override
    public boolean canUseGui(Player var1) {
        return true;
    }

    @NotNull
    public Property<Direction> getFacingProperty() {
        return IEProperties.FACING_HORIZONTAL;
    }

    public BlockPos getModelOffset(BlockState blockState, Vec3i vec3i) {
        if (this.isDummy()) {
            return DUMMY_POS;
        }
        return MASTER_POS;
    }

    @Override
    public Component m_5446_() {
        return Component.m_237115_((String)"desc.engineered_schematics.schematic_table");
    }
}

