/*
 * Decompiled with CFR 0.152.
 */
package tech.muddykat.engineered_schematics.client.renderer;

import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;

public class BorderState {
    private boolean topEdge = true;
    private boolean rightEdge = true;
    private boolean bottomEdge = true;
    private boolean leftEdge = true;
    private boolean topRightCorner = true;
    private boolean bottomRightCorner = true;
    private boolean bottomLeftCorner = true;
    private boolean topLeftCorner = true;

    public boolean hasTopEdge() {
        return this.topEdge;
    }

    public boolean hasRightEdge() {
        return this.rightEdge;
    }

    public boolean hasBottomEdge() {
        return this.bottomEdge;
    }

    public boolean hasLeftEdge() {
        return this.leftEdge;
    }

    public boolean hasTopRightCorner() {
        return this.topRightCorner;
    }

    public boolean hasBottomRightCorner() {
        return this.bottomRightCorner;
    }

    public boolean hasBottomLeftCorner() {
        return this.bottomLeftCorner;
    }

    public boolean hasTopLeftCorner() {
        return this.topLeftCorner;
    }

    public void updateEdge(Direction dir, boolean visible, Direction facing) {
        if (dir == Direction.UP) {
            this.topEdge = visible;
        } else if (dir == Direction.DOWN) {
            this.bottomEdge = visible;
        } else if (dir == facing.m_122427_()) {
            this.rightEdge = visible;
        } else if (dir == facing.m_122428_()) {
            this.leftEdge = visible;
        }
    }

    public void updateCorners(Map<Direction, Boolean> adjacent, Map<BlockPos, Boolean> diagonalBlocks, Direction facing, BlockPos pos) {
        Object level = null;
        boolean hasDiagonalTopRight = diagonalBlocks.getOrDefault(pos.m_121945_(Direction.UP).m_121945_(facing.m_122427_()), false);
        this.topRightCorner = adjacent.getOrDefault(Direction.UP, false) == false || adjacent.getOrDefault(facing.m_122427_(), false) == false || !hasDiagonalTopRight;
        boolean hasDiagonalBottomRight = diagonalBlocks.getOrDefault(pos.m_121945_(Direction.DOWN).m_121945_(facing.m_122427_()), false);
        this.bottomRightCorner = adjacent.getOrDefault(Direction.DOWN, false) == false || adjacent.getOrDefault(facing.m_122427_(), false) == false || !hasDiagonalBottomRight;
        boolean hasDiagonalBottomLeft = diagonalBlocks.getOrDefault(pos.m_121945_(Direction.DOWN).m_121945_(facing.m_122428_()), false);
        this.bottomLeftCorner = adjacent.getOrDefault(Direction.DOWN, false) == false || adjacent.getOrDefault(facing.m_122428_(), false) == false || !hasDiagonalBottomLeft;
        boolean hasDiagonalTopLeft = diagonalBlocks.getOrDefault(pos.m_121945_(Direction.UP).m_121945_(facing.m_122428_()), false);
        this.topLeftCorner = adjacent.getOrDefault(Direction.UP, false) == false || adjacent.getOrDefault(facing.m_122428_(), false) == false || !hasDiagonalTopLeft;
    }

    public void updateFromNBT(CompoundTag nbt) {
        this.topEdge = nbt.m_128471_("topEdge");
        this.rightEdge = nbt.m_128471_("rightEdge");
        this.bottomEdge = nbt.m_128471_("bottomEdge");
        this.leftEdge = nbt.m_128471_("leftEdge");
        this.topRightCorner = nbt.m_128471_("topRightCorner");
        this.bottomRightCorner = nbt.m_128471_("bottomRightCorner");
        this.bottomLeftCorner = nbt.m_128471_("bottomLeftCorner");
        this.topLeftCorner = nbt.m_128471_("topLeftCorner");
    }

    public void writeToNBT(CompoundTag nbt) {
        nbt.m_128379_("topEdge", this.topEdge);
        nbt.m_128379_("rightEdge", this.rightEdge);
        nbt.m_128379_("bottomEdge", this.bottomEdge);
        nbt.m_128379_("leftEdge", this.leftEdge);
        nbt.m_128379_("topRightCorner", this.topRightCorner);
        nbt.m_128379_("bottomRightCorner", this.bottomRightCorner);
        nbt.m_128379_("bottomLeftCorner", this.bottomLeftCorner);
        nbt.m_128379_("topLeftCorner", this.topLeftCorner);
    }
}

