/*
 * Decompiled with CFR 0.152.
 */
package tech.muddykat.engineered_schematics.client.renderer;

import blusunrize.immersiveengineering.api.utils.DirectionUtils;
import blusunrize.immersiveengineering.client.utils.RenderUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.model.data.ModelData;
import org.joml.Quaternionf;
import tech.muddykat.engineered_schematics.block.entity.SchematicBoardBlockEntity;
import tech.muddykat.engineered_schematics.client.renderer.BorderState;
import tech.muddykat.engineered_schematics.client.renderer.ESDynamicModel;

public class CorkboardRenderer
implements BlockEntityRenderer<SchematicBoardBlockEntity> {
    private static final Map<String, BakedModel> modelCache = new HashMap<String, BakedModel>();
    public static ESDynamicModel FRAME_EDGE;
    public static ESDynamicModel CORNER;
    public static ESDynamicModel SCHEMATIC;
    private static final Map<Direction, Quaternionf> ROTATE_FOR_FACING;

    protected static void rotateForFacingNoCentering(PoseStack stack, Direction facing) {
        stack.m_252781_(ROTATE_FOR_FACING.get(facing));
    }

    protected static void rotateForFacing(PoseStack stack, Direction facing) {
        stack.m_85837_(0.5, 0.5, 0.5);
        CorkboardRenderer.rotateForFacingNoCentering(stack, facing);
        stack.m_85837_(-0.5, -0.5, -0.5);
    }

    private void renderCornerBL(PoseStack pose, MultiBufferSource mainBuffer, Level level, BlockPos pos, int pPackedLight, int pPackedOverlay) {
        pose.m_85836_();
        pose.m_252880_(0.0f, -0.9375f, 0.0f);
        this.renderDynamicModel(CORNER, pose, mainBuffer, Direction.NORTH, level, pos, pPackedLight, pPackedOverlay);
        pose.m_85849_();
    }

    private void renderCornerTL(PoseStack pose, MultiBufferSource mainBuffer, Level level, BlockPos pos, int pPackedLight, int pPackedOverlay) {
        pose.m_85836_();
        this.renderDynamicModel(CORNER, pose, mainBuffer, Direction.NORTH, level, pos, pPackedLight, pPackedOverlay);
        pose.m_85849_();
    }

    private void renderCornerTR(PoseStack pose, MultiBufferSource mainBuffer, Level level, BlockPos pos, int pPackedLight, int pPackedOverlay) {
        pose.m_85836_();
        pose.m_252880_(0.9375f, 0.0f, 0.0f);
        this.renderDynamicModel(CORNER, pose, mainBuffer, Direction.NORTH, level, pos, pPackedLight, pPackedOverlay);
        pose.m_85849_();
    }

    private void renderCornerBR(PoseStack pose, MultiBufferSource mainBuffer, Level level, BlockPos pos, int pPackedLight, int pPackedOverlay) {
        pose.m_85836_();
        pose.m_252880_(0.9375f, -0.9375f, 0.0f);
        this.renderDynamicModel(CORNER, pose, mainBuffer, Direction.NORTH, level, pos, pPackedLight, pPackedOverlay);
        pose.m_85849_();
    }

    public void render(SchematicBoardBlockEntity tile, float pPartialTick, PoseStack pose, MultiBufferSource mainBuffer, int pPackedLight, int pPackedOverlay) {
        NonNullList<ItemStack> inventory = tile.getInventory();
        Level level = tile.m_58904_();
        BlockPos pos = tile.m_58899_();
        BorderState borderState = tile.getBorderState();
        List<Float> randomState = tile.getRandomState();
        CorkboardRenderer.rotateForFacing(pose, tile.getFacing());
        pose.m_85836_();
        if (borderState.hasLeftEdge()) {
            pose.m_85836_();
            this.renderDynamicModel(FRAME_EDGE, pose, mainBuffer, Direction.NORTH, level, pos, pPackedLight, pPackedOverlay);
            pose.m_85849_();
        }
        if (borderState.hasRightEdge()) {
            pose.m_85836_();
            pose.m_252880_(0.9375f, 0.0f, 0.0f);
            this.renderDynamicModel(FRAME_EDGE, pose, mainBuffer, Direction.NORTH, level, pos, pPackedLight, pPackedOverlay);
            pose.m_85849_();
        }
        if (borderState.hasBottomLeftCorner()) {
            this.renderCornerBL(pose, mainBuffer, level, pos, pPackedLight, pPackedOverlay);
        }
        if (borderState.hasTopLeftCorner()) {
            this.renderCornerTL(pose, mainBuffer, level, pos, pPackedLight, pPackedOverlay);
        }
        if (borderState.hasBottomRightCorner()) {
            this.renderCornerBR(pose, mainBuffer, level, pos, pPackedLight, pPackedOverlay);
        }
        if (borderState.hasTopRightCorner()) {
            this.renderCornerTR(pose, mainBuffer, level, pos, pPackedLight, pPackedOverlay);
        }
        if (borderState.hasBottomEdge()) {
            pose.m_85836_();
            pose.m_85837_(0.0, 0.0625, 0.0);
            pose.m_252781_(new Quaternionf().rotateZ((float)Math.PI / 180 * (180.0f - Direction.UP.m_122435_())));
            this.renderDynamicModel(FRAME_EDGE, pose, mainBuffer, Direction.NORTH, level, pos, pPackedLight, pPackedOverlay);
            pose.m_85849_();
        }
        if (borderState.hasTopEdge()) {
            pose.m_85836_();
            pose.m_252781_(new Quaternionf().rotateZ((float)Math.PI / 180 * (180.0f - Direction.UP.m_122435_())));
            pose.m_252880_(-1.0f, 0.0f, 0.0f);
            this.renderDynamicModel(FRAME_EDGE, pose, mainBuffer, Direction.NORTH, level, pos, pPackedLight, pPackedOverlay);
            pose.m_85849_();
        }
        pose.m_85849_();
        assert (inventory != null);
        if (!inventory.isEmpty()) {
            pose.m_85837_(0.09375, -0.125, 0.15);
            float xPos = 0.0f;
            float yPos = 0.0f;
            int invSize = inventory.size();
            for (int i = 0; i < invSize; ++i) {
                ItemStack item = (ItemStack)inventory.get(i);
                if (item.m_41619_()) continue;
                float r = -1.0f + randomState.get(i).floatValue() * 2.0f;
                float randomOffsetX = -1.0f + randomState.get(i).floatValue() * 2.0f;
                float randomOffsetY = -1.0f + randomState.get(4 + i).floatValue() * 2.0f;
                if (borderState.hasRightEdge()) {
                    randomOffsetX -= 0.5f;
                }
                if (borderState.hasLeftEdge()) {
                    randomOffsetX += 0.5f;
                }
                if (borderState.hasTopEdge()) {
                    randomOffsetY -= 0.5f;
                }
                if (borderState.hasBottomEdge()) {
                    randomOffsetY += 0.5f;
                }
                xPos = i % 2;
                float f = yPos = i < 2 ? 1.0f : 0.0f;
                if (!borderState.hasRightEdge() && !borderState.hasLeftEdge()) {
                    if (xPos == 0.0f) {
                        randomOffsetX -= 0.6f;
                    }
                    if (xPos == 1.0f) {
                        randomOffsetX += 0.6f;
                    }
                }
                if (!borderState.hasTopEdge() && !borderState.hasBottomEdge()) {
                    if (yPos == 0.0f) {
                        randomOffsetY -= 0.6f;
                    }
                    if (yPos == 1.0f) {
                        randomOffsetY += 0.6f;
                    }
                }
                pose.m_85836_();
                pose.m_85837_((double)xPos * 0.375, (double)(yPos * 0.5f), (double)((float)(-i) * 0.0025f));
                pose.m_85836_();
                pose.m_252880_(0.06f * randomOffsetX, 0.04f * randomOffsetY, 0.0f);
                pose.m_252781_(new Quaternionf().rotateX(-(2.0f * r) * ((float)Math.PI / 180)));
                pose.m_252781_(new Quaternionf().rotateZ(-(6.0f * r) * ((float)Math.PI / 180)));
                pose.m_85836_();
                float s = 1.0f + r * 0.05f;
                pose.m_85841_(s, s, s);
                this.renderDynamicModel(SCHEMATIC, pose, mainBuffer, Direction.NORTH, level, pos, pPackedLight, pPackedOverlay);
                pose.m_85849_();
                pose.m_85849_();
                pose.m_85849_();
            }
        }
    }

    private void renderDynamicModel(ESDynamicModel model, PoseStack matrix, MultiBufferSource buffer, Direction facing, Level level, BlockPos pos, int light, int overlay) {
        matrix.m_85836_();
        List<BakedQuad> quads = model.getNullQuads(ModelData.EMPTY);
        RenderUtils.renderModelTESRFancy(quads, (VertexConsumer)buffer.m_6299_(RenderType.m_110457_()), (PoseStack)matrix, (Level)level, (BlockPos)pos, (boolean)false, (int)0xF0F0F0, (int)light);
        matrix.m_85849_();
    }

    static {
        ROTATE_FOR_FACING = (Map)Util.m_137469_(new EnumMap(Direction.class), m -> {
            for (Direction facing : DirectionUtils.BY_HORIZONTAL_INDEX) {
                m.put(facing, new Quaternionf().rotateY((float)Math.PI / 180 * (180.0f - facing.m_122435_())));
            }
        });
    }
}

