/*
 * Decompiled with CFR 0.152.
 */
package tech.muddykat.engineered_schematics.event;

import com.mojang.datafixers.util.Pair;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import tech.muddykat.engineered_schematics.EngineeredSchematics;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class IMCReceiver {
    private static final String TEMPLATE_KEY = "formation_item";

    @SubscribeEvent
    public static void processIMC(InterModProcessEvent event) {
        InterModComms.getMessages((String)"engineered_schematics").forEach(message -> {
            if (TEMPLATE_KEY.equals(message.method())) {
                Object receivedMessage = message.messageSupplier().get();
                if (receivedMessage instanceof Pair) {
                    Pair pair = (Pair)receivedMessage;
                    if (pair.getFirst() instanceof ResourceLocation && pair.getSecond() instanceof ItemStack) {
                        Pair multiblock_name = pair;
                        EngineeredSchematics.setTemplateFormationItem((ResourceLocation)multiblock_name.getFirst(), (ItemStack)multiblock_name.getSecond());
                        EngineeredSchematics.LOGGER.info("Received IMC formation item: {}", multiblock_name.getFirst());
                    } else {
                        EngineeredSchematics.LOGGER.warn("Received IMC message with incorrect types: {}", (Object)pair);
                    }
                } else {
                    EngineeredSchematics.LOGGER.warn("Received IMC message is not a valid Pair: {}", receivedMessage);
                }
            }
        });
    }
}

