/*
 * Decompiled with CFR 0.152.
 */
package tech.muddykat.engineered_schematics.helper;

import blusunrize.immersiveengineering.api.multiblocks.MultiblockHandler;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockBE;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.data.ModelData;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableInt;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import tech.muddykat.engineered_schematics.client.ESShaders;
import tech.muddykat.engineered_schematics.item.ESSchematicSettings;
import tech.muddykat.engineered_schematics.item.SchematicProjection;
import tech.muddykat.engineered_schematics.registry.ESRenderTypes;

public class SchematicRenderer {
    private static final int COLOR_ERROR = 0xFF0000;
    private static final int COLOR_WARNING = 0xFFFF00;
    private static final int COLOR_SUCCESS = 48896;
    private static final int COLOR_HIGHLIGHT = 0x44FF44;
    private static final float[] COLOR_HELD = new float[]{0.2f, 1.0f, 0.5f};
    private static final float[] COLOR_NORMAL = new float[]{0.2f, 0.5f, 1.0f};
    static final BlockPos.MutableBlockPos FULL_MAX = new BlockPos.MutableBlockPos(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
    private static final Tesselator PHANTOM_TESSELATOR = new Tesselator();

    public static void renderSchematic(PoseStack matrix, ESSchematicSettings settings, Player player, Level world) {
        if (settings.getMultiblock() == null) {
            return;
        }
        assert (settings.getPos() != null);
        BlockPos.MutableBlockPos hit = SchematicRenderer.initializePosition(settings);
        if (hit.equals((Object)FULL_MAX)) {
            return;
        }
        SchematicProjection projection = SchematicRenderer.setupProjection(world, settings);
        Vec3i mbSize = settings.getMultiblock().getSize(world);
        HashMap<BlockPos, Boolean> badStates = new HashMap<BlockPos, Boolean>(mbSize.m_123341_() * mbSize.m_123342_() * mbSize.m_123343_());
        ArrayList<Pair<RenderLayer, SchematicProjection.Info>> toRender = new ArrayList<Pair<RenderLayer, SchematicProjection.Info>>(projection.getBlockCount());
        RenderingState renderState = SchematicRenderer.processBlocks(projection, world, (BlockPos)hit, badStates, toRender);
        for (Pair pair : toRender) {
            SchematicProjection.Info info = (SchematicProjection.Info)pair.getSecond();
            BlockEntity be = world.m_7702_(info.tPos.m_121955_((Vec3i)settings.getPos()));
            if (!(be instanceof IMultiblockBE)) continue;
            SchematicRenderer.renderSchematicGrid(matrix, settings, 39168, world);
            return;
        }
        MultiBufferSource.BufferSource mainBuffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        SchematicRenderer.renderResults(matrix, renderState, settings, mainBuffer, world, player, mbSize, badStates, toRender);
        mainBuffer.m_109911_();
    }

    private static BlockPos.MutableBlockPos initializePosition(ESSchematicSettings settings) {
        BlockPos.MutableBlockPos hit = new BlockPos.MutableBlockPos(FULL_MAX.m_123341_(), FULL_MAX.m_123342_(), FULL_MAX.m_123343_());
        if (settings.getPos() != null) {
            hit.m_122190_((Vec3i)settings.getPos());
        }
        return hit;
    }

    private static SchematicProjection setupProjection(Level world, ESSchematicSettings settings) {
        SchematicProjection projection = new SchematicProjection(world, settings.getMultiblock());
        projection.setRotation(settings.getRotation());
        projection.setFlip(settings.isMirrored());
        return projection;
    }

    private static RenderingState processBlocks(SchematicProjection projection, Level world, BlockPos hit, Map<BlockPos, Boolean> badStates, List<Pair<RenderLayer, SchematicProjection.Info>> toRender) {
        MutableInt currentLayer = new MutableInt();
        MutableInt badBlocks = new MutableInt();
        MutableInt goodBlocks = new MutableInt();
        AtomicInteger imperfectionLayer = new AtomicInteger(-1);
        projection.processAll((layer, info) -> SchematicRenderer.processBlock(layer, info, world, hit, badStates, toRender, currentLayer, badBlocks, goodBlocks, imperfectionLayer));
        return new RenderingState(goodBlocks.getValue().intValue() == projection.getBlockCount(), imperfectionLayer.get() != -1, badStates.containsValue(false), currentLayer.getValue());
    }

    private static boolean processBlock(int layer, SchematicProjection.Info info, Level world, BlockPos hit, Map<BlockPos, Boolean> badStates, List<Pair<RenderLayer, SchematicProjection.Info>> toRender, MutableInt currentLayer, MutableInt badBlocks, MutableInt goodBlocks, AtomicInteger imperfectionLayer) {
        if (badBlocks.getValue() == 0 && layer > currentLayer.getValue()) {
            currentLayer.setValue(layer);
        } else if (layer != currentLayer.getValue()) {
            return true;
        }
        if (hit != FULL_MAX && layer == currentLayer.getValue()) {
            BlockPos realPos = info.tPos.m_121955_((Vec3i)hit);
            BlockState currentState = world.m_8055_(realPos);
            BlockState targetState = info.getModifiedState(world, realPos);
            if (targetState == currentState) {
                toRender.add((Pair<RenderLayer, SchematicProjection.Info>)Pair.of((Object)((Object)RenderLayer.PERFECT), (Object)info));
                goodBlocks.increment();
                return false;
            }
            if (!currentState.m_60795_()) {
                toRender.add((Pair<RenderLayer, SchematicProjection.Info>)Pair.of((Object)((Object)RenderLayer.BAD), (Object)info));
                boolean isSameBlockType = targetState.m_60734_().m_49966_().equals(currentState.m_60734_().m_49966_());
                badStates.put(info.tPos, isSameBlockType);
                imperfectionLayer.set(layer);
                return false;
            }
            badBlocks.increment();
        }
        toRender.add((Pair<RenderLayer, SchematicProjection.Info>)Pair.of((Object)((Object)RenderLayer.ALL), (Object)info));
        return false;
    }

    private static void renderResults(PoseStack matrix, RenderingState state, ESSchematicSettings settings, MultiBufferSource.BufferSource mainBuffer, Level world, Player player, Vec3i mbSize, Map<BlockPos, Boolean> badStates, List<Pair<RenderLayer, SchematicProjection.Info>> toRender) {
        matrix.m_85836_();
        toRender.sort(Comparator.comparingInt(a -> ((RenderLayer)((Object)((Object)a.getFirst()))).ordinal()));
        matrix.m_252880_((float)settings.getPos().m_123341_(), (float)settings.getPos().m_123342_(), (float)settings.getPos().m_123343_());
        BlockPos.MutableBlockPos min = new BlockPos.MutableBlockPos(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
        BlockPos.MutableBlockPos max = new BlockPos.MutableBlockPos(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
        ItemStack heldStack = player.m_21205_();
        int gridLayer = state.currentLayer();
        for (Pair<RenderLayer, SchematicProjection.Info> pair : toRender) {
            SchematicProjection.Info info = (SchematicProjection.Info)pair.getSecond();
            boolean isHeld = heldStack.m_41720_() == info.getRawState().m_60734_().m_5456_();
            switch ((RenderLayer)((Object)pair.getFirst())) {
                case ALL: {
                    SchematicRenderer.renderAllLayer(matrix, world, info, isHeld, state.hasWrongBlock(), mainBuffer);
                    break;
                }
                case BAD: {
                    SchematicRenderer.renderBadLayer(matrix, mainBuffer, info, badStates);
                    break;
                }
                case PERFECT: {
                    SchematicRenderer.updatePerfectBounds(min, max, info);
                }
            }
        }
        for (BlockPos badBlocks : badStates.keySet()) {
            gridLayer = Math.min(gridLayer, badBlocks.m_123342_());
        }
        if (!state.perfect()) {
            matrix.m_85836_();
            SchematicRenderer.renderGridForRotation(matrix, mainBuffer, settings, mbSize, state, gridLayer);
            matrix.m_85849_();
        }
        matrix.m_85849_();
        if (state.perfect()) {
            assert (settings.getMultiblock() != null);
            BlockPos pos = settings.getPos();
            matrix.m_85836_();
            BlockPos offset = new BlockPos(-Mth.m_14042_((int)mbSize.m_123341_(), (int)2), 0, -Mth.m_14042_((int)mbSize.m_123343_(), (int)2));
            matrix.m_252880_((float)pos.m_123341_(), (float)pos.m_123342_(), (float)pos.m_123343_());
            SchematicRenderer.renderOutlineBox((MultiBufferSource)mainBuffer, matrix, (Vec3i)min, (Vec3i)max, 48896);
            matrix.m_85836_();
            matrix.m_252880_((float)offset.m_123341_(), (float)offset.m_123342_(), (float)offset.m_123343_());
            SchematicRenderer.drawFrontGroundText(matrix, new Vec3((double)mbSize.m_123341_(), 0.0, (double)mbSize.m_123343_()), (MultiBufferSource)mainBuffer, settings.getRotation(), settings.getMultiblock(), 0x66FFFFFF, (Component)Component.m_237115_((String)"item.engineered_schematics.multiblock_schematic.formed"));
            matrix.m_85849_();
            matrix.m_85849_();
            Rotation rotation = settings.getRotation();
            BlockPos trigger = settings.getMultiblock().getTriggerOffset().m_7954_(rotation);
            matrix.m_85836_();
            BlockPos off = new BlockPos(0, 0, 1).m_7954_(rotation);
            float offA = 0.55f;
            matrix.m_252880_((float)pos.m_123341_() + (float)off.m_123341_() * offA, (float)pos.m_123342_() + (float)off.m_123342_() * offA, (float)pos.m_123343_() + (float)off.m_123343_() * offA);
            BlockPos offset2 = new BlockPos(-Mth.m_14042_((int)mbSize.m_123341_(), (int)2), 0, -Mth.m_14042_((int)mbSize.m_123343_(), (int)2)).m_7954_(rotation);
            matrix.m_252880_((float)offset2.m_123341_(), (float)offset2.m_123342_(), (float)offset2.m_123343_());
            matrix.m_85836_();
            if (rotation.equals((Object)Rotation.CLOCKWISE_90)) {
                matrix.m_252880_(0.0f, 0.0f, 1.0f);
            }
            if (rotation.equals((Object)Rotation.COUNTERCLOCKWISE_90)) {
                matrix.m_252880_(1.0f, 0.0f, 0.0f);
            }
            if (rotation.equals((Object)Rotation.CLOCKWISE_180)) {
                matrix.m_252880_(1.0f, 0.0f, 1.0f);
            }
            matrix.m_252880_((float)trigger.m_123341_(), (float)trigger.m_123342_(), (float)trigger.m_123343_());
            matrix.m_252781_(new Quaternionf().rotateY((float)(90 * rotation.ordinal()) * ((float)Math.PI / 180)));
            ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
            ItemStack hammerStack = settings.getFormationTool();
            BakedModel itemModel = itemRenderer.m_174264_(hammerStack, world, null, 0);
            int hammer = 0xAA0000;
            float red = (float)(hammer >> 16 & 0xFF) / 255.0f;
            float green = (float)(hammer >> 8 & 0xFF) / 255.0f;
            float blue = (float)(hammer & 0xFF) / 255.0f;
            ESShaders.setSchematicRenderData(world.m_46467_(), red, green, blue);
            MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
            VertexConsumer vertexConsumer = buffer.m_6299_(ESRenderTypes.SCHEMATIC);
            itemRenderer.m_115189_(itemModel, hammerStack, 0xF000F0, OverlayTexture.f_118083_, matrix, vertexConsumer);
            matrix.m_85849_();
            matrix.m_85849_();
        }
    }

    private static void renderGridForRotation(PoseStack matrix, MultiBufferSource.BufferSource buffer, ESSchematicSettings settings, Vec3i mbSize, RenderingState state, int y) {
        Rotation rotation = settings.getRotation();
        assert (settings.getMultiblock() != null);
        boolean isHorizontalRotation = rotation == Rotation.NONE || rotation == Rotation.CLOCKWISE_180;
        int width = isHorizontalRotation ? mbSize.m_123341_() : mbSize.m_123343_();
        int depth = isHorizontalRotation ? mbSize.m_123343_() : mbSize.m_123341_();
        matrix.m_85836_();
        matrix.m_252880_((float)(-Math.floorDiv(width, 2)), (float)(-mbSize.m_123342_()), (float)(-Math.floorDiv(depth, 2)));
        matrix.m_252880_(0.0f, (float)y, 0.0f);
        int highlightColor = state.hasImperfection() ? (state.hasWrongBlock() ? 0xFF0000 : 0xFFFF00) : 0xFFFFFF;
        Vec3 origin = Vec3.f_82478_;
        Vec3 normal = new Vec3((double)width, (double)mbSize.m_123342_(), (double)depth);
        Component name = state.hasImperfection() ? (state.hasWrongBlock() ? Component.m_237115_((String)"item.engineered_schematics.multiblock_schematic.error") : settings.getMultiblock().getDisplayName()) : settings.getMultiblock().getDisplayName();
        SchematicRenderer.renderGrid((MultiBufferSource)buffer, matrix, origin, normal, 16.0f, 1.0f, highlightColor, y, name, settings);
        matrix.m_85849_();
    }

    private static void renderAllLayer(PoseStack matrix, Level world, SchematicProjection.Info info, boolean isHeld, boolean hasWrongBlock, MultiBufferSource.BufferSource buffer) {
        if (hasWrongBlock) {
            return;
        }
        matrix.m_85836_();
        SchematicRenderer.renderPhantom(matrix, world, info, isHeld ? COLOR_HELD : COLOR_NORMAL, 0.0f);
        if (isHeld) {
            SchematicRenderer.renderCenteredOutlineBox((MultiBufferSource)buffer, matrix, 0x44FF44);
        }
        matrix.m_85849_();
    }

    private static void renderBadLayer(PoseStack matrix, MultiBufferSource.BufferSource buffer, SchematicProjection.Info info, Map<BlockPos, Boolean> badStates) {
        matrix.m_85836_();
        matrix.m_252880_((float)info.tPos.m_123341_(), (float)info.tPos.m_123342_(), (float)info.tPos.m_123343_());
        SchematicRenderer.renderCenteredOutlineBox((MultiBufferSource)buffer, matrix, badStates.get(info.tPos) != false ? 0xFFFF00 : 0xFF0000);
        matrix.m_85849_();
    }

    private static void updatePerfectBounds(BlockPos.MutableBlockPos min, BlockPos.MutableBlockPos max, SchematicProjection.Info info) {
        min.m_122178_(Math.min(info.tPos.m_123341_(), min.m_123341_()), Math.min(info.tPos.m_123342_(), min.m_123342_()), Math.min(info.tPos.m_123343_(), min.m_123343_()));
        max.m_122178_(Math.max(info.tPos.m_123341_(), max.m_123341_()), Math.max(info.tPos.m_123342_(), max.m_123342_()), Math.max(info.tPos.m_123343_(), max.m_123343_()));
    }

    public static void renderPhantom(PoseStack matrix, Level realWorld, SchematicProjection.Info rInfo, float[] color, float partialTicks) {
        BlockRenderDispatcher dispatcher = Minecraft.m_91087_().m_91289_();
        ModelBlockRenderer blockRenderer = dispatcher.m_110937_();
        BlockColors blockColors = Minecraft.m_91087_().m_91298_();
        matrix.m_252880_((float)rInfo.tPos.m_123341_(), (float)rInfo.tPos.m_123342_(), (float)rInfo.tPos.m_123343_());
        MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)PHANTOM_TESSELATOR.m_85915_());
        BlockState state = rInfo.getModifiedState(realWorld, rInfo.tPos);
        state.m_60701_((LevelAccessor)realWorld, rInfo.tPos, 3);
        ModelData modelData = ModelData.EMPTY;
        BlockEntity te = rInfo.templateWorld.m_7702_(rInfo.tBlockInfo.f_74675_());
        if (te != null) {
            te.m_155250_(state);
            modelData = te.getModelData();
        }
        RenderShape blockrendertype = state.m_60799_();
        switch (blockrendertype) {
            case MODEL: {
                BakedModel ibakedmodel = dispatcher.m_110910_(state);
                int i = blockColors.m_92577_(state, null, null, 0);
                float red = (float)(i >> 16 & 0xFF) / 255.0f;
                float green = (float)(i >> 8 & 0xFF) / 255.0f;
                float blue = (float)(i & 0xFF) / 255.0f;
                modelData = ibakedmodel.getModelData((BlockAndTintGetter)rInfo.templateWorld, rInfo.tBlockInfo.f_74675_(), state, modelData);
                ESShaders.setSchematicRenderData(0.0f, color[0], color[1], color[2]);
                VertexConsumer vc = buffer.m_6299_(ESRenderTypes.SCHEMATIC);
                matrix.m_85841_(0.5f, 0.5f, 0.5f);
                matrix.m_252880_(0.5f, 0.5f, 0.5f);
                blockRenderer.renderModel(matrix.m_85850_(), vc, state, ibakedmodel, red, green, blue, 0xF000F0, OverlayTexture.f_118083_, modelData, null);
                matrix.m_252880_(-0.5f, -0.5f, -0.5f);
                matrix.m_85841_(2.0f, 2.0f, 2.0f);
                break;
            }
            case ENTITYBLOCK_ANIMATED: {
                ItemStack stack = new ItemStack((ItemLike)state.m_60734_());
                matrix.m_85841_(0.5f, 0.5f, 0.5f);
                matrix.m_252880_(0.5f, 0.5f, 0.5f);
                Minecraft.m_91087_().m_91291_().m_269128_(stack, ItemDisplayContext.NONE, 0xF000F0, OverlayTexture.f_118083_, matrix, (MultiBufferSource)buffer, null, 0);
                matrix.m_252880_(-0.5f, -0.5f, -0.5f);
                matrix.m_85841_(2.0f, 2.0f, 2.0f);
                break;
            }
        }
        buffer.m_109911_();
    }

    public static void renderCenteredOutlineBox(MultiBufferSource buffer, PoseStack matrix, int rgb) {
        SchematicRenderer.renderBox(buffer, matrix, Vec3.f_82478_, new Vec3(1.0, 1.0, 1.0), rgb);
    }

    public static void renderOutlineBox(MultiBufferSource buffer, PoseStack matrix, Vec3i min, Vec3i max, int rgb) {
        SchematicRenderer.renderBox(buffer, matrix, Vec3.m_82528_((Vec3i)min), Vec3.m_82528_((Vec3i)max).m_82520_(1.0, 1.0, 1.0), rgb);
    }

    public static void renderGrid(MultiBufferSource buffer, PoseStack matrix, Vec3 origin, Vec3 normal, float gridSize, float stepSize, int rgb, int currentLayer, Component name, ESSchematicSettings settings) {
        int rgba;
        VertexConsumer builder = buffer.m_6299_((RenderType)RenderType.f_110371_);
        Rotation rotation = settings.getRotation();
        MultiblockHandler.IMultiblock multiblock = settings.getMultiblock();
        assert (multiblock != null);
        float alpha = 0.3f;
        int color = rgba = rgb | (int)(alpha * 255.0f) << 24;
        int guideColor = 65280;
        Vec3 max = origin.m_82549_(normal);
        matrix.m_85836_();
        boolean isDebug = Minecraft.m_91087_().f_91066_.f_92063_;
        float a = 0.0f;
        while ((double)a <= normal.f_82481_) {
            rgba = color;
            if ((a == 0.0f || (double)a == normal.f_82481_) && isDebug) {
                if (rotation.equals((Object)Rotation.NONE) && a == 0.0f) {
                    rgba = 0x66FF0000;
                }
                if (rotation.equals((Object)Rotation.CLOCKWISE_180) && a != 0.0f) {
                    rgba = 0x66FF0000;
                }
                if (rotation.equals((Object)Rotation.CLOCKWISE_90) && a == 0.0f) {
                    rgba = 0x660000FF;
                }
                if (rotation.equals((Object)Rotation.COUNTERCLOCKWISE_90) && a != 0.0f) {
                    rgba = 0x660000FF;
                }
            }
            matrix.m_252880_(0.0f, 0.0f, a);
            SchematicRenderer.line(builder, matrix, origin, max, 2, 6, rgba);
            matrix.m_252880_(0.0f, 0.0f, -a);
            a += stepSize;
        }
        a = 0.0f;
        while ((double)a <= normal.f_82479_) {
            rgba = color;
            if ((a == 0.0f || (double)a == normal.f_82479_) && isDebug) {
                if (rotation.equals((Object)Rotation.NONE) && a == 0.0f) {
                    rgba = 0x660000FF;
                }
                if (rotation.equals((Object)Rotation.CLOCKWISE_90) && a != 0.0f) {
                    rgba = 0x66FF0000;
                }
                if (rotation.equals((Object)Rotation.COUNTERCLOCKWISE_90) && a == 0.0f) {
                    rgba = 0x66FF0000;
                }
                if (rotation.equals((Object)Rotation.CLOCKWISE_180) && a != 0.0f) {
                    rgba = 0x660000FF;
                }
            }
            matrix.m_252880_(a, 0.0f, 0.0f);
            SchematicRenderer.line(builder, matrix, origin, max, 2, 3, rgba);
            matrix.m_252880_(-a, 0.0f, 0.0f);
            a += stepSize;
        }
        if (isDebug) {
            matrix.m_85836_();
            matrix.m_85837_(0.0, normal.f_82480_, 0.0);
            guideColor |= 0x66000000;
            if (rotation.equals((Object)Rotation.NONE)) {
                SchematicRenderer.line(builder, matrix, origin, max, 2, 0, guideColor);
            }
            if (rotation.equals((Object)Rotation.CLOCKWISE_90)) {
                SchematicRenderer.line(builder, matrix, origin, max, 6, 4, guideColor);
            }
            if (rotation.equals((Object)Rotation.COUNTERCLOCKWISE_90)) {
                SchematicRenderer.line(builder, matrix, origin, max, 3, 1, guideColor);
            }
            if (rotation.equals((Object)Rotation.CLOCKWISE_180)) {
                SchematicRenderer.line(builder, matrix, origin, max, 7, 5, guideColor);
            }
            matrix.m_85849_();
        }
        matrix.m_85849_();
        SchematicRenderer.drawFrontGroundText(matrix, max.m_82492_(0.0, (double)currentLayer, 0.0), buffer, rotation, multiblock, color, name);
    }

    public static void drawFrontGroundText(PoseStack matrix, Vec3 mbSize, MultiBufferSource buffer, Rotation rotation, MultiblockHandler.IMultiblock multiblock, int color, Component text) {
        matrix.m_85837_(0.0, mbSize.f_82480_, 0.0);
        matrix.m_85836_();
        Font font = Minecraft.m_91087_().f_91062_;
        matrix.m_252880_(0.0f, 0.0125f, 0.0f);
        if (rotation.equals((Object)Rotation.NONE)) {
            matrix.m_85837_(0.0, 0.0, mbSize.m_7094_() + 0.125);
        }
        if (rotation.equals((Object)Rotation.CLOCKWISE_90)) {
            matrix.m_252880_(-0.125f, 0.0f, 0.0f);
        }
        if (rotation.equals((Object)Rotation.COUNTERCLOCKWISE_90)) {
            matrix.m_85837_(mbSize.m_7096_() + 0.125, 0.0, mbSize.m_7094_());
        }
        if (rotation.equals((Object)Rotation.CLOCKWISE_180)) {
            matrix.m_85837_(mbSize.m_7096_(), 0.0, -0.125);
        }
        matrix.m_252781_(new Quaternionf().rotateAxis(1.5707964f, 1.0f, 0.0f, 0.0f));
        matrix.m_252781_(new Quaternionf().rotateAxis((float)(90 * rotation.ordinal()) * ((float)Math.PI / 180), 0.0f, 0.0f, 1.0f));
        matrix.m_85841_(0.1f, 0.1f, 0.1f);
        float s = (float)(mbSize.f_82479_ / (double)text.getString().length());
        matrix.m_85841_(s, s, s);
        font.m_272077_(text, 0.0f, 0.0f, color, false, matrix.m_85850_().m_252922_(), buffer, Font.DisplayMode.NORMAL, 0xF000F0, 0xF000F0);
        matrix.m_85849_();
    }

    public static void renderSchematicGrid(PoseStack matrix, ESSchematicSettings settings, int color, Level world) {
        if (settings.getMultiblock() == null) {
            return;
        }
        BlockPos.MutableBlockPos hit = new BlockPos.MutableBlockPos(FULL_MAX.m_123341_(), FULL_MAX.m_123342_(), FULL_MAX.m_123343_());
        MutableBoolean isPlaced = new MutableBoolean(false);
        if (settings.getPos() != null) {
            hit.m_122190_((Vec3i)settings.getPos());
            isPlaced.setTrue();
        }
        if (!hit.equals((Object)FULL_MAX)) {
            SchematicProjection projection = new SchematicProjection(world, settings.getMultiblock());
            Rotation rotation = settings.getRotation();
            projection.setRotation(rotation);
            projection.setFlip(settings.isMirrored());
            Vec3i mb_size = settings.getMultiblock().getSize(world);
            matrix.m_252880_((float)hit.m_123341_(), (float)hit.m_123342_(), (float)hit.m_123343_());
            Component name = settings.getMultiblock().getDisplayName();
            MultiBufferSource.BufferSource mainBuffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
            matrix.m_85836_();
            if (settings.getRotation().equals((Object)Rotation.CLOCKWISE_180) || settings.getRotation().equals((Object)Rotation.NONE)) {
                matrix.m_252880_((float)(-Math.floorDiv(mb_size.m_123341_(), 2)), (float)(-mb_size.m_123342_()), (float)(-Math.floorDiv(mb_size.m_123343_(), 2)));
                SchematicRenderer.renderGrid((MultiBufferSource)mainBuffer, matrix, Vec3.f_82478_, new Vec3((double)mb_size.m_123341_(), (double)mb_size.m_123342_(), (double)mb_size.m_123343_()), 16.0f, 1.0f, color, 0, name, settings);
            } else {
                matrix.m_252880_((float)(-Math.floorDiv(mb_size.m_123343_(), 2)), (float)(-mb_size.m_123342_()), (float)(-Math.floorDiv(mb_size.m_123341_(), 2)));
                SchematicRenderer.renderGrid((MultiBufferSource)mainBuffer, matrix, Vec3.f_82478_, new Vec3((double)mb_size.m_123343_(), (double)mb_size.m_123342_(), (double)mb_size.m_123341_()), 16.0f, 1.0f, color, 0, name, settings);
            }
            matrix.m_85849_();
            mainBuffer.m_109911_();
        }
    }

    private static void renderBox(MultiBufferSource buffer, PoseStack matrix, Vec3 min, Vec3 max, int rgb) {
        VertexConsumer builder = buffer.m_6299_((RenderType)RenderType.f_110371_);
        float alpha = 0.3f;
        int rgba = rgb | (int)(alpha * 255.0f) << 24;
        SchematicRenderer.line(builder, matrix, min, max, 2, 6, rgba);
        SchematicRenderer.line(builder, matrix, min, max, 6, 7, rgba);
        SchematicRenderer.line(builder, matrix, min, max, 7, 3, rgba);
        SchematicRenderer.line(builder, matrix, min, max, 3, 2, rgba);
        SchematicRenderer.line(builder, matrix, min, max, 2, 0, rgba);
        SchematicRenderer.line(builder, matrix, min, max, 6, 4, rgba);
        SchematicRenderer.line(builder, matrix, min, max, 3, 1, rgba);
        SchematicRenderer.line(builder, matrix, min, max, 7, 5, rgba);
        SchematicRenderer.line(builder, matrix, min, max, 0, 4, rgba);
        SchematicRenderer.line(builder, matrix, min, max, 4, 5, rgba);
        SchematicRenderer.line(builder, matrix, min, max, 5, 1, rgba);
        SchematicRenderer.line(builder, matrix, min, max, 1, 0, rgba);
    }

    private static void line(VertexConsumer out, PoseStack mat, Vec3 min, Vec3 max, int startBits, int endBits, int rgba) {
        Vector3f start = SchematicRenderer.combine(min, max, startBits);
        Vector3f end = SchematicRenderer.combine(min, max, endBits);
        Vector3f delta = new Vector3f((Vector3fc)end);
        delta.sub((Vector3fc)start);
        out.m_252986_(mat.m_85850_().m_252922_(), start.x(), start.y(), start.z()).m_193479_(rgba).m_252939_(mat.m_85850_().m_252943_(), delta.x(), delta.y(), delta.z()).m_5752_();
        out.m_252986_(mat.m_85850_().m_252922_(), end.x(), end.y(), end.z()).m_193479_(rgba).m_252939_(mat.m_85850_().m_252943_(), delta.x(), delta.y(), delta.z()).m_5752_();
    }

    private static Vector3f combine(Vec3 start, Vec3 end, int mixBits) {
        float eps = 0.01f;
        return new Vector3f((float)((mixBits & 4) != 0 ? end.f_82479_ + (double)0.01f : start.f_82479_ - (double)0.01f), (float)((mixBits & 2) != 0 ? end.f_82480_ + (double)0.01f : start.f_82480_ - (double)0.01f), (float)((mixBits & 1) != 0 ? end.f_82481_ + (double)0.01f : start.f_82481_ - (double)0.01f));
    }

    private record RenderingState(boolean perfect, boolean hasImperfection, boolean hasWrongBlock, int currentLayer) {
    }

    public static enum RenderLayer {
        ALL,
        BAD,
        PERFECT;

    }
}

