/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tweakeroo.config;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fi.dy.masa.malilib.config.ConfigUtils;
import fi.dy.masa.malilib.config.HudAlignment;
import fi.dy.masa.malilib.config.IConfigBase;
import fi.dy.masa.malilib.config.IConfigHandler;
import fi.dy.masa.malilib.config.IConfigOptionListEntry;
import fi.dy.masa.malilib.config.IHotkeyTogglable;
import fi.dy.masa.malilib.config.options.ConfigBoolean;
import fi.dy.masa.malilib.config.options.ConfigBooleanHotkeyed;
import fi.dy.masa.malilib.config.options.ConfigColor;
import fi.dy.masa.malilib.config.options.ConfigDouble;
import fi.dy.masa.malilib.config.options.ConfigFloat;
import fi.dy.masa.malilib.config.options.ConfigInteger;
import fi.dy.masa.malilib.config.options.ConfigOptionList;
import fi.dy.masa.malilib.config.options.ConfigString;
import fi.dy.masa.malilib.config.options.ConfigStringList;
import fi.dy.masa.malilib.hotkeys.IHotkey;
import fi.dy.masa.malilib.util.ActiveMode;
import fi.dy.masa.malilib.util.FileUtils;
import fi.dy.masa.malilib.util.JsonUtils;
import fi.dy.masa.malilib.util.MessageOutputType;
import fi.dy.masa.malilib.util.restrictions.UsageRestriction;
import fi.dy.masa.tweakeroo.Tweakeroo;
import fi.dy.masa.tweakeroo.config.ConfigBooleanClient;
import fi.dy.masa.tweakeroo.config.FeatureToggle;
import fi.dy.masa.tweakeroo.config.Hotkeys;
import fi.dy.masa.tweakeroo.tweaks.MiscTweaks;
import fi.dy.masa.tweakeroo.tweaks.PlacementTweaks;
import fi.dy.masa.tweakeroo.tweaks.RenderTweaks;
import fi.dy.masa.tweakeroo.util.EasyPlacementProtocol;
import fi.dy.masa.tweakeroo.util.InventoryUtils;
import fi.dy.masa.tweakeroo.util.PlacementRestrictionMode;
import fi.dy.masa.tweakeroo.util.SnapAimMode;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.minecraft.class_310;

public class Configs
implements IConfigHandler {
    private static final String CONFIG_FILE_NAME = "tweakeroo.json";
    private static final String GENERIC_KEY = "tweakeroo.config.generic";
    private static final String FIXES_KEY = "tweakeroo.config.fixes";
    private static final String LISTS_KEY = "tweakeroo.config.lists";
    private static final String DISABLE_KEY = "tweakeroo.config.disable";
    private static final String INTERNAL_KEY = "tweakeroo.config.internal";

    public static ConfigDouble getActiveFlySpeedConfig() {
        return switch (Internal.FLY_SPEED_PRESET.getIntegerValue()) {
            case 1 -> Generic.FLY_SPEED_PRESET_2;
            case 2 -> Generic.FLY_SPEED_PRESET_3;
            case 3 -> Generic.FLY_SPEED_PRESET_4;
            default -> Generic.FLY_SPEED_PRESET_1;
        };
    }

    public static void loadFromFile() {
        Path configFile = FileUtils.getConfigDirectoryAsPath().resolve(CONFIG_FILE_NAME);
        if (Files.exists(configFile, new LinkOption[0]) && Files.isReadable(configFile)) {
            JsonElement element = JsonUtils.parseJsonFileAsPath((Path)configFile);
            if (element != null && element.isJsonObject()) {
                JsonObject root = element.getAsJsonObject();
                ConfigUtils.readConfigBase((JsonObject)root, (String)"Fixes", Fixes.OPTIONS);
                ConfigUtils.readConfigBase((JsonObject)root, (String)"Generic", Generic.OPTIONS);
                ConfigUtils.readConfigBase((JsonObject)root, (String)"GenericHotkeys", Hotkeys.HOTKEY_LIST);
                ConfigUtils.readConfigBase((JsonObject)root, (String)"Internal", Internal.OPTIONS);
                ConfigUtils.readConfigBase((JsonObject)root, (String)"Lists", Lists.OPTIONS);
                ConfigUtils.readHotkeyToggleOptions((JsonObject)root, (String)"DisableHotkeys", (String)"DisableToggles", Disable.OPTIONS);
                ConfigUtils.readHotkeyToggleOptions((JsonObject)root, (String)"TweakHotkeys", (String)"TweakToggles", FeatureToggle.VALUES);
            }
        } else {
            Tweakeroo.LOGGER.error("loadFromFile(): Failed to load config file '{}'.", (Object)configFile.toAbsolutePath());
        }
        InventoryUtils.setToolSwitchableSlots(Generic.TOOL_SWITCHABLE_SLOTS.getStringValue());
        InventoryUtils.setToolSwitchIgnoreSlots(Generic.TOOL_SWITCH_IGNORED_SLOTS.getStringValue());
        InventoryUtils.parseSilkTouchOveride(Lists.SILK_TOUCH_OVERRIDE.getStrings());
        InventoryUtils.setRepairModeSlots(Lists.REPAIR_MODE_SLOTS.getStrings());
        InventoryUtils.setUnstackingItems(Lists.UNSTACKING_ITEMS.getStrings());
        InventoryUtils.setWeaponMapping(Lists.ENTITY_WEAPON_MAPPING.getStrings());
        PlacementTweaks.BLOCK_TYPE_BREAK_RESTRICTION.setListType((UsageRestriction.ListType)Lists.BLOCK_TYPE_BREAK_RESTRICTION_LIST_TYPE.getOptionListValue());
        PlacementTweaks.BLOCK_TYPE_BREAK_RESTRICTION.setListContents(Lists.BLOCK_TYPE_BREAK_RESTRICTION_BLACKLIST.getStrings(), Lists.BLOCK_TYPE_BREAK_RESTRICTION_WHITELIST.getStrings());
        PlacementTweaks.FAST_RIGHT_CLICK_BLOCK_RESTRICTION.setListType((UsageRestriction.ListType)Lists.FAST_RIGHT_CLICK_BLOCK_LIST_TYPE.getOptionListValue());
        PlacementTweaks.FAST_RIGHT_CLICK_BLOCK_RESTRICTION.setListContents(Lists.FAST_RIGHT_CLICK_BLOCK_BLACKLIST.getStrings(), Lists.FAST_RIGHT_CLICK_BLOCK_WHITELIST.getStrings());
        PlacementTweaks.FAST_RIGHT_CLICK_ITEM_RESTRICTION.setListType((UsageRestriction.ListType)Lists.FAST_RIGHT_CLICK_ITEM_LIST_TYPE.getOptionListValue());
        PlacementTweaks.FAST_RIGHT_CLICK_ITEM_RESTRICTION.setListContents(Lists.FAST_RIGHT_CLICK_ITEM_BLACKLIST.getStrings(), Lists.FAST_RIGHT_CLICK_ITEM_WHITELIST.getStrings());
        PlacementTweaks.FAST_PLACEMENT_ITEM_RESTRICTION.setListType((UsageRestriction.ListType)Lists.FAST_PLACEMENT_ITEM_LIST_TYPE.getOptionListValue());
        PlacementTweaks.FAST_PLACEMENT_ITEM_RESTRICTION.setListContents(Lists.FAST_PLACEMENT_ITEM_BLACKLIST.getStrings(), Lists.FAST_PLACEMENT_ITEM_WHITELIST.getStrings());
        PlacementTweaks.HAND_RESTOCK_RESTRICTION.setListType((UsageRestriction.ListType)Lists.HAND_RESTOCK_LIST_TYPE.getOptionListValue());
        PlacementTweaks.HAND_RESTOCK_RESTRICTION.setListContents(Lists.HAND_RESTOCK_BLACKLIST.getStrings(), Lists.HAND_RESTOCK_WHITELIST.getStrings());
        MiscTweaks.POTION_RESTRICTION.setListType((UsageRestriction.ListType)Lists.POTION_WARNING_LIST_TYPE.getOptionListValue());
        MiscTweaks.POTION_RESTRICTION.setListContents(Lists.POTION_WARNING_BLACKLIST.getStrings(), Lists.POTION_WARNING_WHITELIST.getStrings());
        RenderTweaks.rebuildLists();
        MiscTweaks.ENTITY_TYPE_ATTACK_RESTRICTION.setListType((UsageRestriction.ListType)Lists.ENTITY_TYPE_ATTACK_RESTRICTION_LIST_TYPE.getOptionListValue());
        MiscTweaks.ENTITY_TYPE_ATTACK_RESTRICTION.setListContents(Lists.ENTITY_TYPE_ATTACK_RESTRICTION_BLACKLIST.getStrings(), Lists.ENTITY_TYPE_ATTACK_RESTRICTION_WHITELIST.getStrings());
        if (class_310.method_1551().field_1687 == null) {
            FeatureToggle.TWEAK_FREE_CAMERA.setBooleanValue(false);
        }
    }

    public static void saveToFile() {
        Path dir = FileUtils.getConfigDirectoryAsPath();
        if (!Files.exists(dir, new LinkOption[0])) {
            FileUtils.createDirectoriesIfMissing((Path)dir);
        }
        if (Files.isDirectory(dir, new LinkOption[0])) {
            JsonObject root = new JsonObject();
            ConfigUtils.writeConfigBase((JsonObject)root, (String)"Fixes", Fixes.OPTIONS);
            ConfigUtils.writeConfigBase((JsonObject)root, (String)"Generic", Generic.OPTIONS);
            ConfigUtils.writeConfigBase((JsonObject)root, (String)"GenericHotkeys", Hotkeys.HOTKEY_LIST);
            ConfigUtils.writeConfigBase((JsonObject)root, (String)"Internal", Internal.OPTIONS);
            ConfigUtils.writeConfigBase((JsonObject)root, (String)"Lists", Lists.OPTIONS);
            ConfigUtils.writeHotkeyToggleOptions((JsonObject)root, (String)"DisableHotkeys", (String)"DisableToggles", Disable.OPTIONS);
            ConfigUtils.writeHotkeyToggleOptions((JsonObject)root, (String)"TweakHotkeys", (String)"TweakToggles", FeatureToggle.VALUES);
            JsonUtils.writeJsonToFileAsPath((JsonObject)root, (Path)dir.resolve(CONFIG_FILE_NAME));
        } else {
            Tweakeroo.LOGGER.error("saveToFile(): Config Folder '{}' does not exist!", (Object)dir.toAbsolutePath());
        }
    }

    public void load() {
        Configs.loadFromFile();
    }

    public void save() {
        Configs.saveToFile();
    }

    public static class Internal {
        public static final ConfigDouble DARKNESS_SCALE_VALUE_ORIGINAL = (ConfigDouble)new ConfigDouble("darknessScaleValueOriginal", 0.0, 0.0, 1.0).apply("tweakeroo.config.internal");
        public static final ConfigInteger FLY_SPEED_PRESET = (ConfigInteger)new ConfigInteger("flySpeedPreset", 0, 0, 3).apply("tweakeroo.config.internal");
        public static final ConfigDouble GAMMA_VALUE_ORIGINAL = (ConfigDouble)new ConfigDouble("gammaValueOriginal", 0.0, 0.0, 1.0).apply("tweakeroo.config.internal");
        public static final ConfigInteger HOTBAR_SCROLL_CURRENT_ROW = (ConfigInteger)new ConfigInteger("hotbarScrollCurrentRow", 3, 0, 3).apply("tweakeroo.config.internal");
        public static final ConfigDouble SLIME_BLOCK_SLIPPERINESS_ORIGINAL = (ConfigDouble)new ConfigDouble("slimeBlockSlipperinessOriginal", 0.8, 0.0, 1.0).apply("tweakeroo.config.internal");
        public static final ConfigInteger SHULKER_MAX_STACK_SIZE = (ConfigInteger)new ConfigInteger("shulkerMaxStackSize", 64, 1, 99).apply("tweakeroo.config.internal");
        public static final ImmutableList<IConfigBase> OPTIONS = ImmutableList.of((Object)DARKNESS_SCALE_VALUE_ORIGINAL, (Object)FLY_SPEED_PRESET, (Object)GAMMA_VALUE_ORIGINAL, (Object)HOTBAR_SCROLL_CURRENT_ROW, (Object)SLIME_BLOCK_SLIPPERINESS_ORIGINAL, (Object)SHULKER_MAX_STACK_SIZE);
    }

    public static class Generic {
        public static final ConfigOptionList ACCURATE_PLACEMENT_PROTOCOL_MODE = (ConfigOptionList)new ConfigOptionList("accuratePlacementProtocolMode", (IConfigOptionListEntry)EasyPlacementProtocol.AUTO).apply("tweakeroo.config.generic");
        public static final ConfigBoolean ACCURATE_PLACEMENT_PROTOCOL = (ConfigBoolean)new ConfigBoolean("accuratePlacementProtocol", true).apply("tweakeroo.config.generic");
        public static final ConfigInteger AFTER_CLICKER_CLICK_COUNT = (ConfigInteger)new ConfigInteger("afterClickerClickCount", 1, 1, 32).apply("tweakeroo.config.generic");
        public static final ConfigDouble ANGEL_BLOCK_PLACEMENT_DISTANCE = (ConfigDouble)new ConfigDouble("angelBlockPlacementDistance", 3.0, 1.0, 5.0).apply("tweakeroo.config.generic");
        public static final ConfigBoolean AREA_SELECTION_USE_ALL = (ConfigBoolean)new ConfigBoolean("areaSelectionUseAll", false).apply("tweakeroo.config.generic");
        public static final ConfigDouble BLOCK_REACH_DISTANCE = (ConfigDouble)new ConfigDouble("blockReachDistance", 4.5, 1.0, 64.0).apply("tweakeroo.config.generic");
        public static final ConfigOptionList BLOCK_TYPE_BREAK_RESTRICTION_WARN = (ConfigOptionList)new ConfigOptionList("blockTypeBreakRestrictionWarn", (IConfigOptionListEntry)MessageOutputType.MESSAGE).apply("tweakeroo.config.generic");
        public static final ConfigInteger BREAKING_GRID_SIZE = (ConfigInteger)new ConfigInteger("breakingGridSize", 3, 1, 1000).apply("tweakeroo.config.generic");
        public static final ConfigInteger RESTRICTION_LAYER_HEIGHT = new ConfigInteger("restrictionLayerHeight", 1, -1000, 1000, "The layer height for the layer restriction mode.\nTo quickly adjust the value, scroll while\nholding down the tweak toggle keybind.");
        public static final ConfigOptionList BREAKING_RESTRICTION_MODE = (ConfigOptionList)new ConfigOptionList("breakingRestrictionMode", (IConfigOptionListEntry)PlacementRestrictionMode.LINE).apply("tweakeroo.config.generic");
        public static final ConfigBoolean BUNDLE_DISPLAY_BACKGROUND_COLOR = (ConfigBoolean)new ConfigBoolean("bundleDisplayBgColor", true).apply("tweakeroo.config.generic");
        public static final ConfigBoolean BUNDLE_DISPLAY_REQUIRE_SHIFT = (ConfigBoolean)new ConfigBoolean("bundleDisplayRequireShift", true).apply("tweakeroo.config.generic");
        public static final ConfigInteger BUNDLE_DISPLAY_ROW_WIDTH = (ConfigInteger)new ConfigInteger("bundleDisplayRowWidth", 9, 6, 9).apply("tweakeroo.config.generic");
        public static final ConfigColor CHAT_BACKGROUND_COLOR = new ConfigColor("chatBackgroundColor", "#80000000").apply("tweakeroo.config.generic");
        public static final ConfigString CHAT_TIME_FORMAT = (ConfigString)new ConfigString("chatTimeFormat", "[HH:mm:ss]").apply("tweakeroo.config.generic");
        public static final ConfigBoolean CLIENT_PLACEMENT_ROTATION = (ConfigBoolean)new ConfigBoolean("clientPlacementRotation", true).apply("tweakeroo.config.generic");
        public static final ConfigBoolean CLIENT_PLACEMENT_VALIDATION = (ConfigBoolean)new ConfigBoolean("clientPlacementValidation", true).apply("tweakeroo.config.generic");
        public static final ConfigInteger CUSTOM_INVENTORY_GUI_SCALE = (ConfigInteger)new ConfigInteger("customInventoryGuiScale", 2, 1, 10).apply("tweakeroo.config.generic");
        public static final ConfigDouble DARKNESS_SCALE_OVERRIDE_VALUE = (ConfigDouble)new ConfigDouble("darknessScaleOverrideValue", 0.45, 0.0, 1.0).apply("tweakeroo.config.generic");
        public static final ConfigBoolean DEBUG_LOGGING = (ConfigBoolean)new ConfigBoolean("debugLogging", false).apply("tweakeroo.config.generic");
        public static final ConfigOptionList ELYTRA_CAMERA_INDICATOR = (ConfigOptionList)new ConfigOptionList("elytraCameraIndicator", (IConfigOptionListEntry)ActiveMode.WITH_KEY).apply("tweakeroo.config.generic");
        public static final ConfigDouble ENTITY_REACH_DISTANCE = (ConfigDouble)new ConfigDouble("entityReachDistance", 3.0, 1.0, 64.0).apply("tweakeroo.config.generic");
        public static final ConfigOptionList ENTITY_TYPE_ATTACK_RESTRICTION_WARN = (ConfigOptionList)new ConfigOptionList("entityTypeAttackRestrictionWarn", (IConfigOptionListEntry)MessageOutputType.MESSAGE).apply("tweakeroo.config.generic");
        public static final ConfigInteger FAST_BLOCK_PLACEMENT_COUNT = (ConfigInteger)new ConfigInteger("fastBlockPlacementCount", 2, 1, 16).apply("tweakeroo.config.generic");
        public static final ConfigBoolean FAST_LEFT_CLICK_ALLOW_TOOLS = (ConfigBoolean)new ConfigBoolean("fastLeftClickAllowTools", false).apply("tweakeroo.config.generic");
        public static final ConfigInteger FAST_LEFT_CLICK_COUNT = (ConfigInteger)new ConfigInteger("fastLeftClickCount", 10, 1, 64).apply("tweakeroo.config.generic");
        public static final ConfigBoolean FAST_PLACEMENT_REMEMBER_ALWAYS = (ConfigBoolean)new ConfigBoolean("fastPlacementRememberOrientation", true).apply("tweakeroo.config.generic");
        public static final ConfigInteger FAST_RIGHT_CLICK_COUNT = (ConfigInteger)new ConfigInteger("fastRightClickCount", 10, 1, 64).apply("tweakeroo.config.generic");
        public static final ConfigInteger FILL_CLONE_LIMIT = (ConfigInteger)new ConfigInteger("fillCloneLimit", 10000000, 1, 1000000000).apply("tweakeroo.config.generic");
        public static final ConfigColor FLEXIBLE_PLACEMENT_OVERLAY_COLOR = new ConfigColor("flexibleBlockPlacementOverlayColor", "#C03030F0").apply("tweakeroo.config.generic");
        public static final ConfigDouble FLY_DECELERATION_FACTOR = (ConfigDouble)new ConfigDouble("flyDecelerationFactor", 0.4, 0.0, 1.0).apply("tweakeroo.config.generic");
        public static final ConfigDouble FLY_SPEED_PRESET_1 = (ConfigDouble)new ConfigDouble("flySpeedPreset1", 0.01, 0.0, 4.0).apply("tweakeroo.config.generic");
        public static final ConfigDouble FLY_SPEED_PRESET_2 = (ConfigDouble)new ConfigDouble("flySpeedPreset2", 0.064, 0.0, 4.0).apply("tweakeroo.config.generic");
        public static final ConfigDouble FLY_SPEED_PRESET_3 = (ConfigDouble)new ConfigDouble("flySpeedPreset3", 0.128, 0.0, 4.0).apply("tweakeroo.config.generic");
        public static final ConfigDouble FLY_SPEED_PRESET_4 = (ConfigDouble)new ConfigDouble("flySpeedPreset4", 0.32, 0.0, 4.0).apply("tweakeroo.config.generic");
        public static final ConfigDouble FLY_SPEED_INCREMENT_1 = (ConfigDouble)new ConfigDouble("flySpeedIncrement1", 0.128, -4.0, 4.0).apply("tweakeroo.config.generic");
        public static final ConfigDouble FLY_SPEED_INCREMENT_2 = (ConfigDouble)new ConfigDouble("flySpeedIncrement2", -0.128, -4.0, 4.0).apply("tweakeroo.config.generic");
        public static final ConfigBooleanHotkeyed FREE_CAMERA_PLAYER_INPUTS = new ConfigBooleanHotkeyed("freeCameraPlayerInputs", false, "").apply("tweakeroo.config.generic");
        public static final ConfigBooleanHotkeyed FREE_CAMERA_PLAYER_MOVEMENT = new ConfigBooleanHotkeyed("freeCameraPlayerMovement", false, "").apply("tweakeroo.config.generic");
        public static final ConfigBooleanHotkeyed FREE_CAMERA_SHOW_HANDS = new ConfigBooleanHotkeyed("freeCameraShowHands", false, "").apply("tweakeroo.config.generic");
        public static final ConfigBooleanHotkeyed FREE_CAMERA_SHOW_HOTBAR = new ConfigBooleanHotkeyed("freeCameraShowHotBar", false, "").apply("tweakeroo.config.generic");
        public static final ConfigBooleanHotkeyed FREE_CAMERA_SHOW_STATUS_BARS = new ConfigBooleanHotkeyed("freeCameraShowStatusBars", false, "").apply("tweakeroo.config.generic");
        public static final ConfigDouble GAMMA_OVERRIDE_VALUE = (ConfigDouble)new ConfigDouble("gammaOverrideValue", 16.0, 0.0, 32.0).apply("tweakeroo.config.generic");
        public static final ConfigBoolean HAND_RESTOCK_PRE = (ConfigBoolean)new ConfigBoolean("handRestockPre", true).apply("tweakeroo.config.generic");
        public static final ConfigInteger HAND_RESTOCK_PRE_THRESHOLD = (ConfigInteger)new ConfigInteger("handRestockPreThreshold", 6, 1, 64).apply("tweakeroo.config.generic");
        public static final ConfigBoolean HANGABLE_ENTITY_BYPASS_INVERSE = (ConfigBoolean)new ConfigBoolean("hangableEntityBypassInverse", false).apply("tweakeroo.config.generic");
        public static final ConfigInteger HOTBAR_SLOT_CYCLE_MAX = (ConfigInteger)new ConfigInteger("hotbarSlotCycleMax", 2, 1, 9).apply("tweakeroo.config.generic");
        public static final ConfigInteger HOTBAR_SLOT_RANDOMIZER_MAX = (ConfigInteger)new ConfigInteger("hotbarSlotRandomizerMax", 5, 1, 9).apply("tweakeroo.config.generic");
        public static final ConfigOptionList HOTBAR_SWAP_OVERLAY_ALIGNMENT = (ConfigOptionList)new ConfigOptionList("hotbarSwapOverlayAlignment", (IConfigOptionListEntry)HudAlignment.BOTTOM_RIGHT).apply("tweakeroo.config.generic");
        public static final ConfigInteger HOTBAR_SWAP_OVERLAY_OFFSET_X = (ConfigInteger)new ConfigInteger("hotbarSwapOverlayOffsetX", 4).apply("tweakeroo.config.generic");
        public static final ConfigInteger HOTBAR_SWAP_OVERLAY_OFFSET_Y = (ConfigInteger)new ConfigInteger("hotbarSwapOverlayOffsetY", 4).apply("tweakeroo.config.generic");
        public static final ConfigBoolean INVENTORY_PREVIEW_VILLAGER_BG_COLOR = (ConfigBoolean)new ConfigBoolean("inventoryPreviewVillagerBGColor", false).apply("tweakeroo.config.generic");
        public static final ConfigInteger ITEM_SWAP_DURABILITY_THRESHOLD = (ConfigInteger)new ConfigInteger("itemSwapDurabilityThreshold", 20, 5, 10000).apply("tweakeroo.config.generic");
        public static final ConfigBoolean ITEM_USE_PACKET_CHECK_BYPASS = (ConfigBoolean)new ConfigBoolean("itemUsePacketCheckBypass", true).apply("tweakeroo.config.generic");
        public static final ConfigBoolean MAP_PREVIEW_REQUIRE_SHIFT = (ConfigBoolean)new ConfigBoolean("mapPreviewRequireShift", true).apply("tweakeroo.config.generic");
        public static final ConfigInteger MAP_PREVIEW_SIZE = (ConfigInteger)new ConfigInteger("mapPreviewSize", 160, 16, 512).apply("tweakeroo.config.generic");
        public static final ConfigInteger PERIODIC_ATTACK_INTERVAL = (ConfigInteger)new ConfigInteger("periodicAttackInterval", 20, 0, Integer.MAX_VALUE).apply("tweakeroo.config.generic");
        public static final ConfigInteger PERIODIC_USE_INTERVAL = (ConfigInteger)new ConfigInteger("periodicUseInterval", 20, 0, Integer.MAX_VALUE).apply("tweakeroo.config.generic");
        public static final ConfigInteger PERIODIC_HOLD_ATTACK_DURATION = (ConfigInteger)new ConfigInteger("periodicHoldAttackDuration", 20, 0, Integer.MAX_VALUE).apply("tweakeroo.config.generic");
        public static final ConfigInteger PERIODIC_HOLD_ATTACK_INTERVAL = (ConfigInteger)new ConfigInteger("periodicHoldAttackInterval", 20, 0, Integer.MAX_VALUE).apply("tweakeroo.config.generic");
        public static final ConfigInteger PERIODIC_HOLD_USE_DURATION = (ConfigInteger)new ConfigInteger("periodicHoldUseDuration", 20, 0, Integer.MAX_VALUE).apply("tweakeroo.config.generic");
        public static final ConfigInteger PERIODIC_HOLD_USE_INTERVAL = (ConfigInteger)new ConfigInteger("periodicHoldUseInterval", 20, 0, Integer.MAX_VALUE).apply("tweakeroo.config.generic");
        public static final ConfigBoolean PERMANENT_SNEAK_ALLOW_IN_GUIS = (ConfigBoolean)new ConfigBoolean("permanentSneakAllowInGUIs", false).apply("tweakeroo.config.generic");
        public static final ConfigInteger PLACEMENT_GRID_SIZE = (ConfigInteger)new ConfigInteger("placementGridSize", 3, 1, 1000).apply("tweakeroo.config.generic");
        public static final ConfigInteger PLACEMENT_LIMIT = (ConfigInteger)new ConfigInteger("placementLimit", 3, 1, 10000).apply("tweakeroo.config.generic");
        public static final ConfigOptionList PLACEMENT_RESTRICTION_MODE = (ConfigOptionList)new ConfigOptionList("placementRestrictionMode", (IConfigOptionListEntry)PlacementRestrictionMode.FACE).apply("tweakeroo.config.generic");
        public static final ConfigBoolean PLACEMENT_RESTRICTION_TIED_TO_FAST = (ConfigBoolean)new ConfigBoolean("placementRestrictionTiedToFast", true).apply("tweakeroo.config.generic");
        public static final ConfigBoolean POTION_WARNING_BENEFICIAL_ONLY = (ConfigBoolean)new ConfigBoolean("potionWarningBeneficialOnly", true).apply("tweakeroo.config.generic");
        public static final ConfigInteger POTION_WARNING_THRESHOLD = (ConfigInteger)new ConfigInteger("potionWarningThreshold", 600, 1, 1000000).apply("tweakeroo.config.generic");
        public static final ConfigBoolean REMEMBER_FLEXIBLE = (ConfigBoolean)new ConfigBoolean("rememberFlexibleFromClick", true).apply("tweakeroo.config.generic");
        public static final ConfigInteger RENDER_LIMIT_ITEM = (ConfigInteger)new ConfigInteger("renderLimitItem", -1, -1, 10000).apply("tweakeroo.config.generic");
        public static final ConfigInteger RENDER_LIMIT_XP_ORB = (ConfigInteger)new ConfigInteger("renderLimitXPOrb", -1, -1, 10000).apply("tweakeroo.config.generic");
        public static final ConfigInteger SCAFFOLD_PLACE_DISTANCE = (ConfigInteger)new ConfigInteger("scaffoldPlaceDistance", 5, 1, 20).apply("tweakeroo.config.generic");
        public static final ConfigBoolean SCAFFOLD_PLACE_VANILLA = (ConfigBoolean)new ConfigBoolean("scaffoldPlaceVanilla", false).apply("tweakeroo.config.generic");
        public static final ConfigInteger SCULK_SENSOR_PULSE_LENGTH = (ConfigInteger)new ConfigInteger("sculkSensorPulseLength", 40, 0, 10000).apply("tweakeroo.config.generic");
        public static final ConfigBoolean SELECTIVE_BLOCKS_TRACK_PISTONS = (ConfigBoolean)new ConfigBoolean("selectiveBlocksTrackPistons", false).apply("tweakeroo.config.generic");
        public static final ConfigBoolean SELECTIVE_BLOCKS_HIDE_PARTICLES = (ConfigBoolean)new ConfigBoolean("selectiveBlocksHideParticles", true).apply("tweakeroo.config.generic");
        public static final ConfigBoolean SELECTIVE_BLOCKS_HIDE_ENTITIES = (ConfigBoolean)new ConfigBoolean("selectiveBlocksHideEntities", false).apply("tweakeroo.config.generic");
        public static final ConfigBoolean SELECTIVE_BLOCKS_NO_HIT = (ConfigBoolean)new ConfigBoolean("selectiveBlocksNoHit", true).apply("tweakeroo.config.generic");
        public static final ConfigFloat SERVER_DATA_SYNC_CACHE_REFRESH = (ConfigFloat)new ConfigFloat("serverDataSyncCacheRefresh", 0.25f, 0.05f, 1.0f).apply("tweakeroo.config.generic");
        public static final ConfigFloat SERVER_DATA_SYNC_CACHE_TIMEOUT = (ConfigFloat)new ConfigFloat("serverDataSyncCacheTimeout", 0.75f, 0.25f, 5.0f).apply("tweakeroo.config.generic");
        public static final ConfigInteger SERVER_NBT_REQUEST_RATE = (ConfigInteger)new ConfigInteger("serverNbtRequestRate", 2).apply("tweakeroo.config.generic");
        public static final ConfigBoolean SHULKER_DISPLAY_BACKGROUND_COLOR = (ConfigBoolean)new ConfigBoolean("shulkerDisplayBgColor", true).apply("tweakeroo.config.generic");
        public static final ConfigBoolean SHULKER_DISPLAY_ENDER_CHEST = (ConfigBoolean)new ConfigBoolean("shulkerDisplayEnderChest", false).apply("tweakeroo.config.generic");
        public static final ConfigBoolean SHULKER_DISPLAY_REQUIRE_SHIFT = (ConfigBoolean)new ConfigBoolean("shulkerDisplayRequireShift", true).apply("tweakeroo.config.generic");
        public static final ConfigBoolean SLOT_SYNC_WORKAROUND = (ConfigBoolean)new ConfigBoolean("slotSyncWorkaround", true).apply("tweakeroo.config.generic");
        public static final ConfigBoolean SLOT_SYNC_WORKAROUND_ALWAYS = (ConfigBoolean)new ConfigBoolean("slotSyncWorkaroundAlways", false).apply("tweakeroo.config.generic");
        public static final ConfigBoolean SNAP_AIM_INDICATOR = (ConfigBoolean)new ConfigBoolean("snapAimIndicator", true).apply("tweakeroo.config.generic");
        public static final ConfigColor SNAP_AIM_INDICATOR_COLOR = new ConfigColor("snapAimIndicatorColor", "#603030FF").apply("tweakeroo.config.generic");
        public static final ConfigOptionList SNAP_AIM_MODE = (ConfigOptionList)new ConfigOptionList("snapAimMode", (IConfigOptionListEntry)SnapAimMode.YAW).apply("tweakeroo.config.generic");
        public static final ConfigBoolean SNAP_AIM_ONLY_CLOSE_TO_ANGLE = (ConfigBoolean)new ConfigBoolean("snapAimOnlyCloseToAngle", true).apply("tweakeroo.config.generic");
        public static final ConfigBoolean SNAP_AIM_PITCH_OVERSHOOT = (ConfigBoolean)new ConfigBoolean("snapAimPitchOvershoot", false).apply("tweakeroo.config.generic");
        public static final ConfigDouble SNAP_AIM_PITCH_STEP = (ConfigDouble)new ConfigDouble("snapAimPitchStep", 12.5, 0.0, 90.0).apply("tweakeroo.config.generic");
        public static final ConfigDouble SNAP_AIM_THRESHOLD_PITCH = (ConfigDouble)new ConfigDouble("snapAimThresholdPitch", 1.5).apply("tweakeroo.config.generic");
        public static final ConfigDouble SNAP_AIM_THRESHOLD_YAW = (ConfigDouble)new ConfigDouble("snapAimThresholdYaw", 5.0).apply("tweakeroo.config.generic");
        public static final ConfigDouble SNAP_AIM_YAW_STEP = (ConfigDouble)new ConfigDouble("snapAimYawStep", 45.0, 0.0, 360.0).apply("tweakeroo.config.generic");
        public static final ConfigInteger STRUCTURE_BLOCK_MAX_SIZE = (ConfigInteger)new ConfigInteger("structureBlockMaxSize", 128, 1, 256).apply("tweakeroo.config.generic");
        public static final ConfigString TOOL_SWITCHABLE_SLOTS = (ConfigString)new ConfigString("toolSwitchableSlots", "1-9").apply("tweakeroo.config.generic");
        public static final ConfigString TOOL_SWITCH_IGNORED_SLOTS = (ConfigString)new ConfigString("toolSwitchIgnoredSlots", "").apply("tweakeroo.config.generic");
        public static final ConfigBooleanHotkeyed TOOL_SWAP_ALLOW_UNENCHANTED_TO_BREAK = new ConfigBooleanHotkeyed("toolSwapAllowUnenchantedToBreak", false, "").apply("tweakeroo.config.generic");
        public static final ConfigBooleanHotkeyed TOOL_SWAP_BETTER_ENCHANTS = new ConfigBooleanHotkeyed("toolSwapBetterEnchants", false, "").apply("tweakeroo.config.generic");
        public static final ConfigBooleanHotkeyed TOOL_SWAP_PREFER_SILK_TOUCH = new ConfigBooleanHotkeyed("toolSwapPreferSilkTouch", false, "").apply("tweakeroo.config.generic");
        public static final ConfigBooleanHotkeyed TOOL_SWAP_BAMBOO_USES_SWORD_FIRST = new ConfigBooleanHotkeyed("toolSwapBambooUsesSwordFirst", true, "").apply("tweakeroo.config.generic");
        public static final ConfigBooleanHotkeyed TOOL_SWAP_NEEDS_SHEARS_FIRST = new ConfigBooleanHotkeyed("toolSwapNeedsShearsFirst", true, "").apply("tweakeroo.config.generic");
        public static final ConfigBooleanHotkeyed TOOL_SWAP_SILK_TOUCH_FIRST = new ConfigBooleanHotkeyed("toolSwapSilkTouchFirst", true, "").apply("tweakeroo.config.generic");
        public static final ConfigBooleanHotkeyed TOOL_SWAP_SILK_TOUCH_ORES = new ConfigBooleanHotkeyed("toolSwapSilkTouchOres", false, "").apply("tweakeroo.config.generic");
        public static final ConfigBooleanHotkeyed TOOL_SWAP_SILK_TOUCH_OVERRIDE = new ConfigBooleanHotkeyed("toolSwapSilkTouchOverride", false, "").apply("tweakeroo.config.generic");
        public static final ConfigBooleanHotkeyed WEAPON_SWAP_BETTER_ENCHANTS = new ConfigBooleanHotkeyed("weaponSwapBetterEnchants", false, "").apply("tweakeroo.config.generic");
        public static final ConfigBoolean ZOOM_ADJUST_MOUSE_SENSITIVITY = (ConfigBoolean)new ConfigBoolean("zoomAdjustMouseSensitivity", true).apply("tweakeroo.config.generic");
        public static final ConfigDouble ZOOM_FOV = (ConfigDouble)new ConfigDouble("zoomFov", 30.0, 0.01, 359.99).apply("tweakeroo.config.generic");
        public static final ConfigBoolean ZOOM_RESET_FOV_ON_ACTIVATE = (ConfigBoolean)new ConfigBoolean("zoomResetFovOnActivate", true).apply("tweakeroo.config.generic");
        public static final ImmutableList<IConfigBase> OPTIONS = ImmutableList.of((Object)ACCURATE_PLACEMENT_PROTOCOL_MODE, (Object)ACCURATE_PLACEMENT_PROTOCOL, (Object)BUNDLE_DISPLAY_BACKGROUND_COLOR, (Object)BUNDLE_DISPLAY_REQUIRE_SHIFT, (Object)BUNDLE_DISPLAY_ROW_WIDTH, (Object)CLIENT_PLACEMENT_ROTATION, (Object)CLIENT_PLACEMENT_VALIDATION, (Object)DEBUG_LOGGING, (Object)FAST_LEFT_CLICK_ALLOW_TOOLS, (Object)FAST_PLACEMENT_REMEMBER_ALWAYS, (Object)FREE_CAMERA_PLAYER_INPUTS, (Object)FREE_CAMERA_PLAYER_MOVEMENT, (Object[])new IConfigBase[]{FREE_CAMERA_SHOW_HANDS, FREE_CAMERA_SHOW_HOTBAR, FREE_CAMERA_SHOW_STATUS_BARS, HAND_RESTOCK_PRE, HANGABLE_ENTITY_BYPASS_INVERSE, INVENTORY_PREVIEW_VILLAGER_BG_COLOR, ITEM_USE_PACKET_CHECK_BYPASS, MAP_PREVIEW_REQUIRE_SHIFT, PERMANENT_SNEAK_ALLOW_IN_GUIS, PLACEMENT_RESTRICTION_TIED_TO_FAST, POTION_WARNING_BENEFICIAL_ONLY, REMEMBER_FLEXIBLE, SHULKER_DISPLAY_BACKGROUND_COLOR, SHULKER_DISPLAY_ENDER_CHEST, SHULKER_DISPLAY_REQUIRE_SHIFT, SLOT_SYNC_WORKAROUND, SLOT_SYNC_WORKAROUND_ALWAYS, SNAP_AIM_INDICATOR, SNAP_AIM_ONLY_CLOSE_TO_ANGLE, SNAP_AIM_PITCH_OVERSHOOT, ZOOM_ADJUST_MOUSE_SENSITIVITY, AREA_SELECTION_USE_ALL, RESTRICTION_LAYER_HEIGHT, BLOCK_TYPE_BREAK_RESTRICTION_WARN, BREAKING_RESTRICTION_MODE, ELYTRA_CAMERA_INDICATOR, ENTITY_TYPE_ATTACK_RESTRICTION_WARN, PLACEMENT_RESTRICTION_MODE, HOTBAR_SWAP_OVERLAY_ALIGNMENT, SELECTIVE_BLOCKS_TRACK_PISTONS, SELECTIVE_BLOCKS_HIDE_PARTICLES, SELECTIVE_BLOCKS_HIDE_ENTITIES, SELECTIVE_BLOCKS_NO_HIT, SNAP_AIM_MODE, CHAT_TIME_FORMAT, CHAT_BACKGROUND_COLOR, FLEXIBLE_PLACEMENT_OVERLAY_COLOR, SNAP_AIM_INDICATOR_COLOR, AFTER_CLICKER_CLICK_COUNT, BLOCK_REACH_DISTANCE, ANGEL_BLOCK_PLACEMENT_DISTANCE, BREAKING_GRID_SIZE, CUSTOM_INVENTORY_GUI_SCALE, DARKNESS_SCALE_OVERRIDE_VALUE, ENTITY_REACH_DISTANCE, FAST_BLOCK_PLACEMENT_COUNT, FAST_LEFT_CLICK_COUNT, FAST_RIGHT_CLICK_COUNT, FILL_CLONE_LIMIT, FLY_DECELERATION_FACTOR, FLY_SPEED_PRESET_1, FLY_SPEED_PRESET_2, FLY_SPEED_PRESET_3, FLY_SPEED_PRESET_4, FLY_SPEED_INCREMENT_1, FLY_SPEED_INCREMENT_2, GAMMA_OVERRIDE_VALUE, HAND_RESTOCK_PRE_THRESHOLD, HOTBAR_SLOT_CYCLE_MAX, HOTBAR_SLOT_RANDOMIZER_MAX, HOTBAR_SWAP_OVERLAY_OFFSET_X, HOTBAR_SWAP_OVERLAY_OFFSET_Y, ITEM_SWAP_DURABILITY_THRESHOLD, MAP_PREVIEW_SIZE, PERIODIC_ATTACK_INTERVAL, PERIODIC_USE_INTERVAL, PERIODIC_HOLD_ATTACK_DURATION, PERIODIC_HOLD_ATTACK_INTERVAL, PERIODIC_HOLD_USE_DURATION, PERIODIC_HOLD_USE_INTERVAL, PLACEMENT_GRID_SIZE, PLACEMENT_LIMIT, POTION_WARNING_THRESHOLD, RENDER_LIMIT_ITEM, RENDER_LIMIT_XP_ORB, SCAFFOLD_PLACE_DISTANCE, SCAFFOLD_PLACE_VANILLA, SCULK_SENSOR_PULSE_LENGTH, SERVER_DATA_SYNC_CACHE_REFRESH, SERVER_DATA_SYNC_CACHE_TIMEOUT, SERVER_NBT_REQUEST_RATE, SNAP_AIM_PITCH_STEP, SNAP_AIM_THRESHOLD_PITCH, SNAP_AIM_THRESHOLD_YAW, SNAP_AIM_YAW_STEP, STRUCTURE_BLOCK_MAX_SIZE, TOOL_SWITCHABLE_SLOTS, TOOL_SWAP_ALLOW_UNENCHANTED_TO_BREAK, TOOL_SWITCH_IGNORED_SLOTS, TOOL_SWAP_BETTER_ENCHANTS, TOOL_SWAP_PREFER_SILK_TOUCH, TOOL_SWAP_BAMBOO_USES_SWORD_FIRST, TOOL_SWAP_NEEDS_SHEARS_FIRST, TOOL_SWAP_SILK_TOUCH_FIRST, TOOL_SWAP_SILK_TOUCH_ORES, TOOL_SWAP_SILK_TOUCH_OVERRIDE, WEAPON_SWAP_BETTER_ENCHANTS, ZOOM_FOV, ZOOM_RESET_FOV_ON_ACTIVATE});
        public static final ImmutableList<IHotkey> HOTKEYS = ImmutableList.of((Object)FREE_CAMERA_PLAYER_INPUTS, (Object)FREE_CAMERA_PLAYER_MOVEMENT, (Object)FREE_CAMERA_SHOW_HANDS, (Object)FREE_CAMERA_SHOW_HOTBAR, (Object)TOOL_SWAP_BETTER_ENCHANTS, (Object)TOOL_SWAP_PREFER_SILK_TOUCH, (Object)TOOL_SWAP_BAMBOO_USES_SWORD_FIRST, (Object)TOOL_SWAP_NEEDS_SHEARS_FIRST, (Object)TOOL_SWAP_SILK_TOUCH_FIRST, (Object)TOOL_SWAP_SILK_TOUCH_ORES, (Object)TOOL_SWAP_SILK_TOUCH_OVERRIDE, (Object)WEAPON_SWAP_BETTER_ENCHANTS, (Object[])new IHotkey[0]);
    }

    public static class Fixes {
        public static final ConfigBoolean STACKABLE_SHULKERS_IN_HOPPER_FIX = (ConfigBoolean)new ConfigBoolean("stackableShulkersInHopperFix", true).apply("tweakeroo.config.fixes");
        public static final ConfigBoolean MAC_HORIZONTAL_SCROLL = (ConfigBoolean)new ConfigBoolean("macHorizontalScroll", false).apply("tweakeroo.config.fixes");
        public static final ConfigBoolean RAVAGER_CLIENT_BLOCK_BREAK_FIX = (ConfigBoolean)new ConfigBoolean("ravagerClientBlockBreakFix", false).apply("tweakeroo.config.fixes");
        public static final ImmutableList<IConfigBase> OPTIONS = ImmutableList.of((Object)STACKABLE_SHULKERS_IN_HOPPER_FIX, (Object)MAC_HORIZONTAL_SCROLL, (Object)RAVAGER_CLIENT_BLOCK_BREAK_FIX);
    }

    public static class Lists {
        public static final ConfigOptionList BLOCK_TYPE_BREAK_RESTRICTION_LIST_TYPE = (ConfigOptionList)new ConfigOptionList("blockTypeBreakRestrictionListType", (IConfigOptionListEntry)UsageRestriction.ListType.BLACKLIST).apply("tweakeroo.config.lists");
        public static final ConfigStringList BLOCK_TYPE_BREAK_RESTRICTION_BLACKLIST = (ConfigStringList)new ConfigStringList("blockTypeBreakRestrictionBlackList", ImmutableList.of((Object)"minecraft:budding_amethyst")).apply("tweakeroo.config.lists");
        public static final ConfigStringList BLOCK_TYPE_BREAK_RESTRICTION_WHITELIST = (ConfigStringList)new ConfigStringList("blockTypeBreakRestrictionWhiteList", ImmutableList.of()).apply("tweakeroo.config.lists");
        public static final ConfigOptionList ENTITY_TYPE_ATTACK_RESTRICTION_LIST_TYPE = (ConfigOptionList)new ConfigOptionList("entityTypeAttackRestrictionListType", (IConfigOptionListEntry)UsageRestriction.ListType.BLACKLIST).apply("tweakeroo.config.lists");
        public static final ConfigStringList ENTITY_TYPE_ATTACK_RESTRICTION_BLACKLIST = (ConfigStringList)new ConfigStringList("entityTypeAttackRestrictionBlackList", ImmutableList.of((Object)"minecraft:villager")).apply("tweakeroo.config.lists");
        public static final ConfigStringList ENTITY_TYPE_ATTACK_RESTRICTION_WHITELIST = (ConfigStringList)new ConfigStringList("entityTypeAttackRestrictionWhiteList", ImmutableList.of()).apply("tweakeroo.config.lists");
        public static final ConfigStringList ENTITY_WEAPON_MAPPING = (ConfigStringList)new ConfigStringList("entityWeaponMapping", ImmutableList.of((Object)"<default> => minecraft:mace, minecraft:netherite_sword, minecraft:diamond_sword, minecraft:iron_sword, minecraft:golden_sword, minecraft:stone_sword, minecraft:wooden_sword", (Object)"minecraft:end_crystal, minecraft:item_frame, minecraft:glow_item_frame, minecraft:leash_knot => <ignore>", (Object)"minecraft:minecart, minecraft:chest_minecart, minecraft:furnace_minecart, minecraft:hopper_minecart, minecraft:hopper_minecart, minecraft:spawner_minecart, minecraft:tnt_minecart, minecraft:oak_boat, minecraft:oak_chest_boat, minecraft:spruce_boat, minecraft:spruce_chest_boat, minecraft:birch_boat, minecraft:birch_chest_boat, minecraft:jungle_boat, minecraft:jungle_chest_boat, minecraft:acacia_boat, minecraft:acacia_chest_boat, minecraft:cherry_boat, minecraft:cherry_chest_boat, minecraft:dark_oak_boat, minecraft:dark_oak_chest_boat, minecraft:pale_oak_boat, minecraft:pale_oak_chest_boat, minecraft:mangrove_boat, minecraft:mangrove_chest_boat, minecraft:bamboo_raft, minecraft:bamboo_chest_raft=> minecraft:mace, minecraft:netherite_axe, minecraft:diamond_axe, minecraft:iron_axe, minecraft:golden_axe, minecraft:stone_axe, minecraft:wooden_axe")).apply("tweakeroo.config.lists");
        public static final ConfigOptionList FAST_PLACEMENT_ITEM_LIST_TYPE = (ConfigOptionList)new ConfigOptionList("fastPlacementItemListType", (IConfigOptionListEntry)UsageRestriction.ListType.BLACKLIST).apply("tweakeroo.config.lists");
        public static final ConfigStringList FAST_PLACEMENT_ITEM_BLACKLIST = (ConfigStringList)new ConfigStringList("fastPlacementItemBlackList", ImmutableList.of((Object)"minecraft:ender_chest", (Object)"minecraft:white_shulker_box")).apply("tweakeroo.config.lists");
        public static final ConfigStringList FAST_PLACEMENT_ITEM_WHITELIST = (ConfigStringList)new ConfigStringList("fastPlacementItemWhiteList", ImmutableList.of()).apply("tweakeroo.config.lists");
        public static final ConfigOptionList FAST_RIGHT_CLICK_BLOCK_LIST_TYPE = (ConfigOptionList)new ConfigOptionList("fastRightClickBlockListType", (IConfigOptionListEntry)UsageRestriction.ListType.BLACKLIST).apply("tweakeroo.config.lists");
        public static final ConfigStringList FAST_RIGHT_CLICK_BLOCK_BLACKLIST = (ConfigStringList)new ConfigStringList("fastRightClickBlockBlackList", ImmutableList.of((Object)"minecraft:chest", (Object)"minecraft:ender_chest", (Object)"minecraft:trapped_chest", (Object)"minecraft:white_shulker_box")).apply("tweakeroo.config.lists");
        public static final ConfigStringList FAST_RIGHT_CLICK_BLOCK_WHITELIST = (ConfigStringList)new ConfigStringList("fastRightClickBlockWhiteList", ImmutableList.of()).apply("tweakeroo.config.lists");
        public static final ConfigOptionList FAST_RIGHT_CLICK_ITEM_LIST_TYPE = (ConfigOptionList)new ConfigOptionList("fastRightClickListType", (IConfigOptionListEntry)UsageRestriction.ListType.NONE).apply("tweakeroo.config.lists");
        public static final ConfigStringList FAST_RIGHT_CLICK_ITEM_BLACKLIST = (ConfigStringList)new ConfigStringList("fastRightClickBlackList", ImmutableList.of((Object)"minecraft:firework_rocket")).apply("tweakeroo.config.lists");
        public static final ConfigStringList FAST_RIGHT_CLICK_ITEM_WHITELIST = (ConfigStringList)new ConfigStringList("fastRightClickWhiteList", ImmutableList.of((Object)"minecraft:bucket", (Object)"minecraft:water_bucket", (Object)"minecraft:lava_bucket", (Object)"minecraft:glass_bottle")).apply("tweakeroo.config.lists");
        public static final ConfigOptionList HAND_RESTOCK_LIST_TYPE = (ConfigOptionList)new ConfigOptionList("handRestockListType", (IConfigOptionListEntry)UsageRestriction.ListType.NONE).apply("tweakeroo.config.lists");
        public static final ConfigStringList HAND_RESTOCK_BLACKLIST = (ConfigStringList)new ConfigStringList("handRestockBlackList", ImmutableList.of((Object)"minecraft:bucket", (Object)"minecraft:lava_bucket", (Object)"minecraft:water_bucket")).apply("tweakeroo.config.lists");
        public static final ConfigStringList HAND_RESTOCK_WHITELIST = (ConfigStringList)new ConfigStringList("handRestockWhiteList", ImmutableList.of()).apply("tweakeroo.config.lists");
        public static final ConfigOptionList POTION_WARNING_LIST_TYPE = (ConfigOptionList)new ConfigOptionList("potionWarningListType", (IConfigOptionListEntry)UsageRestriction.ListType.NONE).apply("tweakeroo.config.lists");
        public static final ConfigStringList POTION_WARNING_BLACKLIST = (ConfigStringList)new ConfigStringList("potionWarningBlackList", ImmutableList.of((Object)"minecraft:hunger", (Object)"minecraft:mining_fatigue", (Object)"minecraft:nausea", (Object)"minecraft:poison", (Object)"minecraft:slowness", (Object)"minecraft:weakness")).apply("tweakeroo.config.lists");
        public static final ConfigStringList POTION_WARNING_WHITELIST = (ConfigStringList)new ConfigStringList("potionWarningWhiteList", ImmutableList.of((Object)"minecraft:fire_resistance", (Object)"minecraft:invisibility", (Object)"minecraft:water_breathing")).apply("tweakeroo.config.lists");
        public static final ConfigStringList REPAIR_MODE_SLOTS = (ConfigStringList)new ConfigStringList("repairModeSlots", ImmutableList.of((Object)"mainhand", (Object)"offhand")).apply("tweakeroo.config.lists");
        public static final ConfigOptionList SELECTIVE_BLOCKS_LIST_TYPE = (ConfigOptionList)new ConfigOptionList("selectiveBlocksListType", (IConfigOptionListEntry)UsageRestriction.ListType.NONE).apply("tweakeroo.config.lists");
        public static final ConfigString SELECTIVE_BLOCKS_WHITELIST = (ConfigString)new ConfigString("selectiveBlocksWhitelist", "").apply("tweakeroo.config.lists");
        public static final ConfigString SELECTIVE_BLOCKS_BLACKLIST = (ConfigString)new ConfigString("selectiveBlocksBlacklist", "").apply("tweakeroo.config.lists");
        public static final ConfigStringList SILK_TOUCH_OVERRIDE = (ConfigStringList)new ConfigStringList("silkTouchOverride", ImmutableList.of()).apply("tweakeroo.config.lists");
        public static final ConfigStringList UNSTACKING_ITEMS = (ConfigStringList)new ConfigStringList("unstackingItems", ImmutableList.of((Object)"minecraft:bucket", (Object)"minecraft:glass_bottle")).apply("tweakeroo.config.lists");
        public static final ImmutableList<IConfigBase> OPTIONS = ImmutableList.of((Object)BLOCK_TYPE_BREAK_RESTRICTION_LIST_TYPE, (Object)BLOCK_TYPE_BREAK_RESTRICTION_BLACKLIST, (Object)BLOCK_TYPE_BREAK_RESTRICTION_WHITELIST, (Object)ENTITY_TYPE_ATTACK_RESTRICTION_LIST_TYPE, (Object)ENTITY_TYPE_ATTACK_RESTRICTION_BLACKLIST, (Object)ENTITY_TYPE_ATTACK_RESTRICTION_WHITELIST, (Object)ENTITY_WEAPON_MAPPING, (Object)FAST_PLACEMENT_ITEM_LIST_TYPE, (Object)FAST_RIGHT_CLICK_BLOCK_LIST_TYPE, (Object)FAST_RIGHT_CLICK_ITEM_LIST_TYPE, (Object)POTION_WARNING_LIST_TYPE, (Object)FAST_PLACEMENT_ITEM_BLACKLIST, (Object[])new IConfigBase[]{FAST_PLACEMENT_ITEM_WHITELIST, FAST_RIGHT_CLICK_BLOCK_BLACKLIST, FAST_RIGHT_CLICK_BLOCK_WHITELIST, FAST_RIGHT_CLICK_ITEM_BLACKLIST, FAST_RIGHT_CLICK_ITEM_WHITELIST, HAND_RESTOCK_LIST_TYPE, HAND_RESTOCK_BLACKLIST, HAND_RESTOCK_WHITELIST, POTION_WARNING_BLACKLIST, POTION_WARNING_WHITELIST, REPAIR_MODE_SLOTS, SILK_TOUCH_OVERRIDE, UNSTACKING_ITEMS, SELECTIVE_BLOCKS_LIST_TYPE, SELECTIVE_BLOCKS_WHITELIST, SELECTIVE_BLOCKS_BLACKLIST});
    }

    public static class Disable {
        public static final ConfigBooleanHotkeyed DISABLE_ARMOR_STAND_RENDERING = new ConfigBooleanHotkeyed("disableArmorStandRendering", false, "").apply("tweakeroo.config.disable");
        public static final ConfigBooleanHotkeyed DISABLE_ATMOSPHERIC_FOG = new ConfigBooleanHotkeyed("disableAtmosphericFog", false, "").apply("tweakeroo.config.disable");
        public static final ConfigBooleanHotkeyed DISABLE_AXE_STRIPPING = new ConfigBooleanHotkeyed("disableAxeStripping", false, "").apply("tweakeroo.config.disable");
        public static final ConfigBooleanHotkeyed DISABLE_BAT_SPAWNING = new ConfigBooleanClient("disableBatSpawning", false, "").apply("tweakeroo.config.disable");
        public static final ConfigBooleanHotkeyed DISABLE_BEACON_BEAM_RENDERING = new ConfigBooleanHotkeyed("disableBeaconBeamRendering", false, "").apply("tweakeroo.config.disable");
        public static final ConfigBooleanHotkeyed DISABLE_BLOCK_BREAK_PARTICLES = new ConfigBooleanHotkeyed("disableBlockBreakingParticles", false, "").apply("tweakeroo.config.disable");
        public static final ConfigBooleanHotkeyed DISABLE_BLOCK_BREAK_COOLDOWN = new ConfigBooleanHotkeyed("disableBlockBreakCooldown", false, "").apply("tweakeroo.config.disable");
        public static final ConfigBooleanHotkeyed DISABLE_DOUBLE_TAP_SPRINT = new ConfigBooleanHotkeyed("disableDoubleTapSprint", false, "").apply("tweakeroo.config.disable");
        public static final ConfigBooleanHotkeyed DISABLE_BOSS_BAR = new ConfigBooleanHotkeyed("disableBossBar", false, "").apply("tweakeroo.config.disable");
        public static final ConfigBooleanHotkeyed DISABLE_BOSS_FOG = new ConfigBooleanHotkeyed("disableBossFog", false, "").apply("tweakeroo.config.disable");
        public static final ConfigBooleanHotkeyed DISABLE_CHUNK_RENDERING = new ConfigBooleanHotkeyed("disableChunkRendering", false, "").apply("tweakeroo.config.disable");
        public static final ConfigBooleanHotkeyed DISABLE_CLIENT_ENTITY_UPDATES = new ConfigBooleanHotkeyed("disableClientEntityUpdates", false, "").apply("tweakeroo.config.disable");
        public static final ConfigBooleanHotkeyed DISABLE_CLIENT_LIGHT_UPDATES = new ConfigBooleanHotkeyed("disableClientLightUpdates", false, "").apply("tweakeroo.config.disable");
        public static final ConfigBooleanHotkeyed DISABLE_CONSTANT_CHUNK_SAVING = new ConfigBooleanHotkeyed("disableConstantChunkSaving", false, "").apply("tweakeroo.config.disable");
        public static final ConfigBooleanHotkeyed DISABLE_CREATIVE_INFESTED_BLOCKS = new ConfigBooleanHotkeyed("disableCreativeMenuInfestedBlocks", false, "").apply("tweakeroo.config.disable");
        public static final ConfigBooleanHotkeyed DISABLE_DEAD_MOB_RENDERING = new ConfigBooleanHotkeyed("disableDeadMobRendering", false, "").apply("tweakeroo.config.disable");
        public static final ConfigBooleanHotkeyed DISABLE_DEAD_MOB_TARGETING = new ConfigBooleanHotkeyed("disableDeadMobTargeting", false, "").apply("tweakeroo.config.disable");
        public static final ConfigBooleanHotkeyed DISABLE_ENTITY_RENDERING = new ConfigBooleanHotkeyed("disableEntityRendering", false, "").apply("tweakeroo.config.disable");
        public static final ConfigBooleanHotkeyed DISABLE_ENTITY_TICKING = new ConfigBooleanClient("disableEntityTicking", false, "").apply("tweakeroo.config.disable");
        public static final ConfigBooleanHotkeyed DISABLE_FALLING_BLOCK_RENDER = new ConfigBooleanHotkeyed("disableFallingBlockEntityRendering", false, "").apply("tweakeroo.config.disable");
        public static final ConfigBooleanHotkeyed DISABLE_FP_EFFECT_PARTICLES = new ConfigBooleanHotkeyed("disableFirstPersonEffectParticles", false, "").apply("tweakeroo.config.disable");
        public static final ConfigBooleanHotkeyed DISABLE_INVENTORY_EFFECTS = new ConfigBooleanHotkeyed("disableInventoryEffectRendering", false, "").apply("tweakeroo.config.disable");
        public static final ConfigBooleanHotkeyed DISABLE_ITEM_SWITCH_COOLDOWN = new ConfigBooleanHotkeyed("disableItemSwitchRenderCooldown", false, "").apply("tweakeroo.config.disable");
        public static final ConfigBooleanHotkeyed DISABLE_MOB_SPAWNER_MOB_RENDER = new ConfigBooleanHotkeyed("disableMobSpawnerMobRendering", false, "").apply("tweakeroo.config.disable");
        public static final ConfigBooleanHotkeyed DISABLE_NAUSEA_EFFECT = new ConfigBooleanHotkeyed("disableNauseaEffect", false, "").apply("tweakeroo.config.disable");
        public static final ConfigBooleanHotkeyed DISABLE_NETHER_FOG = new ConfigBooleanHotkeyed("disableNetherFog", false, "").apply("tweakeroo.config.disable");
        public static final ConfigBooleanHotkeyed DISABLE_NETHER_PORTAL_SOUND = new ConfigBooleanHotkeyed("disableNetherPortalSound", false, "").apply("tweakeroo.config.disable");
        public static final ConfigBooleanHotkeyed DISABLE_OBSERVER = new ConfigBooleanClient("disableObserver", false, "").apply("tweakeroo.config.disable");
        public static final ConfigBooleanHotkeyed DISABLE_OFFHAND_RENDERING = new ConfigBooleanHotkeyed("disableOffhandRendering", false, "").apply("tweakeroo.config.disable");
        public static final ConfigBooleanHotkeyed DISABLE_PARTICLES = new ConfigBooleanHotkeyed("disableParticles", false, "").apply("tweakeroo.config.disable");
        public static final ConfigBooleanHotkeyed DISABLE_PORTAL_GUI_CLOSING = new ConfigBooleanHotkeyed("disablePortalGuiClosing", false, "").apply("tweakeroo.config.disable");
        public static final ConfigBooleanHotkeyed DISABLE_RAIN_EFFECTS = new ConfigBooleanHotkeyed("disableRainEffects", false, "").apply("tweakeroo.config.disable");
        public static final ConfigBooleanHotkeyed DISABLE_RENDERING_SCAFFOLDING = new ConfigBooleanHotkeyed("disableRenderingScaffolding", false, "").apply("tweakeroo.config.disable");
        public static final ConfigBooleanHotkeyed DISABLE_RENDER_DISTANCE_FOG = new ConfigBooleanHotkeyed("disableRenderDistanceFog", false, "").apply("tweakeroo.config.disable");
        public static final ConfigBooleanHotkeyed DISABLE_SCOREBOARD_RENDERING = new ConfigBooleanHotkeyed("disableScoreboardRendering", false, "").apply("tweakeroo.config.disable");
        public static final ConfigBooleanHotkeyed DISABLE_SHULKER_BOX_TOOLTIP = new ConfigBooleanHotkeyed("disableShulkerBoxTooltip", false, "").apply("tweakeroo.config.disable");
        public static final ConfigBooleanHotkeyed DISABLE_SHOVEL_PATHING = new ConfigBooleanHotkeyed("disableShovelPathing", false, "").apply("tweakeroo.config.disable");
        public static final ConfigBooleanHotkeyed DISABLE_SIGN_GUI = new ConfigBooleanHotkeyed("disableSignGui", false, "").apply("tweakeroo.config.disable");
        public static final ConfigBooleanHotkeyed DISABLE_SKY_DARKNESS = new ConfigBooleanHotkeyed("disableSkyDarkness", false, "").apply("tweakeroo.config.disable");
        public static final ConfigBooleanHotkeyed DISABLE_SLIME_BLOCK_SLOWDOWN = new ConfigBooleanHotkeyed("disableSlimeBlockSlowdown", false, "").apply("tweakeroo.config.disable");
        public static final ConfigBooleanHotkeyed DISABLE_STATUS_EFFECT_HUD = new ConfigBooleanHotkeyed("disableStatusEffectHud", false, "").apply("tweakeroo.config.disable");
        public static final ConfigBooleanHotkeyed DISABLE_TILE_ENTITY_RENDERING = new ConfigBooleanHotkeyed("disableTileEntityRendering", false, "").apply("tweakeroo.config.disable");
        public static final ConfigBooleanHotkeyed DISABLE_TILE_ENTITY_TICKING = new ConfigBooleanClient("disableTileEntityTicking", false, "").apply("tweakeroo.config.disable");
        public static final ConfigBooleanHotkeyed DISABLE_VILLAGER_TRADE_LOCKING = new ConfigBooleanClient("disableVillagerTradeLocking", false, "").apply("tweakeroo.config.disable");
        public static final ConfigBooleanHotkeyed DISABLE_WALL_UNSPRINT = new ConfigBooleanHotkeyed("disableWallUnsprint", false, "").apply("tweakeroo.config.disable");
        public static final ConfigBooleanHotkeyed DISABLE_WORLD_VIEW_BOB = new ConfigBooleanHotkeyed("disableWorldViewBob", false, "").apply("tweakeroo.config.disable");
        public static final ImmutableList<IHotkeyTogglable> OPTIONS = ImmutableList.of((Object)DISABLE_ARMOR_STAND_RENDERING, (Object)DISABLE_ATMOSPHERIC_FOG, (Object)DISABLE_AXE_STRIPPING, (Object)DISABLE_BAT_SPAWNING, (Object)DISABLE_BEACON_BEAM_RENDERING, (Object)DISABLE_BLOCK_BREAK_PARTICLES, (Object)DISABLE_BLOCK_BREAK_COOLDOWN, (Object)DISABLE_DOUBLE_TAP_SPRINT, (Object)DISABLE_BOSS_BAR, (Object)DISABLE_BOSS_FOG, (Object)DISABLE_CHUNK_RENDERING, (Object)DISABLE_CLIENT_ENTITY_UPDATES, (Object[])new IHotkeyTogglable[]{DISABLE_CLIENT_LIGHT_UPDATES, DISABLE_CONSTANT_CHUNK_SAVING, DISABLE_CREATIVE_INFESTED_BLOCKS, DISABLE_DEAD_MOB_RENDERING, DISABLE_DEAD_MOB_TARGETING, DISABLE_ENTITY_RENDERING, DISABLE_ENTITY_TICKING, DISABLE_FALLING_BLOCK_RENDER, DISABLE_FP_EFFECT_PARTICLES, DISABLE_INVENTORY_EFFECTS, DISABLE_ITEM_SWITCH_COOLDOWN, DISABLE_MOB_SPAWNER_MOB_RENDER, DISABLE_NAUSEA_EFFECT, DISABLE_NETHER_FOG, DISABLE_NETHER_PORTAL_SOUND, DISABLE_OBSERVER, DISABLE_OFFHAND_RENDERING, DISABLE_PARTICLES, DISABLE_PORTAL_GUI_CLOSING, DISABLE_RAIN_EFFECTS, DISABLE_RENDERING_SCAFFOLDING, DISABLE_RENDER_DISTANCE_FOG, DISABLE_SCOREBOARD_RENDERING, DISABLE_SHULKER_BOX_TOOLTIP, DISABLE_SHOVEL_PATHING, DISABLE_SIGN_GUI, DISABLE_SKY_DARKNESS, DISABLE_SLIME_BLOCK_SLOWDOWN, DISABLE_STATUS_EFFECT_HUD, DISABLE_TILE_ENTITY_RENDERING, DISABLE_TILE_ENTITY_TICKING, DISABLE_VILLAGER_TRADE_LOCKING, DISABLE_WALL_UNSPRINT, DISABLE_WORLD_VIEW_BOB});
    }
}

