/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tweakeroo.gui.widgets;

import fi.dy.masa.malilib.gui.LeftRight;
import fi.dy.masa.malilib.gui.MaLiLibIcons;
import fi.dy.masa.malilib.gui.interfaces.IGuiIcon;
import fi.dy.masa.malilib.gui.interfaces.ISelectionListener;
import fi.dy.masa.malilib.gui.widgets.WidgetListBase;
import fi.dy.masa.malilib.gui.widgets.WidgetSearchBar;
import fi.dy.masa.tweakeroo.data.CameraPresetManager;
import fi.dy.masa.tweakeroo.gui.GuiCameraPresetEditor;
import fi.dy.masa.tweakeroo.gui.widgets.WidgetCameraPresetEntry;
import fi.dy.masa.tweakeroo.util.CameraPreset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_11908;
import net.minecraft.class_1937;
import net.minecraft.class_332;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;

public class WidgetCameraPresetList
extends WidgetListBase<CameraPreset, WidgetCameraPresetEntry> {
    private final GuiCameraPresetEditor parent;
    private List<CameraPreset> presets;
    private final class_5321<class_1937> dimKey;
    private static int lastScrollbarPosition;
    private boolean scrollbarRestored;

    public WidgetCameraPresetList(int x, int y, int width, int height, @Nullable class_5321<class_1937> dimKey, @Nullable GuiCameraPresetEditor parent) {
        super(x, y, width, height, (ISelectionListener)parent);
        this.parent = parent;
        this.widgetSearchBar = new WidgetSearchBar(x + 2, y + 8, width - 14, 14, 0, (IGuiIcon)MaLiLibIcons.SEARCH, LeftRight.LEFT);
        this.widgetSearchBar.setZLevel(1);
        this.dimKey = dimKey;
        this.browserEntriesOffsetY = 17;
        this.browserEntryHeight = 22;
        this.presets = new ArrayList<CameraPreset>();
        this.updatePresets();
    }

    private void updatePresets() {
        this.presets.clear();
        this.presets = this.dimKey == null || this.parent.shouldShowAll() ? CameraPresetManager.getInstance().toList() : CameraPresetManager.getInstance().toList(this.dimKey);
    }

    public GuiCameraPresetEditor getPresetEditorGui() {
        return this.parent;
    }

    public boolean onKeyTyped(class_11908 input) {
        if (input.comp_4795() == 256) {
            this.parent.method_25419();
        }
        return super.onKeyTyped(input);
    }

    public void drawContents(class_332 drawContext, int mouseX, int mouseY, float partialTicks) {
        super.drawContents(drawContext, mouseX, mouseY, partialTicks);
        lastScrollbarPosition = this.scrollBar.getValue();
    }

    protected void offsetSelectionOrScrollbar(int amount, boolean changeSelection) {
        super.offsetSelectionOrScrollbar(amount, changeSelection);
        lastScrollbarPosition = this.scrollBar.getValue();
    }

    protected Collection<CameraPreset> getAllEntries() {
        return this.presets;
    }

    protected List<String> getEntryStringsForFilter(CameraPreset entry) {
        ArrayList<String> list = new ArrayList<String>();
        if (entry != null) {
            list.add(Integer.toString(entry.getId()));
            list.add(entry.getName().toLowerCase());
            list.add(entry.getDim().method_12832().toLowerCase());
            return list;
        }
        return Collections.emptyList();
    }

    protected void refreshBrowserEntries() {
        super.refreshBrowserEntries();
        if (!this.scrollbarRestored && lastScrollbarPosition <= this.scrollBar.getMaxValue()) {
            this.scrollBar.setValue(lastScrollbarPosition);
            this.scrollbarRestored = true;
            this.reCreateListEntryWidgets();
        }
    }

    protected void reCreateListEntryWidgets() {
        this.updatePresets();
        super.reCreateListEntryWidgets();
    }

    protected WidgetCameraPresetEntry createListEntryWidget(int x, int y, int listIndex, boolean isOdd, CameraPreset entry) {
        return new WidgetCameraPresetEntry(x, y, this.browserEntryWidth, this.getBrowserEntryHeightFor(entry), isOdd, entry, listIndex, this);
    }
}

