/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tweakeroo.mixin.network;

import fi.dy.masa.tweakeroo.config.Configs;
import fi.dy.masa.tweakeroo.config.FeatureToggle;
import fi.dy.masa.tweakeroo.tweaks.MiscTweaks;
import fi.dy.masa.tweakeroo.tweaks.PlacementTweaks;
import fi.dy.masa.tweakeroo.util.CameraUtils;
import fi.dy.masa.tweakeroo.util.InventoryUtils;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_636;
import net.minecraft.class_746;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_636.class})
public abstract class MixinClientPlayerInteractionManager {
    @Shadow
    @Final
    private class_310 field_3712;
    @Shadow
    private int field_3716;

    @Shadow
    public abstract class_1269 method_2896(class_746 var1, class_1268 var2, class_3965 var3);

    @Inject(method={"interactItem"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/network/ClientPlayerInteractionManager;syncSelectedSlot()V")}, cancellable=true)
    private void tweakeroo_onProcessRightClickFirst(class_1657 player, class_1268 hand, CallbackInfoReturnable<class_1269> cir) {
        if (CameraUtils.shouldPreventPlayerInputs() || PlacementTweaks.onProcessRightClickPre(player, hand)) {
            cir.setReturnValue((Object)class_1269.field_5811);
            cir.cancel();
        }
    }

    @Inject(method={"interactItem"}, at={@At(value="TAIL")})
    private void tweakeroo_onProcessRightClickPost(class_1657 player, class_1268 hand, CallbackInfoReturnable<class_1269> cir) {
        if (((class_1269)cir.getReturnValue()).method_23665()) {
            PlacementTweaks.onProcessRightClickPost(player, hand);
        }
    }

    @Inject(method={"interactEntity(Lnet/minecraft/entity/player/PlayerEntity;Lnet/minecraft/entity/Entity;Lnet/minecraft/util/Hand;)Lnet/minecraft/util/ActionResult;"}, at={@At(value="HEAD")}, cancellable=true)
    private void tweakeroo_onRightClickMouseOnEntityPre1(class_1657 player, class_1297 target, class_1268 hand, CallbackInfoReturnable<class_1269> cir) {
        if (CameraUtils.shouldPreventPlayerInputs() || PlacementTweaks.onProcessRightClickPre(player, hand)) {
            cir.setReturnValue((Object)class_1269.field_5811);
        }
    }

    @Inject(method={"interactEntityAtLocation(Lnet/minecraft/entity/player/PlayerEntity;Lnet/minecraft/entity/Entity;Lnet/minecraft/util/hit/EntityHitResult;Lnet/minecraft/util/Hand;)Lnet/minecraft/util/ActionResult;"}, at={@At(value="HEAD")}, cancellable=true)
    private void tweakeroo_onRightClickMouseOnEntityPre2(class_1657 player, class_1297 target, class_3966 trace, class_1268 hand, CallbackInfoReturnable<class_1269> cir) {
        if (CameraUtils.shouldPreventPlayerInputs() || PlacementTweaks.onProcessRightClickPre(player, hand)) {
            cir.setReturnValue((Object)class_1269.field_5811);
        }
    }

    @Inject(method={"attackEntity"}, at={@At(value="HEAD")}, cancellable=true)
    private void tweakeroo_preventEntityAttacksInFreeCameraMode(class_1657 player, class_1297 target, CallbackInfo ci) {
        if (CameraUtils.shouldPreventPlayerInputs()) {
            ci.cancel();
        } else if (FeatureToggle.TWEAK_ENTITY_TYPE_ATTACK_RESTRICTION.getBooleanValue() && !MiscTweaks.isEntityAllowedByAttackingRestriction(target.method_5864())) {
            ci.cancel();
        } else if (FeatureToggle.TWEAK_WEAPON_SWITCH.getBooleanValue()) {
            InventoryUtils.trySwitchToWeapon(target);
        }
    }

    @Inject(method={"attackBlock"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/world/ClientWorld;getBlockState(Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/block/BlockState;", ordinal=2)})
    private void tweakeroo_onClickBlockPre(class_2338 pos, class_2350 face, CallbackInfoReturnable<Boolean> cir) {
        if (this.field_3712.field_1724 != null && this.field_3712.field_1687 != null) {
            if (FeatureToggle.TWEAK_TOOL_SWITCH.getBooleanValue()) {
                InventoryUtils.trySwitchToEffectiveTool(pos);
            }
            PlacementTweaks.cacheStackInHand(class_1268.field_5808);
        }
    }

    @Inject(method={"attackBlock"}, at={@At(value="HEAD")}, cancellable=true)
    private void tweakeroo_handleBreakingRestriction1(class_2338 pos, class_2350 side, CallbackInfoReturnable<Boolean> cir) {
        if (FeatureToggle.TWEAK_AREA_SELECTOR.getBooleanValue() || CameraUtils.shouldPreventPlayerInputs() || !PlacementTweaks.isPositionAllowedByBreakingRestriction(pos, side)) {
            cir.setReturnValue((Object)false);
        } else {
            InventoryUtils.trySwapCurrentToolIfNearlyBroken();
        }
    }

    @Inject(method={"attackBlock"}, at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraft/client/network/ClientPlayerInteractionManager;sendSequencedPacket(Lnet/minecraft/client/world/ClientWorld;Lnet/minecraft/client/network/SequencedPacketCreator;)V")})
    private void tweakeroo_handleBreakReplaceInAttack(class_2338 targetPos, class_2350 side, CallbackInfoReturnable<Boolean> cir) {
        if (FeatureToggle.TWEAK_BREAK_REPLACE.getBooleanValue() && this.field_3712.field_1687 != null && this.field_3712.field_1724 != null && this.field_3712.field_1687.method_8320(targetPos).method_26215()) {
            class_3965 blockHitResult = new class_3965(targetPos.method_46558(), side, targetPos, false);
            for (class_1268 hand : class_1268.values()) {
                class_1799 stack = this.field_3712.field_1724.method_5998(hand);
                if (stack == null || !(stack.method_7909() instanceof class_1747) || !this.method_2896(this.field_3712.field_1724, hand, blockHitResult).method_23665()) continue;
                if (!this.field_3712.field_1724.method_31549().field_7477) {
                    this.field_3716 = 1;
                }
                return;
            }
        }
    }

    @Inject(method={"updateBlockBreakingProgress"}, at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraft/client/network/ClientPlayerInteractionManager;sendSequencedPacket(Lnet/minecraft/client/world/ClientWorld;Lnet/minecraft/client/network/SequencedPacketCreator;)V")})
    private void tweakeroo_handleBreakReplaceInUpdate(class_2338 targetPos, class_2350 side, CallbackInfoReturnable<Boolean> cir) {
        if (FeatureToggle.TWEAK_BREAK_REPLACE.getBooleanValue() && this.field_3712.field_1687 != null && this.field_3712.field_1724 != null && this.field_3712.field_1687.method_8320(targetPos).method_26215()) {
            class_3965 blockHitResult = new class_3965(targetPos.method_46558(), side, targetPos, false);
            for (class_1268 hand : class_1268.values()) {
                class_1799 stack = this.field_3712.field_1724.method_5998(hand);
                if (stack == null || !(stack.method_7909() instanceof class_1747) || !this.method_2896(this.field_3712.field_1724, hand, blockHitResult).method_23665()) continue;
                return;
            }
        }
    }

    @Inject(method={"updateBlockBreakingProgress"}, at={@At(value="HEAD")}, cancellable=true)
    private void tweakeroo_handleBreakingRestriction2(class_2338 pos, class_2350 side, CallbackInfoReturnable<Boolean> cir) {
        if (Configs.Disable.DISABLE_BLOCK_BREAK_COOLDOWN.getBooleanValue()) {
            this.field_3716 = 0;
        }
        if (FeatureToggle.TWEAK_AREA_SELECTOR.getBooleanValue() || CameraUtils.shouldPreventPlayerInputs() || !PlacementTweaks.isPositionAllowedByBreakingRestriction(pos, side)) {
            cir.setReturnValue((Object)true);
        } else {
            InventoryUtils.trySwapCurrentToolIfNearlyBroken();
        }
    }

    @Inject(method={"hasLimitedAttackSpeed"}, at={@At(value="HEAD")}, cancellable=true)
    private void tweakeroo_overrideLimitedAttackSpeed(CallbackInfoReturnable<Boolean> cir) {
        if (FeatureToggle.TWEAK_FAST_LEFT_CLICK.getBooleanValue()) {
            cir.setReturnValue((Object)false);
        }
    }
}

