/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tweakeroo.util;

import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.util.EquipmentUtils;
import fi.dy.masa.malilib.util.GuiUtils;
import fi.dy.masa.malilib.util.InfoUtils;
import fi.dy.masa.tweakeroo.Tweakeroo;
import fi.dy.masa.tweakeroo.config.Configs;
import fi.dy.masa.tweakeroo.config.FeatureToggle;
import fi.dy.masa.tweakeroo.data.CachedTagManager;
import fi.dy.masa.tweakeroo.mixin.block.IMixinAbstractBlock;
import fi.dy.masa.tweakeroo.tweaks.PlacementTweaks;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.class_10192;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1723;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1814;
import net.minecraft.class_1893;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2868;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.minecraft.class_6019;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import net.minecraft.class_9274;
import net.minecraft.class_9334;
import org.apache.commons.lang3.tuple.Pair;

public class InventoryUtils {
    private static final List<class_1304> REPAIR_MODE_SLOTS = new ArrayList<class_1304>();
    private static final List<Integer> REPAIR_MODE_SLOT_NUMBERS = new ArrayList<Integer>();
    private static final HashSet<class_1792> UNSTACKING_ITEMS = new HashSet();
    private static final List<Integer> TOOL_SWITCHABLE_SLOTS = new ArrayList<Integer>();
    private static final List<Integer> TOOL_SWITCH_IGNORED_SLOTS = new ArrayList<Integer>();
    private static final HashMap<class_1299<?>, HashSet<class_1792>> WEAPON_MAPPING = new HashMap();
    private static boolean needsCache = false;

    public static void setToolSwitchableSlots(String configStr) {
        InventoryUtils.parseSlotsFromString(configStr, TOOL_SWITCHABLE_SLOTS);
    }

    public static void setToolSwitchIgnoreSlots(String configStr) {
        InventoryUtils.parseSlotsFromString(configStr, TOOL_SWITCH_IGNORED_SLOTS);
    }

    public static void parseSlotsFromString(String configStr, Collection<Integer> output) {
        String[] parts = configStr.split(",");
        Pattern patternRange = Pattern.compile("^(?<start>[0-9])-(?<end>[0-9])$");
        output.clear();
        if (configStr.isBlank()) {
            return;
        }
        for (String str : parts) {
            try {
                Matcher matcher = patternRange.matcher(str);
                if (matcher.matches()) {
                    int slotEnd;
                    int slotStart = Integer.parseInt(matcher.group("start")) - 1;
                    if (slotStart > (slotEnd = Integer.parseInt(matcher.group("end")) - 1) || !class_1661.method_7380((int)slotStart) || !class_1661.method_7380((int)slotEnd)) continue;
                    for (int slotNum = slotStart; slotNum <= slotEnd; ++slotNum) {
                        if (output.contains(slotNum)) continue;
                        output.add(slotNum);
                    }
                    continue;
                }
                int slotNum = Integer.parseInt(str) - 1;
                if (!class_1661.method_7380((int)slotNum) || output.contains(slotNum)) continue;
                output.add(slotNum);
            }
            catch (NumberFormatException ignore) {
                InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)"Failed to parse slots from string %s", (Object[])new Object[]{configStr});
            }
        }
    }

    public static void setUnstackingItems(List<String> names) {
        UNSTACKING_ITEMS.clear();
        for (String name : names) {
            try {
                Optional opt = class_7923.field_41178.method_10223(class_2960.method_12829((String)name));
                if (!opt.isPresent() || ((class_6880.class_6883)opt.get()).comp_349() == class_1802.field_8162) continue;
                UNSTACKING_ITEMS.add((class_1792)((class_6880.class_6883)opt.get()).comp_349());
            }
            catch (Exception e) {
                Tweakeroo.LOGGER.warn("Failed to set an unstacking protected item from name '{}'", (Object)name, (Object)e);
            }
        }
    }

    public static void setRepairModeSlots(List<String> names) {
        REPAIR_MODE_SLOTS.clear();
        REPAIR_MODE_SLOT_NUMBERS.clear();
        Iterator<String> iterator = names.iterator();
        while (iterator.hasNext()) {
            class_1304 type;
            String name;
            if ((type = (switch (name = iterator.next()) {
                case "mainhand" -> class_1304.field_6173;
                case "offhand" -> class_1304.field_6171;
                case "head" -> class_1304.field_6169;
                case "chest" -> class_1304.field_6174;
                case "legs" -> class_1304.field_6172;
                case "feet" -> class_1304.field_6166;
                default -> null;
            })) == null) continue;
            REPAIR_MODE_SLOTS.add(type);
            int slotNum = InventoryUtils.getSlotNumberForEquipmentType(type, null);
            if (slotNum < 0) continue;
            REPAIR_MODE_SLOT_NUMBERS.add(slotNum);
        }
    }

    public static void setWeaponMapping(List<String> mappings) {
        WEAPON_MAPPING.clear();
        for (String mapping : mappings) {
            Optional opt2;
            String[] split = mapping.replaceAll(" ", "").split("=>");
            if (split.length != 2) {
                Tweakeroo.LOGGER.warn("Expected weapon mapping to be `entity_ids => weapon_ids` got '{}'", (Object)mapping);
                continue;
            }
            HashSet<class_1792> weapons = new HashSet<class_1792>();
            String entities = split[0].trim();
            String items = split[1].trim();
            if (!items.equals("<ignore>")) {
                for (String itemId : items.split(",")) {
                    try {
                        opt2 = class_7923.field_41178.method_10223(class_2960.method_12829((String)itemId));
                        if (opt2.isPresent()) {
                            weapons.add((class_1792)((class_6880.class_6883)opt2.get()).comp_349());
                            continue;
                        }
                    }
                    catch (Exception opt2) {
                        // empty catch block
                    }
                    Tweakeroo.LOGGER.warn("Unable to find item to use as weapon: '{}'", (Object)itemId);
                }
            }
            if (entities.equalsIgnoreCase("<default>")) {
                WEAPON_MAPPING.computeIfAbsent(null, s -> new HashSet()).addAll(weapons);
                continue;
            }
            for (String entity_id : entities.split(",")) {
                try {
                    opt2 = class_7923.field_41177.method_10223(class_2960.method_12829((String)entity_id));
                    if (opt2.isPresent()) {
                        WEAPON_MAPPING.computeIfAbsent((class_1299)((class_6880.class_6883)opt2.get()).comp_349(), s -> new HashSet()).addAll(weapons);
                        continue;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Tweakeroo.LOGGER.warn("Unable to find entity: '{}'", (Object)entity_id);
            }
        }
    }

    private static boolean isConfiguredRepairSlot(int slotNum, class_1657 player) {
        if (REPAIR_MODE_SLOTS.contains(class_1304.field_6173) && slotNum - 36 == player.method_31548().method_67532()) {
            return true;
        }
        return REPAIR_MODE_SLOT_NUMBERS.contains(slotNum);
    }

    @Nullable
    private static class_1304 getEquipmentTypeForSlot(int slotNum, class_1657 player) {
        if (REPAIR_MODE_SLOTS.contains(class_1304.field_6173) && slotNum - 36 == player.method_31548().method_67532()) {
            return class_1304.field_6173;
        }
        return switch (slotNum) {
            case 45 -> class_1304.field_6171;
            case 5 -> class_1304.field_6169;
            case 6 -> class_1304.field_6174;
            case 7 -> class_1304.field_6172;
            case 8 -> class_1304.field_6166;
            default -> null;
        };
    }

    private static int getSlotNumberForEquipmentType(class_1304 type, @Nullable class_1657 player) {
        return switch (type) {
            case class_1304.field_6173 -> {
                if (player != null) {
                    yield player.method_31548().method_67532() + 36;
                }
                yield -1;
            }
            case class_1304.field_6171 -> 45;
            case class_1304.field_6169 -> 5;
            case class_1304.field_6174 -> 6;
            case class_1304.field_6172 -> 7;
            case class_1304.field_6166 -> 8;
            default -> -1;
        };
    }

    public static void swapHotbarWithInventoryRow(class_1657 player, int row) {
        class_1723 container = player.field_7498;
        row = class_3532.method_15340((int)row, (int)0, (int)2);
        int slot = row * 9 + 9;
        for (int hotbarSlot = 0; hotbarSlot < 9; ++hotbarSlot) {
            fi.dy.masa.malilib.util.InventoryUtils.swapSlots((class_1703)container, (int)slot, (int)hotbarSlot);
            ++slot;
        }
    }

    public static void restockNewStackToHand(class_1657 player, class_1268 hand, class_1799 stackReference, boolean allowHotbar) {
        int slotWithItem;
        if (stackReference.method_7963()) {
            int minDurability = InventoryUtils.getMinDurability(stackReference);
            slotWithItem = InventoryUtils.findSlotWithSuitableReplacementToolWithDurabilityLeft((class_1703)player.field_7498, stackReference, minDurability);
        } else {
            slotWithItem = InventoryUtils.findSlotWithItem((class_1703)player.field_7498, stackReference, allowHotbar, true);
        }
        if (slotWithItem != -1) {
            InventoryUtils.swapItemToHand(player, hand, slotWithItem);
        }
    }

    public static void preRestockHand(class_1657 player, class_1268 hand, boolean allowHotbar) {
        class_1799 stackHand = player.method_5998(hand);
        int threshold = Configs.Generic.HAND_RESTOCK_PRE_THRESHOLD.getIntegerValue();
        if (FeatureToggle.TWEAK_HAND_RESTOCK.getBooleanValue() && Configs.Generic.HAND_RESTOCK_PRE.getBooleanValue() && !stackHand.method_7960() && stackHand.method_7947() <= threshold && stackHand.method_7914() > threshold && PlacementTweaks.canUseItemWithRestriction(PlacementTweaks.HAND_RESTOCK_RESTRICTION, stackHand) && player.field_7512 == player.field_7498 && player.field_7512.method_34255().method_7960()) {
            class_310 mc = class_310.method_1551();
            class_1723 container = player.field_7498;
            int endSlot = allowHotbar ? 44 : 35;
            int currentMainHandSlot = player.method_31548().method_67532() + 36;
            int currentSlot = hand == class_1268.field_5808 ? currentMainHandSlot : 45;
            for (int slotNum = 9; slotNum <= endSlot; ++slotNum) {
                class_1735 slot;
                class_1799 stackSlot;
                if (slotNum == currentMainHandSlot || !fi.dy.masa.malilib.util.InventoryUtils.areStacksEqualIgnoreDurability((class_1799)(stackSlot = (slot = (class_1735)container.field_7761.get(slotNum)).method_7677()), (class_1799)stackHand)) continue;
                int button = stackSlot.method_7947() + stackHand.method_7947() <= stackHand.method_7914() ? 0 : 1;
                mc.field_1761.method_2906(container.field_7763, slot.field_7874, button, class_1713.field_7790, player);
                mc.field_1761.method_2906(container.field_7763, currentSlot, 0, class_1713.field_7790, player);
                break;
            }
        }
    }

    public static void trySwapCurrentToolIfNearlyBroken() {
        class_746 player = class_310.method_1551().field_1724;
        if (FeatureToggle.TWEAK_SWAP_ALMOST_BROKEN_TOOLS.getBooleanValue() && player != null) {
            InventoryUtils.trySwapCurrentToolIfNearlyBroken(class_1268.field_5808, (class_1657)player);
            InventoryUtils.trySwapCurrentToolIfNearlyBroken(class_1268.field_5810, (class_1657)player);
        }
    }

    public static void trySwapCurrentToolIfNearlyBroken(class_1268 hand, class_1657 player) {
        int minDurability;
        class_1799 stack = player.method_5998(hand);
        if (!stack.method_7960() && InventoryUtils.isItemAtLowDurability(stack, minDurability = InventoryUtils.getMinDurability(stack))) {
            InventoryUtils.swapItemWithHigherDurabilityToHand(player, hand, stack, minDurability + 1);
        }
    }

    public static void trySwitchToWeapon(class_1297 entity) {
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        if (player != null && mc.field_1687 != null && !TOOL_SWITCH_IGNORED_SLOTS.contains(player.method_31548().method_67532())) {
            class_1723 container = player.field_7498;
            if (player.method_6047().method_31574(class_1802.field_49814)) {
                return;
            }
            ItemPickerTest test = FeatureToggle.TWEAK_SWAP_ALMOST_BROKEN_TOOLS.getBooleanValue() ? (currentStack, previous) -> InventoryUtils.isBetterWeaponAndHasDurability(currentStack, previous, entity) : (currentStack, previous) -> InventoryUtils.isBetterWeapon(currentStack, previous, entity);
            int slotNumber = InventoryUtils.findSlotWithBestItemMatch((class_1703)container, test, class_6019.method_35017((int)36, (int)44), class_6019.method_35017((int)9, (int)35));
            if (slotNumber != -1 && slotNumber - 36 != player.method_31548().method_67532()) {
                InventoryUtils.swapToolToHand(slotNumber, mc);
                PlacementTweaks.cacheStackInHand(class_1268.field_5808);
            }
        }
    }

    private static boolean isBetterWeapon(class_1799 testedStack, class_1799 previousWeapon, class_1297 entity) {
        boolean isWeapon = EquipmentUtils.isAnyWeapon((class_1799)testedStack);
        if (testedStack.method_31574(class_1802.field_49814)) {
            return false;
        }
        if (previousWeapon.method_7960() && isWeapon) {
            return true;
        }
        if (!testedStack.method_7960() && isWeapon) {
            boolean mapping = InventoryUtils.matchesWeaponMapping(testedStack, entity);
            if (!InventoryUtils.matchesWeaponMapping(previousWeapon, entity)) {
                return true;
            }
            if (!mapping || testedStack.method_31574(class_1802.field_49814)) {
                return false;
            }
            return InventoryUtils.isBetterWeaponEach(testedStack, previousWeapon);
        }
        return false;
    }

    private static boolean isBetterWeaponEach(class_1799 testedStack, class_1799 previousWeapon) {
        double prev;
        boolean isRanged = EquipmentUtils.isRangedWeapon((class_1799)testedStack);
        boolean enchants = Configs.Generic.WEAPON_SWAP_BETTER_ENCHANTS.getBooleanValue() ? InventoryUtils.hasSameOrBetterWeaponEnchantments(testedStack, previousWeapon) : true;
        boolean mats = InventoryUtils.hasTheSameOrBetterMaterial(testedStack, previousWeapon);
        boolean rarity = InventoryUtils.hasTheSameOrBetterRarity(testedStack, previousWeapon);
        double tested = InventoryUtils.getBaseAttackDamage(testedStack);
        if (tested > (prev = InventoryUtils.getBaseAttackDamage(previousWeapon))) {
            return rarity || mats;
        }
        if (tested == prev) {
            return (rarity || mats) && enchants;
        }
        return false;
    }

    private static boolean isBetterWeaponAndHasDurability(class_1799 testedStack, class_1799 previousTool, class_1297 entity) {
        return InventoryUtils.hasEnoughDurability(testedStack) && InventoryUtils.isBetterWeapon(testedStack, previousTool, entity);
    }

    private static double getBaseAttackDamage(class_1799 stack) {
        Pair pair = EquipmentUtils.getDamageAndSpeedAttributes((class_1799)stack);
        if ((Double)pair.getLeft() > 0.0) {
            return (Double)pair.getLeft();
        }
        return 0.0;
    }

    protected static boolean matchesWeaponMapping(class_1799 stack, class_1297 entity) {
        HashSet<class_1792> weapons = WEAPON_MAPPING.getOrDefault(entity.method_5864(), WEAPON_MAPPING.get(null));
        return weapons != null && weapons.contains(stack.method_7909());
    }

    public static void trySwitchToEffectiveTool(class_2338 pos) {
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        if (player != null && mc.field_1687 != null && !TOOL_SWITCH_IGNORED_SLOTS.contains(player.method_31548().method_67532())) {
            class_2680 state = mc.field_1687.method_8320(pos);
            class_1723 container = player.field_7498;
            ItemPickerTest test = FeatureToggle.TWEAK_SWAP_ALMOST_BROKEN_TOOLS.getBooleanValue() ? (currentStack, previous) -> InventoryUtils.isBetterToolAndHasDurability(currentStack, previous, state) : (currentStack, previous) -> InventoryUtils.isBetterTool(currentStack, previous, state);
            int slotNumber = InventoryUtils.findSlotWithBestItemMatch((class_1703)container, test, class_6019.method_35017((int)36, (int)44), class_6019.method_35017((int)9, (int)35));
            if (slotNumber != -1 && slotNumber - 36 != player.method_31548().method_67532()) {
                InventoryUtils.swapToolToHand(slotNumber, mc);
            }
        }
    }

    private static boolean isBetterTool(class_1799 testedStack, class_1799 previousTool, class_2680 state) {
        boolean isTool = EquipmentUtils.isAnyTool((class_1799)testedStack);
        boolean isMisc = EquipmentUtils.isMiscTool((class_1799)testedStack);
        if (previousTool.method_7960() && isTool && Configs.Generic.TOOL_SWAP_BAMBOO_USES_SWORD_FIRST.getBooleanValue() && !state.method_27852(class_2246.field_10211)) {
            return true;
        }
        if (Configs.Generic.TOOL_SWAP_BAMBOO_USES_SWORD_FIRST.getBooleanValue() && state.method_27852(class_2246.field_10211)) {
            if (EquipmentUtils.isSword((class_1799)testedStack)) {
                return InventoryUtils.applyBambooNeedsSwordFirst(testedStack, previousTool);
            }
            if (EquipmentUtils.isSword((class_1799)previousTool)) {
                return false;
            }
        }
        if (!testedStack.method_7960() && isMisc && Configs.Generic.TOOL_SWAP_NEEDS_SHEARS_FIRST.getBooleanValue() && CachedTagManager.isNeedsShears(state) && testedStack.method_31574(class_1802.field_8868) && !EquipmentUtils.isCorrectTool((class_1799)testedStack, (class_2680)state)) {
            return InventoryUtils.applyNeedsShearsFirst(testedStack, previousTool, state, isMisc);
        }
        if (!testedStack.method_7960() && isTool) {
            if (Configs.Generic.TOOL_SWAP_SILK_TOUCH_FIRST.getBooleanValue() && CachedTagManager.isNeedsSilkTouch(state) || Configs.Generic.TOOL_SWAP_SILK_TOUCH_ORES.getBooleanValue() && CachedTagManager.isOreBlock(state) && EquipmentUtils.isPickAxe((class_1799)testedStack) && EquipmentUtils.isCorrectTool((class_1799)testedStack, (class_2680)state)) {
                return InventoryUtils.applySilkTouchFirst(testedStack, previousTool, state, isMisc);
            }
            if (Configs.Generic.TOOL_SWAP_SILK_TOUCH_OVERRIDE.getBooleanValue() && CachedTagManager.isSilkTouchOverride(state)) {
                return InventoryUtils.applySilkTouchFirst(testedStack, previousTool, state, isMisc);
            }
            return InventoryUtils.isBetterToolEach(testedStack, previousTool, state, isMisc, true);
        }
        return EquipmentUtils.isCorrectTool((class_1799)testedStack, (class_2680)state);
    }

    private static boolean applyBambooNeedsSwordFirst(class_1799 testedStack, class_1799 previousTool) {
        boolean result;
        boolean prevSword = EquipmentUtils.isSword((class_1799)previousTool);
        boolean enchants = Configs.Generic.WEAPON_SWAP_BETTER_ENCHANTS.getBooleanValue() ? InventoryUtils.hasSameOrBetterWeaponEnchantments(testedStack, previousTool) : true;
        boolean mats = InventoryUtils.hasTheSameOrBetterMaterial(testedStack, previousTool);
        boolean bl = result = mats && enchants;
        if (prevSword) {
            return result;
        }
        return true;
    }

    private static boolean applyNeedsShearsFirst(class_1799 testedStack, class_1799 previousTool, class_2680 state, boolean isMisc) {
        if (!isMisc) {
            return false;
        }
        boolean enchants = Configs.Generic.TOOL_SWAP_BETTER_ENCHANTS.getBooleanValue() ? InventoryUtils.hasSameOrBetterToolEnchantments(testedStack, previousTool) : true;
        float testSpeed = InventoryUtils.getBaseBlockBreakingSpeed(testedStack, state);
        float prevSpeed = InventoryUtils.getBaseBlockBreakingSpeed(previousTool, state);
        boolean prevShears = previousTool.method_31574(class_1802.field_8868);
        boolean result = prevShears ? testSpeed >= prevSpeed && enchants : true;
        return result;
    }

    private static boolean applySilkTouchFirst(class_1799 testedStack, class_1799 previousTool, class_2680 state, boolean isMisc) {
        boolean prevSilk = EquipmentUtils.hasSilkTouch((class_1799)previousTool);
        if (EquipmentUtils.hasSilkTouch((class_1799)testedStack)) {
            float prevSpeed;
            boolean mats = InventoryUtils.hasTheSameOrBetterMaterial(testedStack, previousTool);
            boolean rarity = InventoryUtils.hasTheSameOrBetterRarity(testedStack, previousTool);
            float testSpeed = InventoryUtils.getBaseBlockBreakingSpeed(testedStack, state);
            if (testSpeed > (prevSpeed = InventoryUtils.getBaseBlockBreakingSpeed(previousTool, state))) {
                return true;
            }
            if (testSpeed == prevSpeed) {
                return isMisc ? !prevSilk : (prevSilk ? rarity && mats : true);
            }
            if (testSpeed < prevSpeed && !prevSilk) {
                return isMisc ? true : rarity && mats;
            }
        } else if (prevSilk && !EquipmentUtils.hasSilkTouch((class_1799)testedStack)) {
            return false;
        }
        return InventoryUtils.isBetterToolEach(testedStack, previousTool, state, isMisc, true);
    }

    private static boolean isBetterToolEach(class_1799 testedStack, class_1799 previousTool, class_2680 state, boolean isMisc, boolean loop) {
        boolean correct = EquipmentUtils.isCorrectTool((class_1799)testedStack, (class_2680)state);
        float testSpeed = InventoryUtils.getBaseBlockBreakingSpeed(testedStack, state);
        float prevSpeed = InventoryUtils.getBaseBlockBreakingSpeed(previousTool, state);
        boolean testSilkTouch = EquipmentUtils.hasSilkTouch((class_1799)testedStack);
        boolean prevSilkTouch = EquipmentUtils.hasSilkTouch((class_1799)previousTool);
        if (!correct) {
            return false;
        }
        boolean enchants = Configs.Generic.TOOL_SWAP_BETTER_ENCHANTS.getBooleanValue() ? InventoryUtils.hasSameOrBetterToolEnchantments(testedStack, previousTool) : true;
        boolean mats = InventoryUtils.hasTheSameOrBetterMaterial(testedStack, previousTool);
        boolean rarity = InventoryUtils.hasTheSameOrBetterRarity(testedStack, previousTool);
        if (testSpeed > prevSpeed) {
            return isMisc ? correct : (rarity || mats) && correct;
        }
        if (testSpeed == prevSpeed) {
            boolean preferSilk = Configs.Generic.TOOL_SWAP_PREFER_SILK_TOUCH.getBooleanValue();
            Configs.Generic.TOOL_SWAP_PREFER_SILK_TOUCH.setBooleanValue(false);
            boolean result = isMisc ? enchants && correct : (rarity || mats) && enchants && correct;
            boolean prevResult = loop ? InventoryUtils.isBetterToolEach(previousTool, testedStack, state, isMisc, false) : false;
            Configs.Generic.TOOL_SWAP_PREFER_SILK_TOUCH.setBooleanValue(preferSilk);
            if (prevResult && result) {
                if (preferSilk) {
                    return testSilkTouch && !prevSilkTouch;
                }
                if (!testSilkTouch && prevSilkTouch) {
                    return true;
                }
                if (testSilkTouch && !prevSilkTouch) {
                    return false;
                }
            }
            return result;
        }
        return false;
    }

    private static boolean isBetterToolAndHasDurability(class_1799 testedStack, class_1799 previousTool, class_2680 state) {
        return InventoryUtils.hasEnoughDurability(testedStack) && InventoryUtils.isBetterTool(testedStack, previousTool, state);
    }

    private static boolean hasTheSameOrBetterRarity(class_1799 testedStack, class_1799 previousTool) {
        return Integer.compare(InventoryUtils.getRarityWeight(testedStack), InventoryUtils.getRarityWeight(previousTool)) >= 0;
    }

    private static int getRarityWeight(class_1799 stack) {
        class_1814 class_18142 = stack.method_7932();
        int n = 0;
        switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"EPIC", "RARE", "UNCOMMON", "COMMON"}, (class_1814)class_18142, n)) {
            case 0: {
                return 4;
            }
            case 1: {
                return 3;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 1;
            }
            case -1: {
                return -1;
            }
        }
        return 0;
    }

    private static boolean hasTheSameOrBetterMaterial(class_1799 testedStack, class_1799 previousTool) {
        return Integer.compare(InventoryUtils.getMaterialWeight(testedStack), InventoryUtils.getMaterialWeight(previousTool)) >= 0;
    }

    private static int getMaterialWeight(class_1799 stack) {
        String itemType = class_7923.field_41178.method_10221((Object)stack.method_7909()).method_12832();
        if (itemType.contains("netherite")) {
            return 6;
        }
        if (itemType.contains("diamond")) {
            return 5;
        }
        if (itemType.contains("iron")) {
            return 4;
        }
        if (itemType.contains("copper")) {
            return 3;
        }
        if (itemType.contains("stone")) {
            return 2;
        }
        if (itemType.contains("gold")) {
            return 1;
        }
        if (itemType.contains("wood")) {
            return 0;
        }
        return -1;
    }

    private static boolean hasSameOrBetterToolEnchantments(class_1799 testedStack, class_1799 previousTool) {
        int count = 0;
        count += EquipmentUtils.hasSameOrBetterEnchantment((class_1799)testedStack, (class_1799)previousTool, (class_5321)class_1893.field_9101);
        count += EquipmentUtils.hasSameOrBetterEnchantment((class_1799)testedStack, (class_1799)previousTool, (class_5321)class_1893.field_9119);
        count += EquipmentUtils.hasSameOrBetterEnchantment((class_1799)testedStack, (class_1799)previousTool, (class_5321)class_1893.field_9131);
        return (count += EquipmentUtils.hasSameOrBetterEnchantment((class_1799)testedStack, (class_1799)previousTool, (class_5321)class_1893.field_9130)) >= 0;
    }

    private static boolean hasSameOrBetterWeaponEnchantments(class_1799 testedStack, class_1799 previousTool) {
        int count = 0;
        count += EquipmentUtils.hasSameOrBetterEnchantment((class_1799)testedStack, (class_1799)previousTool, (class_5321)class_1893.field_9101);
        count += EquipmentUtils.hasSameOrBetterEnchantment((class_1799)testedStack, (class_1799)previousTool, (class_5321)class_1893.field_9119);
        count += EquipmentUtils.hasSameOrBetterEnchantment((class_1799)testedStack, (class_1799)previousTool, (class_5321)class_1893.field_9110);
        count += EquipmentUtils.hasSameOrBetterEnchantment((class_1799)testedStack, (class_1799)previousTool, (class_5321)class_1893.field_9118);
        count += EquipmentUtils.hasSameOrBetterEnchantment((class_1799)testedStack, (class_1799)previousTool, (class_5321)class_1893.field_9123);
        count += EquipmentUtils.hasSameOrBetterEnchantment((class_1799)testedStack, (class_1799)previousTool, (class_5321)class_1893.field_9112);
        count += EquipmentUtils.hasSameOrBetterEnchantment((class_1799)testedStack, (class_1799)previousTool, (class_5321)class_1893.field_9103);
        count += EquipmentUtils.hasSameOrBetterEnchantment((class_1799)testedStack, (class_1799)previousTool, (class_5321)class_1893.field_9106);
        count += EquipmentUtils.hasSameOrBetterEnchantment((class_1799)testedStack, (class_1799)previousTool, (class_5321)class_1893.field_50157);
        count += EquipmentUtils.hasSameOrBetterEnchantment((class_1799)testedStack, (class_1799)previousTool, (class_5321)class_1893.field_9115);
        count += EquipmentUtils.hasSameOrBetterEnchantment((class_1799)testedStack, (class_1799)previousTool, (class_5321)class_1893.field_9124);
        count += EquipmentUtils.hasSameOrBetterEnchantment((class_1799)testedStack, (class_1799)previousTool, (class_5321)class_1893.field_9116);
        count += EquipmentUtils.hasSameOrBetterEnchantment((class_1799)testedStack, (class_1799)previousTool, (class_5321)class_1893.field_9125);
        count += EquipmentUtils.hasSameOrBetterEnchantment((class_1799)testedStack, (class_1799)previousTool, (class_5321)class_1893.field_9126);
        count += EquipmentUtils.hasSameOrBetterEnchantment((class_1799)testedStack, (class_1799)previousTool, (class_5321)class_1893.field_9108);
        count += EquipmentUtils.hasSameOrBetterEnchantment((class_1799)testedStack, (class_1799)previousTool, (class_5321)class_1893.field_9098);
        count += EquipmentUtils.hasSameOrBetterEnchantment((class_1799)testedStack, (class_1799)previousTool, (class_5321)class_1893.field_9132);
        count += EquipmentUtils.hasSameOrBetterEnchantment((class_1799)testedStack, (class_1799)previousTool, (class_5321)class_1893.field_9104);
        count += EquipmentUtils.hasSameOrBetterEnchantment((class_1799)testedStack, (class_1799)previousTool, (class_5321)class_1893.field_9120);
        count += EquipmentUtils.hasSameOrBetterEnchantment((class_1799)testedStack, (class_1799)previousTool, (class_5321)class_1893.field_9117);
        return (count += EquipmentUtils.hasSameOrBetterEnchantment((class_1799)testedStack, (class_1799)previousTool, (class_5321)class_1893.field_50158)) >= 0;
    }

    protected static float getBaseBlockBreakingSpeed(class_1799 stack, class_2680 state) {
        int effLevel;
        float speed = EquipmentUtils.getMiningSpeed((class_1799)stack, (class_2680)state);
        if (speed > 1.0f && (effLevel = EquipmentUtils.getEnchantmentLevel((class_1799)stack, (class_5321)class_1893.field_9131)) > 0) {
            speed += (float)(effLevel * effLevel + 1);
        }
        if (state.method_29291() && !stack.method_7951(state)) {
            speed /= 3.3333333f;
        }
        return speed;
    }

    protected static boolean hasEnoughDurability(class_1799 stack) {
        return stack.method_7936() - stack.method_7919() > InventoryUtils.getMinDurability(stack);
    }

    private static int findSuitableSlot(class_1703 container, Predicate<class_1799> itemTest) {
        return InventoryUtils.findSuitableSlot(container, itemTest, class_6019.method_35017((int)9, (int)(container.field_7761.size() - 1)));
    }

    private static int findSuitableSlot(class_1703 container, Predicate<class_1799> itemTest, class_6019 ... ranges) {
        int max = container.field_7761.size() - 1;
        for (class_6019 range : ranges) {
            int end = Math.min(max, range.method_35011());
            for (int slotNumber = range.method_35009(); slotNumber <= end; ++slotNumber) {
                if (!itemTest.test(container.method_7611(slotNumber).method_7677())) continue;
                return slotNumber;
            }
        }
        return -1;
    }

    private static int findSlotWithBestItemMatch(class_1703 container, ItemPickerTest itemTest, class_6019 ... ranges) {
        int max = container.field_7761.size() - 1;
        class_1799 bestMatch = class_1799.field_8037;
        int slotNum = -1;
        for (class_6019 range : ranges) {
            int end = Math.min(max, range.method_35011());
            for (int slotNumber = range.method_35009(); slotNumber <= end; ++slotNumber) {
                class_1735 slot = container.method_7611(slotNumber);
                if (!itemTest.isBetterMatch(slot.method_7677(), bestMatch)) continue;
                bestMatch = slot.method_7677();
                slotNum = slot.field_7874;
            }
        }
        return slotNum;
    }

    private static int findEmptySlot(class_1703 container, Collection<Integer> slotNumbers) {
        int maxSlot = container.field_7761.size() - 1;
        for (int slotNumber : slotNumbers) {
            if (slotNumber < 0 || slotNumber > maxSlot || container.method_7611(slotNumber).method_7681()) continue;
            return slotNumber;
        }
        return -1;
    }

    private static boolean isItemAtLowDurability(class_1799 stack, int minDurability) {
        return stack.method_7963() && stack.method_7936() - stack.method_7919() <= minDurability;
    }

    private static int getMinDurability(class_1799 stack) {
        if (!FeatureToggle.TWEAK_SWAP_ALMOST_BROKEN_TOOLS.getBooleanValue()) {
            return 0;
        }
        int minDurability = Configs.Generic.ITEM_SWAP_DURABILITY_THRESHOLD.getIntegerValue();
        if (stack.method_7936() <= 100 && minDurability <= 20 && (double)minDurability / (double)stack.method_7936() > 0.08) {
            minDurability = (int)Math.ceil((double)stack.method_7936() * 0.08);
        }
        return minDurability;
    }

    private static void swapItemWithHigherDurabilityToHand(class_1657 player, class_1268 hand, class_1799 stackReference, int minDurabilityLeft) {
        class_1723 container = player.field_7498;
        int slotWithItem = InventoryUtils.findSlotWithSuitableReplacementToolWithDurabilityLeft((class_1703)container, stackReference, minDurabilityLeft);
        if (slotWithItem != -1) {
            InventoryUtils.swapItemToHand(player, hand, slotWithItem);
            InfoUtils.printActionbarMessage((String)"tweakeroo.message.swapped_low_durability_item_for_better_durability", (Object[])new Object[0]);
            return;
        }
        slotWithItem = fi.dy.masa.malilib.util.InventoryUtils.findEmptySlotInPlayerInventory((class_1703)container, (boolean)false, (boolean)false);
        if (slotWithItem != -1) {
            InventoryUtils.swapItemToHand(player, hand, slotWithItem);
            InfoUtils.printActionbarMessage((String)"tweakeroo.message.swapped_low_durability_item_off_players_hand", (Object[])new Object[0]);
            return;
        }
        slotWithItem = InventoryUtils.findSuitableSlot((class_1703)container, s -> !s.method_7963());
        if (slotWithItem != -1) {
            InventoryUtils.swapItemToHand(player, hand, slotWithItem);
            InfoUtils.printActionbarMessage((String)"tweakeroo.message.swapped_low_durability_item_for_dummy_item", (Object[])new Object[0]);
        }
    }

    public static void repairModeSwapItems(class_1657 player) {
        if (player.field_7512 == player.field_7498) {
            for (class_1304 type : REPAIR_MODE_SLOTS) {
                InventoryUtils.repairModeHandleSlot(player, type);
            }
        }
    }

    private static void repairModeHandleSlot(class_1657 player, class_1304 type) {
        class_1735 slot;
        int slotRepairableItem;
        int slotNum = InventoryUtils.getSlotNumberForEquipmentType(type, player);
        if (slotNum == -1) {
            return;
        }
        class_1799 stack = player.method_6118(type);
        if (!(stack.method_7960() || stack.method_7963() && stack.method_7986() && EquipmentUtils.getEnchantmentLevel((class_1799)stack, (class_5321)class_1893.field_9101) > 0 || (slotRepairableItem = InventoryUtils.findRepairableItemNotInRepairableSlot(slot = player.field_7512.method_7611(slotNum), player)) == -1)) {
            InventoryUtils.swapItemToEquipmentSlot(player, type, slotRepairableItem);
            InfoUtils.printActionbarMessage((String)"tweakeroo.message.repair_mode.swapped_repairable_item_to_slot", (Object[])new Object[]{type.method_5923()});
        }
    }

    private static int findRepairableItemNotInRepairableSlot(class_1735 targetSlot, class_1657 player) {
        class_1703 containerPlayer = player.field_7512;
        for (class_1735 slot : containerPlayer.field_7761) {
            if (!slot.method_7681() || InventoryUtils.isConfiguredRepairSlot(slot.field_7874, player)) continue;
            class_1799 stack = slot.method_7677();
            if (slot.field_7874 - 36 == player.method_31548().method_67532() || !stack.method_7963() || !stack.method_7986() || !targetSlot.method_7680(stack) || EquipmentUtils.getEnchantmentLevel((class_1799)stack, (class_5321)class_1893.field_9101) <= 0) continue;
            return slot.field_7874;
        }
        return -1;
    }

    public static void equipBestElytra(class_1657 player) {
        if (player == null || GuiUtils.getCurrentScreen() != null) {
            return;
        }
        class_1703 container = player.field_7512;
        Predicate<class_1799> filter = s -> s.method_7909().equals(class_1802.field_8833) && ((class_10192)s.method_58694(class_9334.field_54196)).method_64015(class_1299.field_6097) && s.method_7919() < s.method_7936() - 10;
        int targetSlot = InventoryUtils.findSlotWithBestItemMatch(container, (testedStack, previousBestMatch) -> {
            if (!filter.test(testedStack)) {
                return false;
            }
            if (!filter.test(previousBestMatch)) {
                return true;
            }
            if (EquipmentUtils.getEnchantmentLevel((class_1799)testedStack, (class_5321)class_1893.field_9119) > EquipmentUtils.getEnchantmentLevel((class_1799)previousBestMatch, (class_5321)class_1893.field_9119)) {
                return true;
            }
            if (EquipmentUtils.getEnchantmentLevel((class_1799)testedStack, (class_5321)class_1893.field_9119) < EquipmentUtils.getEnchantmentLevel((class_1799)previousBestMatch, (class_5321)class_1893.field_9119)) {
                return false;
            }
            return testedStack.method_7919() <= previousBestMatch.method_7919();
        }, class_6019.method_35017((int)9, (int)(container.field_7761.size() - 1)));
        if (targetSlot >= 0) {
            InventoryUtils.swapItemToEquipmentSlot(player, class_1304.field_6174, targetSlot);
        }
    }

    public static void swapElytraAndChestPlate(@Nullable class_1657 player) {
        if (player == null || GuiUtils.getCurrentScreen() != null) {
            return;
        }
        class_1703 container = player.field_7512;
        class_1799 currentStack = player.method_6118(class_1304.field_6174);
        Predicate<class_1799> stackFilterChestPlate = s -> EquipmentUtils.matchArmorSlot((class_1799)s, (class_1304)class_1304.field_6174);
        if (currentStack.method_7960() || stackFilterChestPlate.test(currentStack)) {
            InventoryUtils.equipBestElytra(player);
        } else {
            Predicate<class_1799> finalFilter = s -> stackFilterChestPlate.test((class_1799)s) && s.method_7919() < s.method_7936() - 10;
            int targetSlot = InventoryUtils.findSlotWithBestItemMatch(container, (testedStack, previousBestMatch) -> {
                if (!finalFilter.test(testedStack)) {
                    return false;
                }
                if (!finalFilter.test(previousBestMatch)) {
                    return true;
                }
                if (InventoryUtils.getArmorAndArmorToughnessValue(previousBestMatch, 1.0, class_9274.field_49222) < InventoryUtils.getArmorAndArmorToughnessValue(testedStack, 1.0, class_9274.field_49222)) {
                    return true;
                }
                if (InventoryUtils.getArmorAndArmorToughnessValue(previousBestMatch, 1.0, class_9274.field_49222) > InventoryUtils.getArmorAndArmorToughnessValue(testedStack, 1.0, class_9274.field_49222)) {
                    return false;
                }
                return EquipmentUtils.getEnchantmentLevel((class_1799)previousBestMatch, (class_5321)class_1893.field_9111) <= EquipmentUtils.getEnchantmentLevel((class_1799)testedStack, (class_5321)class_1893.field_9111);
            }, class_6019.method_35017((int)9, (int)(container.field_7761.size() - 1)));
            if (targetSlot >= 0) {
                InventoryUtils.swapItemToEquipmentSlot(player, class_1304.field_6174, targetSlot);
            }
        }
    }

    private static double getArmorAndArmorToughnessValue(class_1799 stack, double base, class_9274 slot) {
        double[] total = new double[]{base};
        stack.method_60617(slot, (entry, modifier, consumer) -> {
            if (entry.method_40230().orElseThrow() == class_5134.field_23724 || entry.method_40230().orElseThrow() == class_5134.field_23725) {
                switch (modifier.comp_2450()) {
                    case field_6328: {
                        total[0] = total[0] + modifier.comp_2449();
                        break;
                    }
                    case field_6330: {
                        total[0] = total[0] + modifier.comp_2449() * base;
                        break;
                    }
                    case field_6331: {
                        total[0] = total[0] + modifier.comp_2449() * total[0];
                        break;
                    }
                    default: {
                        throw new MatchException(null, null);
                    }
                }
            }
        });
        return total[0];
    }

    public static int findSlotWithItem(class_1703 container, class_1799 stackReference, boolean allowHotbar, boolean reverse) {
        int startSlot = reverse ? container.field_7761.size() - 1 : 0;
        int endSlot = reverse ? -1 : container.field_7761.size();
        int increment = reverse ? -1 : 1;
        boolean isPlayerInv = container instanceof class_1723;
        for (int slotNum = startSlot; slotNum != endSlot; slotNum += increment) {
            class_1735 slot = (class_1735)container.field_7761.get(slotNum);
            if (isPlayerInv && !fi.dy.masa.malilib.util.InventoryUtils.isRegularInventorySlot((int)slot.field_7874, (boolean)false) || !allowHotbar && InventoryUtils.isHotbarSlot(slot) || !fi.dy.masa.malilib.util.InventoryUtils.areStacksEqualIgnoreDurability((class_1799)slot.method_7677(), (class_1799)stackReference)) continue;
            return slot.field_7874;
        }
        return -1;
    }

    private static boolean isHotbarSlot(class_1735 slot) {
        return InventoryUtils.isHotbarSlot(slot.field_7874);
    }

    public static boolean isHotbarSlot(int slot) {
        return slot >= 36 && slot < 36 + class_1661.method_7368();
    }

    public static boolean isOffhandSlot(int slot) {
        return slot == 36 + class_1661.method_7368();
    }

    private static void swapItemToHand(class_1657 player, class_1268 hand, int slotNumber) {
        class_1703 container = player.field_7512;
        if (slotNumber != -1 && container == player.field_7498) {
            class_310 mc = class_310.method_1551();
            class_1661 inventory = player.method_31548();
            if (hand == class_1268.field_5808) {
                int currentHotbarSlot = inventory.method_67532();
                if (InventoryUtils.isHotbarSlot(slotNumber)) {
                    inventory.method_61496(slotNumber - 36);
                    mc.method_1562().method_52787((class_2596)new class_2868(inventory.method_67532()));
                } else {
                    mc.field_1761.method_2906(container.field_7763, slotNumber, currentHotbarSlot, class_1713.field_7791, (class_1657)mc.field_1724);
                }
            } else if (hand == class_1268.field_5810) {
                mc.field_1761.method_2906(container.field_7763, slotNumber, 40, class_1713.field_7791, (class_1657)mc.field_1724);
            }
        }
    }

    public static void swapItemToEquipmentSlot(class_1657 player, class_1304 type, int sourceSlotNumber) {
        if (sourceSlotNumber != -1 && player.field_7512 == player.field_7498) {
            int equipmentSlotNumber = InventoryUtils.getSlotNumberForEquipmentType(type, player);
            InventoryUtils.swapSlots(player, sourceSlotNumber, equipmentSlotNumber);
        }
    }

    public static void swapSlots(class_1657 player, int slotNum, int otherSlot) {
        class_310 mc = class_310.method_1551();
        class_1703 container = player.field_7512;
        mc.field_1761.method_2906(container.field_7763, slotNum, 0, class_1713.field_7791, player);
        mc.field_1761.method_2906(container.field_7763, otherSlot, 0, class_1713.field_7791, player);
        mc.field_1761.method_2906(container.field_7763, slotNum, 0, class_1713.field_7791, player);
    }

    private static void swapToolToHand(int slotNumber, class_310 mc) {
        class_746 player = mc.field_1724;
        if (slotNumber >= 0 && player.field_7512 == player.field_7498) {
            class_1661 inventory = player.method_31548();
            class_1723 container = player.field_7498;
            if (InventoryUtils.isHotbarSlot(slotNumber)) {
                inventory.method_61496(slotNumber - 36);
                mc.method_1562().method_52787((class_2596)new class_2868(inventory.method_67532()));
            } else {
                int selectedSlot = inventory.method_67532();
                int hotbarSlot = InventoryUtils.getUsableHotbarSlotForTool(selectedSlot, TOOL_SWITCHABLE_SLOTS, (class_1703)container);
                if (class_1661.method_7380((int)hotbarSlot)) {
                    if (hotbarSlot != selectedSlot) {
                        inventory.method_61496(hotbarSlot);
                        mc.method_1562().method_52787((class_2596)new class_2868(inventory.method_67532()));
                    }
                    mc.field_1761.method_2906(container.field_7763, slotNumber, hotbarSlot, class_1713.field_7791, (class_1657)mc.field_1724);
                }
            }
        }
    }

    private static int getUsableHotbarSlotForTool(int currentHotbarSlot, Collection<Integer> validSlots, class_1703 container) {
        int first = -1;
        int nonTool = -1;
        if (validSlots.contains(currentHotbarSlot)) {
            class_1799 stack = container.method_7611(currentHotbarSlot + 36).method_7677();
            if (stack.method_7960()) {
                return currentHotbarSlot;
            }
            if (!EquipmentUtils.isRegularTool((class_1799)stack)) {
                nonTool = currentHotbarSlot;
            }
        }
        for (int hotbarSlot : validSlots) {
            class_1799 stack = container.method_7611(hotbarSlot + 36).method_7677();
            if (stack.method_7960()) {
                return hotbarSlot;
            }
            if (nonTool == -1 && !EquipmentUtils.isRegularTool((class_1799)stack)) {
                nonTool = hotbarSlot;
            }
            if (first != -1) continue;
            first = hotbarSlot;
        }
        return nonTool >= 0 ? nonTool : first;
    }

    private static int findSlotWithSuitableReplacementToolWithDurabilityLeft(class_1703 container, class_1799 stackReference, int minDurabilityLeft) {
        for (class_1735 slot : container.field_7761) {
            class_1799 stackSlot = slot.method_7677();
            if (!fi.dy.masa.malilib.util.InventoryUtils.isRegularInventorySlot((int)slot.field_7874, (boolean)false) || !class_1799.method_7984((class_1799)stackSlot, (class_1799)stackReference) || stackSlot.method_7936() - stackSlot.method_7919() < minDurabilityLeft || !InventoryUtils.hasSameIshEnchantments(stackReference, stackSlot)) continue;
            return slot.field_7874;
        }
        return -1;
    }

    private static boolean hasSameIshEnchantments(class_1799 stackReference, class_1799 stack) {
        int level = EquipmentUtils.getEnchantmentLevel((class_1799)stackReference, (class_5321)class_1893.field_9099);
        if (level > 0) {
            return EquipmentUtils.getEnchantmentLevel((class_1799)stack, (class_5321)class_1893.field_9099) >= level;
        }
        level = EquipmentUtils.getEnchantmentLevel((class_1799)stackReference, (class_5321)class_1893.field_9130);
        if (level > 0) {
            return EquipmentUtils.getEnchantmentLevel((class_1799)stack, (class_5321)class_1893.field_9130) >= level;
        }
        return true;
    }

    private static int findSlotWithEffectiveItemWithDurabilityLeft(class_1703 container, class_2680 state) {
        int slotNum = -1;
        float bestSpeed = -1.0f;
        for (class_1735 slot : container.field_7761) {
            int effLevel;
            class_1799 stack;
            if (slot.field_7874 <= 8 || !slot.method_7681() || (stack = slot.method_7677()).method_7936() - stack.method_7919() <= InventoryUtils.getMinDurability(stack)) continue;
            float speed = stack.method_7924(state);
            if (speed > 1.0f && (effLevel = EquipmentUtils.getEnchantmentLevel((class_1799)stack, (class_5321)class_1893.field_9131)) > 0) {
                speed += (float)(effLevel * effLevel + 1);
            }
            if (!(speed > 1.0f) || slotNum != -1 && !(speed > bestSpeed)) continue;
            slotNum = slot.field_7874;
            bestSpeed = speed;
        }
        return slotNum;
    }

    private static void tryCombineStacksInInventory(class_1657 player, class_1799 stackReference) {
        ArrayList<class_1735> slots = new ArrayList<class_1735>();
        class_1723 container = player.field_7498;
        class_310 mc = class_310.method_1551();
        for (class_1735 slot : container.field_7761) {
            class_1799 stack;
            if (slot.field_7874 < 8 || (stack = slot.method_7677()).method_7947() >= stack.method_7914() || !fi.dy.masa.malilib.util.InventoryUtils.areStacksEqual((class_1799)stackReference, (class_1799)stack)) continue;
            slots.add(slot);
        }
        block1: for (int i = 0; i < slots.size(); ++i) {
            class_1735 slot1 = (class_1735)slots.get(i);
            for (int j = i + 1; j < slots.size(); ++j) {
                class_1735 slot2 = (class_1735)slots.get(j);
                class_1799 stack = slot1.method_7677();
                if (stack.method_7947() < stack.method_7914()) {
                    mc.field_1761.method_2906(container.field_7763, slot1.field_7874, 0, class_1713.field_7790, player);
                    mc.field_1761.method_2906(container.field_7763, slot2.field_7874, 0, class_1713.field_7790, player);
                    if (!player.method_31548().method_7391().method_7960()) {
                        mc.field_1761.method_2906(container.field_7763, slot1.field_7874, 0, class_1713.field_7790, player);
                    }
                    if (slot2.method_7677().method_7947() >= slot2.method_7677().method_7914()) {
                        slots.remove(j);
                        --j;
                    }
                }
                if (!slot1.method_7681()) continue block1;
            }
        }
    }

    public static boolean canUnstackingItemNotFitInInventory(class_1799 stack, class_1657 player) {
        if (FeatureToggle.TWEAK_ITEM_UNSTACKING_PROTECTION.getBooleanValue() && stack.method_7947() > 1 && UNSTACKING_ITEMS.contains(stack.method_7909()) && fi.dy.masa.malilib.util.InventoryUtils.findEmptySlotInPlayerInventory((class_1703)player.field_7498, (boolean)false, (boolean)false) == -1) {
            InventoryUtils.tryCombineStacksInInventory(player, stack);
            return fi.dy.masa.malilib.util.InventoryUtils.findEmptySlotInPlayerInventory((class_1703)player.field_7498, (boolean)false, (boolean)false) == -1;
        }
        return false;
    }

    public static void switchToPickedBlock() {
        class_2338 pos;
        class_2680 stateTargeted;
        class_1799 stack;
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        class_638 world = mc.field_1687;
        if (player == null || world == null || player.field_7512 != player.field_7498) {
            return;
        }
        double reach = mc.field_1724.method_55754();
        boolean isCreative = player.method_68878();
        class_239 trace = player.method_5745(reach, mc.method_61966().method_60637(false), false);
        if (trace != null && trace.method_17783() == class_239.class_240.field_1332 && !(stack = ((IMixinAbstractBlock)(stateTargeted = world.method_8320(pos = ((class_3965)trace).method_17777())).method_26204()).tweakeroo_getPickStack((class_4538)world, pos, stateTargeted, false)).method_7960() && !fi.dy.masa.malilib.util.InventoryUtils.areStacksEqual((class_1799)stack, (class_1799)player.method_6047())) {
            class_1703 container = player.field_7512;
            class_1661 inventory = player.method_31548();
            if (isCreative) {
                inventory.method_65126(stack);
                mc.field_1761.method_2909(player.method_5998(class_1268.field_5808), 36 + inventory.method_67532());
            } else {
                int slotNumber = fi.dy.masa.malilib.util.InventoryUtils.findSlotWithItem((class_1703)container, (class_1799)stack, (boolean)true);
                if (slotNumber != -1) {
                    InventoryUtils.swapItemToHand((class_1657)player, class_1268.field_5808, slotNumber);
                }
            }
        }
    }

    public static interface ItemPickerTest {
        public boolean isBetterMatch(class_1799 var1, class_1799 var2);
    }
}

