/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tweakeroo.util;

import fi.dy.masa.tweakeroo.config.Configs;
import fi.dy.masa.tweakeroo.config.FeatureToggle;
import fi.dy.masa.tweakeroo.util.CameraUtils;
import fi.dy.masa.tweakeroo.util.MiscUtils;
import javax.annotation.Nullable;
import net.minecraft.class_10185;
import net.minecraft.class_1297;
import net.minecraft.class_1313;
import net.minecraft.class_243;
import net.minecraft.class_299;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_3469;
import net.minecraft.class_3532;
import net.minecraft.class_634;
import net.minecraft.class_638;
import net.minecraft.class_746;

public class CameraEntity
extends class_746 {
    @Nullable
    private static CameraEntity camera;
    @Nullable
    private static class_1297 originalCameraEntity;
    private static class_243 cameraMotion;
    private static boolean cullChunksOriginal;
    private static boolean sprinting;
    private static boolean originalCameraWasPlayer;

    private CameraEntity(class_310 mc, class_638 world, class_634 netHandler, class_3469 stats, class_299 recipeBook, class_10185 input, boolean sprinting) {
        super(mc, world, netHandler, stats, recipeBook, input, sprinting);
    }

    public boolean method_7325() {
        return true;
    }

    public int method_5628() {
        if (originalCameraEntity != null) {
            return originalCameraEntity.method_5628();
        }
        return super.method_5628();
    }

    public static void movementTick() {
        CameraEntity camera = CameraEntity.getCamera();
        if (camera != null && !Configs.Generic.FREE_CAMERA_PLAYER_MOVEMENT.getBooleanValue()) {
            class_315 options = class_310.method_1551().field_1690;
            camera.updateLastTickPosition();
            if (options.field_1867.method_1434()) {
                sprinting = true;
            } else if (!options.field_1894.method_1434() && !options.field_1881.method_1434()) {
                sprinting = false;
            }
            cameraMotion = MiscUtils.calculatePlayerMotionWithDeceleration(cameraMotion, 0.15, 0.4);
            double forward = sprinting ? CameraEntity.cameraMotion.field_1352 * 3.0 : CameraEntity.cameraMotion.field_1352;
            camera.handleMotion(forward, CameraEntity.cameraMotion.field_1351, CameraEntity.cameraMotion.field_1350);
        }
    }

    private static double getMoveSpeed() {
        double base = 0.07;
        if (FeatureToggle.TWEAK_FLY_SPEED.getBooleanValue()) {
            base = Configs.getActiveFlySpeedConfig().getDoubleValue();
        }
        return base * 10.0;
    }

    private void handleMotion(double forward, double up, double strafe) {
        float yaw = this.method_36454();
        double scale = CameraEntity.getMoveSpeed();
        double xFactor = Math.sin((double)yaw * Math.PI / 180.0);
        double zFactor = Math.cos((double)yaw * Math.PI / 180.0);
        double x = (strafe * zFactor - forward * xFactor) * scale;
        double y = up * scale;
        double z = (forward * zFactor + strafe * xFactor) * scale;
        this.method_18799(new class_243(x, y, z));
        this.method_5784(class_1313.field_6308, this.method_18798());
    }

    private void updateLastTickPosition() {
        this.field_6038 = this.method_23317();
        this.field_5971 = this.method_23318();
        this.field_5989 = this.method_23321();
        this.field_6014 = this.method_23317();
        this.field_6036 = this.method_23318();
        this.field_5969 = this.method_23321();
        this.field_5982 = this.method_36454();
        this.field_6004 = this.method_36455();
        this.field_6259 = this.field_6241;
    }

    public void setCameraRotations(float yaw, float pitch) {
        this.method_36456(yaw);
        this.method_36457(pitch);
        this.field_6241 = yaw;
    }

    public void updateCameraRotations(float yawChange, float pitchChange) {
        float yaw = this.method_36454() + yawChange * 0.15f;
        float pitch = class_3532.method_15363((float)(this.method_36455() + pitchChange * 0.15f), (float)-90.0f, (float)90.0f);
        this.method_36456(yaw);
        this.method_36457(pitch);
        this.setCameraRotations(yaw, pitch);
    }

    private static CameraEntity createCameraEntity(class_310 mc) {
        class_746 player = mc.field_1724;
        if (player == null) {
            throw new RuntimeException("Cannot create CameraEntity from null!");
        }
        class_243 entityPos = player.method_73189();
        float yaw = player.method_36454();
        float pitch = player.method_36455();
        if (mc.field_1724.method_24828()) {
            mc.field_1724.method_18799(class_243.field_1353);
        }
        CameraEntity camera = new CameraEntity(mc, mc.field_1687, player.field_3944, player.method_3143(), player.method_3130(), class_10185.field_54098, false);
        camera.field_5960 = true;
        camera.method_23327(entityPos.method_10216(), entityPos.method_10214() + 0.125, entityPos.method_10215());
        camera.method_36456(yaw);
        camera.method_36457(pitch);
        camera.method_18799(class_243.field_1353);
        return camera;
    }

    @Nullable
    public static CameraEntity getCamera() {
        return camera;
    }

    public static void setCameraState(boolean enabled) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1687 != null && mc.field_1724 != null) {
            if (enabled) {
                CameraEntity.createAndSetCamera(mc);
            } else {
                CameraEntity.removeCamera(mc);
            }
        }
    }

    public static boolean originalCameraWasPlayer() {
        return originalCameraWasPlayer;
    }

    private static void createAndSetCamera(class_310 mc) {
        camera = CameraEntity.createCameraEntity(mc);
        originalCameraEntity = mc.method_1560();
        originalCameraWasPlayer = originalCameraEntity == mc.field_1724;
        cullChunksOriginal = mc.field_1730;
        mc.method_1504((class_1297)camera);
        mc.field_1730 = false;
        Configs.Generic.FREE_CAMERA_PLAYER_MOVEMENT.setBooleanValue(false);
    }

    private static void removeCamera(class_310 mc) {
        if (mc.field_1687 != null && camera != null) {
            mc.method_1504((class_1297)(originalCameraWasPlayer ? mc.field_1724 : originalCameraEntity));
            mc.field_1730 = cullChunksOriginal;
            int chunkX = class_3532.method_15357((double)(camera.method_23317() / 16.0)) >> 4;
            int chunkZ = class_3532.method_15357((double)(camera.method_23321() / 16.0)) >> 4;
            CameraUtils.markChunksForRebuildOnDeactivation(chunkX, chunkZ);
        }
        originalCameraEntity = null;
        camera = null;
    }

    static {
        cameraMotion = new class_243(0.0, 0.0, 0.0);
    }
}

