/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.automessages999;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class AutoMessages999
extends JavaPlugin
implements Listener,
TabExecutor {
    private boolean enabled;
    private boolean randomOrder;
    private boolean debugLogging;
    private boolean delayFirstMessage;
    private final Map<Integer, List<TimedMessage>> scheduledMessages = new HashMap<Integer, List<TimedMessage>>();
    private final List<BukkitRunnable> runningTasks = new ArrayList<BukkitRunnable>();
    private long lastDebugLogTime = 0L;
    private static final long DEBUG_LOG_INTERVAL_MS = 10000L;
    private final long serverStartTime = System.currentTimeMillis();

    public void onEnable() {
        this.saveDefaultConfig();
        this.reloadPluginConfig();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getCommand("automessages").setExecutor((CommandExecutor)this);
        this.scheduleAllMessages();
        this.getLogger().info("AutoMessages999 has been enabled!");
    }

    public void onDisable() {
        this.cancelAllTasks();
        this.getLogger().info("AutoMessages999 has been disabled!");
    }

    private void reloadPluginConfig() {
        this.reloadConfig();
        this.enabled = this.getConfig().getBoolean("messages.enabled", true);
        this.randomOrder = this.getConfig().getBoolean("settings.random-order", false);
        this.debugLogging = this.getConfig().getBoolean("settings.debug-logging", false);
        this.delayFirstMessage = this.getConfig().getBoolean("settings.delay-first-message", false);
        this.validateConfig();
    }

    private void validateConfig() {
        List intervalMessagesRaw = this.getConfig().getList("messages.interval");
        if (intervalMessagesRaw == null || intervalMessagesRaw.isEmpty()) {
            this.getLogger().warning("No interval messages configured in config.yml!");
            return;
        }
        for (int i = 0; i < intervalMessagesRaw.size(); ++i) {
            Object entry = intervalMessagesRaw.get(i);
            if (!(entry instanceof Map)) {
                this.getLogger().warning("Interval message entry #" + (i + 1) + " is not a valid map. Skipping.");
                continue;
            }
            Map mapEntry = (Map)entry;
            if (!mapEntry.containsKey("message") || !(mapEntry.get("message") instanceof String)) {
                this.getLogger().warning("Interval message entry #" + (i + 1) + " missing valid 'message' field.");
            }
            if (!mapEntry.containsKey("interval")) {
                this.getLogger().warning("Interval message entry #" + (i + 1) + " missing 'interval' field. Defaulting to 20.");
                continue;
            }
            try {
                int interval = Integer.parseInt(mapEntry.get("interval").toString());
                if (interval > 0) continue;
                this.getLogger().warning("Interval message entry #" + (i + 1) + " has non-positive interval: " + interval);
                continue;
            }
            catch (NumberFormatException e) {
                this.getLogger().warning("Interval message entry #" + (i + 1) + " has invalid interval: " + String.valueOf(mapEntry.get("interval")));
            }
        }
        List joinMessages = this.getConfig().getStringList("messages.join");
        if (joinMessages.isEmpty()) {
            this.getLogger().warning("No join messages configured in config.yml!");
        }
    }

    private void cancelAllTasks() {
        for (BukkitRunnable task : this.runningTasks) {
            try {
                task.cancel();
            }
            catch (Exception e) {
                this.getLogger().log(Level.WARNING, "Error cancelling task: " + e.getMessage(), e);
            }
        }
        this.runningTasks.clear();
        this.scheduledMessages.clear();
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        if (!this.enabled) {
            return;
        }
        Player player = event.getPlayer();
        List<JoinMessage> joinMessages = this.loadJoinMessages();
        if (joinMessages.isEmpty()) {
            this.getLogger().warning("Join messages list is empty, no join message sent.");
            return;
        }
        List applicableMessages = joinMessages.stream().filter(jm -> jm.worlds.isEmpty() || jm.worlds.contains(player.getWorld().getName())).collect(Collectors.toList());
        if (applicableMessages.isEmpty()) {
            if (this.debugLogging) {
                this.getLogger().info("No join messages applicable for world " + player.getWorld().getName());
            }
            return;
        }
        int maxMessages = this.getConfig().getInt("messages.join-max-messages", 1);
        maxMessages = Math.max(1, maxMessages);
        List<Object> selectedMessages = new ArrayList();
        if (this.randomOrder) {
            Collections.shuffle(applicableMessages);
            selectedMessages = applicableMessages.stream().limit(maxMessages).collect(Collectors.toList());
        } else {
            selectedMessages = applicableMessages.stream().limit(maxMessages).collect(Collectors.toList());
        }
        for (JoinMessage jm2 : selectedMessages) {
            String msg = this.colorize(this.replacePlaceholders(jm2.message, player));
            player.sendMessage(msg);
        }
    }

    private List<JoinMessage> loadJoinMessages() {
        List rawJoinMessages = this.getConfig().getStringList("messages.join");
        ArrayList<JoinMessage> joinMessages = new ArrayList<JoinMessage>();
        ConfigurationSection joinPerWorldSection = this.getConfig().getConfigurationSection("messages.join-per-world");
        if (joinPerWorldSection != null) {
            for (String worldName : joinPerWorldSection.getKeys(false)) {
                List messages = joinPerWorldSection.getStringList(worldName);
                for (String msg : messages) {
                    joinMessages.add(new JoinMessage(msg, Collections.singleton(worldName)));
                }
            }
        }
        for (String msg : rawJoinMessages) {
            joinMessages.add(new JoinMessage(msg, Collections.emptySet()));
        }
        return joinMessages;
    }

    private void scheduleAllMessages() {
        if (!this.enabled) {
            return;
        }
        this.cancelAllTasks();
        List intervalMessagesRaw = this.getConfig().getList("messages.interval");
        if (intervalMessagesRaw == null || intervalMessagesRaw.isEmpty()) {
            this.getLogger().warning("No interval messages configured in config.yml!");
            return;
        }
        for (int i = 0; i < intervalMessagesRaw.size(); ++i) {
            Object entry = intervalMessagesRaw.get(i);
            if (!(entry instanceof Map)) {
                this.getLogger().warning("Skipping invalid interval message entry #" + (i + 1) + ": not a map");
                continue;
            }
            Map mapEntry = (Map)entry;
            try {
                Object worldsObj;
                String message = (String)mapEntry.get("message");
                if (message == null) {
                    this.getLogger().warning("Interval message #" + (i + 1) + " missing 'message' field. Skipping.");
                    continue;
                }
                int interval2 = 20;
                if (mapEntry.containsKey("interval")) {
                    try {
                        interval2 = Integer.parseInt(mapEntry.get("interval").toString());
                        if (interval2 <= 0) {
                            this.getLogger().warning("Interval message #" + (i + 1) + " has non-positive interval: " + interval2 + ". Using 20.");
                            interval2 = 20;
                        }
                    }
                    catch (NumberFormatException e) {
                        this.getLogger().warning("Interval message #" + (i + 1) + " has invalid interval: " + String.valueOf(mapEntry.get("interval")) + ". Using 20.");
                        interval2 = 20;
                    }
                }
                String permission = null;
                if (mapEntry.containsKey("permission")) {
                    permission = mapEntry.get("permission").toString();
                }
                HashSet<String> worlds = new HashSet<String>();
                if (mapEntry.containsKey("worlds") && (worldsObj = mapEntry.get("worlds")) instanceof List) {
                    for (Object w : (List)worldsObj) {
                        if (w == null) continue;
                        worlds.add(w.toString());
                    }
                }
                TimedMessage timedMessage = new TimedMessage(message, permission, worlds);
                this.scheduledMessages.computeIfAbsent(interval2, k -> new ArrayList()).add(timedMessage);
                continue;
            }
            catch (Exception e) {
                this.getLogger().warning("Skipping invalid interval message entry #" + (i + 1) + ": " + e.getMessage());
            }
        }
        this.scheduledMessages.forEach((interval, messages) -> {
            if (messages.isEmpty()) {
                return;
            }
            if (this.randomOrder) {
                Collections.shuffle(messages);
            }
            BukkitRunnable task = new BukkitRunnable((List)messages){
                private int currentIndex = 0;
                final /* synthetic */ List val$messages;
                {
                    this.val$messages = list;
                }

                public void run() {
                    boolean anyPlayerHasPermission;
                    if (!AutoMessages999.this.enabled) {
                        this.cancel();
                        return;
                    }
                    if (this.val$messages.isEmpty()) {
                        return;
                    }
                    if (this.currentIndex >= this.val$messages.size()) {
                        this.currentIndex = 0;
                    }
                    TimedMessage timedMessage = (TimedMessage)this.val$messages.get(this.currentIndex);
                    String formatted = AutoMessages999.this.colorize(timedMessage.message);
                    if (!Bukkit.getOnlinePlayers().isEmpty() && !(anyPlayerHasPermission = Bukkit.getOnlinePlayers().stream().anyMatch(p -> p.hasPermission("automessages.use")))) {
                        long now;
                        if (AutoMessages999.this.debugLogging && (now = System.currentTimeMillis()) - AutoMessages999.this.lastDebugLogTime > 10000L) {
                            AutoMessages999.this.getLogger().info("No players with 'automessages.use' permission online, skipping message broadcast.");
                            AutoMessages999.this.lastDebugLogTime = now;
                        }
                        this.currentIndex = (this.currentIndex + 1) % this.val$messages.size();
                        return;
                    }
                    if (timedMessage.permission == null && timedMessage.worlds.isEmpty()) {
                        long now;
                        Bukkit.broadcastMessage((String)AutoMessages999.this.replacePlaceholders(formatted, null));
                        if (AutoMessages999.this.debugLogging && (now = System.currentTimeMillis()) - AutoMessages999.this.lastDebugLogTime > 10000L) {
                            AutoMessages999.this.getLogger().info("Broadcasted message: " + formatted);
                            AutoMessages999.this.lastDebugLogTime = now;
                        }
                    } else {
                        long now;
                        for (Player player : Bukkit.getOnlinePlayers()) {
                            if (!player.hasPermission("automessages.use") || timedMessage.permission != null && !player.hasPermission(timedMessage.permission) || !timedMessage.worlds.isEmpty() && !timedMessage.worlds.contains(player.getWorld().getName())) continue;
                            player.sendMessage(AutoMessages999.this.replacePlaceholders(formatted, player));
                        }
                        if (AutoMessages999.this.debugLogging && (now = System.currentTimeMillis()) - AutoMessages999.this.lastDebugLogTime > 10000L) {
                            AutoMessages999.this.getLogger().info("Sent message with permission/world filter: " + formatted);
                            AutoMessages999.this.lastDebugLogTime = now;
                        }
                    }
                    timedMessage.incrementSentCount();
                    this.currentIndex = (this.currentIndex + 1) % this.val$messages.size();
                }
            };
            long intervalTicks = (long)interval.intValue() * 20L;
            long initialDelay = this.delayFirstMessage ? intervalTicks : 0L;
            task.runTaskTimer((Plugin)this, initialDelay, intervalTicks);
            this.runningTasks.add(task);
        });
    }

    private String replacePlaceholders(String message, Player player) {
        String replaced = message;
        replaced = player != null ? replaced.replace("%playername%", player.getName()) : replaced.replace("%playername%", "Player");
        replaced = replaced.replace("%online%", String.valueOf(Bukkit.getOnlinePlayers().size()));
        replaced = replaced.replace("%maxplayers%", String.valueOf(Bukkit.getMaxPlayers()));
        replaced = replaced.replace("%server%", Bukkit.getServer().getName());
        replaced = replaced.replace("%motd%", Bukkit.getServer().getMotd());
        replaced = replaced.replace("%version%", Bukkit.getServer().getVersion());
        Plugin[] plugins = Bukkit.getPluginManager().getPlugins();
        String pluginList = Arrays.stream(plugins).map(Plugin::getName).sorted().collect(Collectors.joining(", "));
        replaced = replaced.replace("%plugins%", pluginList);
        long uptimeMillis = System.currentTimeMillis() - this.serverStartTime;
        replaced = replaced.replace("%uptime%", this.formatDuration(uptimeMillis));
        World defaultWorld = Bukkit.getWorlds().isEmpty() ? null : (World)Bukkit.getWorlds().get(0);
        replaced = replaced.replace("%default_world%", defaultWorld != null ? defaultWorld.getName() : "world");
        Object serverIp = "unknown";
        int serverPort = Bukkit.getServer().getPort();
        String ip = Bukkit.getServer().getIp();
        serverIp = ip != null && !ip.isEmpty() ? ip + ":" + serverPort : "localhost:" + serverPort;
        replaced = replaced.replace("%server_ip%", (CharSequence)serverIp);
        if (player != null) {
            World w = player.getWorld();
            replaced = replaced.replace("%world%", w.getName());
            replaced = replaced.replace("%world_time%", String.valueOf(w.getTime()));
            replaced = replaced.replace("%world_day%", String.valueOf(w.getFullTime() / 24000L));
            replaced = replaced.replace("%world_players%", String.valueOf(w.getPlayers().size()));
            replaced = replaced.replace("%world_weather%", this.getWeatherString(w));
            replaced = replaced.replace("%world_seed%", String.valueOf(w.getSeed()));
        } else {
            replaced = replaced.replace("%world%", "world");
            replaced = replaced.replace("%world_time%", "0");
            replaced = replaced.replace("%world_day%", "0");
            replaced = replaced.replace("%world_players%", "0");
            replaced = replaced.replace("%world_weather%", "clear");
            replaced = replaced.replace("%world_seed%", "0");
        }
        double tps = this.getServerTPS();
        replaced = replaced.replace("%tps%", String.format(Locale.US, "%.2f", tps));
        Calendar cal = Calendar.getInstance();
        replaced = replaced.replace("%time%", new SimpleDateFormat("HH:mm:ss").format(cal.getTime()));
        replaced = replaced.replace("%date%", new SimpleDateFormat("yyyy-MM-dd").format(cal.getTime()));
        replaced = replaced.replace("%day%", String.valueOf(cal.get(5)));
        replaced = replaced.replace("%month%", String.valueOf(cal.get(2) + 1));
        replaced = replaced.replace("%year%", String.valueOf(cal.get(1)));
        replaced = replaced.replace("%hour%", String.valueOf(cal.get(11)));
        replaced = replaced.replace("%minute%", String.valueOf(cal.get(12)));
        replaced = replaced.replace("%second%", String.valueOf(cal.get(13)));
        return replaced;
    }

    private String getWeatherString(World w) {
        if (w.hasStorm()) {
            if (w.isThundering()) {
                return "thunder";
            }
            return "rain";
        }
        return "clear";
    }

    private double getServerTPS() {
        try {
            Server server = Bukkit.getServer();
            Object minecraftServer = server.getClass().getMethod("getServer", new Class[0]).invoke((Object)server, new Object[0]);
            Object recentTps = minecraftServer.getClass().getField("recentTps").get(minecraftServer);
            if (recentTps instanceof double[]) {
                double[] tpsArray = (double[])recentTps;
                return tpsArray.length > 0 ? tpsArray[0] : 20.0;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 20.0;
    }

    private String formatDuration(long millis) {
        long seconds = millis / 1000L;
        long hours = seconds / 3600L;
        long minutes = seconds % 3600L / 60L;
        long secs = seconds % 60L;
        return String.format("%02d:%02d:%02d", hours, minutes, secs);
    }

    private String colorize(String text) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)text);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String sub;
        if (args.length == 0) {
            sender.sendMessage(this.colorize("&6AutoMessages999 &7- &eUsage:"));
            sender.sendMessage(this.colorize("&e/automessages reload &7- Reload the config"));
            sender.sendMessage(this.colorize("&e/automessages toggle &7- Enable/disable automated messages"));
            return true;
        }
        switch (sub = args[0].toLowerCase(Locale.ROOT)) {
            case "reload": {
                if (!sender.hasPermission("automessages.reload")) {
                    sender.sendMessage(this.colorize("&cYou do not have permission to reload AutoMessages."));
                    return true;
                }
                this.reloadPluginConfig();
                this.scheduleAllMessages();
                sender.sendMessage(this.colorize("&aAutoMessages config reloaded and messages rescheduled."));
                this.getLogger().info(sender.getName() + " reloaded AutoMessages config.");
                return true;
            }
            case "toggle": {
                if (!sender.hasPermission("automessages.toggle")) {
                    sender.sendMessage(this.colorize("&cYou do not have permission to toggle AutoMessages."));
                    return true;
                }
                this.enabled = !this.enabled;
                this.getConfig().set("messages.enabled", (Object)this.enabled);
                this.saveConfig();
                if (this.enabled) {
                    this.scheduleAllMessages();
                    sender.sendMessage(this.colorize("&aAutoMessages enabled."));
                    this.getLogger().info(sender.getName() + " enabled AutoMessages.");
                } else {
                    this.cancelAllTasks();
                    sender.sendMessage(this.colorize("&cAutoMessages disabled."));
                    this.getLogger().info(sender.getName() + " disabled AutoMessages.");
                }
                return true;
            }
        }
        sender.sendMessage(this.colorize("&cUnknown subcommand. Use /automessages reload or /automessages toggle."));
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            List<String> subs = Arrays.asList("reload", "toggle");
            return subs.stream().filter(s -> s.startsWith(args[0].toLowerCase(Locale.ROOT))).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private static class JoinMessage {
        final String message;
        final Set<String> worlds;

        JoinMessage(String message, Set<String> worlds) {
            this.message = message;
            this.worlds = worlds;
        }
    }

    private static class TimedMessage {
        final String message;
        final String permission;
        final Set<String> worlds;
        private int sentCount = 0;

        TimedMessage(String message, String permission, Set<String> worlds) {
            this.message = message;
            this.permission = permission;
            this.worlds = worlds;
        }

        void incrementSentCount() {
            ++this.sentCount;
        }

        int getSentCount() {
            return this.sentCount;
        }
    }
}

