/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.automessages999;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class AutoMessages999
extends JavaPlugin
implements Listener,
TabExecutor {
    private boolean enabled;
    private boolean randomOrder;
    private boolean debugLogging;
    private boolean delayFirstMessage;
    private final Map<Integer, List<TimedMessage>> scheduledMessages = new HashMap<Integer, List<TimedMessage>>();
    private final List<BukkitRunnable> runningTasks = new ArrayList<BukkitRunnable>();

    public void onEnable() {
        this.saveDefaultConfig();
        this.reloadPluginConfig();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getCommand("automessages").setExecutor((CommandExecutor)this);
        this.scheduleAllMessages();
        this.getLogger().info("AutoMessages999 has been enabled!");
    }

    public void onDisable() {
        this.cancelAllTasks();
        this.getLogger().info("AutoMessages999 has been disabled!");
    }

    private void reloadPluginConfig() {
        this.reloadConfig();
        this.enabled = this.getConfig().getBoolean("messages.enabled", true);
        this.randomOrder = this.getConfig().getBoolean("settings.random-order", false);
        this.debugLogging = this.getConfig().getBoolean("settings.debug-logging", false);
        this.delayFirstMessage = this.getConfig().getBoolean("settings.delay-first-message", false);
        this.validateConfig();
    }

    private void validateConfig() {
        List intervalMessages = this.getConfig().getMapList("messages.interval");
        if (intervalMessages.isEmpty()) {
            this.getLogger().warning("No interval messages configured in config.yml!");
        }
        for (int i = 0; i < intervalMessages.size(); ++i) {
            Map entry = (Map)intervalMessages.get(i);
            if (!entry.containsKey("message") || !(entry.get("message") instanceof String)) {
                this.getLogger().warning("Interval message entry #" + (i + 1) + " missing valid 'message' field.");
            }
            if (!entry.containsKey("interval")) {
                this.getLogger().warning("Interval message entry #" + (i + 1) + " missing 'interval' field. Defaulting to 20.");
                continue;
            }
            try {
                int interval = Integer.parseInt(entry.get("interval").toString());
                if (interval > 0) continue;
                this.getLogger().warning("Interval message entry #" + (i + 1) + " has non-positive interval: " + interval);
                continue;
            }
            catch (NumberFormatException e) {
                this.getLogger().warning("Interval message entry #" + (i + 1) + " has invalid interval: " + String.valueOf(entry.get("interval")));
            }
        }
        List joinMessages = this.getConfig().getStringList("messages.join");
        if (joinMessages.isEmpty()) {
            this.getLogger().warning("No join messages configured in config.yml!");
        }
    }

    private void cancelAllTasks() {
        this.runningTasks.forEach(BukkitRunnable::cancel);
        this.runningTasks.clear();
        this.scheduledMessages.clear();
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        if (!this.enabled) {
            return;
        }
        Player player = event.getPlayer();
        List<JoinMessage> joinMessages = this.loadJoinMessages();
        if (joinMessages.isEmpty()) {
            this.getLogger().warning("Join messages list is empty, no join message sent.");
            return;
        }
        List applicableMessages = joinMessages.stream().filter(jm -> jm.worlds.isEmpty() || jm.worlds.contains(player.getWorld().getName())).collect(Collectors.toList());
        if (applicableMessages.isEmpty()) {
            if (this.debugLogging) {
                this.getLogger().info("No join messages applicable for world " + player.getWorld().getName());
            }
            return;
        }
        int maxMessages = this.getConfig().getInt("messages.join-max-messages", 1);
        maxMessages = Math.max(1, maxMessages);
        if (this.randomOrder) {
            Collections.shuffle(applicableMessages);
        }
        int sentCount = 0;
        for (JoinMessage jm2 : applicableMessages) {
            if (sentCount >= maxMessages) break;
            String msg = this.colorize(this.replacePlaceholders(jm2.message, player));
            player.sendMessage(msg);
            ++sentCount;
        }
    }

    private List<JoinMessage> loadJoinMessages() {
        List rawJoinMessages = this.getConfig().getStringList("messages.join");
        ArrayList<JoinMessage> joinMessages = new ArrayList<JoinMessage>();
        ConfigurationSection joinPerWorldSection = this.getConfig().getConfigurationSection("messages.join-per-world");
        if (joinPerWorldSection != null) {
            for (String worldName : joinPerWorldSection.getKeys(false)) {
                List messages = joinPerWorldSection.getStringList(worldName);
                for (String msg : messages) {
                    joinMessages.add(new JoinMessage(msg, Collections.singleton(worldName)));
                }
            }
        }
        for (String msg : rawJoinMessages) {
            joinMessages.add(new JoinMessage(msg, Collections.emptySet()));
        }
        return joinMessages;
    }

    private void scheduleAllMessages() {
        if (!this.enabled) {
            return;
        }
        this.cancelAllTasks();
        List intervalMessages = this.getConfig().getMapList("messages.interval");
        if (intervalMessages.isEmpty()) {
            this.getLogger().warning("No interval messages configured in config.yml!");
            return;
        }
        for (int i = 0; i < intervalMessages.size(); ++i) {
            Map entry = (Map)intervalMessages.get(i);
            try {
                Object worldsObj;
                String message = (String)entry.get("message");
                int interval2 = 20;
                if (entry.containsKey("interval") && (interval2 = Integer.parseInt(entry.get("interval").toString())) <= 0) {
                    this.getLogger().warning("Interval message #" + (i + 1) + " has non-positive interval: " + interval2 + ". Using 20.");
                    interval2 = 20;
                }
                String permission = null;
                if (entry.containsKey("permission")) {
                    permission = entry.get("permission").toString();
                }
                HashSet<String> worlds = new HashSet<String>();
                if (entry.containsKey("worlds") && (worldsObj = entry.get("worlds")) instanceof List) {
                    for (Object w : (List)worldsObj) {
                        if (w == null) continue;
                        worlds.add(w.toString());
                    }
                }
                TimedMessage timedMessage = new TimedMessage(message, permission, worlds);
                this.scheduledMessages.computeIfAbsent(interval2, k -> new ArrayList()).add(timedMessage);
                continue;
            }
            catch (Exception e) {
                this.getLogger().warning("Skipping invalid interval message entry #" + (i + 1) + ": " + e.getMessage());
            }
        }
        this.scheduledMessages.forEach((interval, messages) -> {
            if (messages.isEmpty()) {
                return;
            }
            if (this.randomOrder) {
                Collections.shuffle(messages);
            }
            BukkitRunnable task = new BukkitRunnable(this, (List)messages){
                private int currentIndex = 0;
                final /* synthetic */ List val$messages;
                final /* synthetic */ AutoMessages999 this$0;
                {
                    this.val$messages = list;
                    this.this$0 = this$0;
                }

                public void run() {
                    if (!this.this$0.enabled) {
                        this.cancel();
                        return;
                    }
                    if (this.val$messages.isEmpty()) {
                        return;
                    }
                    TimedMessage timedMessage = (TimedMessage)this.val$messages.get(this.currentIndex);
                    String formatted = this.this$0.colorize(timedMessage.message);
                    if (timedMessage.permission == null && timedMessage.worlds.isEmpty()) {
                        Bukkit.broadcastMessage((String)this.this$0.replacePlaceholders(formatted, null));
                        if (this.this$0.debugLogging) {
                            this.this$0.getLogger().info("Broadcasted message: " + formatted);
                        }
                    } else {
                        for (Player player : Bukkit.getOnlinePlayers()) {
                            if (timedMessage.permission != null && !player.hasPermission(timedMessage.permission) || !timedMessage.worlds.isEmpty() && !timedMessage.worlds.contains(player.getWorld().getName())) continue;
                            player.sendMessage(this.this$0.replacePlaceholders(formatted, player));
                        }
                        if (this.this$0.debugLogging) {
                            this.this$0.getLogger().info("Sent message with permission/world filter: " + formatted);
                        }
                    }
                    timedMessage.incrementSentCount();
                    this.currentIndex = (this.currentIndex + 1) % this.val$messages.size();
                }
            };
            long intervalTicks = (long)interval.intValue() * 20L;
            long initialDelay = this.delayFirstMessage ? intervalTicks : 0L;
            task.runTaskTimer((Plugin)this, initialDelay, intervalTicks);
            this.runningTasks.add(task);
        });
    }

    private String replacePlaceholders(String message, Player player) {
        String replaced = message;
        replaced = player != null ? replaced.replace("%player%", player.getName()) : replaced.replace("%player%", "Player");
        replaced = replaced.replace("%online%", String.valueOf(Bukkit.getOnlinePlayers().size()));
        replaced = replaced.replace("%server%", Bukkit.getServer().getName());
        String time = new SimpleDateFormat("HH:mm:ss").format(new Date());
        replaced = replaced.replace("%time%", time);
        return replaced;
    }

    private String colorize(String text) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)text);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String sub;
        if (args.length == 0) {
            sender.sendMessage(this.colorize("&6AutoMessages999 &7- &eUsage:"));
            sender.sendMessage(this.colorize("&e/automessages reload &7- Reload the config"));
            sender.sendMessage(this.colorize("&e/automessages toggle &7- Enable/disable automated messages"));
            return true;
        }
        switch (sub = args[0].toLowerCase(Locale.ROOT)) {
            case "reload": {
                if (!sender.hasPermission("automessages.reload")) {
                    sender.sendMessage(this.colorize("&cYou do not have permission to reload AutoMessages."));
                    return true;
                }
                this.reloadPluginConfig();
                this.scheduleAllMessages();
                sender.sendMessage(this.colorize("&aAutoMessages config reloaded and messages rescheduled."));
                this.getLogger().info(sender.getName() + " reloaded AutoMessages config.");
                return true;
            }
            case "toggle": {
                if (!sender.hasPermission("automessages.toggle")) {
                    sender.sendMessage(this.colorize("&cYou do not have permission to toggle AutoMessages."));
                    return true;
                }
                this.enabled = !this.enabled;
                this.getConfig().set("messages.enabled", (Object)this.enabled);
                this.saveConfig();
                if (this.enabled) {
                    this.scheduleAllMessages();
                    sender.sendMessage(this.colorize("&aAutoMessages enabled."));
                    this.getLogger().info(sender.getName() + " enabled AutoMessages.");
                } else {
                    this.cancelAllTasks();
                    sender.sendMessage(this.colorize("&cAutoMessages disabled."));
                    this.getLogger().info(sender.getName() + " disabled AutoMessages.");
                }
                return true;
            }
        }
        sender.sendMessage(this.colorize("&cUnknown subcommand. Use /automessages reload or /automessages toggle."));
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            List<String> subs = Arrays.asList("reload", "toggle");
            return subs.stream().filter(s -> s.startsWith(args[0].toLowerCase(Locale.ROOT))).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private static class JoinMessage {
        final String message;
        final Set<String> worlds;

        JoinMessage(String message, Set<String> worlds) {
            this.message = message;
            this.worlds = worlds;
        }
    }

    private static class TimedMessage {
        final String message;
        final String permission;
        final Set<String> worlds;
        private int sentCount = 0;

        TimedMessage(String message, String permission, Set<String> worlds) {
            this.message = message;
            this.permission = permission;
            this.worlds = worlds;
        }

        void incrementSentCount() {
            ++this.sentCount;
        }

        int getSentCount() {
            return this.sentCount;
        }
    }
}

