/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.automessages999;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class AutoMessages999
extends JavaPlugin
implements Listener {
    private FileConfiguration config;
    private File configFile;
    private final Map<Integer, List<TimedMessage>> scheduledMessages = new HashMap<Integer, List<TimedMessage>>();
    private final List<BukkitRunnable> runningTasks = new ArrayList<BukkitRunnable>();

    public void onEnable() {
        this.setupConfig();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.scheduleAllMessages();
        this.getLogger().info("AutoMessages999 has been enabled!");
    }

    public void onDisable() {
        this.runningTasks.forEach(BukkitRunnable::cancel);
        this.runningTasks.clear();
        this.scheduledMessages.clear();
        this.saveConfig();
        this.getLogger().info("AutoMessages999 has been disabled!");
    }

    private void setupConfig() {
        this.configFile = new File(this.getDataFolder(), "config.yml");
        if (!this.configFile.exists()) {
            this.configFile.getParentFile().mkdirs();
            this.saveResource("config.yml", false);
            this.getLogger().info("Created new config file");
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
        this.config.addDefault("messages.enabled", (Object)true);
        this.config.addDefault("settings.random-order", (Object)false);
        ArrayList<String> defaultJoinMessages = new ArrayList<String>();
        defaultJoinMessages.add("&aWelcome to the server, %player%!");
        defaultJoinMessages.add("&eEnjoy your stay, %player%!");
        defaultJoinMessages.add("&6Welcome back, %player%!");
        ArrayList<Map<String, Object>> defaultIntervalMessages = new ArrayList<Map<String, Object>>();
        this.addDefaultMessage(defaultIntervalMessages, "&aRules reminder every 10s", 10);
        this.addDefaultMessage(defaultIntervalMessages, "&bTwitter updates @ServerName (20s)", 20);
        this.addDefaultMessage(defaultIntervalMessages, "&dJoin our Discord (30s)", 30);
        this.addDefaultMessage(defaultIntervalMessages, "&eServer restart notice (40s)", 40);
        this.addDefaultMessage(defaultIntervalMessages, "&6Vote for rewards (50s)", 50);
        this.addDefaultMessage(defaultIntervalMessages, "&aStarter kits available (60s)", 60);
        this.addDefaultMessage(defaultIntervalMessages, "&bWeekly events schedule (70s)", 70);
        this.addDefaultMessage(defaultIntervalMessages, "&cReport bugs to staff (80s)", 80);
        this.addDefaultMessage(defaultIntervalMessages, "&dUse /help for commands (90s)", 90);
        this.addDefaultMessage(defaultIntervalMessages, "&eHave fun! (100s)", 100);
        this.config.addDefault("messages.join", defaultJoinMessages);
        this.config.addDefault("messages.interval", defaultIntervalMessages);
        this.config.options().copyDefaults(true);
        this.saveConfig();
    }

    private void addDefaultMessage(List<Map<String, Object>> list, String message, int interval) {
        HashMap<String, Object> entry = new HashMap<String, Object>();
        entry.put("message", message);
        entry.put("interval", interval);
        list.add(entry);
    }

    public void saveConfig() {
        try {
            this.config.save(this.configFile);
        }
        catch (IOException e) {
            this.getLogger().log(Level.SEVERE, "Could not save config to " + String.valueOf(this.configFile), e);
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        if (!this.config.getBoolean("messages.enabled", true)) {
            return;
        }
        List joinMessages = this.config.getStringList("messages.join");
        if (joinMessages.isEmpty()) {
            return;
        }
        String randomMessage = (String)joinMessages.get((int)(Math.random() * (double)joinMessages.size()));
        event.getPlayer().sendMessage(this.colorize(randomMessage.replace("%player%", event.getPlayer().getName())));
    }

    private void scheduleAllMessages() {
        if (!this.config.getBoolean("messages.enabled", true)) {
            return;
        }
        List intervalMessages = this.config.getMapList("messages.interval");
        if (intervalMessages.isEmpty()) {
            this.getLogger().warning("No interval messages configured in config.yml!");
            return;
        }
        this.scheduledMessages.clear();
        this.runningTasks.forEach(BukkitRunnable::cancel);
        this.runningTasks.clear();
        for (Map entry : intervalMessages) {
            try {
                String message = (String)entry.get("message");
                int interval2 = entry.containsKey("interval") ? Integer.parseInt(entry.get("interval").toString()) : 20;
                this.scheduledMessages.computeIfAbsent(interval2, k -> new ArrayList()).add(new TimedMessage(message));
            }
            catch (Exception e) {
                this.getLogger().warning("Skipping invalid message entry: " + e.getMessage());
            }
        }
        this.scheduledMessages.forEach((interval, messages) -> {
            BukkitRunnable task = new BukkitRunnable(this, (List)messages){
                private int currentIndex = 0;
                final /* synthetic */ List val$messages;
                final /* synthetic */ AutoMessages999 this$0;
                {
                    this.val$messages = list;
                    this.this$0 = this$0;
                }

                public void run() {
                    if (!this.this$0.config.getBoolean("messages.enabled", true)) {
                        this.cancel();
                        return;
                    }
                    TimedMessage message = (TimedMessage)this.val$messages.get(this.currentIndex);
                    String formatted = this.this$0.colorize(message.message);
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        player.sendMessage(formatted.replace("%player%", player.getName()));
                    }
                    this.currentIndex = (this.currentIndex + 1) % this.val$messages.size();
                }
            };
            long intervalTicks = (long)interval.intValue() * 20L;
            task.runTaskTimer((Plugin)this, intervalTicks, intervalTicks);
            this.runningTasks.add(task);
        });
    }

    private String colorize(String text) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)text);
    }

    private static class TimedMessage {
        final String message;

        TimedMessage(String message) {
            this.message = message;
        }
    }
}

