/*
 * Decompiled with CFR 0.152.
 */
package com.avatarkage.balisongs;

import com.avatarkage.balisongs.items.BalisongItem;
import com.avatarkage.balisongs.registry.ModDataComponents;
import com.avatarkage.balisongs.registry.ModItemProperties;
import com.avatarkage.balisongs.registry.ModItems;
import com.avatarkage.balisongs.registry.ModSounds;
import com.mojang.logging.LogUtils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import org.slf4j.Logger;

@Mod(value="balisongs")
public class BalisongsMod {
    public static final String MODID = "balisongs";
    public static final Logger LOGGER = LogUtils.getLogger();

    public BalisongsMod(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::addCreative);
        modEventBus.addListener(this::onClientSetup);
        ModItems.register(modEventBus);
        ModSounds.register(modEventBus);
        ModDataComponents.register(modEventBus);
        NeoForge.EVENT_BUS.addListener(this::addBalisongTooltip);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.COMBAT) {
            event.insertAfter(new ItemStack((ItemLike)Items.NETHERITE_AXE), new ItemStack((ItemLike)ModItems.WOODEN_BALISONG.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)ModItems.WOODEN_BALISONG.get()), new ItemStack((ItemLike)ModItems.STONE_BALISONG.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)ModItems.STONE_BALISONG.get()), new ItemStack((ItemLike)ModItems.IRON_BALISONG.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)ModItems.IRON_BALISONG.get()), new ItemStack((ItemLike)ModItems.GOLDEN_BALISONG.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)ModItems.GOLDEN_BALISONG.get()), new ItemStack((ItemLike)ModItems.DIAMOND_BALISONG.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)ModItems.DIAMOND_BALISONG.get()), new ItemStack((ItemLike)ModItems.NETHERITE_BALISONG.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            if (ModList.get().isLoaded("vanillabackport")) {
                event.insertAfter(new ItemStack((ItemLike)ModItems.NETHERITE_BALISONG.get()), new ItemStack((ItemLike)ModItems.COPPER_BALISONG.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            }
        }
        if (event.getTabKey() == CreativeModeTabs.TOOLS_AND_UTILITIES) {
            event.insertAfter(new ItemStack((ItemLike)Items.WOODEN_HOE), new ItemStack((ItemLike)ModItems.WOODEN_BALISONG.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)Items.STONE_HOE), new ItemStack((ItemLike)ModItems.STONE_BALISONG.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)Items.IRON_HOE), new ItemStack((ItemLike)ModItems.IRON_BALISONG.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)Items.GOLDEN_HOE), new ItemStack((ItemLike)ModItems.GOLDEN_BALISONG.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)Items.DIAMOND_HOE), new ItemStack((ItemLike)ModItems.DIAMOND_BALISONG.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)Items.NETHERITE_HOE), new ItemStack((ItemLike)ModItems.NETHERITE_BALISONG.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            if (ModList.get().isLoaded("vanillabackport")) {
                event.insertAfter(new ItemStack((ItemLike)ModItems.NETHERITE_BALISONG.get()), new ItemStack((ItemLike)ModItems.COPPER_BALISONG.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            }
        }
    }

    private void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(ModItemProperties::addCustomItemProperties);
    }

    private void addBalisongTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        Item item = stack.getItem();
        if (!(item instanceof BalisongItem)) {
            return;
        }
        BalisongItem balisong = (BalisongItem)item;
        boolean closed = (Boolean)stack.get((DataComponentType)ModDataComponents.CLOSED.get());
        float damage = balisong.getDamage(closed);
        float speed = balisong.getAttackSpeed(closed);
        float tooltipDamage = damage + 0.0f;
        float tooltipSpeed = 3.5f + speed;
        List tooltip = event.getToolTip();
        tooltip.add(Component.empty());
        tooltip.add(Component.literal((String)"When in main hand:").withStyle(ChatFormatting.GRAY));
        tooltip.add(Component.literal((String)" ").append((Component)Component.literal((String)(this.format(tooltipDamage) + " Attack Damage")).withStyle(ChatFormatting.DARK_GREEN)));
        tooltip.add(Component.literal((String)" ").append((Component)Component.literal((String)(this.format(tooltipSpeed) + " Attack Speed")).withStyle(ChatFormatting.DARK_GREEN)));
    }

    private String format(float value) {
        if (value == (float)((int)value)) {
            return String.valueOf((int)value);
        }
        return String.format("%.2f", Float.valueOf(value)).replaceAll("0+$", "").replaceAll("\\.$", "");
    }
}

