/*
 * Decompiled with CFR 0.152.
 */
package com.avatarkage.balisongs.items;

import com.avatarkage.balisongs.registry.ModDataComponents;
import com.avatarkage.balisongs.registry.ModSounds;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;

/*
 * Uses jvm11+ dynamic constants - pseudocode provided - see https://www.benf.org/other/cfr/dynamic-constants.html
 */
public class BalisongItem
extends SwordItem {
    private final Tier tier;
    private static final int WINDOW_SECONDS = 3;
    private static final int TICKS_PER_SECOND = 20;
    private static final Map<UUID, int[]> flipWindow = new HashMap<UUID, int[]>();
    private static final Map<UUID, Long> windowStartTick = new HashMap<UUID, Long>();
    private final Map<UUID, Long> lastFlipTick = new HashMap<UUID, Long>();

    public BalisongItem(Item.Properties properties, Tier tier) {
        super(tier, properties);
        this.tier = tier;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        int secondIndex;
        ItemStack stack = player.getItemInHand(hand);
        player.swing(hand);
        player.startUsingItem(hand);
        boolean closed = (Boolean)stack.get(ModDataComponents.CLOSED);
        stack.set(ModDataComponents.CLOSED, (Object)(!closed ? 1 : 0));
        Random random = new Random();
        float pitchVariation = 1.0f + (random.nextFloat() - 0.4f) * 0.3f;
        level.playSound(null, player.getX(), player.getY(), player.getZ(), ModSounds.FLIP_BALISONG.get(), SoundSource.PLAYERS, 0.75f, pitchVariation);
        UUID uuid = player.getUUID();
        long currentTick = level.getGameTime();
        flipWindow.putIfAbsent(uuid, new int[3]);
        windowStartTick.putIfAbsent(uuid, currentTick);
        this.lastFlipTick.put(uuid, currentTick);
        int[] window = flipWindow.get(uuid);
        long startTick = windowStartTick.get(uuid);
        if (currentTick - startTick >= 60L) {
            Arrays.fill(window, 0);
            startTick = currentTick;
            windowStartTick.put(uuid, startTick);
        }
        if ((secondIndex = (int)((currentTick - startTick) / 20L)) >= 3) {
            secondIndex = 2;
        }
        ResourceLocation momentumKey = ResourceLocation.fromNamespaceAndPath((String)"balisongs", (String)"momentum");
        Holder momentumHolder = player.level().registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolder(momentumKey).orElse(null);
        int momentumLevel = momentumHolder != null ? EnchantmentHelper.getItemEnchantmentLevel((Holder)momentumHolder, (ItemStack)stack) : 0;
        int increment = 1;
        if (momentumLevel > 0) {
            increment *= (int)Math.pow(1.35, momentumLevel);
        }
        int n = secondIndex;
        window[n] = window[n] + increment;
        return InteractionResultHolder.consume((Object)stack);
    }

    private void updateFlipWindow(Player player, Level level) {
        UUID uuid = player.getUUID();
        long currentTick = level.getGameTime();
        flipWindow.putIfAbsent(uuid, new int[3]);
        windowStartTick.putIfAbsent(uuid, currentTick);
        int[] window = flipWindow.get(uuid);
        long startTick = windowStartTick.get(uuid);
        Long lastTick = this.lastFlipTick.get(uuid);
        if (lastTick != null && currentTick - lastTick >= 60L) {
            Arrays.fill(window, 0);
            startTick = currentTick;
            windowStartTick.put(uuid, startTick);
        }
        this.lastFlipTick.put(uuid, currentTick);
        for (int secondIndex = (int)((currentTick - startTick) / 20L); secondIndex >= 3; --secondIndex) {
            for (int i = 0; i < 2; ++i) {
                window[i] = window[i + 1];
            }
            window[2] = 0;
            windowStartTick.put(uuid, startTick += 20L);
        }
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slot, boolean selected) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (selected) {
            this.updateFlipWindow(player, level);
        }
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        Player player;
        boolean isClosed = (Boolean)stack.get(ModDataComponents.CLOSED);
        float baseDamage = this.getDamage(isClosed);
        if (!isClosed && attacker instanceof Player) {
            player = (Player)attacker;
            int[] window = flipWindow.getOrDefault(player.getUUID(), new int[3]);
            int totalFlips = Arrays.stream(window).sum();
            baseDamage += (float)totalFlips * 0.35f;
            flipWindow.put(player.getUUID(), new int[3]);
            windowStartTick.put(player.getUUID(), player.level().getGameTime());
        }
        target.hurt(attacker.damageSources().mobAttack(attacker), baseDamage);
        if (isClosed && !this.shouldBreakStun(target)) {
            target.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 40, 255, false, false, false));
        }
        if (attacker instanceof Player && !(player = (Player)attacker).isCreative()) {
            this.damageItem(stack, player);
        }
        return true;
    }

    private boolean shouldBreakStun(LivingEntity target) {
        if (target.isBlocking()) {
            return true;
        }
        if (target instanceof IronGolem || target instanceof Shulker || target instanceof WitherBoss || target instanceof EnderDragon || target instanceof Warden) {
            return true;
        }
        return this.hasIronPlusArmor(target);
    }

    private boolean hasIronPlusArmor(LivingEntity entity) {
        AbstractHorse horse;
        ItemStack horseArmor;
        ItemStack helmet = entity.getItemBySlot(EquipmentSlot.HEAD);
        if (helmet.is(Items.IRON_HELMET) || helmet.is(Items.DIAMOND_HELMET) || helmet.is(Items.NETHERITE_HELMET)) {
            return true;
        }
        return entity instanceof AbstractHorse && ((horseArmor = (horse = (AbstractHorse)entity).getBodyArmorItem()).is(Items.IRON_HORSE_ARMOR) || horseArmor.is(Items.DIAMOND_HORSE_ARMOR));
    }

    private void damageItem(ItemStack stack, Player player) {
        stack.setDamageValue(stack.getDamageValue() + 1);
        if (stack.getDamageValue() >= stack.getMaxDamage()) {
            stack.setCount(0);
        }
    }

    /*
     * Exception decompiling
     */
    public float getDamage(boolean closed) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't turn ConstantPoolEntry into Literal - got DynamicInfo value=1,450
         *     at org.benf.cfr.reader.bytecode.analysis.parse.literal.TypedLiteral.getConstantPoolEntry(TypedLiteral.java:340)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.getBootstrapArg(Op02WithProcessedDataAndRefs.java:538)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.getVarArgs(Op02WithProcessedDataAndRefs.java:671)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeBootstrapArgs(Op02WithProcessedDataAndRefs.java:630)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:411)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
         *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public float getAttackSpeed(boolean closed) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't turn ConstantPoolEntry into Literal - got DynamicInfo value=1,450
         *     at org.benf.cfr.reader.bytecode.analysis.parse.literal.TypedLiteral.getConstantPoolEntry(TypedLiteral.java:340)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.getBootstrapArg(Op02WithProcessedDataAndRefs.java:538)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.getVarArgs(Op02WithProcessedDataAndRefs.java:671)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeBootstrapArgs(Op02WithProcessedDataAndRefs.java:630)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:411)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
         *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

