/*
 * Decompiled with CFR 0.152.
 */
package com.avatarkage.balisongs;

import com.avatarkage.balisongs.items.BalisongItem;
import com.avatarkage.balisongs.registry.ModDataComponents;
import com.avatarkage.balisongs.registry.ModEnchantments;
import com.avatarkage.balisongs.registry.ModItemProperties;
import com.avatarkage.balisongs.registry.ModItems;
import com.avatarkage.balisongs.registry.ModSounds;
import com.mojang.logging.LogUtils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="balisongs")
public class BalisongsMod {
    public static final String MODID = "balisongs";
    public static final Logger LOGGER = LogUtils.getLogger();

    public BalisongsMod() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::addCreative);
        modEventBus.addListener(this::onClientSetup);
        ModItems.register(modEventBus);
        ModSounds.register(modEventBus);
        ModEnchantments.REGISTRY.register(modEventBus);
        MinecraftForge.EVENT_BUS.addListener(this::addBalisongTooltip);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.f_256797_) {
            event.m_246326_((ItemLike)ModItems.WOODEN_BALISONG.get());
            event.m_246326_((ItemLike)ModItems.STONE_BALISONG.get());
            event.m_246326_((ItemLike)ModItems.IRON_BALISONG.get());
            event.m_246326_((ItemLike)ModItems.GOLDEN_BALISONG.get());
            event.m_246326_((ItemLike)ModItems.DIAMOND_BALISONG.get());
            event.m_246326_((ItemLike)ModItems.NETHERITE_BALISONG.get());
        }
        if (event.getTabKey() == CreativeModeTabs.f_256869_) {
            event.m_246326_((ItemLike)ModItems.WOODEN_BALISONG.get());
            event.m_246326_((ItemLike)ModItems.STONE_BALISONG.get());
            event.m_246326_((ItemLike)ModItems.IRON_BALISONG.get());
            event.m_246326_((ItemLike)ModItems.GOLDEN_BALISONG.get());
            event.m_246326_((ItemLike)ModItems.DIAMOND_BALISONG.get());
            event.m_246326_((ItemLike)ModItems.NETHERITE_BALISONG.get());
        }
    }

    private void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(ModItemProperties::addCustomItemProperties);
    }

    private void addBalisongTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        Item item = stack.m_41720_();
        if (!(item instanceof BalisongItem)) {
            return;
        }
        BalisongItem balisong = (BalisongItem)item;
        boolean closed = ModDataComponents.isClosed(stack);
        float damage = balisong.getDamage(closed);
        float speed = balisong.getAttackSpeed(closed);
        float tooltipDamage = damage;
        float tooltipSpeed = 3.5f + speed;
        List tooltip = event.getToolTip();
        tooltip.add(Component.m_237119_());
        tooltip.add(Component.m_237113_((String)"When in main hand:").m_130940_(ChatFormatting.GRAY));
        tooltip.add(Component.m_237113_((String)" ").m_7220_((Component)Component.m_237113_((String)(this.format(tooltipDamage) + " Attack Damage")).m_130940_(ChatFormatting.DARK_GREEN)));
        tooltip.add(Component.m_237113_((String)" ").m_7220_((Component)Component.m_237113_((String)(this.format(tooltipSpeed) + " Attack Speed")).m_130940_(ChatFormatting.DARK_GREEN)));
    }

    private String format(float value) {
        if (value == (float)((int)value)) {
            return String.valueOf((int)value);
        }
        return String.format("%.2f", Float.valueOf(value)).replaceAll("0+$", "").replaceAll("\\.$", "");
    }
}

