/*
 * Decompiled with CFR 0.152.
 */
package com.avatarkage.balisongs.items;

import com.avatarkage.balisongs.registry.ModEnchantments;
import com.avatarkage.balisongs.registry.ModSounds;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;

public class BalisongItem
extends SwordItem {
    public static final String NBT_CLOSED = "closed";
    private final Tier tier;
    private static final int WINDOW_SECONDS = 3;
    private static final int TICKS_PER_SECOND = 20;
    private static final Map<UUID, int[]> flipWindow = new HashMap<UUID, int[]>();
    private static final Map<UUID, Long> windowStartTick = new HashMap<UUID, Long>();
    private final Map<UUID, Long> lastFlipTick = new HashMap<UUID, Long>();

    public BalisongItem(Item.Properties properties, Tier tier) {
        super(tier, 3, -2.0f, properties);
        this.tier = tier;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        int secondIndex;
        ItemStack stack = player.m_21120_(hand);
        player.m_6674_(hand);
        player.m_6672_(hand);
        boolean closed = stack.m_41784_().m_128471_(NBT_CLOSED);
        stack.m_41784_().m_128379_(NBT_CLOSED, !closed);
        float pitchVariation = 1.0f + (level.f_46441_.m_188501_() - 0.4f) * 0.3f;
        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)ModSounds.FLIP_BALISONG.get(), SoundSource.PLAYERS, 0.75f, pitchVariation);
        UUID uuid = player.m_20148_();
        long currentTick = level.m_46467_();
        flipWindow.putIfAbsent(uuid, new int[3]);
        windowStartTick.putIfAbsent(uuid, currentTick);
        this.lastFlipTick.put(uuid, currentTick);
        int[] window = flipWindow.get(uuid);
        long startTick = windowStartTick.get(uuid);
        if (currentTick - startTick >= 60L) {
            Arrays.fill(window, 0);
            windowStartTick.put(uuid, currentTick);
            startTick = currentTick;
        }
        if ((secondIndex = (int)((currentTick - startTick) / 20L)) >= 3) {
            secondIndex = 2;
        }
        int momentumLevel = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.MOMENTUM.get()), (ItemStack)stack);
        int increment = 1;
        if (momentumLevel > 0) {
            increment *= (int)Math.pow(1.35, momentumLevel);
        }
        int n = secondIndex;
        window[n] = window[n] + increment;
        return InteractionResultHolder.m_19096_((Object)stack);
    }

    private void updateFlipWindow(Player player, Level level) {
        UUID uuid = player.m_20148_();
        long currentTick = level.m_46467_();
        flipWindow.putIfAbsent(uuid, new int[3]);
        windowStartTick.putIfAbsent(uuid, currentTick);
        int[] window = flipWindow.get(uuid);
        long startTick = windowStartTick.get(uuid);
        Long lastTick = this.lastFlipTick.get(uuid);
        if (lastTick != null && currentTick - lastTick >= 60L) {
            Arrays.fill(window, 0);
            windowStartTick.put(uuid, currentTick);
            startTick = currentTick;
        }
        this.lastFlipTick.put(uuid, currentTick);
        for (int secondIndex = (int)((currentTick - startTick) / 20L); secondIndex >= 3; --secondIndex) {
            for (int i = 0; i < 2; ++i) {
                window[i] = window[i + 1];
            }
            window[2] = 0;
            windowStartTick.put(uuid, startTick += 20L);
        }
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean selected) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        this.updateFlipWindow(player, level);
        if (selected) {
            boolean closed = stack.m_41784_().m_128471_(NBT_CLOSED);
            float attackDamage = this.getDamage(closed);
            float attackSpeed = this.getAttackSpeed(closed);
            AttributeModifier damageModifier = new AttributeModifier(f_41374_, "Weapon modifier", (double)attackDamage, AttributeModifier.Operation.ADDITION);
            AttributeModifier speedModifier = new AttributeModifier(f_41375_, "Weapon modifier", (double)attackSpeed, AttributeModifier.Operation.ADDITION);
            if (player.m_21051_(Attributes.f_22281_).m_22111_(f_41374_) != null) {
                player.m_21051_(Attributes.f_22281_).m_22120_(f_41374_);
            }
            if (player.m_21051_(Attributes.f_22283_).m_22111_(f_41375_) != null) {
                player.m_21051_(Attributes.f_22283_).m_22120_(f_41375_);
            }
            player.m_21051_(Attributes.f_22281_).m_22118_(damageModifier);
            player.m_21051_(Attributes.f_22283_).m_22118_(speedModifier);
        }
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        Player player;
        boolean isClosed = stack.m_41784_().m_128471_(NBT_CLOSED);
        float baseDamage = this.getDamage(isClosed);
        if (!isClosed && attacker instanceof Player) {
            player = (Player)attacker;
            int[] window = flipWindow.getOrDefault(player.m_20148_(), new int[3]);
            int flips = Arrays.stream(window).sum();
            baseDamage += (float)flips * 0.35f;
            flipWindow.put(player.m_20148_(), new int[3]);
            windowStartTick.put(player.m_20148_(), player.m_9236_().m_46467_());
        }
        target.m_6469_(attacker.m_269291_().m_269333_(attacker), baseDamage);
        if (isClosed && !this.shouldBreakStun(target)) {
            target.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 40, 255, false, false, false));
        }
        if (attacker instanceof Player && !(player = (Player)attacker).m_7500_()) {
            this.damageItem(stack, player);
        }
        return true;
    }

    private boolean shouldBreakStun(LivingEntity target) {
        if (target.m_21254_()) {
            return true;
        }
        if (target instanceof IronGolem || target instanceof Shulker || target instanceof WitherBoss || target instanceof EnderDragon || target instanceof Warden) {
            return true;
        }
        return this.hasIronPlusArmor(target);
    }

    private boolean hasIronPlusArmor(LivingEntity entity) {
        AbstractHorse horse;
        ItemStack armor;
        ItemStack helmet = entity.m_6844_(EquipmentSlot.HEAD);
        if (helmet.m_150930_(Items.f_42468_) || helmet.m_150930_(Items.f_42472_) || helmet.m_150930_(Items.f_42480_)) {
            return true;
        }
        return entity instanceof AbstractHorse && ((armor = (horse = (AbstractHorse)entity).m_6844_(EquipmentSlot.CHEST)).m_150930_(Items.f_42651_) || armor.m_150930_(Items.f_42653_));
    }

    private void damageItem(ItemStack stack, Player player) {
        stack.m_41721_(stack.m_41773_() + 1);
        if (stack.m_41773_() >= stack.m_41776_()) {
            stack.m_41774_(1);
        }
    }

    public float getDamage(boolean closed) {
        float base = this.tier == Tiers.WOOD ? 1.0f : (this.tier == Tiers.STONE ? 2.0f : (this.tier == Tiers.IRON ? 3.0f : (this.tier == Tiers.GOLD ? 1.0f : (this.tier == Tiers.DIAMOND ? 4.0f : (this.tier == Tiers.NETHERITE ? 5.0f : 1.0f)))));
        return closed ? 1.0f : base;
    }

    public float getAttackSpeed(boolean closed) {
        float base = this.tier == Tiers.WOOD ? -1.4f : (this.tier == Tiers.STONE ? -1.5f : (this.tier == Tiers.IRON ? -1.6f : (this.tier == Tiers.GOLD ? -1.7f : (this.tier == Tiers.DIAMOND ? -1.8f : (this.tier == Tiers.NETHERITE ? -1.9f : -1.0f)))));
        return closed ? base : base + 0.5f;
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot slot) {
        return ImmutableMultimap.of();
    }
}

