/*
 * Decompiled with CFR 0.152.
 */
package com.oldschooljail.config;

import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.oldschooljail.OldSchoolJailMod;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;

public class JailConfig {
    public TimeUnit inputTimeUnit = TimeUnit.MINUTES;
    public long maxSentenceSeconds = 86400L;
    public boolean allowJailTime = true;
    public boolean blockCommands = true;
    public boolean blockTeleportation = true;
    public boolean blockBlockBreaking = true;
    public boolean blockBlockPlacing = true;
    public boolean blockInteraction = true;
    public String releaseMessage = "\u00a7aYou have been released from jail!";
    public String jailExpiredMessage = "\u00a7aYour jail sentence has expired. You are now free!";
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("oldschooljail.toml");

    public static JailConfig load() {
        JailConfig config = new JailConfig();
        if (CONFIG_PATH.toFile().exists()) {
            try (CommentedFileConfig fileConfig = CommentedFileConfig.of((Path)CONFIG_PATH);){
                fileConfig.load();
                config.inputTimeUnit = TimeUnit.valueOf((String)fileConfig.getOrElse("time.input_unit", (Object)"MINUTES"));
                config.maxSentenceSeconds = fileConfig.getLongOrElse("time.max_sentence_seconds", 86400L);
                config.allowJailTime = (Boolean)fileConfig.getOrElse("permissions.allow_jail_time_command", (Object)true);
                config.blockCommands = (Boolean)fileConfig.getOrElse("restrictions.block_commands", (Object)true);
                config.blockTeleportation = (Boolean)fileConfig.getOrElse("restrictions.block_teleportation", (Object)true);
                config.blockBlockBreaking = (Boolean)fileConfig.getOrElse("restrictions.block_block_breaking", (Object)true);
                config.blockBlockPlacing = (Boolean)fileConfig.getOrElse("restrictions.block_block_placing", (Object)true);
                config.blockInteraction = (Boolean)fileConfig.getOrElse("restrictions.block_interaction", (Object)true);
                config.releaseMessage = (String)fileConfig.getOrElse("messages.release", (Object)"\u00a7aYou have been released from jail!");
                config.jailExpiredMessage = (String)fileConfig.getOrElse("messages.jail_expired", (Object)"\u00a7aYour jail sentence has expired. You are now free!");
                OldSchoolJailMod.LOGGER.info("Loaded config from " + String.valueOf(CONFIG_PATH));
            }
            catch (Exception e) {
                OldSchoolJailMod.LOGGER.error("Failed to load config, using defaults", (Throwable)e);
            }
        } else {
            config.save();
            OldSchoolJailMod.LOGGER.info("Created default config at " + String.valueOf(CONFIG_PATH));
        }
        return config;
    }

    public void save() {
        try (CommentedFileConfig config = (CommentedFileConfig)CommentedFileConfig.builder((Path)CONFIG_PATH).sync().preserveInsertionOrder().build();){
            config.load();
            config.setComment("time", " Time-related settings for jail sentences");
            config.set("time.input_unit", (Object)this.inputTimeUnit.name());
            config.setComment("time.input_unit", " The time unit used in /jail commands (SECONDS, MINUTES, or HOURS)\n Example: If set to MINUTES, '/jail player 30 reason' = 30 minutes");
            config.set("time.max_sentence_seconds", (Object)this.maxSentenceSeconds);
            config.setComment("time.max_sentence_seconds", " Maximum jail sentence length in seconds (regardless of input_unit)\n Default: 86400 (24 hours) | Set to -1 for unlimited");
            config.setComment("permissions", " Permission-related settings");
            config.set("permissions.allow_jail_time_command", (Object)this.allowJailTime);
            config.setComment("permissions.allow_jail_time_command", " Allow jailed players to use '/jail time' to check their sentence\n Recommended: true (so players know when they'll be released)");
            config.setComment("restrictions", " What actions are blocked while a player is jailed\n Note: Chat is always allowed");
            config.set("restrictions.block_commands", (Object)this.blockCommands);
            config.setComment("restrictions.block_commands", " Block all commands except '/jail time' (if enabled above)\n Recommended: true (prevents /home, /spawn, /tpa to escape)");
            config.set("restrictions.block_teleportation", (Object)this.blockTeleportation);
            config.setComment("restrictions.block_teleportation", " Teleport player back to jail if they move more than 50 blocks away\n Recommended: true (prevents escape via plugins/mods)");
            config.set("restrictions.block_block_breaking", (Object)this.blockBlockBreaking);
            config.setComment("restrictions.block_block_breaking", " Prevent breaking blocks while jailed\n Recommended: true");
            config.set("restrictions.block_block_placing", (Object)this.blockBlockPlacing);
            config.setComment("restrictions.block_block_placing", " Prevent placing blocks while jailed\n Recommended: true");
            config.set("restrictions.block_interaction", (Object)this.blockInteraction);
            config.setComment("restrictions.block_interaction", " Prevent interacting with blocks (buttons, levers, doors, etc.) while jailed\n Recommended: true");
            config.setComment("messages", " Customizable messages sent to players\n Color codes: \u00a7a=green, \u00a7c=red, \u00a7e=yellow, \u00a77=gray, etc.");
            config.set("messages.release", (Object)this.releaseMessage);
            config.setComment("messages.release", " Message sent when a player is manually released via '/jail release'");
            config.set("messages.jail_expired", (Object)this.jailExpiredMessage);
            config.setComment("messages.jail_expired", " Message sent when a player's jail time expires automatically");
            config.save();
        }
        catch (Exception e) {
            OldSchoolJailMod.LOGGER.error("Failed to save config", (Throwable)e);
        }
    }

    public long convertToSeconds(long time) {
        return switch (this.inputTimeUnit.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> time;
            case 1 -> time * 60L;
            case 2 -> time * 3600L;
        };
    }

    public String getTimeUnitName() {
        return switch (this.inputTimeUnit.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> "second(s)";
            case 1 -> "minute(s)";
            case 2 -> "hour(s)";
        };
    }

    public static enum TimeUnit {
        SECONDS,
        MINUTES,
        HOURS;

    }
}

