/*
 * Decompiled with CFR 0.152.
 */
package com.oldschooljail.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.oldschooljail.OldSchoolJailMod;
import com.oldschooljail.model.Jail;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;

public class JailData {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final File dataFile;
    private final Map<String, JailEntry> jails = new HashMap<String, JailEntry>();

    private JailData(File dataFile) {
        this.dataFile = dataFile;
    }

    public static JailData load(MinecraftServer server) {
        File worldDir = server.method_27050(class_5218.field_24188).toFile();
        File dataFile = new File(worldDir, "oldschooljail_jails.json");
        JailData data = new JailData(dataFile);
        if (dataFile.exists()) {
            try (FileReader reader = new FileReader(dataFile);){
                Map loadedJails = (Map)GSON.fromJson((Reader)reader, new TypeToken<Map<String, JailEntry>>(){}.getType());
                if (loadedJails != null) {
                    data.jails.putAll(loadedJails);
                }
                OldSchoolJailMod.LOGGER.info("Loaded {} jails", (Object)data.jails.size());
            }
            catch (IOException e) {
                OldSchoolJailMod.LOGGER.error("Failed to load jails data", (Throwable)e);
            }
        }
        return data;
    }

    public void save() {
        try {
            this.dataFile.getParentFile().mkdirs();
            try (FileWriter writer = new FileWriter(this.dataFile);){
                GSON.toJson(this.jails, (Appendable)writer);
            }
            OldSchoolJailMod.LOGGER.info("Saved {} jails", (Object)this.jails.size());
        }
        catch (IOException e) {
            OldSchoolJailMod.LOGGER.error("Failed to save jails data", (Throwable)e);
        }
    }

    public void addJail(Jail jail) {
        JailEntry entry = new JailEntry();
        entry.x = jail.getX();
        entry.y = jail.getY();
        entry.z = jail.getZ();
        entry.yaw = jail.getYaw();
        entry.pitch = jail.getPitch();
        entry.worldId = jail.getWorldId();
        this.jails.put(jail.getName().toLowerCase(), entry);
        this.save();
    }

    public Jail getJail(String name) {
        JailEntry entry = this.jails.get(name.toLowerCase());
        if (entry == null) {
            return null;
        }
        return new Jail(name, entry.x, entry.y, entry.z, entry.yaw, entry.pitch, entry.worldId);
    }

    public boolean hasJail(String name) {
        return this.jails.containsKey(name.toLowerCase());
    }

    public void removeJail(String name) {
        this.jails.remove(name.toLowerCase());
        this.save();
    }

    public Map<String, JailEntry> getAllJails() {
        return new HashMap<String, JailEntry>(this.jails);
    }

    public static class JailEntry {
        public double x;
        public double y;
        public double z;
        public float yaw;
        public float pitch;
        public String worldId;
    }
}

