/*
 * Decompiled with CFR 0.152.
 */
package com.oldschooljail.event;

import com.oldschooljail.OldSchoolJailMod;
import com.oldschooljail.data.JailData;
import com.oldschooljail.data.JailedPlayersData;
import com.oldschooljail.model.Jail;
import com.oldschooljail.model.JailedPlayer;
import java.util.Set;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;

public class PlayerEventHandler {
    public static void register() {
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            class_3222 player = handler.method_32311();
            JailedPlayersData jailedData = OldSchoolJailMod.getJailedPlayersData();
            if (jailedData == null) {
                return;
            }
            JailedPlayer jailedPlayer = jailedData.getJailedPlayer(player.method_5667());
            if (jailedPlayer != null) {
                if (jailedPlayer.shouldBeReleased()) {
                    player.method_64398((class_2561)class_2561.method_43470((String)OldSchoolJailMod.getConfig().jailExpiredMessage));
                    jailedData.teleportToOriginalLocation(player, jailedPlayer, server);
                    jailedData.releasePlayer(player.method_5667());
                } else {
                    JailData jailData = OldSchoolJailMod.getJailData();
                    Jail jail = jailData.getJail(jailedPlayer.getJailName());
                    if (jail != null) {
                        PlayerEventHandler.teleportToJail(player, jail, server);
                        long remaining = jailedPlayer.getRemainingTimeSeconds();
                        player.method_64398((class_2561)class_2561.method_43470((String)("\u00a7cYou are still jailed! Time remaining: " + PlayerEventHandler.formatTime(remaining))));
                    } else {
                        player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7aYour jail was removed. You are free!"));
                        jailedData.teleportToOriginalLocation(player, jailedPlayer, server);
                        jailedData.releasePlayer(player.method_5667());
                    }
                }
            }
        });
    }

    private static void teleportToJail(class_3222 player, Jail jail, MinecraftServer server) {
        try {
            class_5321 worldKey = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)class_2960.method_60654((String)jail.getWorldId()));
            class_3218 world = server.method_3847(worldKey);
            if (world == null) {
                world = server.method_30002();
            }
            player.method_48105(world, jail.getX(), jail.getY(), jail.getZ(), Set.of(), jail.getYaw(), jail.getPitch(), true);
        }
        catch (Exception e) {
            OldSchoolJailMod.LOGGER.error("Failed to teleport player to jail", (Throwable)e);
        }
    }

    private static String formatTime(long seconds) {
        long hours = seconds / 3600L;
        long minutes = seconds % 3600L / 60L;
        long secs = seconds % 60L;
        if (hours > 0L) {
            return hours + "h " + minutes + "m " + secs + "s";
        }
        if (minutes > 0L) {
            return minutes + "m " + secs + "s";
        }
        return secs + "s";
    }
}

