/*
 * Decompiled with CFR 0.152.
 */
package com.oldschooljail.mixin;

import com.oldschooljail.OldSchoolJailMod;
import com.oldschooljail.data.JailData;
import com.oldschooljail.data.JailedPlayersData;
import com.oldschooljail.model.Jail;
import com.oldschooljail.model.JailedPlayer;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3222.class})
public class ServerPlayerEntityAfkMixin {
    private static final Map<UUID, class_243> originalAfkPositions = new HashMap<UUID, class_243>();
    private static final Map<UUID, Boolean> previousJailState = new HashMap<UUID, Boolean>();

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void onTick(CallbackInfo ci) {
        class_3222 player = (class_3222)this;
        UUID playerUuid = player.method_5667();
        JailedPlayersData jailedData = OldSchoolJailMod.getJailedPlayersData();
        boolean currentlyJailed = jailedData != null && jailedData.isJailed(playerUuid);
        boolean previouslyJailed = previousJailState.getOrDefault(playerUuid, false);
        previousJailState.put(playerUuid, currentlyJailed);
        if (!currentlyJailed && previouslyJailed && originalAfkPositions.containsKey(playerUuid)) {
            try {
                Object playerData = player.getClass().getMethod("ec$getPlayerData", new Class[0]).invoke((Object)player, new Object[0]);
                if (playerData != null) {
                    Field lastTickPosField = playerData.getClass().getDeclaredField("lastTickPos");
                    lastTickPosField.setAccessible(true);
                    lastTickPosField.set(playerData, originalAfkPositions.get(playerUuid));
                    originalAfkPositions.remove(playerUuid);
                    OldSchoolJailMod.LOGGER.debug("Restored original AFK position for released player {}", (Object)player.method_5477().getString());
                }
            }
            catch (Exception e) {
                originalAfkPositions.remove(playerUuid);
            }
            return;
        }
        if (!currentlyJailed) {
            return;
        }
        JailedPlayer jailedPlayer = jailedData.getJailedPlayer(player.method_5667());
        JailData jailData = OldSchoolJailMod.getJailData();
        Jail jail = jailData.getJail(jailedPlayer.getJailName());
        if (jail == null) {
            return;
        }
        try {
            Object playerData = player.getClass().getMethod("ec$getPlayerData", new Class[0]).invoke((Object)player, new Object[0]);
            if (playerData != null) {
                Field lastTickPosField = playerData.getClass().getDeclaredField("lastTickPos");
                lastTickPosField.setAccessible(true);
                if (!originalAfkPositions.containsKey(playerUuid)) {
                    class_243 currentAfkPos = (class_243)lastTickPosField.get(playerData);
                    originalAfkPositions.put(playerUuid, currentAfkPos);
                    OldSchoolJailMod.LOGGER.debug("Stored original AFK position for jailed player {}: {}", (Object)player.method_5477().getString(), (Object)currentAfkPos);
                }
                lastTickPosField.set(playerData, new class_243(jail.getX(), jail.getY(), jail.getZ()));
            }
        }
        catch (Exception e) {
            OldSchoolJailMod.LOGGER.debug("Could not override Essentials AFK position: {}", (Object)e.getMessage());
        }
    }
}

