/*
 * Decompiled with CFR 0.152.
 */
package com.oldschooljail.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.oldschooljail.OldSchoolJailMod;
import com.oldschooljail.config.JailConfig;
import com.oldschooljail.data.JailData;
import com.oldschooljail.data.JailedPlayersData;
import com.oldschooljail.model.Jail;
import com.oldschooljail.model.JailedPlayer;
import com.oldschooljail.util.PermissionUtil;
import java.util.Collection;
import java.util.Set;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2262;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;

public class JailCommand {
    private static final SuggestionProvider<class_2168> JAIL_NAME_SUGGESTIONS = (context, builder) -> {
        JailData jailData = OldSchoolJailMod.getJailData();
        if (jailData != null) {
            return class_2172.method_9265(jailData.getAllJails().keySet(), (SuggestionsBuilder)builder);
        }
        return builder.buildFuture();
    };

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"jail").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9244((String)"time", (ArgumentType)IntegerArgumentType.integer((int)1)).then(class_2170.method_9244((String)"reason", (ArgumentType)StringArgumentType.greedyString()).executes(JailCommand::jailPlayer)))).then(class_2170.method_9244((String)"jail_name", (ArgumentType)StringArgumentType.word()).suggests(JAIL_NAME_SUGGESTIONS).then(class_2170.method_9244((String)"time", (ArgumentType)IntegerArgumentType.integer((int)1)).then(class_2170.method_9244((String)"reason", (ArgumentType)StringArgumentType.greedyString()).executes(JailCommand::jailPlayerToSpecificJail)))))).then(class_2170.method_9247((String)"set").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).executes(JailCommand::setJailAtCurrentPos)).then(class_2170.method_9244((String)"pos", (ArgumentType)class_2262.method_9698()).executes(JailCommand::setJailAtPos))))).then(class_2170.method_9247((String)"delete").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).suggests(JAIL_NAME_SUGGESTIONS).executes(JailCommand::deleteJail)))).then(class_2170.method_9247((String)"release").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(JailCommand::releasePlayer)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"time").executes(JailCommand::checkJailTime)).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(JailCommand::checkPlayerJailTime)))).then(class_2170.method_9247((String)"list").executes(JailCommand::listJailedPlayers)));
    }

    private static int jailPlayer(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 target = class_2186.method_9315(context, (String)"player");
        int time = IntegerArgumentType.getInteger(context, (String)"time");
        String reason = StringArgumentType.getString(context, (String)"reason");
        JailData jailData = OldSchoolJailMod.getJailData();
        Jail jail = jailData.getAllJails().entrySet().stream().findFirst().map(e -> jailData.getJail((String)e.getKey())).orElse(null);
        if (jail == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"\u00a7cNo jails have been set! Use /jail set <name> first."));
            return 0;
        }
        return JailCommand.executeJail((class_2168)context.getSource(), target, time, jail.getName(), reason);
    }

    private static int jailPlayerToSpecificJail(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 target = class_2186.method_9315(context, (String)"player");
        int time = IntegerArgumentType.getInteger(context, (String)"time");
        String jailName = StringArgumentType.getString(context, (String)"jail_name");
        String reason = StringArgumentType.getString(context, (String)"reason");
        JailData jailData = OldSchoolJailMod.getJailData();
        if (!jailData.hasJail(jailName)) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)("\u00a7cJail '" + jailName + "' doesn't exist!")));
            return 0;
        }
        return JailCommand.executeJail((class_2168)context.getSource(), target, time, jailName, reason);
    }

    private static int executeJail(class_2168 source, class_3222 target, int time, String jailName, String reason) throws CommandSyntaxException {
        if (!PermissionUtil.hasPermission(source, "oldschooljail.jail")) {
            source.method_9213((class_2561)class_2561.method_43470((String)"\u00a7cYou don't have permission to jail players!"));
            return 0;
        }
        if (source.method_44023() != null && source.method_44023().equals((Object)target)) {
            source.method_9213((class_2561)class_2561.method_43470((String)"\u00a7cYou can't jail yourself!"));
            return 0;
        }
        if (PermissionUtil.isImmune(target)) {
            source.method_9213((class_2561)class_2561.method_43470((String)"\u00a7cThat player is immune to jailing!"));
            return 0;
        }
        JailedPlayersData jailedData = OldSchoolJailMod.getJailedPlayersData();
        if (jailedData.isJailed(target.method_5667())) {
            JailedPlayer existingJail = jailedData.getJailedPlayer(target.method_5667());
            long remaining = existingJail.getRemainingTimeSeconds();
            source.method_9213((class_2561)class_2561.method_43470((String)("\u00a7c" + target.method_5477().getString() + " is already jailed! Remaining time: " + JailCommand.formatTime(remaining) + ". Use /jail release first.")));
            return 0;
        }
        JailConfig config = OldSchoolJailMod.getConfig();
        long timeInSeconds = config.convertToSeconds(time);
        if (timeInSeconds > config.maxSentenceSeconds) {
            source.method_9213((class_2561)class_2561.method_43470((String)("\u00a7cJail time exceeds maximum allowed sentence of " + config.maxSentenceSeconds + " seconds!")));
            return 0;
        }
        JailData jailData = OldSchoolJailMod.getJailData();
        Jail jail = jailData.getJail(jailName);
        if (jail == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)("\u00a7cJail '" + jailName + "' doesn't exist!")));
            return 0;
        }
        double origX = target.method_23317();
        double origY = target.method_23318();
        double origZ = target.method_23321();
        float origYaw = target.method_36454();
        float origPitch = target.method_36455();
        String origWorld = target.method_51469().method_27983().method_29177().toString();
        long releaseTime = System.currentTimeMillis() + timeInSeconds * 1000L;
        String jailerName = source.method_9214();
        JailedPlayer jailedPlayer = new JailedPlayer(target.method_5667(), jail.getName(), releaseTime, reason, jailerName, origX, origY, origZ, origYaw, origPitch, origWorld);
        jailedData.jailPlayer(jailedPlayer);
        JailCommand.teleportToJail(target, jail);
        target.method_64398((class_2561)class_2561.method_43470((String)("\u00a7cYou have been jailed for " + JailCommand.formatTime(timeInSeconds) + " by " + jailerName + "!")));
        target.method_64398((class_2561)class_2561.method_43470((String)("\u00a7eReason: " + reason)));
        source.method_9226(() -> class_2561.method_43470((String)("\u00a7aJailed " + target.method_5477().getString() + " in '" + jail.getName() + "' for " + JailCommand.formatTime(timeInSeconds) + "!")), true);
        return 1;
    }

    private static int setJailAtCurrentPos(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        if (!PermissionUtil.hasPermission(source, "oldschooljail.set")) {
            source.method_9213((class_2561)class_2561.method_43470((String)"\u00a7cYou don't have permission to set jails!"));
            return 0;
        }
        class_3222 player = source.method_9207();
        String name = StringArgumentType.getString(context, (String)"name");
        double x = player.method_23317();
        double y = player.method_23318();
        double z = player.method_23321();
        float yaw = player.method_36454();
        float pitch = player.method_36455();
        class_5321 worldKey = player.method_51469().method_27983();
        String worldId = worldKey.method_29177().toString();
        Jail jail = new Jail(name, x, y, z, yaw, pitch, worldId);
        OldSchoolJailMod.getJailData().addJail(jail);
        source.method_9226(() -> class_2561.method_43470((String)("\u00a7aJail '" + name + "' set at " + String.format("%.2f, %.2f, %.2f", x, y, z))), true);
        return 1;
    }

    private static int setJailAtPos(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        if (!PermissionUtil.hasPermission(source, "oldschooljail.set")) {
            source.method_9213((class_2561)class_2561.method_43470((String)"\u00a7cYou don't have permission to set jails!"));
            return 0;
        }
        String name = StringArgumentType.getString(context, (String)"name");
        class_2338 pos = class_2262.method_48299(context, (String)"pos");
        double x = (double)pos.method_10263() + 0.5;
        double y = pos.method_10264();
        double z = (double)pos.method_10260() + 0.5;
        float yaw = 0.0f;
        float pitch = 0.0f;
        class_5321 worldKey = source.method_9225().method_27983();
        String worldId = worldKey.method_29177().toString();
        Jail jail = new Jail(name, x, y, z, yaw, pitch, worldId);
        OldSchoolJailMod.getJailData().addJail(jail);
        source.method_9226(() -> class_2561.method_43470((String)("\u00a7aJail '" + name + "' set at " + pos.method_10263() + ", " + pos.method_10264() + ", " + pos.method_10260())), true);
        return 1;
    }

    private static int deleteJail(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        if (!PermissionUtil.hasPermission(source, "oldschooljail.delete")) {
            source.method_9213((class_2561)class_2561.method_43470((String)"\u00a7cYou don't have permission to delete jails!"));
            return 0;
        }
        String name = StringArgumentType.getString(context, (String)"name");
        JailData jailData = OldSchoolJailMod.getJailData();
        if (!jailData.hasJail(name)) {
            source.method_9213((class_2561)class_2561.method_43470((String)("\u00a7cJail '" + name + "' doesn't exist!")));
            return 0;
        }
        JailedPlayersData jailedData = OldSchoolJailMod.getJailedPlayersData();
        for (JailedPlayer jp : jailedData.getPlayersInJail(name)) {
            class_3222 player = source.method_9211().method_3760().method_14602(jp.getPlayerUuid());
            if (player != null) {
                if (OldSchoolJailMod.getConfig().teleportBackOnRelease) {
                    jailedData.teleportToOriginalLocation(player, jp, source.method_9211());
                }
                player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7aYou have been released because the jail was deleted."));
            }
            jailedData.releasePlayer(jp.getPlayerUuid());
        }
        jailData.removeJail(name);
        source.method_9226(() -> class_2561.method_43470((String)("\u00a7aDeleted jail '" + name + "' and released all prisoners.")), true);
        return 1;
    }

    private static int releasePlayer(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        if (!PermissionUtil.hasPermission(source, "oldschooljail.release")) {
            source.method_9213((class_2561)class_2561.method_43470((String)"\u00a7cYou don't have permission to release players!"));
            return 0;
        }
        class_3222 target = class_2186.method_9315(context, (String)"player");
        JailedPlayersData jailedData = OldSchoolJailMod.getJailedPlayersData();
        if (!jailedData.isJailed(target.method_5667())) {
            source.method_9213((class_2561)class_2561.method_43470((String)("\u00a7c" + target.method_5477().getString() + " is not jailed!")));
            return 0;
        }
        JailedPlayer jailedPlayer = jailedData.getJailedPlayer(target.method_5667());
        jailedData.releasePlayer(target.method_5667());
        if (jailedPlayer != null && OldSchoolJailMod.getConfig().teleportBackOnRelease) {
            jailedData.teleportToOriginalLocation(target, jailedPlayer, source.method_9211());
        }
        target.method_64398((class_2561)class_2561.method_43470((String)OldSchoolJailMod.getConfig().releaseMessage));
        source.method_9226(() -> class_2561.method_43470((String)("\u00a7aReleased " + target.method_5477().getString() + " from jail.")), true);
        return 1;
    }

    private static int checkJailTime(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_9207();
        JailedPlayersData jailedData = OldSchoolJailMod.getJailedPlayersData();
        JailedPlayer jailed = jailedData.getJailedPlayer(player.method_5667());
        if (jailed == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)"\u00a7cYou are not jailed!"));
            return 0;
        }
        long remaining = jailed.getRemainingTimeSeconds();
        source.method_9226(() -> class_2561.method_43470((String)("\u00a7eYou will be released in: " + JailCommand.formatTime(remaining))), false);
        return 1;
    }

    private static int checkPlayerJailTime(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        if (!PermissionUtil.hasPermission(source, "oldschooljail.jail")) {
            source.method_9213((class_2561)class_2561.method_43470((String)"\u00a7cYou don't have permission to check other players' jail time!"));
            return 0;
        }
        class_3222 target = class_2186.method_9315(context, (String)"player");
        JailedPlayersData jailedData = OldSchoolJailMod.getJailedPlayersData();
        JailedPlayer jailed = jailedData.getJailedPlayer(target.method_5667());
        if (jailed == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)("\u00a7c" + target.method_5477().getString() + " is not jailed!")));
            return 0;
        }
        long remaining = jailed.getRemainingTimeSeconds();
        source.method_9226(() -> class_2561.method_43470((String)("\u00a7e" + target.method_5477().getString() + " will be released in: " + JailCommand.formatTime(remaining))), false);
        return 1;
    }

    private static int listJailedPlayers(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        if (!PermissionUtil.hasPermission(source, "oldschooljail.jail")) {
            source.method_9213((class_2561)class_2561.method_43470((String)"\u00a7cYou don't have permission to list jailed players!"));
            return 0;
        }
        JailedPlayersData jailedData = OldSchoolJailMod.getJailedPlayersData();
        Collection<JailedPlayer> jailedPlayers = jailedData.getAllJailedPlayers();
        if (jailedPlayers.isEmpty()) {
            source.method_9226(() -> class_2561.method_43470((String)"\u00a7aNo players are currently jailed."), false);
            return 1;
        }
        source.method_9226(() -> class_2561.method_43470((String)"\u00a7e=== Currently Jailed Players ==="), false);
        for (JailedPlayer jailedPlayer : jailedPlayers) {
            class_3222 player;
            MinecraftServer server = source.method_9211();
            Object playerName = server != null ? ((player = server.method_3760().method_14602(jailedPlayer.getPlayerUuid())) != null ? player.method_5477().getString() : jailedPlayer.getPlayerUuid().toString().substring(0, 8) + "...") : "Unknown";
            long remaining = jailedPlayer.getRemainingTimeSeconds();
            String status = server != null && server.method_3760().method_14602(jailedPlayer.getPlayerUuid()) != null ? "\u00a7aOnline" : "\u00a77Offline";
            source.method_9226(() -> JailCommand.lambda$listJailedPlayers$11((String)playerName, jailedPlayer, remaining, status), false);
            source.method_9226(() -> class_2561.method_43470((String)("\u00a77  Reason: \u00a7f" + jailedPlayer.getReason() + " \u00a77- Jailed by: \u00a7f" + jailedPlayer.getJailedBy())), false);
        }
        source.method_9226(() -> class_2561.method_43470((String)("\u00a7eTotal: \u00a7f" + jailedPlayers.size() + " \u00a7eplayers jailed")), false);
        return 1;
    }

    private static void teleportToJail(class_3222 player, Jail jail) {
        MinecraftServer server = player.method_51469().method_8503();
        if (server == null) {
            return;
        }
        class_5321 worldKey = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)class_2960.method_60654((String)jail.getWorldId()));
        class_3218 world = server.method_3847(worldKey);
        if (world == null) {
            world = server.method_30002();
        }
        player.method_48105(world, jail.getX(), jail.getY(), jail.getZ(), Set.of(), jail.getYaw(), jail.getPitch(), true);
    }

    private static String formatTime(long seconds) {
        long hours = seconds / 3600L;
        long minutes = seconds % 3600L / 60L;
        long secs = seconds % 60L;
        if (hours > 0L) {
            return hours + "h " + minutes + "m " + secs + "s";
        }
        if (minutes > 0L) {
            return minutes + "m " + secs + "s";
        }
        return secs + "s";
    }

    private static /* synthetic */ class_2561 lambda$listJailedPlayers$11(String playerName, JailedPlayer jailedPlayer, long remaining, String status) {
        return class_2561.method_43470((String)("\u00a7e" + playerName + " \u00a77- Jail: \u00a7f" + jailedPlayer.getJailName() + " \u00a77- Time: \u00a7f" + JailCommand.formatTime(remaining) + " \u00a77- Status: " + status));
    }
}

