/*
 * Decompiled with CFR 0.152.
 */
package com.oldschooljail.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.oldschooljail.OldSchoolJailMod;
import com.oldschooljail.model.JailedPlayer;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5218;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;

public class JailedPlayersData {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final File dataFile;
    private final Map<UUID, JailedPlayerEntry> jailedPlayers = new HashMap<UUID, JailedPlayerEntry>();
    private ScheduledExecutorService releaseTimer;

    private JailedPlayersData(File dataFile) {
        this.dataFile = dataFile;
    }

    public static JailedPlayersData load(MinecraftServer server) {
        File worldDir = server.method_27050(class_5218.field_24188).toFile();
        File dataFile = new File(worldDir, "oldschooljail_players.json");
        JailedPlayersData data = new JailedPlayersData(dataFile);
        if (dataFile.exists()) {
            try (FileReader reader = new FileReader(dataFile);){
                Map loaded = (Map)GSON.fromJson((Reader)reader, new TypeToken<Map<UUID, JailedPlayerEntry>>(){}.getType());
                if (loaded != null) {
                    data.jailedPlayers.putAll(loaded);
                }
                OldSchoolJailMod.LOGGER.info("Loaded {} jailed players", (Object)data.jailedPlayers.size());
            }
            catch (IOException e) {
                OldSchoolJailMod.LOGGER.error("Failed to load jailed players data", (Throwable)e);
            }
        }
        return data;
    }

    public void save() {
        try {
            this.dataFile.getParentFile().mkdirs();
            try (FileWriter writer = new FileWriter(this.dataFile);){
                GSON.toJson(this.jailedPlayers, (Appendable)writer);
            }
        }
        catch (IOException e) {
            OldSchoolJailMod.LOGGER.error("Failed to save jailed players data", (Throwable)e);
        }
    }

    public void startReleaseTimer(MinecraftServer server) {
        this.releaseTimer = Executors.newSingleThreadScheduledExecutor();
        this.releaseTimer.scheduleAtFixedRate(() -> {
            ArrayList<UUID> toRelease = new ArrayList<UUID>();
            for (Map.Entry<UUID, JailedPlayerEntry> entry : this.jailedPlayers.entrySet()) {
                JailedPlayer jp = this.toJailedPlayer(entry.getKey(), entry.getValue());
                if (!jp.shouldBeReleased()) continue;
                toRelease.add(entry.getKey());
            }
            for (UUID uuid : toRelease) {
                server.execute(() -> {
                    class_3222 player;
                    JailedPlayer jp = this.getJailedPlayer(uuid);
                    if (jp != null && (player = server.method_3760().method_14602(uuid)) != null) {
                        player.method_64398((class_2561)class_2561.method_43470((String)OldSchoolJailMod.getConfig().jailExpiredMessage));
                        if (OldSchoolJailMod.getConfig().teleportBackOnRelease) {
                            this.teleportToOriginalLocation(player, jp, server);
                        }
                        this.releasePlayer(uuid);
                    }
                });
            }
        }, 1L, 1L, TimeUnit.SECONDS);
    }

    public void jailPlayer(JailedPlayer jailedPlayer) {
        JailedPlayerEntry entry = new JailedPlayerEntry();
        entry.jailName = jailedPlayer.getJailName();
        entry.releaseTime = jailedPlayer.getReleaseTime();
        entry.reason = jailedPlayer.getReason();
        entry.jailedBy = jailedPlayer.getJailedBy();
        entry.originalX = jailedPlayer.getOriginalX();
        entry.originalY = jailedPlayer.getOriginalY();
        entry.originalZ = jailedPlayer.getOriginalZ();
        entry.originalYaw = jailedPlayer.getOriginalYaw();
        entry.originalPitch = jailedPlayer.getOriginalPitch();
        entry.originalWorld = jailedPlayer.getOriginalWorld();
        this.jailedPlayers.put(jailedPlayer.getPlayerUuid(), entry);
        this.save();
    }

    public JailedPlayer getJailedPlayer(UUID uuid) {
        JailedPlayerEntry entry = this.jailedPlayers.get(uuid);
        if (entry == null) {
            return null;
        }
        return this.toJailedPlayer(uuid, entry);
    }

    public boolean isJailed(UUID uuid) {
        return this.jailedPlayers.containsKey(uuid);
    }

    public void releasePlayer(UUID uuid) {
        this.jailedPlayers.remove(uuid);
        this.save();
    }

    public List<JailedPlayer> getPlayersInJail(String jailName) {
        ArrayList<JailedPlayer> players = new ArrayList<JailedPlayer>();
        for (Map.Entry<UUID, JailedPlayerEntry> entry : this.jailedPlayers.entrySet()) {
            if (!entry.getValue().jailName.equalsIgnoreCase(jailName)) continue;
            players.add(this.toJailedPlayer(entry.getKey(), entry.getValue()));
        }
        return players;
    }

    public Collection<JailedPlayer> getAllJailedPlayers() {
        ArrayList<JailedPlayer> players = new ArrayList<JailedPlayer>();
        for (Map.Entry<UUID, JailedPlayerEntry> entry : this.jailedPlayers.entrySet()) {
            players.add(this.toJailedPlayer(entry.getKey(), entry.getValue()));
        }
        return players;
    }

    private JailedPlayer toJailedPlayer(UUID uuid, JailedPlayerEntry entry) {
        return new JailedPlayer(uuid, entry.jailName, entry.releaseTime, entry.reason, entry.jailedBy, entry.originalX, entry.originalY, entry.originalZ, entry.originalYaw, entry.originalPitch, entry.originalWorld);
    }

    public void teleportToOriginalLocation(class_3222 player, JailedPlayer jailedPlayer, MinecraftServer server) {
        try {
            class_5321 worldKey = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)class_2960.method_60654((String)jailedPlayer.getOriginalWorld()));
            class_3218 world = server.method_3847(worldKey);
            if (world == null) {
                world = server.method_30002();
            }
            player.method_48105(world, jailedPlayer.getOriginalX(), jailedPlayer.getOriginalY(), jailedPlayer.getOriginalZ(), Set.of(), jailedPlayer.getOriginalYaw(), jailedPlayer.getOriginalPitch(), true);
        }
        catch (Exception e) {
            OldSchoolJailMod.LOGGER.error("Failed to teleport player to original location", (Throwable)e);
        }
    }

    public void shutdown() {
        if (this.releaseTimer != null) {
            this.releaseTimer.shutdown();
        }
    }

    public static class JailedPlayerEntry {
        public String jailName;
        public long releaseTime;
        public String reason;
        public String jailedBy;
        public double originalX;
        public double originalY;
        public double originalZ;
        public float originalYaw;
        public float originalPitch;
        public String originalWorld;
    }
}

